/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.gzip;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractROArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.SingleArchiveEntryIterator;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GzipArchiveFile
extends AbstractROArchiveFile {
    public GzipArchiveFile(AbstractFile file) {
        super(file);
    }

    public ArchiveEntryIterator getEntryIterator() throws IOException {
        String extension = this.getExtension();
        String name = this.getName();
        if (extension != null) {
            if ((extension = extension.toLowerCase()).equals("tgz")) {
                name = name.substring(0, name.length() - 3) + "tar";
            } else if (extension.equals("gz")) {
                name = name.substring(0, name.length() - 3);
            }
        }
        return new SingleArchiveEntryIterator(new ArchiveEntry("/" + name, false, this.getDate(), -1L, true));
    }

    public InputStream getEntryInputStream(ArchiveEntry entry, ArchiveEntryIterator entryIterator) throws IOException, UnsupportedFileOperationException {
        return new GZIPInputStream(this.getInputStream());
    }
}

