/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl.ar;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.AbstractROArchiveFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.ArchiveEntryIterator;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.impl.ar.ArArchiveEntryIterator;
import com.mucommander.commons.io.BoundedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArArchiveFile
extends AbstractROArchiveFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArArchiveFile.class);

    public ArArchiveFile(AbstractFile file) {
        super(file);
    }

    public ArchiveEntryIterator getEntryIterator() throws IOException, UnsupportedFileOperationException {
        return new ArArchiveEntryIterator(this.getInputStream());
    }

    public InputStream getEntryInputStream(ArchiveEntry entry, ArchiveEntryIterator entryIterator) throws IOException, UnsupportedFileOperationException {
        ArchiveEntry currentEntry;
        InputStream in = this.getInputStream();
        ArArchiveEntryIterator iterator = new ArArchiveEntryIterator(in);
        while ((currentEntry = iterator.nextEntry()) != null) {
            if (!currentEntry.getName().equals(entry.getName())) continue;
            LOGGER.trace("found entry {}", entry.getName());
            return new BoundedInputStream(in, entry.getSize(), false);
        }
        LOGGER.info("Warning: entry not found, throwing IOException");
        throw new IOException();
    }
}

