/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.impl;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.commons.file.impl.ProxyFile;
import com.mucommander.commons.file.impl.local.LocalFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedFile
extends ProxyFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedFile.class);
    private boolean recurseInstances;
    private long getSize;
    private boolean getSizeSet;
    private long getDate;
    private boolean getDateSet;
    private boolean isSymlink;
    private boolean isSymlinkSet;
    private boolean isDirectory;
    private boolean isDirectorySet;
    private boolean isArchive;
    private boolean isArchiveSet;
    private boolean isHidden;
    private boolean isHiddenSet;
    private String getAbsolutePath;
    private boolean getAbsolutePathSet;
    private String getCanonicalPath;
    private boolean getCanonicalPathSet;
    private String getExtension;
    private boolean getExtensionSet;
    private String getName;
    private boolean getNameSet;
    private long getFreeSpace;
    private boolean getFreeSpaceSet;
    private long getTotalSpace;
    private boolean getTotalSpaceSet;
    private boolean exists;
    private boolean existsSet;
    private FilePermissions getPermissions;
    private boolean getPermissionsSet;
    private String getPermissionsString;
    private boolean getPermissionsStringSet;
    private String getOwner;
    private boolean getOwnerSet;
    private String getGroup;
    private boolean getGroupSet;
    private boolean isRoot;
    private boolean isRootSet;
    private AbstractFile getParent;
    private boolean getParentSet;
    private AbstractFile getRoot;
    private boolean getRootSet;
    private AbstractFile getCanonicalFile;
    private boolean getCanonicalFileSet;
    private static boolean getFileAttributesAvailable;
    private static Method mGetBooleanAttributes;
    private static int BA_DIRECTORY;
    private static int BA_EXISTS;
    private static int BA_HIDDEN;
    private static Object fs;

    public CachedFile(AbstractFile file, boolean recursiveInstances) {
        super(file);
        this.recurseInstances = recursiveInstances;
    }

    private AbstractFile[] createCachedFiles(AbstractFile[] files) {
        int nbFiles = files.length;
        for (int i = 0; i < nbFiles; ++i) {
            files[i] = new CachedFile(files[i], true);
        }
        return files;
    }

    private void getFileAttributes(AbstractFile file) {
        if ((file = file.getTopAncestor()) instanceof LocalFile) {
            try {
                int ba = (Integer)mGetBooleanAttributes.invoke(fs, file.getUnderlyingFileObject());
                this.isDirectory = (ba & BA_DIRECTORY) != 0;
                this.isDirectorySet = true;
                this.exists = (ba & BA_EXISTS) != 0;
                this.existsSet = true;
                this.isHidden = (ba & BA_HIDDEN) != 0;
                this.isHiddenSet = true;
            }
            catch (Exception e) {
                LOGGER.info("Could not retrieve file attributes for {}", file, e);
            }
        }
    }

    public long getSize() {
        if (!this.getSizeSet) {
            this.getSize = this.file.getSize();
            this.getSizeSet = true;
        }
        return this.getSize;
    }

    public long getDate() {
        if (!this.getDateSet) {
            this.getDate = this.file.getDate();
            this.getDateSet = true;
        }
        return this.getDate;
    }

    public boolean isSymlink() {
        if (!this.isSymlinkSet) {
            this.isSymlink = this.file.isSymlink();
            this.isSymlinkSet = true;
        }
        return this.isSymlink;
    }

    public boolean isDirectory() {
        if (!this.isDirectorySet && getFileAttributesAvailable && "file".equals(this.file.getURL().getScheme())) {
            this.getFileAttributes(this.file);
        }
        if (!this.isDirectorySet) {
            this.isDirectory = this.file.isDirectory();
            this.isDirectorySet = true;
        }
        return this.isDirectory;
    }

    public boolean isArchive() {
        if (!this.isArchiveSet) {
            this.isArchive = this.file.isArchive();
            this.isArchiveSet = true;
        }
        return this.isArchive;
    }

    public boolean isHidden() {
        if (!this.isHiddenSet && getFileAttributesAvailable && "file".equals(this.file.getURL().getScheme())) {
            this.getFileAttributes(this.file);
        }
        if (!this.isHiddenSet) {
            this.isHidden = this.file.isHidden();
            this.isHiddenSet = true;
        }
        return this.isHidden;
    }

    public String getAbsolutePath() {
        if (!this.getAbsolutePathSet) {
            this.getAbsolutePath = this.file.getAbsolutePath();
            this.getAbsolutePathSet = true;
        }
        return this.getAbsolutePath;
    }

    public String getCanonicalPath() {
        if (!this.getCanonicalPathSet) {
            this.getCanonicalPath = this.file.getCanonicalPath();
            this.getCanonicalPathSet = true;
        }
        return this.getCanonicalPath;
    }

    public String getExtension() {
        if (!this.getExtensionSet) {
            this.getExtension = this.file.getExtension();
            this.getExtensionSet = true;
        }
        return this.getExtension;
    }

    public String getName() {
        if (!this.getNameSet) {
            this.getName = this.file.getName();
            this.getNameSet = true;
        }
        return this.getName;
    }

    public long getFreeSpace() throws IOException, UnsupportedFileOperationException {
        if (!this.getFreeSpaceSet) {
            this.getFreeSpace = this.file.getFreeSpace();
            this.getFreeSpaceSet = true;
        }
        return this.getFreeSpace;
    }

    public long getTotalSpace() throws IOException, UnsupportedFileOperationException {
        if (!this.getTotalSpaceSet) {
            this.getTotalSpace = this.file.getTotalSpace();
            this.getTotalSpaceSet = true;
        }
        return this.getTotalSpace;
    }

    public boolean exists() {
        if (!this.existsSet && getFileAttributesAvailable && "file".equals(this.file.getURL().getScheme())) {
            this.getFileAttributes(this.file);
        }
        if (!this.existsSet) {
            this.exists = this.file.exists();
            this.existsSet = true;
        }
        return this.exists;
    }

    public FilePermissions getPermissions() {
        if (!this.getPermissionsSet) {
            this.getPermissions = this.file.getPermissions();
            this.getPermissionsSet = true;
        }
        return this.getPermissions;
    }

    public String getPermissionsString() {
        if (!this.getPermissionsStringSet) {
            this.getPermissionsString = this.file.getPermissionsString();
            this.getPermissionsStringSet = true;
        }
        return this.getPermissionsString;
    }

    public String getOwner() {
        if (!this.getOwnerSet) {
            this.getOwner = this.file.getOwner();
            this.getOwnerSet = true;
        }
        return this.getOwner;
    }

    public String getGroup() {
        if (!this.getGroupSet) {
            this.getGroup = this.file.getGroup();
            this.getGroupSet = true;
        }
        return this.getGroup;
    }

    public boolean isRoot() {
        if (!this.isRootSet) {
            this.isRoot = this.file.isRoot();
            this.isRootSet = true;
        }
        return this.isRoot;
    }

    public AbstractFile getParent() {
        if (!this.getParentSet) {
            this.getParent = this.file.getParent();
            if (this.recurseInstances && this.getParent != null) {
                this.getParent = new CachedFile(this.getParent, true);
            }
            this.getParentSet = true;
        }
        return this.getParent;
    }

    public AbstractFile getRoot() {
        if (!this.getRootSet) {
            this.getRoot = this.file.getRoot();
            if (this.recurseInstances) {
                this.getRoot = new CachedFile(this.getRoot, true);
            }
            this.getRootSet = true;
        }
        return this.getRoot;
    }

    public AbstractFile getCanonicalFile() {
        if (!this.getCanonicalFileSet) {
            this.getCanonicalFile = this.file.getCanonicalFile();
            if (this.recurseInstances) {
                this.getCanonicalFile = this.getCanonicalFile == this.file ? this : new CachedFile(this.getCanonicalFile, true);
            }
            this.getCanonicalFileSet = true;
        }
        return this.getCanonicalFile;
    }

    public AbstractFile[] ls() throws IOException, UnsupportedFileOperationException {
        AbstractFile[] files = this.file.ls();
        if (this.recurseInstances) {
            return this.createCachedFiles(files);
        }
        return files;
    }

    public AbstractFile[] ls(FileFilter filter) throws IOException, UnsupportedFileOperationException {
        AbstractFile[] files = this.file.ls(filter);
        if (this.recurseInstances) {
            return this.createCachedFiles(files);
        }
        return files;
    }

    public AbstractFile[] ls(FilenameFilter filter) throws IOException, UnsupportedFileOperationException {
        AbstractFile[] files = this.file.ls(filter);
        if (this.recurseInstances) {
            return this.createCachedFiles(files);
        }
        return files;
    }

    static {
        try {
            Class<File> clazz = File.class;
            Class<?> clazz2 = Class.forName("java.io.FileSystem");
            mGetBooleanAttributes = clazz2.getDeclaredMethod("getBooleanAttributes", clazz);
            Field field = clazz2.getDeclaredField("BA_EXISTS");
            Field field2 = clazz2.getDeclaredField("BA_DIRECTORY");
            Field field3 = clazz2.getDeclaredField("BA_HIDDEN");
            Field field4 = clazz.getDeclaredField("fs");
            mGetBooleanAttributes.setAccessible(true);
            field4.setAccessible(true);
            field.setAccessible(true);
            field2.setAccessible(true);
            field3.setAccessible(true);
            BA_EXISTS = (Integer)field.get(null);
            BA_DIRECTORY = (Integer)field2.get(null);
            BA_HIDDEN = (Integer)field3.get(null);
            fs = field4.get(null);
            getFileAttributesAvailable = true;
            LOGGER.trace("Access to java.io.FileSystem granted");
        }
        catch (Exception exception) {
            LOGGER.info("Error while allowing access to java.io.FileSystem", exception);
        }
    }
}

