/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.icon;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.icon.FileIconProvider;
import com.mucommander.commons.file.impl.local.LocalFile;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.Icon;

public abstract class LocalFileIconProvider
implements FileIconProvider {
    protected LocalFile createTempLocalFile(AbstractFile abstractFile) {
        try {
            LocalFile localFile = FileFactory.getTemporaryFile(abstractFile.getName(), false).getAncestor(LocalFile.class);
            if (abstractFile.isDirectory()) {
                localFile.mkdir();
            } else {
                localFile.getOutputStream().close();
            }
            return localFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Icon getFileIcon(AbstractFile originalFile, Dimension preferredResolution) {
        Icon icon;
        AbstractFile topFile = originalFile.getTopAncestor();
        if (topFile instanceof LocalFile) {
            icon = this.getLocalFileIcon((LocalFile)topFile, originalFile, preferredResolution);
        } else {
            LocalFile tempFile = this.createTempLocalFile(topFile);
            if (tempFile == null) {
                return null;
            }
            icon = this.getLocalFileIcon(tempFile, originalFile, preferredResolution);
            try {
                tempFile.delete();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return icon;
    }

    public abstract Icon getLocalFileIcon(LocalFile var1, AbstractFile var2, Dimension var3);
}

