/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.icon;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.icon.CacheableFileIconProvider;
import com.mucommander.commons.file.icon.FileIconProvider;
import com.mucommander.commons.file.icon.IconCache;
import java.awt.Dimension;
import javax.swing.Icon;

public class CachedFileIconProvider
implements FileIconProvider {
    protected CacheableFileIconProvider cacheableFip;

    public CachedFileIconProvider(CacheableFileIconProvider cacheableFip) {
        this.cacheableFip = cacheableFip;
    }

    public static IconCache createCache() {
        return new IconCache();
    }

    public Icon getFileIcon(AbstractFile file, Dimension preferredResolution) {
        boolean isCacheable = this.cacheableFip.isCacheable(file, preferredResolution);
        Icon icon = isCacheable ? this.cacheableFip.lookupCache(file, preferredResolution) : null;
        if (icon == null) {
            icon = this.cacheableFip.getFileIcon(file, preferredResolution);
            if (isCacheable && icon != null) {
                this.cacheableFip.addToCache(file, icon, preferredResolution);
            }
        }
        return icon;
    }
}

