/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.filter;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.util.FileSet;
import java.util.Vector;

public abstract class AbstractFileFilter
implements FileFilter {
    protected boolean inverted;

    public AbstractFileFilter() {
        this(false);
    }

    public AbstractFileFilter(boolean inverted) {
        this.setInverted(inverted);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public boolean match(AbstractFile file) {
        if (this.inverted) {
            return this.reject(file);
        }
        return this.accept(file);
    }

    public boolean reject(AbstractFile file) {
        return !this.accept(file);
    }

    public AbstractFile[] filter(AbstractFile[] files) {
        Vector<AbstractFile> filteredFilesV = new Vector<AbstractFile>();
        for (AbstractFile file : files) {
            if (!this.match(file)) continue;
            filteredFilesV.add(file);
        }
        AbstractFile[] filteredFiles = new AbstractFile[filteredFilesV.size()];
        filteredFilesV.toArray(filteredFiles);
        return filteredFiles;
    }

    public void filter(FileSet files) {
        int i = 0;
        while (i < files.size()) {
            if (this.reject((AbstractFile)files.elementAt(i))) {
                files.removeElementAt(i);
                continue;
            }
            ++i;
        }
    }
}

