/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.filter;

import com.mucommander.commons.file.filter.AbstractStringCriterionFilter;
import com.mucommander.commons.file.filter.CriterionValueGenerator;
import com.mucommander.commons.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractExtensionFilter
extends AbstractStringCriterionFilter {
    private char[][] extensions;

    public AbstractExtensionFilter(CriterionValueGenerator<String> generator, String[] extensions, boolean caseSensitive, boolean inverted) {
        super(generator, caseSensitive, inverted);
        this.extensions = new char[extensions.length][];
        for (int i = 0; i < extensions.length; ++i) {
            this.extensions[i] = extensions[i].toCharArray();
        }
    }

    public boolean accept(String value) {
        int len = value.length();
        if (this.isCaseSensitive()) {
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!StringUtils.matches(value, this.extensions[i], len)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!StringUtils.matchesIgnoreCase(value, this.extensions[i], len)) continue;
                return true;
            }
        }
        return false;
    }
}

