/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.connection;

import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.connection.ConnectionPool;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionHandler.class);
    protected FileURL realm;
    protected Credentials credentials;
    protected boolean isLocked;
    protected long lastActivityTimestamp;
    protected long lastKeepAliveTimestamp;
    protected long closeOnInactivityPeriod = 300L;
    protected long keepAlivePeriod = -1L;

    public ConnectionHandler(FileURL serverURL) {
        this.realm = serverURL.getRealm();
        this.credentials = serverURL.getCredentials();
    }

    public FileURL getRealm() {
        return this.realm;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public boolean checkConnection() throws IOException {
        if (!this.isConnected()) {
            LOGGER.info("not connected, starting connection, this=" + this);
            this.startConnection();
            return true;
        }
        return false;
    }

    public synchronized boolean acquireLock() {
        if (this.isLocked) {
            LOGGER.info("!!!!! acquireLock() returning false, should not happen !!!!!", new Throwable());
            return false;
        }
        this.isLocked = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseLock() {
        ConnectionHandler connectionHandler = this;
        synchronized (connectionHandler) {
            if (!this.isLocked) {
                LOGGER.info("!!!!! releaseLock() returning false, should not happen !!!!!", new Throwable());
                return false;
            }
            this.isLocked = false;
        }
        ConnectionPool.notifyConnectionHandlerLockReleased();
        return true;
    }

    public synchronized boolean isLocked() {
        return this.isLocked;
    }

    public void updateLastActivityTimestamp() {
        this.lastActivityTimestamp = System.currentTimeMillis();
    }

    public long getLastActivityTimestamp() {
        return this.lastActivityTimestamp;
    }

    public void updateLastKeepAliveTimestamp() {
        this.lastKeepAliveTimestamp = System.currentTimeMillis();
    }

    public long getLastKeepAliveTimestamp() {
        return this.lastKeepAliveTimestamp;
    }

    public long getCloseOnInactivityPeriod() {
        return this.closeOnInactivityPeriod;
    }

    public long getKeepAlivePeriod() {
        return this.keepAlivePeriod;
    }

    public void setKeepAlivePeriod(long nbSeconds) {
        this.keepAlivePeriod = nbSeconds;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ConnectionHandler)) {
            return false;
        }
        ConnectionHandler connHandler = (ConnectionHandler)o;
        return this.equals(connHandler.realm, connHandler.credentials);
    }

    public boolean equals(FileURL realm, Credentials credentials) {
        if (!this.realm.equals(realm, false, true)) {
            return false;
        }
        return this.credentials == null && credentials == null || this.credentials != null && this.credentials.equals(credentials, true) || credentials != null && credentials.equals(this.credentials, true);
    }

    public void throwAuthException(String message) throws AuthException {
        FileURL clonedRealm = (FileURL)this.realm.clone();
        clonedRealm.setCredentials(this.credentials);
        throw new AuthException(clonedRealm, message);
    }

    public abstract void startConnection() throws IOException, AuthException;

    public abstract boolean isConnected();

    public abstract void closeConnection();

    public abstract void keepAlive();
}

