/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.archiver;

import com.mucommander.commons.file.FileAttributes;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.archiver.Archiver;
import com.mucommander.commons.file.impl.zip.provider.ZipEntry;
import com.mucommander.commons.file.impl.zip.provider.ZipOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class ZipArchiver
extends Archiver {
    private ZipOutputStream zos;
    private boolean firstEntry = true;

    protected ZipArchiver(OutputStream outputStream) {
        super(outputStream);
        this.zos = new ZipOutputStream(outputStream);
    }

    public void setComment(String comment) {
        this.zos.setComment(comment);
    }

    public OutputStream createEntry(String entryPath, FileAttributes attributes) throws IOException {
        if (!this.firstEntry) {
            this.zos.closeEntry();
        }
        boolean isDirectory = attributes.isDirectory();
        ZipEntry entry = new ZipEntry(this.normalizePath(entryPath, isDirectory));
        long size = attributes.getSize();
        if (!isDirectory && size >= 0L) {
            entry.setSize(size);
        }
        entry.setTime(attributes.getDate());
        entry.setUnixMode(SimpleFilePermissions.padPermissions(attributes.getPermissions(), isDirectory ? FilePermissions.DEFAULT_DIRECTORY_PERMISSIONS : FilePermissions.DEFAULT_FILE_PERMISSIONS).getIntValue());
        this.zos.putNextEntry(entry);
        if (this.firstEntry) {
            this.firstEntry = false;
        }
        return isDirectory ? null : this.zos;
    }

    public void close() throws IOException {
        this.zos.close();
    }
}

