/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file.archiver;

import com.mucommander.commons.file.FileAttributes;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.archiver.Archiver;
import com.mucommander.commons.file.impl.tar.provider.TarEntry;
import com.mucommander.commons.file.impl.tar.provider.TarOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class TarArchiver
extends Archiver {
    private TarOutputStream tos;
    private boolean firstEntry = true;

    protected TarArchiver(OutputStream outputStream) {
        super(outputStream);
        this.tos = new TarOutputStream(outputStream);
        this.tos.setLongFileMode(2);
    }

    public OutputStream createEntry(String entryPath, FileAttributes attributes) throws IOException {
        if (!this.firstEntry) {
            this.tos.closeEntry();
        }
        boolean isDirectory = attributes.isDirectory();
        TarEntry entry = new TarEntry(this.normalizePath(entryPath, isDirectory));
        long size = attributes.getSize();
        if (!isDirectory && size >= 0L) {
            entry.setSize(size);
        }
        entry.setModTime(attributes.getDate());
        entry.setMode(SimpleFilePermissions.padPermissions(attributes.getPermissions(), isDirectory ? FilePermissions.DEFAULT_DIRECTORY_PERMISSIONS : FilePermissions.DEFAULT_FILE_PERMISSIONS).getIntValue());
        this.tos.putNextEntry(entry);
        if (this.firstEntry) {
            this.firstEntry = false;
        }
        return isDirectory ? null : this.tos;
    }

    public void close() throws IOException {
        if (!this.firstEntry) {
            this.tos.closeEntry();
        }
        this.tos.close();
    }
}

