/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.util.ResourceLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MimeTypes
extends Hashtable<String, String> {
    private static final MimeTypes mimeTypes = new MimeTypes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypes() {
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new InputStreamReader(ResourceLoader.getPackageResourceAsStream(MimeTypes.class.getPackage(), "mime.types")));
            while ((string = bufferedReader.readLine()) != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = stringTokenizer.nextToken();
                    while (stringTokenizer.hasMoreTokens()) {
                        this.put(stringTokenizer.nextToken(), string2);
                    }
                }
                catch (Exception exception) {
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getMimeType(AbstractFile file) {
        if (file.isDirectory()) {
            return null;
        }
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        if (pos == -1) {
            return null;
        }
        return (String)mimeTypes.get(name.substring(pos + 1, name.length()).toLowerCase());
    }
}

