/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AuthenticationType;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.DefaultPathCanonizer;
import com.mucommander.commons.file.DefaultSchemeHandler;
import com.mucommander.commons.file.DefaultSchemeParser;
import com.mucommander.commons.file.SchemeHandler;
import com.mucommander.commons.file.impl.local.LocalFile;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.commons.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileURL
implements Cloneable {
    private SchemeHandler handler;
    private String scheme;
    private int port = -1;
    private String host;
    private String path;
    private String filename;
    private String query;
    private Hashtable<String, String> properties;
    private Credentials credentials;
    private int hashCode;
    private static final SchemeHandler DEFAULT_HANDLER = new DefaultSchemeHandler();
    private static final Hashtable<String, SchemeHandler> handlers = new Hashtable();

    private FileURL(SchemeHandler handler) {
        this.handler = handler;
    }

    private void urlModified() {
        this.hashCode = 0;
    }

    public static FileURL getFileURL(String location) throws MalformedURLException {
        int schemeDelimPos = location.indexOf("://");
        SchemeHandler handler = schemeDelimPos == -1 ? FileURL.getDefaultHandler() : FileURL.getSchemeHandler(location.substring(0, schemeDelimPos));
        FileURL fileURL = new FileURL(handler);
        try {
            handler.getParser().parse(location, fileURL);
        }
        catch (Exception e) {
            if (e instanceof MalformedURLException) {
                throw (MalformedURLException)e;
            }
            throw new MalformedURLException("URL parser error");
        }
        return fileURL;
    }

    private static SchemeHandler getSchemeHandler(String scheme) {
        SchemeHandler handler = FileURL.getRegisteredHandler(scheme);
        if (handler == null) {
            return FileURL.getDefaultHandler();
        }
        return handler;
    }

    public void setHandler(SchemeHandler handler) {
        this.handler = handler;
    }

    public static void registerHandler(String scheme, SchemeHandler handler) {
        handlers.put(scheme.toLowerCase(), handler);
    }

    public static SchemeHandler getRegisteredHandler(String scheme) {
        return handlers.get(scheme.toLowerCase());
    }

    public static SchemeHandler getDefaultHandler() {
        return DEFAULT_HANDLER;
    }

    public static String getFilenameFromPath(String path, String separator) {
        int pos;
        if (path.equals("") || path.equals("/")) {
            return null;
        }
        path = PathUtils.removeTrailingSeparator(path, separator);
        if (!separator.equals("/")) {
            path = PathUtils.removeLeadingSeparator(path, "/");
        }
        if ((pos = path.lastIndexOf(separator)) == -1) {
            return null;
        }
        return path.substring(pos + 1);
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException();
        }
        this.scheme = scheme;
        this.urlModified();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.urlModified();
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
        this.urlModified();
    }

    public int getStandardPort() {
        return this.handler.getStandardPort();
    }

    public AuthenticationType getAuthenticationType() {
        return this.handler.getAuthenticationType();
    }

    public boolean containsCredentials() {
        return this.credentials != null;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials == null || credentials.isEmpty() ? null : credentials;
        this.urlModified();
    }

    public Credentials getGuestCredentials() {
        return this.handler.getGuestCredentials();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        if (path == null || path.equals("")) {
            path = "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
        this.filename = FileURL.getFilenameFromPath(path, this.getPathSeparator());
        this.urlModified();
    }

    public String getPathSeparator() {
        return this.handler.getPathSeparator();
    }

    public FileURL getParent() {
        String separator;
        String parentPath;
        int lastSeparatorPos;
        if (!this.path.equals("/") && !this.path.equals("") && (lastSeparatorPos = (parentPath = this.path.endsWith(separator = this.getPathSeparator()) ? this.path.substring(0, this.path.length() - separator.length()) : this.path).lastIndexOf(separator)) != -1) {
            FileURL parentURL = new FileURL(this.handler);
            parentURL.scheme = this.scheme;
            parentURL.host = this.host;
            parentURL.port = this.port;
            parentURL.path = parentPath.substring(0, lastSeparatorPos + 1);
            parentURL.filename = FileURL.getFilenameFromPath(parentURL.path, separator);
            parentURL.credentials = this.credentials;
            if (this.properties != null) {
                parentURL.properties = new Hashtable<String, String>(this.properties);
            }
            return parentURL;
        }
        return null;
    }

    public FileURL getRealm() {
        return this.handler.getRealm(this);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
        this.urlModified();
    }

    public String getProperty(String name) {
        return this.properties == null ? null : this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        this.urlModified();
    }

    public Enumeration<String> getPropertyNames() {
        if (this.properties == null) {
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public String nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }
        return this.properties.keys();
    }

    public void importProperties(FileURL url) {
        if (url.properties == null) {
            return;
        }
        Enumeration<String> propertyKeys = url.getPropertyNames();
        while (propertyKeys.hasMoreElements()) {
            String key = propertyKeys.nextElement();
            this.setProperty(key, url.getProperty(key));
        }
    }

    public String toString(boolean includeCredentials, boolean maskPassword) {
        StringBuffer sb = new StringBuffer(this.scheme);
        sb.append("://");
        if (includeCredentials && this.credentials != null) {
            try {
                sb.append(URLEncoder.encode(this.credentials.getLogin(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            String password = this.credentials.getPassword();
            if (!"".equals(password)) {
                sb.append(':');
                if (maskPassword) {
                    sb.append(this.credentials.getMaskedPassword());
                } else {
                    try {
                        sb.append(URLEncoder.encode(password, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        // empty catch block
                    }
                }
            }
            sb.append('@');
        }
        if (this.host != null) {
            sb.append(this.host);
        }
        if (this.port != -1 && this.port != this.handler.getStandardPort()) {
            sb.append(':');
            sb.append(this.port);
        }
        if (this.host != null || !this.path.equals("/")) {
            if (this.path.startsWith("/")) {
                sb.append(this.path);
            } else {
                sb.append('/');
                sb.append(this.path);
            }
        }
        if (this.query != null) {
            sb.append('?');
            sb.append(this.query);
        }
        return sb.toString();
    }

    public String toString(boolean includeCredentials) {
        return this.toString(includeCredentials, false);
    }

    public boolean schemeEquals(FileURL url) {
        return this.scheme.equalsIgnoreCase(url.scheme);
    }

    public boolean hostEquals(FileURL url) {
        return StringUtils.equals(this.host, url.host, false);
    }

    public boolean portEquals(FileURL url) {
        int port1 = this.port;
        int port2 = url.port;
        int standardPort = this.getStandardPort();
        return port1 == port2 || standardPort == url.getStandardPort() && (port1 == -1 && port2 == standardPort || port2 == -1 && port1 == standardPort);
    }

    public boolean pathEquals(FileURL url) {
        String path2;
        String path1 = this.getPath();
        if (path1.equals(path2 = url.getPath())) {
            return true;
        }
        String separator = this.getPathSeparator();
        if (separator.equals(url.getPathSeparator())) {
            int len2;
            int separatorLen = separator.length();
            int len1 = path1.length();
            if (Math.abs(len1 - (len2 = path2.length())) == separatorLen && (len1 > len2 ? path1.startsWith(path2) : path2.startsWith(path1))) {
                String diff = len1 > len2 ? path1.substring(len1 - separatorLen) : path2.substring(len2 - separatorLen);
                return separator.equals(diff);
            }
        }
        return false;
    }

    public boolean queryEquals(FileURL url) {
        return StringUtils.equals(this.query, url.query, true);
    }

    public boolean credentialsEquals(FileURL url) {
        Credentials creds1 = this.credentials;
        Credentials creds2 = url.credentials;
        return creds1 == null && creds2 == null || creds1 != null && creds1.equals(creds2, true) || creds2 != null && creds2.equals(creds1, true);
    }

    public boolean propertiesEquals(FileURL url) {
        return this.properties == null && url.properties == null || this.properties != null && this.properties.equals(url.properties) || url.properties != null && url.properties.equals(this.properties);
    }

    public String toString() {
        return this.toString(false);
    }

    public Object clone() {
        FileURL clonedURL = new FileURL(this.handler);
        clonedURL.scheme = this.scheme;
        clonedURL.host = this.host;
        clonedURL.port = this.port;
        clonedURL.path = this.path;
        clonedURL.filename = this.filename;
        clonedURL.query = this.query;
        clonedURL.credentials = this.credentials;
        if (this.properties != null) {
            clonedURL.properties = new Hashtable<String, String>(this.properties);
        }
        clonedURL.hashCode = this.hashCode;
        return clonedURL;
    }

    public boolean equals(Object o) {
        return this.equals(o, true, true);
    }

    public boolean equals(Object o, boolean compareCredentials, boolean compareProperties) {
        if (o == null || !(o instanceof FileURL)) {
            return false;
        }
        FileURL url = (FileURL)o;
        return !(!this.pathEquals(url) || !this.schemeEquals(url) || !this.hostEquals(url) || !this.portEquals(url) || !this.queryEquals(url) || compareCredentials && !this.credentialsEquals(url) || compareProperties && !this.propertiesEquals(url));
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            String separator = this.handler.getPathSeparator();
            int h = PathUtils.getPathHashCode(this.path, separator);
            h = 31 * h + this.scheme.toLowerCase().hashCode();
            h = 31 * h + (this.port == -1 ? this.handler.getStandardPort() : this.port);
            if (this.host != null) {
                h = 31 * h + this.host.toLowerCase().hashCode();
            }
            if (this.query != null) {
                h = 31 * h + this.query.hashCode();
            }
            if (this.credentials != null) {
                h = 31 * h + this.credentials.hashCode();
            }
            if (this.properties != null) {
                h = 31 * h + this.properties.hashCode();
            }
            this.hashCode = h;
        }
        return this.hashCode;
    }

    static {
        FileURL.registerHandler("file", new DefaultSchemeHandler(new DefaultSchemeParser(new DefaultPathCanonizer(LocalFile.SEPARATOR, System.getProperty("user.home")), false), -1, System.getProperty("file.separator"), AuthenticationType.NO_AUTHENTICATION, null));
        FileURL.registerHandler("ftp", new DefaultSchemeHandler(new DefaultSchemeParser(), 21, "/", AuthenticationType.AUTHENTICATION_REQUIRED, new Credentials("anonymous", "anonymous_coward@mucommander.com")));
        FileURL.registerHandler("sftp", new DefaultSchemeHandler(new DefaultSchemeParser(), 22, "/", AuthenticationType.AUTHENTICATION_REQUIRED, null));
        FileURL.registerHandler("hdfs", new DefaultSchemeHandler(new DefaultSchemeParser(true), 8020, "/", AuthenticationType.AUTHENTICATION_OPTIONAL, null));
        FileURL.registerHandler("http", new DefaultSchemeHandler(new DefaultSchemeParser(true), 80, "/", AuthenticationType.AUTHENTICATION_OPTIONAL, null));
        FileURL.registerHandler("s3", new DefaultSchemeHandler(new DefaultSchemeParser(true), 443, "/", AuthenticationType.AUTHENTICATION_REQUIRED, null));
        FileURL.registerHandler("webdav", new DefaultSchemeHandler(new DefaultSchemeParser(true), 80, "/", AuthenticationType.AUTHENTICATION_REQUIRED, null));
        FileURL.registerHandler("https", new DefaultSchemeHandler(new DefaultSchemeParser(true), 443, "/", AuthenticationType.AUTHENTICATION_OPTIONAL, null));
        FileURL.registerHandler("webdavs", new DefaultSchemeHandler(new DefaultSchemeParser(true), 443, "/", AuthenticationType.AUTHENTICATION_REQUIRED, null));
        FileURL.registerHandler("nfs", new DefaultSchemeHandler(new DefaultSchemeParser(), 2049, "/", AuthenticationType.NO_AUTHENTICATION, null));
        FileURL.registerHandler("smb", new DefaultSchemeHandler(new DefaultSchemeParser(), -1, "/", AuthenticationType.AUTHENTICATION_REQUIRED, new Credentials("GUEST", "")){

            public FileURL getRealm(FileURL location) {
                String newPath;
                FileURL realm = new FileURL(this);
                int pos = (newPath = location.getPath()).indexOf(47, 1);
                newPath = newPath.substring(0, pos == -1 ? newPath.length() : pos + 1);
                realm.setPath(newPath);
                realm.setScheme(location.getScheme());
                realm.setHost(location.getHost());
                realm.setPort(location.getPort());
                realm.importProperties(location);
                return realm;
            }
        });
    }
}

