/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AbstractFile;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileOperation {
    READ_FILE,
    RANDOM_READ_FILE,
    WRITE_FILE,
    APPEND_FILE,
    RANDOM_WRITE_FILE,
    CREATE_DIRECTORY,
    LIST_CHILDREN,
    DELETE,
    COPY_REMOTELY,
    RENAME,
    CHANGE_DATE,
    CHANGE_PERMISSION,
    GET_FREE_SPACE,
    GET_TOTAL_SPACE;

    private static final Logger LOGGER;

    public Method getCorrespondingMethod(Class<? extends AbstractFile> clazz) {
        try {
            switch (this) {
                case READ_FILE: {
                    return clazz.getMethod("getInputStream", new Class[0]);
                }
                case RANDOM_READ_FILE: {
                    return clazz.getMethod("getRandomAccessInputStream", new Class[0]);
                }
                case WRITE_FILE: {
                    return clazz.getMethod("getOutputStream", new Class[0]);
                }
                case APPEND_FILE: {
                    return clazz.getMethod("getAppendOutputStream", new Class[0]);
                }
                case RANDOM_WRITE_FILE: {
                    return clazz.getMethod("getRandomAccessOutputStream", new Class[0]);
                }
                case CREATE_DIRECTORY: {
                    return clazz.getMethod("mkdir", new Class[0]);
                }
                case LIST_CHILDREN: {
                    return clazz.getMethod("ls", new Class[0]);
                }
                case CHANGE_DATE: {
                    return clazz.getMethod("changeDate", Long.TYPE);
                }
                case CHANGE_PERMISSION: {
                    return clazz.getMethod("changePermission", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                }
                case DELETE: {
                    return clazz.getMethod("delete", new Class[0]);
                }
                case RENAME: {
                    return clazz.getMethod("renameTo", AbstractFile.class);
                }
                case COPY_REMOTELY: {
                    return clazz.getMethod("copyRemotelyTo", AbstractFile.class);
                }
                case GET_FREE_SPACE: {
                    return clazz.getMethod("getFreeSpace", new Class[0]);
                }
                case GET_TOTAL_SPACE: {
                    return clazz.getMethod("getTotalSpace", new Class[0]);
                }
            }
            LOGGER.warn("this line should not have been executed");
            return null;
        }
        catch (Exception exception) {
            LOGGER.warn("this line should not have been executed", exception);
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(FileOperation.class);
    }
}

