/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AbstractArchiveFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.ArchiveFormatProvider;
import com.mucommander.commons.file.AuthException;
import com.mucommander.commons.file.AuthenticationType;
import com.mucommander.commons.file.Authenticator;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.ProtocolProvider;
import com.mucommander.commons.file.icon.FileIconProvider;
import com.mucommander.commons.file.icon.impl.SwingFileIconProvider;
import com.mucommander.commons.file.impl.ar.ArFormatProvider;
import com.mucommander.commons.file.impl.bzip2.Bzip2FormatProvider;
import com.mucommander.commons.file.impl.ftp.FTPProtocolProvider;
import com.mucommander.commons.file.impl.gzip.GzipFormatProvider;
import com.mucommander.commons.file.impl.hadoop.HDFSProtocolProvider;
import com.mucommander.commons.file.impl.http.HTTPProtocolProvider;
import com.mucommander.commons.file.impl.iso.IsoFormatProvider;
import com.mucommander.commons.file.impl.local.LocalProtocolProvider;
import com.mucommander.commons.file.impl.lst.LstFormatProvider;
import com.mucommander.commons.file.impl.nfs.NFSProtocolProvider;
import com.mucommander.commons.file.impl.rar.RarFormatProvider;
import com.mucommander.commons.file.impl.s3.S3ProtocolProvider;
import com.mucommander.commons.file.impl.sevenzip.SevenZipFormatProvider;
import com.mucommander.commons.file.impl.sftp.SFTPProtocolProvider;
import com.mucommander.commons.file.impl.smb.SMBProtocolProvider;
import com.mucommander.commons.file.impl.tar.TarFormatProvider;
import com.mucommander.commons.file.impl.zip.ZipFormatProvider;
import com.mucommander.commons.file.util.FilePool;
import com.mucommander.commons.file.util.PathTokenizer;
import com.mucommander.commons.file.util.PathUtils;
import com.mucommander.commons.runtime.JavaVersions;
import com.mucommander.commons.runtime.OsFamilies;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileFactory.class);
    private static Hashtable<String, ProtocolProvider> protocolProviders = new Hashtable();
    private static ProtocolProvider localFileProvider;
    private static Vector<ArchiveFormatProvider> archiveFormatProvidersV;
    private static ArchiveFormatProvider[] archiveFormatProviders;
    private static final HashMap<String, FilePool> FILE_POOL_MAP;
    private static final AbstractFile TEMP_DIRECTORY;
    private static FileIconProvider defaultFileIconProvider;
    private static Authenticator defaultAuthenticator;

    private FileFactory() {
    }

    public static ProtocolProvider registerProtocol(String protocol, ProtocolProvider provider) {
        protocol = protocol.toLowerCase();
        FILE_POOL_MAP.put(protocol, new FilePool());
        if (protocol.equals("file")) {
            localFileProvider = provider;
        }
        return protocolProviders.put(protocol, provider);
    }

    public static ProtocolProvider getProtocolProvider(String protocol) {
        return protocolProviders.get(protocol.toLowerCase());
    }

    public static boolean isRegisteredProtocol(String protocol) {
        return FileFactory.getProtocolProvider(protocol) != null;
    }

    public static void registerArchiveFormat(ArchiveFormatProvider provider) {
        archiveFormatProvidersV.add(provider);
        FileFactory.updateArchiveFormatProviderArray();
    }

    private static void updateArchiveFormatProviderArray() {
        archiveFormatProviders = new ArchiveFormatProvider[archiveFormatProvidersV.size()];
        archiveFormatProvidersV.toArray(archiveFormatProviders);
    }

    public static ArchiveFormatProvider getArchiveFormatProvider(String filename) {
        if (filename == null) {
            return null;
        }
        for (ArchiveFormatProvider provider : archiveFormatProviders) {
            if (!provider.getFilenameFilter().accept(filename)) continue;
            return provider;
        }
        return null;
    }

    public static AbstractFile getFile(String absPath) {
        try {
            return FileFactory.getFile(absPath, null);
        }
        catch (IOException e) {
            LOGGER.info("Caught an exception", e);
            return null;
        }
    }

    public static AbstractFile getFile(String absPath, boolean throwException) throws AuthException, IOException {
        try {
            return FileFactory.getFile(absPath, null);
        }
        catch (IOException e) {
            LOGGER.info("Caught an exception", e);
            if (throwException) {
                throw e;
            }
            return null;
        }
    }

    public static AbstractFile getFile(String absPath, AbstractFile parent) throws AuthException, IOException {
        return FileFactory.getFile(FileURL.getFileURL(absPath), parent, new Object[0]);
    }

    public static AbstractFile getFile(FileURL fileURL) {
        try {
            return FileFactory.getFile(fileURL, null, new Object[0]);
        }
        catch (IOException e) {
            LOGGER.info("Caught an exception", e);
            return null;
        }
    }

    public static AbstractFile getFile(FileURL fileURL, boolean throwException) throws IOException {
        try {
            return FileFactory.getFile(fileURL, null, new Object[0]);
        }
        catch (IOException e) {
            LOGGER.info("Caught an exception", e);
            if (throwException) {
                throw e;
            }
            return null;
        }
    }

    public static AbstractFile getFile(FileURL fileURL, AbstractFile parent, Object ... instantiationParams) throws IOException {
        return FileFactory.getFile(fileURL, parent, defaultAuthenticator, instantiationParams);
    }

    public static AbstractFile getFile(FileURL fileURL, AbstractFile parent, Authenticator authenticator, Object ... instantiationParams) throws IOException {
        FileURL clonedURL;
        String currentPath;
        AbstractFile file;
        String protocol = fileURL.getScheme();
        if (!FileFactory.isRegisteredProtocol(protocol)) {
            throw new IOException("Unsupported file protocol: " + protocol);
        }
        FilePool filePool = FILE_POOL_MAP.get(fileURL.getScheme().toLowerCase());
        if (instantiationParams.length == 0 && (file = filePool.get(fileURL)) != null) {
            return file;
        }
        String filePath = fileURL.getPath();
        if (OsFamilies.WINDOWS.isCurrent() && "file".equals(protocol)) {
            filePath = PathUtils.removeLeadingSeparator(filePath, "/");
        }
        String pathSeparator = fileURL.getPathSeparator();
        PathTokenizer pt = new PathTokenizer(filePath, pathSeparator, false);
        AbstractFile currentFile = null;
        boolean lastFileResolved = false;
        while (pt.hasMoreFilenames()) {
            if (FileFactory.isArchiveFilename(pt.nextFilename())) {
                currentPath = PathUtils.removeTrailingSeparator(pt.getCurrentPath(), pathSeparator);
                if (currentFile == null || !currentFile.isArchive()) {
                    clonedURL = (FileURL)fileURL.clone();
                    clonedURL.setPath(currentPath);
                    currentFile = filePool.get(clonedURL);
                    if (currentFile == null) {
                        currentFile = FileFactory.wrapArchive(FileFactory.createRawFile(clonedURL, authenticator, instantiationParams));
                        filePool.put(clonedURL, currentFile);
                    }
                    lastFileResolved = true;
                    continue;
                }
                AbstractFile tempEntryFile = ((AbstractArchiveFile)currentFile).getArchiveEntryFile(PathUtils.removeLeadingSeparator(currentPath.substring(currentFile.getURL().getPath().length(), currentPath.length()), pathSeparator));
                if (tempEntryFile.isArchive()) {
                    currentFile = tempEntryFile;
                    lastFileResolved = true;
                    continue;
                }
                lastFileResolved = false;
                continue;
            }
            lastFileResolved = false;
        }
        if (!lastFileResolved) {
            currentPath = pt.getCurrentPath();
            if (currentFile == null || !currentFile.isArchive()) {
                clonedURL = (FileURL)fileURL.clone();
                clonedURL.setPath(currentPath);
                currentFile = FileFactory.createRawFile(clonedURL, authenticator, instantiationParams);
                filePool.put(currentFile.getURL(), currentFile);
            } else {
                currentFile = ((AbstractArchiveFile)currentFile).getArchiveEntryFile(PathUtils.removeLeadingSeparator(currentPath.substring(currentFile.getURL().getPath().length(), currentPath.length()), pathSeparator));
            }
        }
        if (parent != null) {
            currentFile.setParent(parent);
        }
        return currentFile;
    }

    private static AbstractFile createRawFile(FileURL fileURL, Authenticator authenticator, Object ... instantiationParams) throws IOException {
        ProtocolProvider provider;
        String scheme = fileURL.getScheme().toLowerCase();
        if (scheme.equals("file")) {
            if (localFileProvider == null) {
                throw new IOException("Unknown file protocol: " + scheme);
            }
            return localFileProvider.getFile(fileURL, instantiationParams);
        }
        if (authenticator != null && fileURL.getAuthenticationType() != AuthenticationType.NO_AUTHENTICATION && !fileURL.containsCredentials()) {
            authenticator.authenticate(fileURL);
        }
        if ((provider = FileFactory.getProtocolProvider(scheme)) == null) {
            throw new IOException("Unknown file protocol: " + scheme);
        }
        return provider.getFile(fileURL, instantiationParams);
    }

    private static String getFilenameVariation(String filename) {
        int lastDotPos = filename.lastIndexOf(46);
        int len = filename.length();
        String nameSuffix = "_" + System.currentTimeMillis() + new Random().nextInt(10000);
        filename = lastDotPos == -1 ? filename + nameSuffix : filename.substring(0, lastDotPos) + nameSuffix + filename.substring(lastDotPos, len);
        return filename;
    }

    public static AbstractFile getTemporaryFile(String desiredFilename, boolean deleteOnExit) throws IOException {
        AbstractFile tempFile;
        if (desiredFilename == null || desiredFilename.equals("")) {
            desiredFilename = "temp";
        }
        if ((tempFile = TEMP_DIRECTORY.getDirectChild(desiredFilename)).exists()) {
            tempFile = TEMP_DIRECTORY.getDirectChild(FileFactory.getFilenameVariation(desiredFilename));
        }
        if (deleteOnExit) {
            ((File)tempFile.getUnderlyingFileObject()).deleteOnExit();
        }
        return tempFile;
    }

    public static AbstractFile getTemporaryFile(boolean deleteOnExit) throws IOException {
        return FileFactory.getTemporaryFile(null, deleteOnExit);
    }

    public static AbstractFile getTemporaryFolder() {
        return TEMP_DIRECTORY;
    }

    public static boolean isArchiveFilename(String filename) {
        return FileFactory.getArchiveFormatProvider(filename) != null;
    }

    public static AbstractFile wrapArchive(AbstractFile file) throws IOException {
        ArchiveFormatProvider provider;
        String filename = file.getName();
        if (filename.indexOf(46) != -1 && (provider = FileFactory.getArchiveFormatProvider(filename)) != null) {
            return provider.getFile(file);
        }
        return file;
    }

    public static FileIconProvider getDefaultFileIconProvider() {
        return defaultFileIconProvider;
    }

    public static void setDefaultAuthenticator(Authenticator authenticator) {
        defaultAuthenticator = authenticator;
    }

    static {
        archiveFormatProvidersV = new Vector();
        FILE_POOL_MAP = new HashMap();
        FileFactory.registerProtocol("file", new LocalProtocolProvider());
        FileFactory.registerProtocol("smb", new SMBProtocolProvider());
        HTTPProtocolProvider hTTPProtocolProvider = new HTTPProtocolProvider();
        FileFactory.registerProtocol("http", hTTPProtocolProvider);
        FileFactory.registerProtocol("https", hTTPProtocolProvider);
        FileFactory.registerProtocol("ftp", new FTPProtocolProvider());
        FileFactory.registerProtocol("nfs", new NFSProtocolProvider());
        FileFactory.registerProtocol("sftp", new SFTPProtocolProvider());
        if (JavaVersions.JAVA_1_6.isCurrentOrHigher()) {
            FileFactory.registerProtocol("hdfs", new HDFSProtocolProvider());
        }
        FileFactory.registerProtocol("s3", new S3ProtocolProvider());
        FileFactory.registerArchiveFormat(new ZipFormatProvider());
        FileFactory.registerArchiveFormat(new TarFormatProvider());
        FileFactory.registerArchiveFormat(new GzipFormatProvider());
        FileFactory.registerArchiveFormat(new Bzip2FormatProvider());
        FileFactory.registerArchiveFormat(new IsoFormatProvider());
        FileFactory.registerArchiveFormat(new ArFormatProvider());
        FileFactory.registerArchiveFormat(new LstFormatProvider());
        FileFactory.registerArchiveFormat(new RarFormatProvider());
        FileFactory.registerArchiveFormat(new SevenZipFormatProvider());
        defaultFileIconProvider = new SwingFileIconProvider();
        TEMP_DIRECTORY = FileFactory.getFile(System.getProperty("java.io.tmpdir"));
    }
}

