/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

public final class Credentials {
    private String login;
    private String password;

    public Credentials(String login, String password) {
        if (login == null) {
            login = "";
        }
        if (password == null) {
            password = "";
        }
        this.login = login;
        this.password = password;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public String getMaskedPassword() {
        int passwordLength = this.password.length();
        StringBuffer maskedPasswordSb = new StringBuffer(passwordLength);
        for (int i = 0; i < passwordLength; ++i) {
            maskedPasswordSb.append('*');
        }
        return maskedPasswordSb.toString();
    }

    public boolean isEmpty() {
        return "".equals(this.login) && "".equals(this.password);
    }

    public boolean equals(Object o) {
        return this.equals(o, false);
    }

    public boolean equals(Object o, boolean passwordSensitive) {
        if (o == null) {
            return this.isEmpty();
        }
        if (!(o instanceof Credentials)) {
            return false;
        }
        Credentials credentials = (Credentials)o;
        return credentials.login.equals(this.login) && (!passwordSensitive || credentials.password.equals(this.password));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        return this.login;
    }

    public int hashCode() {
        return this.login.hashCode();
    }
}

