/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.util.PathUtils;
import javax.swing.tree.DefaultMutableTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveEntryTree
extends DefaultMutableTreeNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveEntryTree.class);

    public void addArchiveEntry(ArchiveEntry entry) {
        String entryPath = entry.getPath();
        int entryDepth = entry.getDepth();
        int slashPos = 0;
        DefaultMutableTreeNode node = this;
        for (int d = 1; d <= entryDepth; ++d) {
            String string;
            if (d == entryDepth && !entry.isDirectory()) {
                entry.setExists(true);
                node.add(new DefaultMutableTreeNode(entry, true));
                break;
            }
            if (d == entryDepth) {
                string = entryPath;
            } else {
                slashPos = entryPath.indexOf(47, slashPos) + 1;
                string = entryPath.substring(0, slashPos);
            }
            String subPath = string;
            int nbChildren = node.getChildCount();
            DefaultMutableTreeNode childNode = null;
            boolean matchFound = false;
            for (int c = 0; c < nbChildren; ++c) {
                childNode = (DefaultMutableTreeNode)node.getChildAt(c);
                if (!PathUtils.pathEquals(((ArchiveEntry)childNode.getUserObject()).getPath(), subPath, "/")) continue;
                matchFound = true;
                break;
            }
            if (matchFound) {
                if (d == entryDepth) {
                    LOGGER.trace("Replacing entry for node " + childNode);
                    childNode.setUserObject(entry);
                    continue;
                }
                node = childNode;
                continue;
            }
            if (d == entryDepth) {
                entry.setExists(true);
                node.add(new DefaultMutableTreeNode(entry, true));
                continue;
            }
            LOGGER.trace("Creating node for " + subPath);
            childNode = new DefaultMutableTreeNode(new ArchiveEntry(subPath, true, entry.getDate(), 0L, true), true);
            node.add(childNode);
            node = childNode;
        }
    }

    public DefaultMutableTreeNode findEntryNode(String entryPath) {
        int entryDepth = ArchiveEntry.getDepth(entryPath);
        int slashPos = 0;
        ArchiveEntryTree currentNode = this;
        for (int d = 1; d <= entryDepth; ++d) {
            String string;
            if (d == entryDepth) {
                string = entryPath;
            } else {
                slashPos = entryPath.indexOf(47, slashPos) + 1;
                string = entryPath.substring(0, slashPos);
            }
            String subPath = string;
            int nbChildren = currentNode.getChildCount();
            DefaultMutableTreeNode matchNode = null;
            for (int c = 0; c < nbChildren; ++c) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)currentNode.getChildAt(c);
                if (!PathUtils.pathEquals(((ArchiveEntry)childNode.getUserObject()).getPath(), subPath, "/")) continue;
                matchNode = childNode;
                break;
            }
            if (matchNode == null) {
                return null;
            }
            currentNode = matchNode;
        }
        return currentNode;
    }
}

