/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AbstractFile;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractFileClassLoader
extends ClassLoader {
    private Vector<AbstractFile> files = new Vector();

    public AbstractFileClassLoader(ClassLoader parent) {
        super(parent);
    }

    public AbstractFileClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    public void addFile(AbstractFile file) {
        if (!file.isBrowsable()) {
            throw new IllegalArgumentException();
        }
        if (!this.contains(file)) {
            this.files.add(file);
        }
    }

    public Iterator<AbstractFile> files() {
        return this.files.iterator();
    }

    public boolean contains(AbstractFile file) {
        return this.files.contains(file);
    }

    private AbstractFile findResourceAsFile(String name) {
        Iterator<AbstractFile> iterator = this.files.iterator();
        while (iterator.hasNext()) {
            try {
                AbstractFile file = iterator.next().getChild(name);
                if (!file.exists()) continue;
                return file;
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream in = this.getParent().getResourceAsStream(name);
        if (in != null) {
            return in;
        }
        AbstractFile file = this.findResourceAsFile(name);
        if (file != null) {
            try {
                return file.getInputStream();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected URL findResource(String name) {
        AbstractFile file = this.findResourceAsFile(name);
        if (file == null) {
            return null;
        }
        try {
            return file.getJavaNetURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) {
        Iterator<AbstractFile> iterator = this.files.iterator();
        Vector<URL> resources = new Vector<URL>();
        while (iterator.hasNext()) {
            try {
                AbstractFile file = iterator.next().getChild(name);
                if (!file.exists()) continue;
                resources.add(file.getJavaNetURL());
            }
            catch (IOException e) {}
        }
        return resources.elements();
    }

    @Override
    protected String findLibrary(String name) {
        AbstractFile file = this.findResourceAsFile(name);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClass(String name, AbstractFile file) throws IOException {
        byte[] buffer = new byte[(int)file.getSize()];
        InputStream in = null;
        try {
            in = file.getInputStream();
            for (int offset = 0; offset != buffer.length; offset += in.read(buffer, offset, buffer.length - offset)) {
            }
            Class<?> clazz = this.defineClass(name, buffer, 0, buffer.length);
            return clazz;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        AbstractFile file = this.findResourceAsFile(name.replace('.', '/') + ".class");
        if (file != null) {
            try {
                return this.loadClass(name, file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(name);
    }
}

