/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AbstractArchiveEntryFile;
import com.mucommander.commons.file.AbstractArchiveFile;
import com.mucommander.commons.file.FileAttributes;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.PermissionBits;
import com.mucommander.commons.file.SimpleFilePermissions;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.compat.CompatURLStreamHandler;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.commons.file.impl.ProxyFile;
import com.mucommander.commons.io.ChecksumInputStream;
import com.mucommander.commons.io.FileTransferException;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import com.mucommander.commons.io.StreamUtils;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFile
implements FileAttributes {
    protected FileURL fileURL;

    protected AbstractFile(FileURL url) {
        this.fileURL = url;
    }

    public FileURL getURL() {
        return this.fileURL;
    }

    public URL getJavaNetURL() throws MalformedURLException {
        return new URL(null, this.getURL().toString(true), new CompatURLStreamHandler(this));
    }

    public String getName() {
        String name = this.fileURL.getFilename();
        if (name == null && (name = this.fileURL.getHost()) == null) {
            return "";
        }
        return name;
    }

    public String getExtension() {
        return AbstractFile.getExtension(this.getName());
    }

    public String getAbsolutePath() {
        return this.getURL().toString(false);
    }

    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    public AbstractFile getCanonicalFile() {
        String canonicalPath = this.getCanonicalPath(false);
        if (canonicalPath.equals(this.getAbsolutePath(false))) {
            return this;
        }
        try {
            FileURL canonicalURL = FileURL.getFileURL(canonicalPath);
            canonicalURL.setCredentials(this.fileURL.getCredentials());
            return FileFactory.getFile(canonicalURL);
        }
        catch (IOException e) {
            return this;
        }
    }

    public String getSeparator() {
        return "/";
    }

    public boolean isHidden() {
        return this.getName().startsWith(".");
    }

    public AbstractFile getRoot() {
        FileURL rootURL = (FileURL)this.getURL().clone();
        rootURL.setPath("/");
        return FileFactory.getFile(rootURL);
    }

    public boolean isRoot() {
        return this.getURL().getPath().equals("/");
    }

    public AbstractFile getVolume() {
        return this.getRoot();
    }

    public InputStream getInputStream(long offset) throws IOException, UnsupportedFileOperationException {
        if (this.isFileOperationSupported(FileOperation.RANDOM_READ_FILE)) {
            RandomAccessInputStream rais = this.getRandomAccessInputStream();
            rais.seek(offset);
            return rais;
        }
        InputStream in = this.getInputStream();
        StreamUtils.skipFully(in, offset);
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyStream(InputStream in, boolean append, long length) throws FileTransferException {
        OutputStream out;
        try {
            out = append ? this.getAppendOutputStream() : this.getOutputStream();
        }
        catch (IOException e) {
            throw new FileTransferException(3);
        }
        try {
            StreamUtils.copyStream(in, out, 65536);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new FileTransferException(8);
            }
        }
    }

    public final void copyTo(AbstractFile destFile) throws IOException {
        if (this.isFileOperationSupported(FileOperation.COPY_REMOTELY)) {
            try {
                this.copyRemotelyTo(destFile);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.checkCopyPrerequisites(destFile, false);
        this.copyRecursively(this, destFile);
    }

    public final void moveTo(AbstractFile destFile) throws IOException {
        if (this.isFileOperationSupported(FileOperation.RENAME)) {
            try {
                this.renameTo(destFile);
                return;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.copyTo(destFile);
        try {
            this.deleteRecursively();
        }
        catch (IOException e) {
            throw new FileTransferException(6);
        }
    }

    public void mkfile() throws IOException, UnsupportedFileOperationException {
        if (this.exists()) {
            throw new IOException();
        }
        if (this.isFileOperationSupported(FileOperation.WRITE_FILE)) {
            this.getOutputStream().close();
        } else {
            this.copyStream(new ByteArrayInputStream(new byte[0]), false, 0L);
        }
    }

    public AbstractFile[] ls(FileFilter filter) throws IOException, UnsupportedFileOperationException {
        return filter == null ? this.ls() : filter.filter(this.ls());
    }

    public AbstractFile[] ls(FilenameFilter filter) throws IOException, UnsupportedFileOperationException {
        return filter == null ? this.ls() : filter.filter(this.ls());
    }

    public void changePermissions(int permissions) throws IOException, UnsupportedFileOperationException {
        int bitShift = 0;
        PermissionBits mask = this.getChangeablePermissions();
        for (int a = 0; a <= 2; ++a) {
            for (int p = 1; p <= 4; p <<= 1) {
                if (mask.getBitValue(a, p)) {
                    this.changePermission(a, p, (permissions & 1 << bitShift) != 0);
                }
                ++bitShift;
            }
        }
    }

    public String getPermissionsString() {
        FilePermissions permissions = this.getPermissions();
        int supportedPerms = permissions.getMask().getIntValue();
        String s = "";
        s = s + (char)(this.isSymlink() ? 108 : (this.isDirectory() ? 100 : 45));
        int perms = permissions.getIntValue();
        int bitShift = 6;
        for (int a = 2; a >= 0; --a) {
            if (a == 2 || (supportedPerms & 7 << bitShift) != 0) {
                for (int p = 4; p >= 1; p >>= 1) {
                    s = (perms & p << bitShift) == 0 ? s + '-' : s + (char)(p == 4 ? 114 : (p == 2 ? 119 : 120));
                }
            }
            bitShift -= 3;
        }
        return s;
    }

    public void deleteRecursively() throws IOException, UnsupportedFileOperationException {
        this.deleteRecursively(this);
    }

    public boolean isFileOperationSupported(FileOperation op) {
        return AbstractFile.isFileOperationSupported(op, this.getClass());
    }

    public final boolean isBrowsable() {
        return this.isDirectory() || this.isArchive();
    }

    public final String getNameWithoutExtension() {
        String name = this.getName();
        int position = name.lastIndexOf(46);
        if (position <= 0 || position == name.length() - 1) {
            return name;
        }
        return name.substring(0, position);
    }

    public final String getPath() {
        return this.getAbsolutePath();
    }

    public final String getAbsolutePath(boolean appendSeparator) {
        String path = this.getAbsolutePath();
        return appendSeparator ? this.addTrailingSeparator(path) : this.removeTrailingSeparator(path);
    }

    public final String getCanonicalPath(boolean appendSeparator) {
        String path = this.getCanonicalPath();
        return appendSeparator ? this.addTrailingSeparator(path) : this.removeTrailingSeparator(path);
    }

    public final AbstractFile getChild(String relativePath) throws IOException {
        FileURL childURL = (FileURL)this.getURL().clone();
        childURL.setPath(this.addTrailingSeparator(childURL.getPath()) + relativePath);
        return FileFactory.getFile(childURL, true);
    }

    public final AbstractFile getChildSilently(String relativePath) {
        try {
            return this.getChild(relativePath);
        }
        catch (IOException e) {
            return null;
        }
    }

    public final AbstractFile getDirectChild(String filename) throws IOException {
        if (filename.indexOf(this.getSeparator()) != -1) {
            throw new IOException();
        }
        AbstractFile childFile = this.getChild(filename);
        childFile.setParent(this);
        return childFile;
    }

    public final void mkdirs() throws IOException, UnsupportedFileOperationException {
        AbstractFile parent = this.getParent();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        this.mkdir();
    }

    public final AbstractFile getAncestor() {
        if (this instanceof ProxyFile) {
            return ((ProxyFile)this).getProxiedFile();
        }
        return this;
    }

    public final <T extends AbstractFile> T getAncestor(Class<T> abstractFileClass) {
        AbstractFile lastAncestor;
        AbstractFile ancestor = this;
        do {
            if (!abstractFileClass.isAssignableFrom(ancestor.getClass())) continue;
            return (T)ancestor;
        } while ((lastAncestor = ancestor) != (ancestor = ancestor.getAncestor()));
        return null;
    }

    public final AbstractFile getTopAncestor() {
        AbstractFile topAncestor = this;
        while (topAncestor.hasAncestor()) {
            topAncestor = topAncestor.getAncestor();
        }
        return topAncestor;
    }

    public final boolean hasAncestor() {
        return this instanceof ProxyFile;
    }

    public final boolean hasAncestor(Class<? extends AbstractFile> abstractFileClass) {
        AbstractFile lastAncestor;
        AbstractFile ancestor = this;
        do {
            if (!abstractFileClass.isAssignableFrom(ancestor.getClass())) continue;
            return true;
        } while ((lastAncestor = ancestor) != (ancestor = ancestor.getAncestor()));
        return false;
    }

    public final boolean isParentOf(AbstractFile file) {
        return this.isBrowsable() && file.getCanonicalPath(true).startsWith(this.getCanonicalPath(true));
    }

    public final AbstractArchiveFile getParentArchive() {
        if (this.hasAncestor(AbstractArchiveFile.class)) {
            return this.getAncestor(AbstractArchiveFile.class);
        }
        if (this.hasAncestor(AbstractArchiveEntryFile.class)) {
            return this.getAncestor(AbstractArchiveEntryFile.class).getArchiveFile();
        }
        return null;
    }

    public final Icon getIcon(Dimension preferredResolution) {
        return FileFactory.getDefaultFileIconProvider().getFileIcon(this, preferredResolution);
    }

    public final Icon getIcon() {
        return this.getIcon(new Dimension(16, 16));
    }

    public final String calculateChecksum(String algorithm) throws IOException, NoSuchAlgorithmException, UnsupportedFileOperationException {
        return this.calculateChecksum(MessageDigest.getInstance(algorithm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String calculateChecksum(MessageDigest messageDigest) throws IOException, UnsupportedFileOperationException {
        InputStream in = this.getInputStream();
        try {
            String string = AbstractFile.calculateChecksum(in, messageDigest);
            return string;
        }
        finally {
            in.close();
        }
    }

    public final String addTrailingSeparator(String path) {
        String separator = this.getSeparator();
        if (!path.endsWith(separator)) {
            return path + separator;
        }
        return path;
    }

    protected final String removeTrailingSeparator(String path) {
        String separator = this.getSeparator();
        if (!(!path.endsWith(separator) || separator.equals("/") && path.length() == 1 || separator.equals("\\") && path.charAt(path.length() - 2) == ':')) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected final void checkCopyPrerequisites(AbstractFile destFile, boolean allowCaseVariations) throws FileTransferException {
        boolean isAllowedCaseVariation = false;
        boolean filesEqual = this.equalsCanonical(destFile);
        if (filesEqual) {
            String destFileName;
            String sourceFileName;
            if (allowCaseVariations && (sourceFileName = this.getName()).equalsIgnoreCase(destFileName = destFile.getName()) && !sourceFileName.equals(destFileName)) {
                isAllowedCaseVariation = true;
            }
            if (!isAllowedCaseVariation) {
                throw new FileTransferException(1);
            }
        }
        if (!filesEqual && this.isParentOf(destFile)) {
            throw new FileTransferException(11);
        }
        if (!this.exists()) {
            throw new FileTransferException(10);
        }
    }

    protected final void checkCopyRemotelyPrerequisites(AbstractFile destFile, boolean allowCaseVariations, boolean allowDifferentHosts) throws IOException, FileTransferException {
        if (!this.fileURL.schemeEquals(this.fileURL) || !destFile.getTopAncestor().getClass().equals(this.getTopAncestor().getClass()) || !allowDifferentHosts && !destFile.getURL().hostEquals(this.fileURL)) {
            throw new IOException();
        }
        this.checkCopyPrerequisites(destFile, allowCaseVariations);
    }

    protected final void checkRenamePrerequisites(AbstractFile destFile, boolean allowCaseVariations, boolean allowDifferentHosts) throws IOException, FileTransferException {
        this.checkCopyRemotelyPrerequisites(destFile, allowCaseVariations, allowDifferentHosts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void copyRecursively(AbstractFile sourceFile, AbstractFile destFile) throws FileTransferException {
        if (sourceFile.isSymlink()) {
            return;
        }
        if (sourceFile.isDirectory()) {
            AbstractFile[] children;
            try {
                destFile.mkdir();
            }
            catch (IOException e) {
                throw new FileTransferException(5);
            }
            try {
                children = sourceFile.ls();
            }
            catch (IOException e) {
                throw new FileTransferException(4);
            }
            for (AbstractFile child : children) {
                AbstractFile destChild;
                try {
                    destChild = destFile.getDirectChild(child.getName());
                }
                catch (IOException e) {
                    throw new FileTransferException(3);
                }
                this.copyRecursively(child, destChild);
            }
        } else {
            InputStream in;
            try {
                in = sourceFile.getInputStream();
            }
            catch (IOException e) {
                throw new FileTransferException(2);
            }
            try {
                destFile.copyStream(in, false, sourceFile.getSize());
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new FileTransferException(7);
                }
            }
        }
    }

    protected final void deleteRecursively(AbstractFile file) throws IOException, UnsupportedFileOperationException {
        if (file.isDirectory() && !file.isSymlink()) {
            AbstractFile[] children;
            for (AbstractFile child : children = file.ls()) {
                this.deleteRecursively(child);
            }
        }
        file.delete();
    }

    public final void importPermissions(AbstractFile sourceFile, FilePermissions defaultPermissions) throws IOException, UnsupportedFileOperationException {
        this.changePermissions(SimpleFilePermissions.padPermissions(sourceFile.getPermissions(), defaultPermissions).getIntValue());
    }

    public static boolean isFileOperationSupported(FileOperation fileOperation, Class<? extends AbstractFile> clazz) {
        return !fileOperation.getCorrespondingMethod(clazz).isAnnotationPresent(UnsupportedFileOperation.class);
    }

    public static String getExtension(String filename) {
        int len;
        int lastDotPos = filename.lastIndexOf(46);
        if (lastDotPos <= 0 || lastDotPos == (len = filename.length()) - 1) {
            return null;
        }
        return filename.substring(lastDotPos + 1, len);
    }

    public static String calculateChecksum(InputStream in, MessageDigest messageDigest) throws IOException {
        ChecksumInputStream cin = new ChecksumInputStream(in, messageDigest);
        try {
            StreamUtils.readUntilEOF(cin);
            return cin.getChecksumString();
        }
        catch (IOException e) {
            throw new FileTransferException(4);
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AbstractFile)) {
            return false;
        }
        return this.getURL().equals(((AbstractFile)o).getURL(), true, true);
    }

    public boolean equalsCanonical(Object o) {
        if (o == null || !(o instanceof AbstractFile)) {
            return false;
        }
        return this.getCanonicalPath(false).equals(((AbstractFile)o).getCanonicalPath(false));
    }

    public int hashCode() {
        return this.getURL().hashCode();
    }

    public String toString() {
        return this.getAbsolutePath();
    }

    @Override
    public abstract long getDate();

    public abstract void changeDate(long var1) throws IOException, UnsupportedFileOperationException;

    @Override
    public abstract long getSize();

    public abstract AbstractFile getParent();

    public abstract void setParent(AbstractFile var1);

    @Override
    public abstract boolean exists();

    @Override
    public abstract FilePermissions getPermissions();

    public abstract PermissionBits getChangeablePermissions();

    public abstract void changePermission(int var1, int var2, boolean var3) throws IOException, UnsupportedFileOperationException;

    public abstract String getOwner();

    public abstract boolean canGetOwner();

    public abstract String getGroup();

    public abstract boolean canGetGroup();

    @Override
    public abstract boolean isDirectory();

    public abstract boolean isArchive();

    public abstract boolean isSymlink();

    public abstract AbstractFile[] ls() throws IOException, UnsupportedFileOperationException;

    public abstract void mkdir() throws IOException, UnsupportedFileOperationException;

    public abstract InputStream getInputStream() throws IOException, UnsupportedFileOperationException;

    public abstract OutputStream getOutputStream() throws IOException, UnsupportedFileOperationException;

    public abstract OutputStream getAppendOutputStream() throws IOException, UnsupportedFileOperationException;

    public abstract RandomAccessInputStream getRandomAccessInputStream() throws IOException, UnsupportedFileOperationException;

    public abstract RandomAccessOutputStream getRandomAccessOutputStream() throws IOException, UnsupportedFileOperationException;

    public abstract void delete() throws IOException, UnsupportedFileOperationException;

    public abstract void renameTo(AbstractFile var1) throws IOException, UnsupportedFileOperationException;

    public abstract void copyRemotelyTo(AbstractFile var1) throws IOException, UnsupportedFileOperationException;

    public abstract long getFreeSpace() throws IOException, UnsupportedFileOperationException;

    public abstract long getTotalSpace() throws IOException, UnsupportedFileOperationException;

    public abstract Object getUnderlyingFileObject();
}

