/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.file;

import com.mucommander.commons.file.AbstractArchiveFile;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.ArchiveEntry;
import com.mucommander.commons.file.FileOperation;
import com.mucommander.commons.file.FilePermissions;
import com.mucommander.commons.file.FileURL;
import com.mucommander.commons.file.UnsupportedFileOperation;
import com.mucommander.commons.file.UnsupportedFileOperationException;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.filter.FilenameFilter;
import com.mucommander.commons.io.ByteUtils;
import com.mucommander.commons.io.RandomAccessInputStream;
import com.mucommander.commons.io.RandomAccessOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractArchiveEntryFile
extends AbstractFile {
    protected AbstractArchiveFile archiveFile;
    protected AbstractFile parent;
    protected ArchiveEntry entry;

    protected AbstractArchiveEntryFile(FileURL url, AbstractArchiveFile archiveFile, ArchiveEntry entry) {
        super(url);
        this.archiveFile = archiveFile;
        this.entry = entry;
    }

    public ArchiveEntry getEntry() {
        return this.entry;
    }

    public AbstractArchiveFile getArchiveFile() {
        return this.archiveFile;
    }

    public String getRelativeEntryPath() {
        String path = this.entry.getPath();
        String separator = this.getSeparator();
        if (!separator.equals("/")) {
            path = path.replace("/", separator);
        }
        return path;
    }

    public long getDate() {
        return this.entry.getDate();
    }

    public long getSize() {
        return this.entry.getSize();
    }

    public boolean isDirectory() {
        return this.entry.isDirectory();
    }

    public boolean isArchive() {
        return false;
    }

    public AbstractFile[] ls() throws IOException, UnsupportedFileOperationException {
        return this.archiveFile.ls(this, null, null);
    }

    public AbstractFile[] ls(FilenameFilter filter) throws IOException, UnsupportedFileOperationException {
        return this.archiveFile.ls(this, filter, null);
    }

    public AbstractFile[] ls(FileFilter filter) throws IOException, UnsupportedFileOperationException {
        return this.archiveFile.ls(this, null, filter);
    }

    public AbstractFile getParent() {
        return this.parent;
    }

    public void setParent(AbstractFile parent) {
        this.parent = parent;
    }

    public boolean exists() {
        return this.entry.exists();
    }

    public FilePermissions getPermissions() {
        return this.entry.getPermissions();
    }

    public void changePermission(int access, int permission, boolean enabled) throws IOException, UnsupportedFileOperationException {
        this.changePermissions(ByteUtils.setBit(this.getPermissions().getIntValue(), permission << access * 3, enabled));
    }

    public String getOwner() {
        return this.entry.getOwner();
    }

    public boolean canGetOwner() {
        return this.entry.getOwner() != null;
    }

    public String getGroup() {
        return this.entry.getGroup();
    }

    public boolean canGetGroup() {
        return this.entry.getGroup() != null;
    }

    public boolean isSymlink() {
        return false;
    }

    public long getFreeSpace() throws IOException, UnsupportedFileOperationException {
        return this.archiveFile.getFreeSpace();
    }

    public long getTotalSpace() throws IOException, UnsupportedFileOperationException {
        return this.archiveFile.getTotalSpace();
    }

    public InputStream getInputStream() throws IOException, UnsupportedFileOperationException {
        return this.archiveFile.getEntryInputStream(this.entry, null);
    }

    @UnsupportedFileOperation
    public OutputStream getAppendOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.APPEND_FILE);
    }

    @UnsupportedFileOperation
    public RandomAccessInputStream getRandomAccessInputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_READ_FILE);
    }

    @UnsupportedFileOperation
    public RandomAccessOutputStream getRandomAccessOutputStream() throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RANDOM_WRITE_FILE);
    }

    @UnsupportedFileOperation
    public void copyRemotelyTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.COPY_REMOTELY);
    }

    @UnsupportedFileOperation
    public void renameTo(AbstractFile destFile) throws UnsupportedFileOperationException {
        throw new UnsupportedFileOperationException(FileOperation.RENAME);
    }

    public Object getUnderlyingFileObject() {
        return this.entry;
    }

    public String getSeparator() {
        return this.archiveFile.getSeparator();
    }

    public String getAbsolutePath() {
        return this.archiveFile.getAbsolutePath(true) + this.getRelativeEntryPath();
    }

    public String getCanonicalPath() {
        return this.archiveFile.getCanonicalPath(true) + this.getRelativeEntryPath();
    }

    public AbstractFile getRoot() {
        return this.archiveFile.getRoot();
    }

    public boolean isRoot() {
        return false;
    }

    public AbstractFile getVolume() {
        return this.archiveFile.getVolume();
    }
}

