/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.conf;

import com.mucommander.commons.conf.BufferedConfigurationExplorer;
import com.mucommander.commons.conf.ConfigurationBuilder;
import com.mucommander.commons.conf.ConfigurationEvent;
import com.mucommander.commons.conf.ConfigurationException;
import com.mucommander.commons.conf.ConfigurationExplorer;
import com.mucommander.commons.conf.ConfigurationListener;
import com.mucommander.commons.conf.ConfigurationReader;
import com.mucommander.commons.conf.ConfigurationReaderFactory;
import com.mucommander.commons.conf.ConfigurationSection;
import com.mucommander.commons.conf.ConfigurationSource;
import com.mucommander.commons.conf.ConfigurationStructureException;
import com.mucommander.commons.conf.ConfigurationWriterFactory;
import com.mucommander.commons.conf.SourceConfigurationException;
import com.mucommander.commons.conf.ValueList;
import com.mucommander.commons.conf.XmlConfigurationWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private ConfigurationSource source;
    private ConfigurationReaderFactory readerFactory;
    private ConfigurationWriterFactory writerFactory;
    private final ConfigurationSection root = new ConfigurationSection();
    private final WeakHashMap<ConfigurationListener, ?> LISTENERS = new WeakHashMap();
    private final Object sourceLock = new Object();
    private final Object readerLock = new Object();
    private final Object writerLock = new Object();

    public Configuration() {
    }

    public Configuration(ConfigurationSource source, ConfigurationReaderFactory reader, ConfigurationWriterFactory writer) {
        this.setSource(source);
        this.setReaderFactory(reader);
        this.setWriterFactory(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(ConfigurationSource s) {
        Object object = this.sourceLock;
        synchronized (object) {
            this.source = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationSource getSource() {
        Object object = this.sourceLock;
        synchronized (object) {
            return this.source;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReaderFactory(ConfigurationReaderFactory f) {
        Object object = this.readerLock;
        synchronized (object) {
            this.readerFactory = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriterFactory(ConfigurationWriterFactory f) {
        Object object = this.writerLock;
        synchronized (object) {
            this.writerFactory = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationWriterFactory getWriterFactory() {
        Object object = this.writerLock;
        synchronized (object) {
            if (this.writerFactory == null) {
                return XmlConfigurationWriter.FACTORY;
            }
            return this.writerFactory;
        }
    }

    synchronized void read(Reader in, ConfigurationReader reader) throws IOException, ConfigurationException {
        reader.read(in, new ConfigurationLoader(this.root));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ConfigurationReader reader) throws IOException, ConfigurationException {
        Reader in = null;
        ConfigurationSource source = this.getSource();
        if (source == null) {
            throw new SourceConfigurationException("Configuration source hasn't been set.");
        }
        try {
            in = source.getReader();
            this.read(in, reader);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public void write(Writer out) throws ConfigurationException {
        this.write((ConfigurationBuilder)this.getWriterFactory().getWriterInstance(out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException, ConfigurationException {
        Writer out = null;
        ConfigurationSource source = this.getSource();
        if (source == null) {
            throw new SourceConfigurationException("No configuration source has been set");
        }
        try {
            out = source.getWriter();
            this.write(out);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void write(ConfigurationBuilder builder) throws ConfigurationException {
        builder.startConfiguration();
        this.build(builder, this.root);
        builder.endConfiguration();
    }

    private synchronized void build(ConfigurationBuilder builder, ConfigurationSection root) throws ConfigurationException {
        String name;
        Iterator<String> enumeration = root.variableNames();
        while (enumeration.hasNext()) {
            name = enumeration.next();
            builder.addVariable(name, root.getVariable(name));
        }
        enumeration = root.sectionNames();
        while (enumeration.hasNext()) {
            name = enumeration.next();
            ConfigurationSection section = root.getSection(name);
            if (!section.hasSections() && !section.hasVariables()) continue;
            builder.startSection(name);
            this.build(builder, section);
            builder.endSection(name);
        }
    }

    public void renameVariable(String fromVar, String toVar) {
        this.setVariable(toVar, this.removeVariable(fromVar));
    }

    public synchronized boolean setVariable(String name, String value) {
        ConfigurationExplorer explorer = new ConfigurationExplorer(this.root);
        String buffer = this.moveToParent(explorer, name, true);
        if (explorer.getSection().setVariable(buffer, value)) {
            this.triggerEvent(new ConfigurationEvent(this, name, value));
            return true;
        }
        return false;
    }

    public boolean setVariable(String name, int value) {
        return this.setVariable(name, ConfigurationSection.getValue(value));
    }

    public boolean setVariable(String name, List<String> value, String separator) {
        return this.setVariable(name, ConfigurationSection.getValue(value, separator));
    }

    public boolean setVariable(String name, float value) {
        return this.setVariable(name, ConfigurationSection.getValue(value));
    }

    public boolean setVariable(String name, boolean value) {
        return this.setVariable(name, ConfigurationSection.getValue(value));
    }

    public synchronized String getVariable(String name) {
        ConfigurationExplorer explorer = new ConfigurationExplorer(this.root);
        if ((name = this.moveToParent(explorer, name, false)) == null) {
            return null;
        }
        return explorer.getSection().getVariable(name);
    }

    public ValueList getListVariable(String name, String separator) {
        return ConfigurationSection.getListValue(this.getVariable(name), separator);
    }

    public int getIntegerVariable(String name) {
        return ConfigurationSection.getIntegerValue(this.getVariable(name));
    }

    public boolean getBooleanVariable(String name) {
        return ConfigurationSection.getBooleanValue(this.getVariable(name));
    }

    public boolean isVariableSet(String name) {
        return this.getVariable(name) != null;
    }

    private void prune(BufferedConfigurationExplorer explorer) {
        if (!explorer.hasSections()) {
            return;
        }
        ConfigurationSection current = explorer.popSection();
        while (current.isEmpty() && current != this.root) {
            ConfigurationSection parent = explorer.hasSections() ? explorer.popSection() : this.root;
            parent.removeSection(current);
            current = parent;
        }
    }

    public synchronized String removeVariable(String name) {
        BufferedConfigurationExplorer explorer = new BufferedConfigurationExplorer(this.root);
        String buffer = this.moveToParent(explorer, name, false);
        if (buffer == null) {
            return null;
        }
        buffer = explorer.getSection().removeVariable(buffer);
        if (buffer != null) {
            this.prune(explorer);
            this.triggerEvent(new ConfigurationEvent(this, name, null));
        }
        return buffer;
    }

    public void clear() {
        this.root.clear();
    }

    public synchronized String getVariable(String name, String defaultValue) {
        ConfigurationExplorer explorer = new ConfigurationExplorer(this.root);
        String buffer = this.moveToParent(explorer, name, true);
        String value = explorer.getSection().getVariable(buffer);
        if (value == null) {
            explorer.getSection().setVariable(buffer, defaultValue);
            this.triggerEvent(new ConfigurationEvent(this, name, defaultValue));
            return defaultValue;
        }
        return value;
    }

    public int getVariable(String name, int defaultValue) {
        return ConfigurationSection.getIntegerValue(this.getVariable(name, ConfigurationSection.getValue(defaultValue)));
    }

    public long getVariable(String name, long defaultValue) {
        return ConfigurationSection.getLongValue(this.getVariable(name, ConfigurationSection.getValue(defaultValue)));
    }

    public float getVariable(String name, float defaultValue) {
        return ConfigurationSection.getFloatValue(this.getVariable(name, ConfigurationSection.getValue(defaultValue)));
    }

    public boolean getVariable(String name, boolean defaultValue) {
        return ConfigurationSection.getBooleanValue(this.getVariable(name, ConfigurationSection.getValue(defaultValue)));
    }

    private String moveToParent(ConfigurationExplorer root, String name, boolean create) {
        StringTokenizer parser = new StringTokenizer(name, ".");
        while (parser.hasMoreTokens()) {
            name = parser.nextToken();
            if (!parser.hasMoreTokens()) {
                return name;
            }
            if (root.moveTo(name, create)) continue;
            return null;
        }
        return name;
    }

    public void addConfigurationListener(ConfigurationListener listener) {
        this.LISTENERS.put(listener, null);
    }

    private void triggerEvent(ConfigurationEvent event) {
        for (ConfigurationListener listener : this.LISTENERS.keySet()) {
            listener.configurationChanged(event);
        }
    }

    private class ConfigurationLoader
    implements ConfigurationBuilder {
        private Stack<ConfigurationSection> sections;
        private Stack<String> sectionNames;
        private ConfigurationSection currentSection;

        public ConfigurationLoader(ConfigurationSection root) {
            this.currentSection = root;
        }

        public void startConfiguration() {
            this.sections = new Stack();
            this.sectionNames = new Stack();
        }

        public void endConfiguration() throws ConfigurationException {
            if (!this.sections.empty()) {
                throw new ConfigurationStructureException("Not all sections have been closed.");
            }
            this.sections = null;
            this.sectionNames = null;
        }

        public void startSection(String name) throws ConfigurationException {
            ConfigurationSection buffer = this.currentSection.addSection(name);
            this.sections.push(this.currentSection);
            if (this.sectionNames.empty()) {
                this.sectionNames.push(name + '.');
            } else {
                this.sectionNames.push(this.sectionNames.peek() + name + '.');
            }
            this.currentSection = buffer;
        }

        public void endSection(String name) throws ConfigurationException {
            ConfigurationSection buffer;
            try {
                buffer = this.sections.pop();
                this.sectionNames.pop();
            }
            catch (EmptyStackException e) {
                throw new ConfigurationStructureException("Section " + name + " was already closed.");
            }
            if (buffer.getSection(name) != this.currentSection) {
                throw new ConfigurationStructureException("Section " + name + " is not the currently opened section.");
            }
            this.currentSection = buffer;
        }

        public void addVariable(String name, String value) {
            if (this.currentSection.setVariable(name, value)) {
                if (this.sectionNames.empty()) {
                    Configuration.this.triggerEvent(new ConfigurationEvent(Configuration.this, name, value));
                } else {
                    Configuration.this.triggerEvent(new ConfigurationEvent(Configuration.this, this.sectionNames.peek() + name, value));
                }
            }
        }
    }
}

