/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.commons.collections;

import com.mucommander.commons.collections.VectorChangeListener;
import java.util.Collection;
import java.util.Vector;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlteredVector<E>
extends Vector<E> {
    private WeakHashMap<VectorChangeListener, Object> listeners = new WeakHashMap();

    public AlteredVector() {
    }

    public AlteredVector(Collection<? extends E> collection) {
        super(collection);
    }

    public AlteredVector(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public AlteredVector(int initialCapacity) {
        super(initialCapacity);
    }

    public void addVectorChangeListener(VectorChangeListener listener) {
        this.listeners.put(listener, null);
    }

    private void fireElementsAddedEvent(int startIndex, int nbAdded) {
        for (VectorChangeListener listener : this.listeners.keySet()) {
            listener.elementsAdded(startIndex, nbAdded);
        }
    }

    private void fireElementsRemovedEvent(int startIndex, int nbRemoved) {
        for (VectorChangeListener listener : this.listeners.keySet()) {
            listener.elementsRemoved(startIndex, nbRemoved);
        }
    }

    private void fireElementChangedEvent(int index) {
        for (VectorChangeListener listener : this.listeners.keySet()) {
            listener.elementChanged(index);
        }
    }

    @Override
    public void setElementAt(E o, int i) {
        super.setElementAt(o, i);
        this.fireElementChangedEvent(i);
    }

    @Override
    public E set(int i, E o) {
        o = super.set(i, o);
        this.fireElementChangedEvent(i);
        return o;
    }

    @Override
    public void insertElementAt(E o, int i) {
        super.insertElementAt(o, i);
        this.fireElementsAddedEvent(i, 1);
    }

    @Override
    public void add(int i, E o) {
        this.insertElementAt(o, i);
        this.fireElementsAddedEvent(i, 1);
    }

    @Override
    public void addElement(E o) {
        super.addElement(o);
        this.fireElementsAddedEvent(this.size() - 1, 1);
    }

    @Override
    public boolean add(E o) {
        this.addElement(o);
        this.fireElementsAddedEvent(this.size() - 1, 1);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int sizeBefore = this.size();
        boolean b = super.addAll(collection);
        this.fireElementsAddedEvent(sizeBefore, this.size() - sizeBefore);
        return b;
    }

    @Override
    public boolean addAll(int i, Collection<? extends E> collection) {
        int sizeBefore = this.size();
        boolean b = super.addAll(i, collection);
        this.fireElementsAddedEvent(i, this.size() - sizeBefore);
        return b;
    }

    @Override
    public void removeElementAt(int i) {
        super.removeElementAt(i);
        this.fireElementsRemovedEvent(i, 1);
    }

    @Override
    public E remove(int i) {
        Object o = super.remove(i);
        this.fireElementsRemovedEvent(i, 1);
        return o;
    }

    @Override
    public boolean removeElement(Object o) {
        int index = this.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.removeElementAt(index);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeElement(o);
    }

    @Override
    public void removeAllElements() {
        int sizeBefore = this.size();
        super.removeAllElements();
        this.fireElementsRemovedEvent(0, sizeBefore);
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }
}

