/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.command;

import com.mucommander.command.AssociationBuilder;
import com.mucommander.command.CommandException;
import com.mucommander.xml.XmlAttributes;
import com.mucommander.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;

public class AssociationWriter
implements AssociationBuilder {
    private XmlWriter out;

    public AssociationWriter(OutputStream stream) throws IOException {
        this.out = new XmlWriter(stream);
    }

    public void startBuilding() throws CommandException {
        try {
            this.out.startElement("associations");
            this.out.println();
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void endBuilding() throws CommandException {
        try {
            this.out.endElement("associations");
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void startAssociation(String command) throws CommandException {
        XmlAttributes attr = new XmlAttributes();
        attr.add("command", command);
        try {
            this.out.startElement("association", attr);
            this.out.println();
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void endAssociation() throws CommandException {
        try {
            this.out.endElement("association");
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void setMask(String mask, boolean isCaseSensitive) throws CommandException {
        XmlAttributes attr = new XmlAttributes();
        attr.add("value", mask);
        if (!isCaseSensitive) {
            attr.add("case_sensitive", "false");
        }
        try {
            this.out.writeStandAloneElement("filename", attr);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void setIsSymlink(boolean isSymlink) throws CommandException {
        XmlAttributes attr = new XmlAttributes();
        attr.add("value", isSymlink ? "true" : "false");
        try {
            this.out.writeStandAloneElement("symlink", attr);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void setIsHidden(boolean isHidden) throws CommandException {
        XmlAttributes attr = new XmlAttributes();
        attr.add("value", isHidden ? "true" : "false");
        try {
            this.out.writeStandAloneElement("hidden", attr);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void setIsReadable(boolean isReadable) throws CommandException {
        XmlAttributes attr = new XmlAttributes();
        attr.add("value", isReadable ? "true" : "false");
        try {
            this.out.writeStandAloneElement("readable", attr);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void setIsWritable(boolean isWritable) throws CommandException {
        XmlAttributes attr = new XmlAttributes();
        attr.add("value", isWritable ? "true" : "false");
        try {
            this.out.writeStandAloneElement("writable", attr);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }

    public void setIsExecutable(boolean isExecutable) throws CommandException {
        XmlAttributes attr = new XmlAttributes();
        attr.add("value", isExecutable ? "true" : "false");
        try {
            this.out.writeStandAloneElement("executable", attr);
        }
        catch (IOException e) {
            throw new CommandException(e);
        }
    }
}

