/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.command;

import com.mucommander.command.AssociationBuilder;
import com.mucommander.command.CommandException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AssociationReader
extends DefaultHandler {
    private AssociationBuilder builder;
    private boolean isInAssociation;

    private AssociationReader(AssociationBuilder b) {
        this.builder = b;
    }

    public static void read(InputStream in, AssociationBuilder b) throws IOException, CommandException {
        b.startBuilding();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)new AssociationReader(b));
        }
        catch (ParserConfigurationException e) {
            throw new CommandException(e);
        }
        catch (SAXException e) {
            throw new CommandException(e);
        }
        finally {
            b.endBuilding();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (!this.isInAssociation) {
                if (qName.equals("association")) {
                    String buffer = attributes.getValue("command");
                    if (buffer == null) {
                        return;
                    }
                    this.isInAssociation = true;
                    this.builder.startAssociation(buffer);
                }
            } else if (qName.equals("filename")) {
                String buffer = attributes.getValue("value");
                if (buffer == null) {
                    return;
                }
                String caseSensitive = attributes.getValue("case_sensitive");
                if (caseSensitive != null) {
                    this.builder.setMask(buffer, caseSensitive.equals("true"));
                } else {
                    this.builder.setMask(buffer, true);
                }
            } else if (qName.equals("hidden")) {
                String buffer = attributes.getValue("value");
                if (buffer == null) {
                    return;
                }
                this.builder.setIsHidden(buffer.equals("true"));
            } else if (qName.equals("symlink")) {
                String buffer = attributes.getValue("value");
                if (buffer == null) {
                    return;
                }
                this.builder.setIsSymlink(buffer.equals("true"));
            } else if (qName.equals("readable")) {
                String buffer = attributes.getValue("value");
                if (buffer == null) {
                    return;
                }
                this.builder.setIsReadable(buffer.equals("true"));
            } else if (qName.equals("writable")) {
                String buffer = attributes.getValue("value");
                if (buffer == null) {
                    return;
                }
                this.builder.setIsWritable(buffer.equals("true"));
            } else if (qName.equals("executable")) {
                String buffer = attributes.getValue("value");
                if (buffer == null) {
                    return;
                }
                this.builder.setIsExecutable(buffer.equals("true"));
            }
        }
        catch (CommandException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("association") && this.isInAssociation) {
            try {
                this.builder.endAssociation();
            }
            catch (CommandException e) {
                throw new SAXException(e);
            }
            this.isInAssociation = false;
        }
    }
}

