/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.command;

import com.mucommander.command.AssociationBuilder;
import com.mucommander.command.CommandException;
import com.mucommander.command.CommandManager;
import com.mucommander.command.PermissionsFileFilter;
import com.mucommander.commons.file.filter.AndFileFilter;
import com.mucommander.commons.file.filter.AttributeFileFilter;
import com.mucommander.commons.file.filter.FileFilter;
import com.mucommander.commons.file.filter.RegexpFilenameFilter;

class AssociationFactory
implements AssociationBuilder {
    private AndFileFilter filter;
    private String command;

    AssociationFactory() {
    }

    public void startBuilding() {
    }

    public void endBuilding() {
    }

    public void startAssociation(String command) {
        this.filter = new AndFileFilter(new FileFilter[0]);
        this.command = command;
    }

    public void endAssociation() throws CommandException {
        if (!this.filter.isEmpty()) {
            CommandManager.registerAssociation(this.command, this.filter);
        }
    }

    public void setMask(String mask, boolean isCaseSensitive) {
        this.filter.addFileFilter(new RegexpFilenameFilter(mask, isCaseSensitive));
    }

    public void setIsSymlink(boolean isSymlink) {
        this.filter.addFileFilter(new AttributeFileFilter(4, isSymlink));
    }

    public void setIsHidden(boolean isHidden) {
        this.filter.addFileFilter(new AttributeFileFilter(5, isHidden));
    }

    public void setIsReadable(boolean isReadable) {
        this.filter.addFileFilter(new PermissionsFileFilter(4, isReadable));
    }

    public void setIsWritable(boolean isWritable) {
        this.filter.addFileFilter(new PermissionsFileFilter(2, isWritable));
    }

    public void setIsExecutable(boolean isExecutable) {
        this.filter.addFileFilter(new PermissionsFileFilter(1, isExecutable));
    }
}

