/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.cache;

import com.mucommander.cache.LRUCache;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastLRUCache<K, V>
extends LRUCache<K, V> {
    private LinkedHashMap<K, Object[]> cacheMap = new LinkedHashMap<K, Object[]>(16, 0.75f, true){

        @Override
        protected final boolean removeEldestEntry(Map.Entry<K, Object[]> eldest) {
            return FastLRUCache.this.cacheMap.size() > FastLRUCache.this.capacity;
        }
    };
    private long lastExpiredPurge;

    public FastLRUCache(int capacity) {
        super(capacity);
    }

    public String toString() {
        String s = super.toString() + " size=" + this.cacheMap.size() + " capacity=" + this.capacity + " eldestExpirationDate=" + this.eldestExpirationDate + "\n";
        int i = 0;
        for (Map.Entry<K, Object[]> mapEntry : this.cacheMap.entrySet()) {
            K key = mapEntry.getKey();
            Object[] value = mapEntry.getValue();
            s = s + i++ + "- key=" + key + " value=" + value[0] + " expirationDate=" + value[1] + "\n";
        }
        return s;
    }

    private void purgeExpiredItems() {
        long now = System.currentTimeMillis();
        if (this.eldestExpirationDate > now || this.cacheMap.size() < this.capacity && now - this.lastExpiredPurge < 1000L) {
            return;
        }
        this.eldestExpirationDate = Long.MAX_VALUE;
        Iterator<Object[]> iterator = this.cacheMap.values().iterator();
        while (iterator.hasNext()) {
            Long expirationDateL = (Long)iterator.next()[1];
            if (expirationDateL == null) continue;
            long expirationDate = expirationDateL;
            if (expirationDate < now) {
                iterator.remove();
                continue;
            }
            if (expirationDate >= this.eldestExpirationDate) continue;
            this.eldestExpirationDate = expirationDate;
        }
        this.lastExpiredPurge = now;
    }

    @Override
    public synchronized V get(K key) {
        this.purgeExpiredItems();
        Object[] value = this.cacheMap.get(key);
        if (value == null) {
            return null;
        }
        Long expirationDateL = (Long)value[1];
        if (expirationDateL != null && System.currentTimeMillis() > expirationDateL) {
            this.cacheMap.remove(key);
            return null;
        }
        return (V)value[0];
    }

    @Override
    public synchronized void add(K key, V value, long timeToLive) {
        Long expirationDateL;
        this.purgeExpiredItems();
        if (timeToLive == -1L) {
            expirationDateL = null;
        } else {
            long expirationDate = System.currentTimeMillis() + timeToLive;
            if (expirationDate < this.eldestExpirationDate) {
                this.eldestExpirationDate = expirationDate;
            }
            expirationDateL = expirationDate;
        }
        this.cacheMap.put(key, new Object[]{value, expirationDateL});
    }
}

