/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.bookmark.file;

import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkBuilder;
import com.mucommander.bookmark.BookmarkManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class BookmarkOutputStream
extends ByteArrayOutputStream
implements BookmarkBuilder {
    BookmarkOutputStream() {
    }

    public void close() throws IOException {
        super.close();
        try {
            BookmarkManager.readBookmarks(new ByteArrayInputStream(this.toByteArray()), this);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void startBookmarks() {
    }

    public void endBookmarks() {
    }

    public void addBookmark(String name, String location) {
        Bookmark newBookmark = new Bookmark(name, location);
        Bookmark oldBookmark = BookmarkManager.getBookmark(name);
        if (oldBookmark != null) {
            BookmarkManager.removeBookmark(oldBookmark);
        }
        BookmarkManager.addBookmark(newBookmark);
    }
}

