/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.bookmark;

import com.mucommander.RuntimeConstants;
import com.mucommander.bookmark.BookmarkBuilder;
import com.mucommander.bookmark.BookmarkException;
import com.mucommander.xml.XmlAttributes;
import com.mucommander.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;

class BookmarkWriter
implements BookmarkBuilder {
    private XmlWriter out;

    public BookmarkWriter(OutputStream stream) throws IOException {
        this.out = new XmlWriter(stream);
    }

    public void startBookmarks() throws BookmarkException {
        try {
            XmlAttributes attributes = new XmlAttributes();
            attributes.add("version", RuntimeConstants.VERSION);
            this.out.startElement("bookmarks", attributes);
            this.out.println();
        }
        catch (IOException e) {
            throw new BookmarkException(e);
        }
    }

    public void endBookmarks() throws BookmarkException {
        try {
            this.out.endElement("bookmarks");
        }
        catch (IOException e) {
            throw new BookmarkException(e);
        }
    }

    public void addBookmark(String name, String location) throws BookmarkException {
        try {
            this.out.startElement("bookmark");
            this.out.println();
            this.out.startElement("name");
            this.out.writeCData(name);
            this.out.endElement("name");
            this.out.startElement("location");
            this.out.writeCData(location);
            this.out.endElement("location");
            this.out.endElement("bookmark");
        }
        catch (IOException e) {
            throw new BookmarkException(e);
        }
    }
}

