/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.bookmark;

import com.mucommander.PlatformManager;
import com.mucommander.bookmark.Bookmark;
import com.mucommander.bookmark.BookmarkBuilder;
import com.mucommander.bookmark.BookmarkException;
import com.mucommander.bookmark.BookmarkListener;
import com.mucommander.bookmark.BookmarkParser;
import com.mucommander.bookmark.BookmarkWriter;
import com.mucommander.commons.collections.AlteredVector;
import com.mucommander.commons.collections.VectorChangeListener;
import com.mucommander.commons.file.AbstractFile;
import com.mucommander.commons.file.FileFactory;
import com.mucommander.io.backup.BackupInputStream;
import com.mucommander.io.backup.BackupOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BookmarkManager
implements VectorChangeListener {
    private static boolean isLoading = false;
    private static AbstractFile bookmarksFile;
    private static AlteredVector<Bookmark> bookmarks;
    private static WeakHashMap<BookmarkListener, ?> listeners;
    private static boolean fireEvents;
    private static boolean saveNeeded;
    private static long lastBookmarkChangeTime;
    private static long lastEventPauseTime;
    private static BookmarkManager singleton;

    private BookmarkManager() {
    }

    public static synchronized void buildBookmarks(BookmarkBuilder builder) throws BookmarkException {
        builder.startBookmarks();
        for (Bookmark bookmark : bookmarks) {
            builder.addBookmark(bookmark.getName(), bookmark.getLocation());
        }
        builder.endBookmarks();
    }

    public static synchronized AbstractFile getBookmarksFile() throws IOException {
        if (bookmarksFile == null) {
            return PlatformManager.getPreferencesFolder().getChild("bookmarks.xml");
        }
        return bookmarksFile;
    }

    public static void setBookmarksFile(String path) throws FileNotFoundException {
        AbstractFile file = FileFactory.getFile(path);
        if (file == null) {
            BookmarkManager.setBookmarksFile(new File(path));
        } else {
            BookmarkManager.setBookmarksFile(file);
        }
    }

    public static void setBookmarksFile(File file) throws FileNotFoundException {
        BookmarkManager.setBookmarksFile(FileFactory.getFile(file.getAbsolutePath()));
    }

    public static synchronized void setBookmarksFile(AbstractFile file) throws FileNotFoundException {
        if (file.isBrowsable()) {
            throw new FileNotFoundException("Not a valid file: " + file.getAbsolutePath());
        }
        bookmarksFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadBookmarks() throws Exception {
        BackupInputStream in = null;
        isLoading = true;
        try {
            in = new BackupInputStream(BookmarkManager.getBookmarksFile());
            BookmarkManager.readBookmarks(in, new Loader());
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception exception) {}
            }
            isLoading = false;
        }
    }

    public static synchronized void readBookmarks(InputStream in, BookmarkBuilder builder) throws Exception {
        new BookmarkParser().parse(in, builder);
    }

    public static BookmarkBuilder getBookmarkWriter(OutputStream out) throws IOException {
        return new BookmarkWriter(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void writeBookmarks(boolean forceWrite) throws IOException, BookmarkException {
        if (!forceWrite && !saveNeeded) {
            return;
        }
        BackupOutputStream out = null;
        try {
            out = new BackupOutputStream(BookmarkManager.getBookmarksFile());
            BookmarkManager.buildBookmarks(BookmarkManager.getBookmarkWriter(out));
            saveNeeded = false;
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static synchronized AlteredVector<Bookmark> getBookmarks() {
        return bookmarks;
    }

    public static synchronized void removeBookmark(Bookmark bookmark) {
        bookmarks.remove(bookmark);
    }

    public static synchronized Bookmark getBookmark(String name) {
        int nbBookmarks = bookmarks.size();
        for (int i = 0; i < nbBookmarks; ++i) {
            Bookmark b = (Bookmark)bookmarks.elementAt(i);
            if (!b.getName().equalsIgnoreCase(name)) continue;
            return b;
        }
        return null;
    }

    public static synchronized void addBookmark(Bookmark b) {
        bookmarks.add(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBookmarkListener(BookmarkListener listener) {
        WeakHashMap<BookmarkListener, ?> weakHashMap = listeners;
        synchronized (weakHashMap) {
            listeners.put(listener, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fireBookmarksChanged() {
        if (!isLoading) {
            saveNeeded = true;
        }
        lastBookmarkChangeTime = System.currentTimeMillis();
        if (!fireEvents) {
            return;
        }
        WeakHashMap<BookmarkListener, ?> weakHashMap = listeners;
        synchronized (weakHashMap) {
            for (BookmarkListener listener : listeners.keySet()) {
                listener.bookmarksChanged();
            }
        }
    }

    public static synchronized void setFireEvents(boolean b) {
        if (b) {
            if (!fireEvents && lastBookmarkChangeTime >= lastEventPauseTime) {
                fireEvents = true;
                BookmarkManager.fireBookmarksChanged();
            }
        } else if (fireEvents) {
            fireEvents = false;
            lastEventPauseTime = System.currentTimeMillis();
        }
    }

    @Override
    public void elementsAdded(int startIndex, int nbAdded) {
        BookmarkManager.fireBookmarksChanged();
    }

    @Override
    public void elementsRemoved(int startIndex, int nbRemoved) {
        BookmarkManager.fireBookmarksChanged();
    }

    @Override
    public void elementChanged(int index) {
        BookmarkManager.fireBookmarksChanged();
    }

    static {
        bookmarks = new AlteredVector();
        listeners = new WeakHashMap();
        fireEvents = true;
        singleton = new BookmarkManager();
        bookmarks.addVectorChangeListener(singleton);
    }

    private static class Loader
    implements BookmarkBuilder {
        private Loader() {
        }

        public void startBookmarks() {
        }

        public void endBookmarks() {
        }

        public void addBookmark(String name, String location) {
            BookmarkManager.addBookmark(new Bookmark(name, location));
        }
    }
}

