/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.bonjour;

import com.mucommander.bonjour.BonjourDirectory;
import com.mucommander.bonjour.BonjourService;
import com.mucommander.text.Translator;
import com.mucommander.ui.action.MuAction;
import com.mucommander.ui.helper.MnemonicHelper;
import com.mucommander.ui.icon.IconManager;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class BonjourMenu
extends JMenu
implements MenuListener {
    public BonjourMenu() {
        super(Translator.get("bonjour.bonjour_services", new String[0]));
        this.setIcon(IconManager.getIcon(0, "bonjour.png"));
        this.addMenuListener(this);
    }

    public abstract MuAction getMenuItemAction(BonjourService var1);

    public void menuSelected(MenuEvent menuEvent) {
        this.removeAll();
        if (BonjourDirectory.isActive()) {
            BonjourService[] services = BonjourDirectory.getServices();
            int nbServices = services.length;
            if (nbServices > 0) {
                MnemonicHelper mnemonicHelper = new MnemonicHelper();
                for (int i = 0; i < nbServices; ++i) {
                    JMenuItem menuItem = new JMenuItem(this.getMenuItemAction(services[i]));
                    menuItem.setMnemonic(mnemonicHelper.getMnemonic(menuItem.getText()));
                    this.add(menuItem);
                }
            } else {
                this.add(new JMenuItem(Translator.get("bonjour.no_service_discovered", new String[0]))).setEnabled(false);
            }
        } else {
            this.add(new JMenuItem(Translator.get("bonjour.bonjour_disabled", new String[0]))).setEnabled(false);
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }
}

