/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander.auth;

import com.mucommander.RuntimeConstants;
import com.mucommander.auth.CredentialsManager;
import com.mucommander.auth.CredentialsMapping;
import com.mucommander.bookmark.XORCipher;
import com.mucommander.commons.file.Credentials;
import com.mucommander.commons.file.FileURL;
import com.mucommander.xml.XmlAttributes;
import com.mucommander.xml.XmlWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class CredentialsWriter {
    static void write(OutputStream stream) throws IOException {
        XmlWriter out = new XmlWriter(stream);
        XmlAttributes attributes = new XmlAttributes();
        attributes.add("encryption", "weak");
        attributes.add("version", RuntimeConstants.VERSION);
        out.startElement("credentials_list", attributes);
        out.println();
        for (CredentialsMapping credentialsMapping : CredentialsManager.getPersistentCredentialMappings()) {
            FileURL realm = credentialsMapping.getRealm();
            out.startElement("credentials");
            out.println();
            out.startElement("url");
            out.writeCData(realm.toString(false));
            out.endElement("url");
            Credentials credentials = credentialsMapping.getCredentials();
            out.startElement("login");
            out.writeCData(credentials.getLogin());
            out.endElement("login");
            out.startElement("password");
            out.writeCData(XORCipher.encryptXORBase64(credentials.getPassword()));
            out.endElement("password");
            Enumeration<String> propertyKeys = realm.getPropertyNames();
            while (propertyKeys.hasMoreElements()) {
                String name = propertyKeys.nextElement();
                attributes = new XmlAttributes();
                attributes.add("name", name);
                attributes.add("value", realm.getProperty(name));
                out.startElement("property", attributes);
                out.endElement("property");
            }
            out.endElement("credentials");
        }
        out.endElement("credentials_list");
    }
}

