/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander;

import com.mucommander.RuntimeConstants;
import com.mucommander.commons.file.FileFactory;
import java.io.InputStream;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VersionChecker
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionChecker.class);
    private String latestVersion;
    private String downloadURL;
    private String jarURL;
    private String releaseDate;
    private int state;

    private VersionChecker() {
    }

    public static VersionChecker getInstance() throws Exception {
        VersionChecker instance;
        LOGGER.debug("Opening connection to " + RuntimeConstants.VERSION_URL);
        InputStream in = FileFactory.getFile(RuntimeConstants.VERSION_URL).getInputStream();
        try {
            instance = new VersionChecker();
            SAXParserFactory.newInstance().newSAXParser().parse(in, (DefaultHandler)instance);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to read version XML file at " + RuntimeConstants.VERSION_URL, e);
            throw e;
        }
        finally {
            in.close();
        }
        if (instance.latestVersion == null || instance.latestVersion.equals("") || instance.downloadURL == null || instance.downloadURL.equals("")) {
            throw new Exception();
        }
        return instance;
    }

    public boolean isNewVersionAvailable() {
        if (this.latestVersion.equals(RuntimeConstants.VERSION.trim().toLowerCase())) {
            if (this.releaseDate.equals("")) {
                return true;
            }
            return this.releaseDate.compareTo(RuntimeConstants.BUILD_DATE) > 0;
        }
        return true;
    }

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public String getJarURL() {
        return this.jarURL;
    }

    public void startDocument() {
        this.latestVersion = "";
        this.downloadURL = "";
        this.jarURL = "";
        this.releaseDate = "";
    }

    public void characters(char[] ch, int offset, int length) {
        if (this.state == 1) {
            this.latestVersion = this.latestVersion + new String(ch, offset, length);
        } else if (this.state == 2) {
            this.downloadURL = this.downloadURL + new String(ch, offset, length);
        } else if (this.state == 3) {
            this.jarURL = this.jarURL + new String(ch, offset, length);
        } else if (this.state == 4) {
            this.releaseDate = this.releaseDate + new String(ch, offset, length);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.state = qName.equals("latest_version") ? 1 : (qName.equals("download_url") ? 2 : (qName.equals("jar_url") ? 3 : (qName.equals("release_date") ? 4 : 5)));
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.state = 5;
    }

    public void endDocument() {
        this.latestVersion = this.latestVersion.toLowerCase().trim();
        this.downloadURL = this.downloadURL.trim();
        this.jarURL = this.jarURL.trim();
        if ("".equals(this.jarURL)) {
            this.jarURL = null;
        }
        this.releaseDate = this.releaseDate.trim();
        LOGGER.debug("download URL: " + this.downloadURL);
        LOGGER.debug("jar URL: " + this.jarURL);
        LOGGER.debug("latestVersion: " + this.latestVersion);
        LOGGER.debug("releaseDate:   " + this.releaseDate);
    }
}

