/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander;

import com.mucommander.commons.file.util.ResourceLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeConstants {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeConstants.class);
    public static final String VERSION_URL;
    public static final String VERSION;
    public static final String BUILD_DATE;
    public static final String COPYRIGHT;
    public static final String APP_STRING;
    public static final String BUILD_NUMBER;

    private static String getAttribute(Attributes attributes, String name) {
        String buffer = attributes.getValue(name);
        if (buffer == null) {
            return "?";
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream inputStream = null;
        Attributes attributes = null;
        try {
            inputStream = ResourceLoader.getResourceAsStream("META-INF/MANIFEST.MF", ResourceLoader.getDefaultClassLoader(), ResourceLoader.getRootPackageAsFile(RuntimeConstants.class));
            if (inputStream != null) {
                Manifest manifest = new Manifest();
                manifest.read(inputStream);
                attributes = manifest.getMainAttributes();
            } else {
                LOGGER.warn("MANIFEST.MF not found, default values will be used");
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to read MANIFEST.MF, default values will be used", exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (attributes == null) {
            VERSION = "?";
            COPYRIGHT = "2002-" + Calendar.getInstance().get(1);
            BUILD_DATE = "20020101";
            VERSION_URL = "http://www.mucommander.com/version/version.xml";
            BUILD_NUMBER = "?";
        } else {
            VERSION = RuntimeConstants.getAttribute(attributes, "Specification-Version");
            BUILD_DATE = RuntimeConstants.getAttribute(attributes, "Build-Date");
            VERSION_URL = RuntimeConstants.getAttribute(attributes, "Build-URL");
            BUILD_NUMBER = RuntimeConstants.getAttribute(attributes, "Implementation-Version");
            COPYRIGHT = BUILD_DATE.length() > 4 ? BUILD_DATE.substring(0, 4) : "20020101";
        }
        APP_STRING = "muCommander v" + VERSION;
    }
}

