/*
 * Decompiled with CFR 0.152.
 */
package com.mucommander;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.LayoutBase;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import com.mucommander.conf.MuConfigurations;
import com.mucommander.conf.MuPreference;
import com.mucommander.ui.dialog.debug.DebugConsoleAppender;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuLogging {
    private static ConsoleAppender<ILoggingEvent> consoleAppender;
    private static DebugConsoleAppender debugConsoleAppender;

    private static void updateLogLevel(LogLevel level) {
        Logger logger = (Logger)LoggerFactory.getLogger("ROOT");
        logger.setLevel(level.toLogbackLevel());
    }

    public static LogLevel getLevel(ILoggingEvent loggingEvent) {
        return LogLevel.valueOf(loggingEvent.getLevel());
    }

    public static LogLevel getLogLevel() {
        return LogLevel.valueOf(MuConfigurations.getPreferences().getVariable(MuPreference.LOG_LEVEL, "WARNING"));
    }

    public static void setLogLevel(LogLevel level) {
        MuConfigurations.getPreferences().setVariable(MuPreference.LOG_LEVEL, level.toString());
        MuLogging.updateLogLevel(level);
    }

    public static DebugConsoleAppender getDebugConsoleAppender() {
        return debugConsoleAppender;
    }

    static void configureLogging() throws IOException {
        Appender<ILoggingEvent>[] appenders;
        Logger rootLogger = (Logger)LoggerFactory.getLogger("ROOT");
        LoggerContext loggerContext = rootLogger.getLoggerContext();
        loggerContext.reset();
        rootLogger.detachAndStopAllAppenders();
        for (Appender<ILoggingEvent> appender : appenders = MuLogging.createAppenders(loggerContext)) {
            rootLogger.addAppender(appender);
        }
        MuLogging.updateLogLevel(MuLogging.getLogLevel());
    }

    private static Appender<ILoggingEvent>[] createAppenders(LoggerContext loggerContext) {
        CustomLoggingLayout layout = new CustomLoggingLayout();
        consoleAppender = MuLogging.createConsoleAppender(loggerContext, layout);
        debugConsoleAppender = MuLogging.createDebugConsoleAppender(loggerContext, layout);
        return new Appender[]{consoleAppender, debugConsoleAppender};
    }

    private static ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext loggerContext, Layout<ILoggingEvent> layout) {
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>();
        LayoutWrappingEncoder<ILoggingEvent> encoder = new LayoutWrappingEncoder<ILoggingEvent>();
        encoder.setContext(loggerContext);
        encoder.setLayout(layout);
        encoder.start();
        consoleAppender.setContext(loggerContext);
        consoleAppender.setEncoder(encoder);
        consoleAppender.start();
        return consoleAppender;
    }

    private static DebugConsoleAppender createDebugConsoleAppender(LoggerContext loggerContext, Layout<ILoggingEvent> layout) {
        DebugConsoleAppender debugConsoleAppender = new DebugConsoleAppender(layout);
        debugConsoleAppender.setContext(loggerContext);
        debugConsoleAppender.start();
        return debugConsoleAppender;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CustomLoggingLayout
    extends LayoutBase<ILoggingEvent> {
        private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

        private CustomLoggingLayout() {
        }

        @Override
        public String doLayout(ILoggingEvent event) {
            StackTraceElement stackTraceElement = event.getCallerData()[0];
            StringBuilder sbuf = new StringBuilder(128);
            sbuf.append("[");
            sbuf.append(SIMPLE_DATE_FORMAT.format(new Date(event.getTimeStamp())));
            sbuf.append("] ");
            sbuf.append((Object)MuLogging.getLevel(event));
            sbuf.append(" ");
            sbuf.append(stackTraceElement.getFileName());
            sbuf.append("#");
            sbuf.append(stackTraceElement.getMethodName());
            sbuf.append(",");
            sbuf.append(stackTraceElement.getLineNumber());
            sbuf.append(" ");
            sbuf.append(event.getFormattedMessage());
            sbuf.append(CoreConstants.LINE_SEPARATOR);
            return sbuf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LogLevel {
        OFF,
        SEVERE,
        WARNING,
        INFO,
        CONFIG,
        FINE,
        FINER,
        FINEST;


        public static LogLevel valueOf(Level logbackLevel) {
            switch (logbackLevel.toInt()) {
                case 0x7FFFFFFF: {
                    return OFF;
                }
                case 40000: {
                    return SEVERE;
                }
                case 30000: {
                    return WARNING;
                }
                case 20000: {
                    return INFO;
                }
                case 10000: {
                    return FINE;
                }
                case 5000: {
                    return FINEST;
                }
            }
            return OFF;
        }

        public Level toLogbackLevel() {
            switch (this) {
                case SEVERE: {
                    return Level.ERROR;
                }
                case WARNING: {
                    return Level.WARN;
                }
                case INFO: 
                case CONFIG: {
                    return Level.INFO;
                }
                case FINE: 
                case FINER: {
                    return Level.DEBUG;
                }
                case FINEST: {
                    return Level.TRACE;
                }
            }
            return Level.OFF;
        }
    }
}

