/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

public final class ArabicShaping {
    private final int options;
    private boolean isLogical;
    private boolean spacesRelativeToTextBeginEnd;
    private char tailChar;
    private static final int[] irrelevantPos = new int[]{0, 2, 4, 6, 8, 10, 12, 14};
    private static final int[] tailFamilyIsolatedFinal = new int[]{1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1};
    private static final int[] tashkeelMedial = new int[]{0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1};
    private static final char[] yehHamzaToYeh = new char[]{'\ufeef', '\ufef0'};
    private static final char[] convertNormalizedLamAlef = new char[]{'\u0622', '\u0623', '\u0625', '\u0627'};
    private static final int[] araLink = new int[]{4385, 4897, 5377, 5921, 6403, 7457, 7939, 8961, 9475, 10499, 11523, 12547, 13571, 14593, 15105, 15617, 16129, 16643, 17667, 18691, 19715, 20739, 21763, 22787, 23811, 0, 0, 0, 0, 0, 3, 24835, 25859, 26883, 27923, 28931, 29955, 30979, 32001, 32513, 33027, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 34049, 34561, 35073, 35585, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 33, 33, 0, 33, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 3, 3, 3, 3, 1, 1};
    private static final int[] presLink = new int[]{3, 3, 3, 0, 3, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 32, 33, 32, 33, 0, 1, 32, 33, 0, 2, 3, 1, 32, 33, 0, 2, 3, 1, 0, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 16, 18, 19, 17, 0, 2, 3, 1, 0, 2, 3, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 2, 3, 1, 0, 1, 0, 1, 0, 1, 0, 1};
    private static int[] convertFEto06 = new int[]{1611, 1611, 1612, 1612, 1613, 1613, 1614, 1614, 1615, 1615, 1616, 1616, 1617, 1617, 1618, 1618, 1569, 1570, 1570, 1571, 1571, 1572, 1572, 1573, 1573, 1574, 1574, 1574, 1574, 1575, 1575, 1576, 1576, 1576, 1576, 1577, 1577, 1578, 1578, 1578, 1578, 1579, 1579, 1579, 1579, 1580, 1580, 1580, 1580, 1581, 1581, 1581, 1581, 1582, 1582, 1582, 1582, 1583, 1583, 1584, 1584, 1585, 1585, 1586, 1586, 1587, 1587, 1587, 1587, 1588, 1588, 1588, 1588, 1589, 1589, 1589, 1589, 1590, 1590, 1590, 1590, 1591, 1591, 1591, 1591, 1592, 1592, 1592, 1592, 1593, 1593, 1593, 1593, 1594, 1594, 1594, 1594, 1601, 1601, 1601, 1601, 1602, 1602, 1602, 1602, 1603, 1603, 1603, 1603, 1604, 1604, 1604, 1604, 1605, 1605, 1605, 1605, 1606, 1606, 1606, 1606, 1607, 1607, 1607, 1607, 1608, 1608, 1609, 1609, 1610, 1610, 1610, 1610, 1628, 1628, 1629, 1629, 1630, 1630, 1631, 1631};
    private static final int[][][] shapeTable = new int[][][]{new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 3}, {0, 1, 0, 1}}, new int[][]{{0, 0, 2, 2}, {0, 0, 1, 2}, {0, 1, 1, 2}, {0, 1, 1, 3}}, new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 1, 0, 3}, {0, 1, 0, 3}}, new int[][]{{0, 0, 1, 2}, {0, 0, 1, 2}, {0, 1, 1, 2}, {0, 1, 1, 3}}};

    public ArabicShaping(int options) {
        this.options = options;
        if ((options & 0xE0) > 128) {
            throw new IllegalArgumentException("bad DIGITS options");
        }
        this.isLogical = (options & 4) == 0;
        this.spacesRelativeToTextBeginEnd = (options & 0x4000000) == 0x4000000;
        this.tailChar = (options & 0x8000000) == 0x8000000 ? (char)65139 : (char)8203;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == ArabicShaping.class && this.options == ((ArabicShaping)object).options;
    }

    public int hashCode() {
        return this.options;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append('[');
        switch (this.options & 0x10003) {
            case 0: {
                buf.append("LamAlef resize");
                break;
            }
            case 1: {
                buf.append("LamAlef spaces at near");
                break;
            }
            case 3: {
                buf.append("LamAlef spaces at begin");
                break;
            }
            case 2: {
                buf.append("LamAlef spaces at end");
                break;
            }
            case 65536: {
                buf.append("lamAlef auto");
            }
        }
        switch (this.options & 4) {
            case 0: {
                buf.append(", logical");
                break;
            }
            case 4: {
                buf.append(", visual");
            }
        }
        switch (this.options & 0x18) {
            case 0: {
                buf.append(", no letter shaping");
                break;
            }
            case 8: {
                buf.append(", shape letters");
                break;
            }
            case 24: {
                buf.append(", shape letters tashkeel isolated");
                break;
            }
            case 16: {
                buf.append(", unshape letters");
            }
        }
        switch (this.options & 0x700000) {
            case 0x200000: {
                buf.append(", Seen at near");
            }
        }
        switch (this.options & 0x3800000) {
            case 0x1000000: {
                buf.append(", Yeh Hamza at near");
            }
        }
        switch (this.options & 0xE0000) {
            case 262144: {
                buf.append(", Tashkeel at begin");
                break;
            }
            case 393216: {
                buf.append(", Tashkeel at end");
                break;
            }
            case 786432: {
                buf.append(", Tashkeel replace with tatweel");
                break;
            }
            case 524288: {
                buf.append(", Tashkeel resize");
            }
        }
        switch (this.options & 0xE0) {
            case 0: {
                buf.append(", no digit shaping");
                break;
            }
            case 32: {
                buf.append(", shape digits to AN");
                break;
            }
            case 64: {
                buf.append(", shape digits to EN");
                break;
            }
            case 96: {
                buf.append(", shape digits to AN contextually: default EN");
                break;
            }
            case 128: {
                buf.append(", shape digits to AN contextually: default AL");
            }
        }
        switch (this.options & 0x100) {
            case 0: {
                buf.append(", standard Arabic-Indic digits");
                break;
            }
            case 256: {
                buf.append(", extended Arabic-Indic digits");
            }
        }
        buf.append("]");
        return buf.toString();
    }
}

