/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.OptionHelper;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    private static boolean ignoreTCL = false;

    public static List<URL> getResourceOccurenceCount(String resource, ClassLoader classLoader) throws IOException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        Enumeration<URL> urlEnum = classLoader.getResources(resource);
        while (urlEnum.hasMoreElements()) {
            URL url = urlEnum.nextElement();
            urlList.add(url);
        }
        return urlList;
    }

    public static URL getResource(String resource, ClassLoader classLoader) {
        try {
            return classLoader.getResource(resource);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static URL getResourceBySelfClassLoader(String string) {
        return Loader.getResource(string, Loader.getClassLoaderOfClass(Loader.class));
    }

    public static ClassLoader getTCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class loadClass(String clazz, Context context) throws ClassNotFoundException {
        ClassLoader cl = Loader.getClassLoaderOfObject(context);
        return cl.loadClass(clazz);
    }

    public static ClassLoader getClassLoaderOfObject(Object o) {
        if (o == null) {
            throw new NullPointerException("Argument cannot be null");
        }
        return Loader.getClassLoaderOfClass(o.getClass());
    }

    public static ClassLoader getClassLoaderOfClass(Class clazz) {
        ClassLoader cl = clazz.getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public static Class loadClass(String clazz) throws ClassNotFoundException {
        if (ignoreTCL) {
            return Class.forName(clazz);
        }
        try {
            return Loader.getTCL().loadClass(clazz);
        }
        catch (Throwable e) {
            return Class.forName(clazz);
        }
    }

    static {
        String ignoreTCLProp = OptionHelper.getSystemProperty("logback.ignoreTCL", null);
        if (ignoreTCLProp != null) {
            ignoreTCL = OptionHelper.toBoolean(ignoreTCLProp, true);
        }
    }
}

