/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.AppenderAttachable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderAttachableImpl<E>
implements AppenderAttachable<E> {
    private final List<Appender<E>> appenderList = new ArrayList<Appender<E>>();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock r = this.rwLock.readLock();
    private final Lock w = this.rwLock.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppender(Appender<E> newAppender) {
        if (newAppender == null) {
            throw new IllegalArgumentException("Null argument disallowed");
        }
        this.w.lock();
        try {
            if (!this.appenderList.contains(newAppender)) {
                this.appenderList.add(newAppender);
            }
        }
        finally {
            this.w.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendLoopOnAppenders(E e) {
        int size = 0;
        this.r.lock();
        try {
            for (Appender<E> appender : this.appenderList) {
                appender.doAppend(e);
                ++size;
            }
        }
        finally {
            this.r.unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachAndStopAllAppenders() {
        this.w.lock();
        try {
            for (Appender<E> a : this.appenderList) {
                a.stop();
            }
            this.appenderList.clear();
        }
        finally {
            this.w.unlock();
        }
    }
}

