/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.helpers.NOPAppender;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.sift.AppenderFactoryBase;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.sift.AppenderTrackerImpl;
import ch.qos.logback.core.sift.Discriminator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SiftingAppenderBase<E>
extends UnsynchronizedAppenderBase<E> {
    protected AppenderTracker<E> appenderTracker = new AppenderTrackerImpl();
    AppenderFactoryBase<E> appenderFactory;
    Discriminator<E> discriminator;
    int nopaWarningCount = 0;

    public void setAppenderFactory(AppenderFactoryBase<E> appenderFactory) {
        this.appenderFactory = appenderFactory;
    }

    @Override
    public void start() {
        int errors = 0;
        if (this.discriminator == null) {
            this.addError("Missing discriminator. Aborting");
            ++errors;
        }
        if (!this.discriminator.isStarted()) {
            this.addError("Discriminator has not started successfully. Aborting");
            ++errors;
        }
        if (errors == 0) {
            super.start();
        }
    }

    @Override
    public void stop() {
        for (Appender<E> appender : this.appenderTracker.valueList()) {
            appender.stop();
        }
    }

    protected abstract long getTimestamp(E var1);

    @Override
    protected void append(E event) {
        long timestamp;
        if (!this.isStarted()) {
            return;
        }
        String discriminatingValue = this.discriminator.getDiscriminatingValue(event);
        Appender<E> appender = this.appenderTracker.get(discriminatingValue, timestamp = this.getTimestamp(event));
        if (appender == null) {
            try {
                appender = this.appenderFactory.buildAppender(this.context, discriminatingValue);
                if (appender == null) {
                    appender = this.buildNOPAppender(discriminatingValue);
                }
                this.appenderTracker.put(discriminatingValue, appender, timestamp);
            }
            catch (JoranException e) {
                this.addError("Failed to build appender for [" + discriminatingValue + "]", e);
                return;
            }
        }
        this.appenderTracker.stopStaleAppenders(timestamp);
        appender.doAppend(event);
    }

    NOPAppender<E> buildNOPAppender(String discriminatingValue) {
        NOPAppender nopa = new NOPAppender();
        if (this.nopaWarningCount < 4) {
            ++this.nopaWarningCount;
            this.addError("Failed to build an appender for discriminating value [" + discriminatingValue + "]");
        }
        return nopa;
    }

    public String getDiscriminatorKey() {
        if (this.discriminator != null) {
            return this.discriminator.getKey();
        }
        return null;
    }
}

