/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CyclicBuffer<E> {
    E[] ea;
    int first;
    int last;
    int numElems;
    int maxSize;

    public CyclicBuffer(int maxSize) throws IllegalArgumentException {
        if (maxSize < 1) {
            throw new IllegalArgumentException("The maxSize argument (" + maxSize + ") is not a positive integer.");
        }
        this.init(maxSize);
    }

    private void init(int maxSize) {
        this.maxSize = maxSize;
        this.ea = new Object[maxSize];
        this.first = 0;
        this.last = 0;
        this.numElems = 0;
    }

    public void add(E event) {
        this.ea[this.last] = event;
        if (++this.last == this.maxSize) {
            this.last = 0;
        }
        if (this.numElems < this.maxSize) {
            ++this.numElems;
        } else if (++this.first == this.maxSize) {
            this.first = 0;
        }
    }

    public E get(int i) {
        if (i < 0 || i >= this.numElems) {
            return null;
        }
        return this.ea[(this.first + i) % this.maxSize];
    }

    public List<E> asList() {
        ArrayList<E> tList = new ArrayList<E>();
        for (int i = 0; i < this.length(); ++i) {
            tList.add(this.get(i));
        }
        return tList;
    }

    public int length() {
        return this.numElems;
    }
}

