/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    static void installIfAsked(LoggerContext loggerContext) {
        String slClass = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isEmpty(slClass)) {
            StatusListenerConfigHelper.addStatusListener(loggerContext, slClass);
        }
    }

    static void addStatusListener(LoggerContext loggerContext, String string) {
        StatusListener statusListener = null;
        if ("SYSOUT".equalsIgnoreCase(string)) {
            statusListener = new OnConsoleStatusListener();
        } else {
            try {
                statusListener = (StatusListener)OptionHelper.instantiateByClassName(string, StatusListener.class, loggerContext);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (statusListener != null) {
            loggerContext.getStatusManager().add(statusListener);
        }
    }
}

