'''OpenGL extension NV.texgen_emboss

This module customises the behaviour of the 
OpenGL.raw.GL.NV.texgen_emboss to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides a new texture coordinate generation mode
	suitable for multitexture-based embossing (or bump mapping) effects.
	
	Given two texture units, this extension generates the texture
	coordinates of a second texture unit (an odd-numbered texture unit)
	as a perturbation of a first texture unit (an even-numbered texture
	unit one less than the second texture unit).  The perturbation is
	based on the normal, tangent, and light vectors.  The normal vector
	is supplied by glNormal; the light vector is supplied as a direction
	vector to a specified OpenGL light's position; and the tanget
	vector is supplied by the second texture unit's current texture
	coordinate.  The perturbation is also scaled by program-supplied
	scaling constants.
	
	If both texture units are bound to the same texture representing a
	height field, by subtracting the difference between the resulting two
	filtered texels, programs can achieve a per-pixel embossing effect.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/texgen_emboss.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.NV.texgen_emboss import *
from OpenGL.raw.GL.NV.texgen_emboss import _EXTENSION_NAME

def glInitTexgenEmbossNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION