/* Copyright (c) 2006 Dirk Jagdmann <doj@cubic.org>

This software is provided 'as-is', without any express or implied
warranty. In no event will the authors be held liable for any damages
arising from the use of this software.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

    1. The origin of this software must not be misrepresented; you
       must not claim that you wrote the original software. If you use
       this software in a product, an acknowledgment in the product
       documentation would be appreciated but is not required.

    2. Altered source versions must be plainly marked as such, and
       must not be misrepresented as being the original software.

    3. This notice may not be removed or altered from any source
       distribution. */

/* $Header: /code/cbmfs/d64prologic.hpp,v 1.2 2006/07/21 14:46:04 doj Exp $ */

#ifndef D64PROLOGIC__HPP
#define D64PROLOGIC__HPP

#include "d64.hpp"

class D64PROLOGIC : public D64
{
public:

#pragma pack(push, 1)
struct bam_prologic {
  /*0x00*/ TS dir;
  /*0x02*/ BYTE version;		/* should be 0x41 */
  /*0x03*/ BYTE onesided;
  /*0x04*/ struct bamentry entry[40];
  /*0xA4*/ BYTE diskname[16];
  /*0xB4*/ BYTE unused1[2];		/* should be 0xA0 */
  /*0xB6*/ BYTE id[2];
  /*0xB8*/ BYTE unused2;		/* should be 0xA0 */
  /*0xB9*/ BYTE DOStype[2];		/* should be "2P" */
  /*0xBD*/ BYTE unused3[4];		/* should be 0xA0 */
  /*0xBF*/ BYTE unused4[65];	/* should be 0 */
};
  BOOST_STATIC_ASSERT(sizeof(bam_prologic) == SECTOR_SIZE);
#pragma pack(pop)

  D64PROLOGIC(BYTE *disk_);
  virtual int maxblocks();
  virtual void printbam();

protected:
  virtual int track_max();
  virtual void printbaminfo();

private:
  D64PROLOGIC();
  D64PROLOGIC(const D64PROLOGIC&);
  D64PROLOGIC& operator= (const D64PROLOGIC&);
};

#endif
