if(!dojo._hasResource["dojox.gfx.matrix"]){dojo._hasResource["dojox.gfx.matrix"]=true;dojo.provide("dojox.gfx.matrix");(function(){var m=dojox.gfx.matrix;var _degToRadCache={};m._degToRad=function(degree){return _degToRadCache[degree]||(_degToRadCache[degree]=(Math.PI*degree/180));};m._radToDeg=function(radian){return radian/Math.PI*180;};m.Matrix2D=function(arg){if(arg){if(typeof arg=="number"){this.xx=this.yy=arg;}else if(arg instanceof Array){if(arg.length>0){var matrix=m.normalize(arg[0]);for(var i=1;i<arg.length;++i){var l=matrix,r=dojox.gfx.matrix.normalize(arg[i]);matrix=new m.Matrix2D();matrix.xx=l.xx*r.xx+l.xy*r.yx;matrix.xy=l.xx*r.xy+l.xy*r.yy;matrix.yx=l.yx*r.xx+l.yy*r.yx;matrix.yy=l.yx*r.xy+l.yy*r.yy;matrix.dx=l.xx*r.dx+l.xy*r.dy+l.dx;matrix.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}
dojo.mixin(this,matrix);}}else{dojo.mixin(this,arg);}}};dojo.extend(m.Matrix2D,{xx:1,xy:0,yx:0,yy:1,dx:0,dy:0});dojo.mixin(m,{identity:new m.Matrix2D(),flipX:new m.Matrix2D({xx:-1}),flipY:new m.Matrix2D({yy:-1}),flipXY:new m.Matrix2D({xx:-1,yy:-1}),translate:function(a,b){if(arguments.length>1){return new m.Matrix2D({dx:a,dy:b});}
return new m.Matrix2D({dx:a.x,dy:a.y});},scale:function(a,b){if(arguments.length>1){return new m.Matrix2D({xx:a,yy:b});}
if(typeof a=="number"){return new m.Matrix2D({xx:a,yy:a});}
return new m.Matrix2D({xx:a.x,yy:a.y});},rotate:function(angle){var c=Math.cos(angle);var s=Math.sin(angle);return new m.Matrix2D({xx:c,xy:-s,yx:s,yy:c});},rotateg:function(degree){return m.rotate(m._degToRad(degree));},skewX:function(angle){return new m.Matrix2D({xy:Math.tan(angle)});},skewXg:function(degree){return m.skewX(m._degToRad(degree));},skewY:function(angle){return new m.Matrix2D({yx:Math.tan(angle)});},skewYg:function(degree){return m.skewY(m._degToRad(degree));},reflect:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}
var a2=a*a,b2=b*b,n2=a2+b2,xy=2*a*b/n2;return new m.Matrix2D({xx:2*a2/n2-1,xy:xy,yx:xy,yy:2*b2/n2-1});},project:function(a,b){if(arguments.length==1){b=a.y;a=a.x;}
var a2=a*a,b2=b*b,n2=a2+b2,xy=a*b/n2;return new m.Matrix2D({xx:a2/n2,xy:xy,yx:xy,yy:b2/n2});},normalize:function(matrix){return(matrix instanceof m.Matrix2D)?matrix:new m.Matrix2D(matrix);},clone:function(matrix){var obj=new m.Matrix2D();for(var i in matrix){if(typeof(matrix[i])=="number"&&typeof(obj[i])=="number"&&obj[i]!=matrix[i])obj[i]=matrix[i];}
return obj;},invert:function(matrix){var M=m.normalize(matrix),D=M.xx*M.yy-M.xy*M.yx,M=new m.Matrix2D({xx:M.yy/D,xy:-M.xy/D,yx:-M.yx/D,yy:M.xx/D,dx:(M.xy*M.dy-M.yy*M.dx)/D,dy:(M.yx*M.dx-M.xx*M.dy)/D});return M;},_multiplyPoint:function(matrix,x,y){return{x:matrix.xx*x+matrix.xy*y+matrix.dx,y:matrix.yx*x+matrix.yy*y+matrix.dy};},multiplyPoint:function(matrix,a,b){var M=m.normalize(matrix);if(typeof a=="number"&&typeof b=="number"){return m._multiplyPoint(M,a,b);}
return m._multiplyPoint(M,a.x,a.y);},multiply:function(matrix){var M=m.normalize(matrix);for(var i=1;i<arguments.length;++i){var l=M,r=m.normalize(arguments[i]);M=new m.Matrix2D();M.xx=l.xx*r.xx+l.xy*r.yx;M.xy=l.xx*r.xy+l.xy*r.yy;M.yx=l.yx*r.xx+l.yy*r.yx;M.yy=l.yx*r.xy+l.yy*r.yy;M.dx=l.xx*r.dx+l.xy*r.dy+l.dx;M.dy=l.yx*r.dx+l.yy*r.dy+l.dy;}
return M;},_sandwich:function(matrix,x,y){return m.multiply(m.translate(x,y),matrix,m.translate(-x,-y));},scaleAt:function(a,b,c,d){switch(arguments.length){case 4:return m._sandwich(m.scale(a,b),c,d);case 3:if(typeof c=="number"){return m._sandwich(m.scale(a),b,c);}
return m._sandwich(m.scale(a,b),c.x,c.y);}
return m._sandwich(m.scale(a),b.x,b.y);},rotateAt:function(angle,a,b){if(arguments.length>2){return m._sandwich(m.rotate(angle),a,b);}
return m._sandwich(m.rotate(angle),a.x,a.y);},rotategAt:function(degree,a,b){if(arguments.length>2){return m._sandwich(m.rotateg(degree),a,b);}
return m._sandwich(m.rotateg(degree),a.x,a.y);},skewXAt:function(angle,a,b){if(arguments.length>2){return m._sandwich(m.skewX(angle),a,b);}
return m._sandwich(m.skewX(angle),a.x,a.y);},skewXgAt:function(degree,a,b){if(arguments.length>2){return m._sandwich(m.skewXg(degree),a,b);}
return m._sandwich(m.skewXg(degree),a.x,a.y);},skewYAt:function(angle,a,b){if(arguments.length>2){return m._sandwich(m.skewY(angle),a,b);}
return m._sandwich(m.skewY(angle),a.x,a.y);},skewYgAt:function(degree,a,b){if(arguments.length>2){return m._sandwich(m.skewYg(degree),a,b);}
return m._sandwich(m.skewYg(degree),a.x,a.y);}});})();dojox.gfx.Matrix2D=dojox.gfx.matrix.Matrix2D;}
if(!dojo._hasResource["dojox.gfx._base"]){dojo._hasResource["dojox.gfx._base"]=true;dojo.provide("dojox.gfx._base");(function(){var g=dojox.gfx,b=g._base;g._hasClass=function(node,classStr){var cls=node.getAttribute("className");return cls&&(" "+cls+" ").indexOf(" "+classStr+" ")>=0;}
g._addClass=function(node,classStr){var cls=node.getAttribute("className")||"";if(!cls||(" "+cls+" ").indexOf(" "+classStr+" ")<0){node.setAttribute("className",cls+(cls?" ":"")+classStr);}}
g._removeClass=function(node,classStr){var cls=node.getAttribute("className");if(cls){node.setAttribute("className",cls.replace(new RegExp('(^|\\s+)'+classStr+'(\\s+|$)'),"$1$2"));}}
b._getFontMeasurements=function(){var heights={'1em':0,'1ex':0,'100%':0,'12pt':0,'16px':0,'xx-small':0,'x-small':0,'small':0,'medium':0,'large':0,'x-large':0,'xx-large':0};if(dojo.isIE){dojo.doc.documentElement.style.fontSize="100%";}
var div=dojo.doc.createElement("div");var s=div.style;s.position="absolute";s.left="-100px";s.top="0px";s.width="30px";s.height="1000em";s.borderWidth="0px";s.margin="0px";s.padding="0px";s.outline="none";s.lineHeight="1";s.overflow="hidden";dojo.body().appendChild(div);for(var p in heights){div.style.fontSize=p;heights[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}
dojo.body().removeChild(div);div=null;return heights;};var fontMeasurements=null;b._getCachedFontMeasurements=function(recalculate){if(recalculate||!fontMeasurements){fontMeasurements=b._getFontMeasurements();}
return fontMeasurements;};var measuringNode=null,empty={};b._getTextBox=function(text,style,className){var m,s,al=arguments.length;if(!measuringNode){m=measuringNode=dojo.doc.createElement("div");s=m.style;s.position="absolute";s.left="-10000px";s.top="0";dojo.body().appendChild(m);}else{m=measuringNode;s=m.style;}
m.className="";s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(al>1&&style){for(var i in style){if(i in empty){continue;}
s[i]=style[i];}}
if(al>2&&className){m.className=className;}
m.innerHTML=text;if(m["getBoundingClientRect"]){var bcr=m.getBoundingClientRect();return{l:bcr.left,t:bcr.top,w:bcr.width||(bcr.right-bcr.left),h:bcr.height||(bcr.bottom-bcr.top)};}else{return dojo.marginBox(m);}};var uniqueId=0;b._getUniqueId=function(){var id;do{id=dojo._scopeName+"Unique"+(++uniqueId);}while(dojo.byId(id));return id;};})();dojo.mixin(dojox.gfx,{defaultPath:{type:"path",path:""},defaultPolyline:{type:"polyline",points:[]},defaultRect:{type:"rect",x:0,y:0,width:100,height:100,r:0},defaultEllipse:{type:"ellipse",cx:0,cy:0,rx:200,ry:100},defaultCircle:{type:"circle",cx:0,cy:0,r:100},defaultLine:{type:"line",x1:0,y1:0,x2:100,y2:100},defaultImage:{type:"image",x:0,y:0,width:0,height:0,src:""},defaultText:{type:"text",x:0,y:0,text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultTextPath:{type:"textpath",text:"",align:"start",decoration:"none",rotated:false,kerning:true},defaultStroke:{type:"stroke",color:"black",style:"solid",width:1,cap:"butt",join:4},defaultLinearGradient:{type:"linear",x1:0,y1:0,x2:100,y2:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultRadialGradient:{type:"radial",cx:0,cy:0,r:100,colors:[{offset:0,color:"black"},{offset:1,color:"white"}]},defaultPattern:{type:"pattern",x:0,y:0,width:0,height:0,src:""},defaultFont:{type:"font",style:"normal",variant:"normal",weight:"normal",size:"10pt",family:"serif"},getDefault:(function(){var typeCtorCache={};return function(type){var t=typeCtorCache[type];if(t){return new t();}
t=typeCtorCache[type]=new Function;t.prototype=dojox.gfx["default"+type];return new t();}})(),normalizeColor:function(color){return(color instanceof dojo.Color)?color:new dojo.Color(color);},normalizeParameters:function(existed,update){if(update){var empty={};for(var x in existed){if(x in update&&!(x in empty)){existed[x]=update[x];}}}
return existed;},makeParameters:function(defaults,update){if(!update){return dojo.delegate(defaults);}
var result={};for(var i in defaults){if(!(i in result)){result[i]=dojo.clone((i in update)?update[i]:defaults[i]);}}
return result;},formatNumber:function(x,addSpace){var val=x.toString();if(val.indexOf("e")>=0){val=x.toFixed(4);}else{var point=val.indexOf(".");if(point>=0&&val.length-point>5){val=x.toFixed(4);}}
if(x<0){return val;}
return addSpace?" "+val:val;},makeFontString:function(font){return font.style+" "+font.variant+" "+font.weight+" "+font.size+" "+font.family;},splitFontString:function(str){var font=dojox.gfx.getDefault("Font");var t=str.split(/\s+/);do{if(t.length<5){break;}
font.style=t[0];font.variant=t[1];font.weight=t[2];var i=t[3].indexOf("/");font.size=i<0?t[3]:t[3].substring(0,i);var j=4;if(i<0){if(t[4]=="/"){j=6;}else if(t[4].charAt(0)=="/"){j=5;}}
if(j<t.length){font.family=t.slice(j).join(" ");}}while(false);return font;},cm_in_pt:72/2.54,mm_in_pt:7.2/2.54,px_in_pt:function(){return dojox.gfx._base._getCachedFontMeasurements()["12pt"]/12;},pt2px:function(len){return len*dojox.gfx.px_in_pt();},px2pt:function(len){return len/dojox.gfx.px_in_pt();},normalizedLength:function(len){if(len.length==0)return 0;if(len.length>2){var px_in_pt=dojox.gfx.px_in_pt();var val=parseFloat(len);switch(len.slice(-2)){case"px":return val;case"pt":return val*px_in_pt;case"in":return val*72*px_in_pt;case"pc":return val*12*px_in_pt;case"mm":return val*dojox.gfx.mm_in_pt*px_in_pt;case"cm":return val*dojox.gfx.cm_in_pt*px_in_pt;}}
return parseFloat(len);},pathVmlRegExp:/([A-Za-z]+)|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,pathSvgRegExp:/([A-Za-z])|(\d+(\.\d+)?)|(\.\d+)|(-\d+(\.\d+)?)|(-\.\d+)/g,equalSources:function(a,b){return a&&b&&a==b;}});}
if(!dojo._hasResource["dojox.gfx"]){dojo._hasResource["dojox.gfx"]=true;dojo.provide("dojox.gfx");dojo.loadInit(function(){var gfx=dojo.getObject("dojox.gfx",true),sl,flag,match;if(!gfx.renderer){if(dojo.config.forceGfxRenderer){dojox.gfx.renderer=dojo.config.forceGfxRenderer;return;}
var renderers=(typeof dojo.config.gfxRenderer=="string"?dojo.config.gfxRenderer:"svg,vml,silverlight,canvas").split(",");var ua=navigator.userAgent,iPhoneOsBuild=0,androidVersion=0;if(dojo.isSafari>=3){if(ua.indexOf("iPhone")>=0||ua.indexOf("iPod")>=0){match=ua.match(/Version\/(\d(\.\d)?(\.\d)?)\sMobile\/([^\s]*)\s?/);if(match){iPhoneOsBuild=parseInt(match[4].substr(0,3),16);}}}
if(dojo.isWebKit){if(!iPhoneOsBuild){match=ua.match(/Android\s+(\d+\.\d+)/);if(match){androidVersion=parseFloat(match[1]);}}}
for(var i=0;i<renderers.length;++i){switch(renderers[i]){case"svg":if(!dojo.isIE&&(!iPhoneOsBuild||iPhoneOsBuild>=0x5f1)&&!androidVersion&&!dojo.isAIR){dojox.gfx.renderer="svg";}
break;case"vml":if(dojo.isIE){dojox.gfx.renderer="vml";}
break;case"silverlight":try{if(dojo.isIE){sl=new ActiveXObject("AgControl.AgControl");if(sl&&sl.IsVersionSupported("1.0")){flag=true;}}else{if(navigator.plugins["Silverlight Plug-In"]){flag=true;}}}catch(e){flag=false;}finally{sl=null;}
if(flag){dojox.gfx.renderer="silverlight";}
break;case"canvas":if(!dojo.isIE){dojox.gfx.renderer="canvas";}
break;}
if(dojox.gfx.renderer){break;}}
if(dojo.config.isDebug){console.log("gfx renderer = "+dojox.gfx.renderer);}}});dojo.requireIf(dojox.gfx.renderer=="vml","dojox.gfx.vml");dojo.requireIf(dojox.gfx.renderer=="silverlight","dojox.gfx.silverlight");dojo.requireIf(dojox.gfx.renderer=="canvas","dojox.gfx.canvas");}
if(!dojo._hasResource["dojox.lang.functional.lambda"]){dojo._hasResource["dojox.lang.functional.lambda"]=true;dojo.provide("dojox.lang.functional.lambda");(function(){var df=dojox.lang.functional,lcache={};var split="ab".split(/a*/).length>1?String.prototype.split:function(sep){var r=this.split.call(this,sep),m=sep.exec(this);if(m&&m.index==0){r.unshift("");}
return r;};var lambda=function(s){var args=[],sects=split.call(s,/\s*->\s*/m);if(sects.length>1){while(sects.length){s=sects.pop();args=sects.pop().split(/\s*,\s*|\s+/m);if(sects.length){sects.push("(function("+args+"){return ("+s+")})");}}}else if(s.match(/\b_\b/)){args=["_"];}else{var l=s.match(/^\s*(?:[+*\/%&|\^\.=<>]|!=)/m),r=s.match(/[+\-*\/%&|\^\.=<>!]\s*$/m);if(l||r){if(l){args.push("$1");s="$1"+s;}
if(r){args.push("$2");s=s+"$2";}}else{var vars=s.replace(/(?:\b[A-Z]|\.[a-zA-Z_$])[a-zA-Z_$\d]*|[a-zA-Z_$][a-zA-Z_$\d]*:|this|true|false|null|undefined|typeof|instanceof|in|delete|new|void|arguments|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|escape|eval|isFinite|isNaN|parseFloat|parseInt|unescape|dojo|dijit|dojox|window|document|'(?:[^'\\]|\\.)*'|"(?:[^"\\]|\\.)*"/g,"").match(/([a-z_$][a-z_$\d]*)/gi)||[],t={};dojo.forEach(vars,function(v){if(!(v in t)){args.push(v);t[v]=1;}});}}
return{args:args,body:s};};var compose=function(a){return a.length?function(){var i=a.length-1,x=df.lambda(a[i]).apply(this,arguments);for(--i;i>=0;--i){x=df.lambda(a[i]).call(this,x);}
return x;}:function(x){return x;};};dojo.mixin(df,{rawLambda:function(s){return lambda(s);},buildLambda:function(s){s=lambda(s);return"function("+s.args.join(",")+"){return ("+s.body+");}";},lambda:function(s){if(typeof s=="function"){return s;}
if(s instanceof Array){return compose(s);}
if(s in lcache){return lcache[s];}
s=lambda(s);return lcache[s]=new Function(s.args,"return ("+s.body+");");},clearLambdaCache:function(){lcache={};}});})();}
if(!dojo._hasResource["dojox.lang.functional.array"]){dojo._hasResource["dojox.lang.functional.array"]=true;dojo.provide("dojox.lang.functional.array");(function(){var d=dojo,df=dojox.lang.functional,empty={};d.mixin(df,{filter:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var t=[],v,i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){v=a.next();if(f.call(o,v,i++,a)){t.push(v);}}}else{for(i in a){if(!(i in empty)){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}}}
return t;},forEach:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;f.call(o,a[i],i,a),++i);}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();f.call(o,a.next(),i++,a));}else{for(i in a){if(!(i in empty)){f.call(o,a[i],i,a);}}}
return o;},map:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array(n=a.length);for(i=0;i<n;t[i]=f.call(o,a[i],i,a),++i);}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[];for(i=0;a.hasNext();t.push(f.call(o,a.next(),i++,a)));}else{t=[];for(i in a){if(!(i in empty)){t.push(f.call(o,a[i],i,a));}}}
return t;},every:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(!f.call(o,a[i],i,a)){return false;}}}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(!f.call(o,a.next(),i++,a)){return false;}}}else{for(i in a){if(!(i in empty)){if(!f.call(o,a[i],i,a)){return false;}}}}
return true;},some:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;++i){if(f.call(o,a[i],i,a)){return true;}}}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();){if(f.call(o,a.next(),i++,a)){return true;}}}else{for(i in a){if(!(i in empty)){if(f.call(o,a[i],i,a)){return true;}}}}
return false;}});})();}
if(!dojo._hasResource["dojox.lang.functional.object"]){dojo._hasResource["dojox.lang.functional.object"]=true;dojo.provide("dojox.lang.functional.object");(function(){var d=dojo,df=dojox.lang.functional,empty={};d.mixin(df,{keys:function(obj){var t=[];for(var i in obj){if(!(i in empty)){t.push(i);}}
return t;},values:function(obj){var t=[];for(var i in obj){if(!(i in empty)){t.push(obj[i]);}}
return t;},filterIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},v,i;for(i in obj){if(!(i in empty)){v=obj[i];if(f.call(o,v,i,obj)){t[i]=v;}}}
return t;},forIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);for(var i in obj){if(!(i in empty)){f.call(o,obj[i],i,obj);}}
return o;},mapIn:function(obj,f,o){o=o||d.global;f=df.lambda(f);var t={},i;for(i in obj){if(!(i in empty)){t[i]=f.call(o,obj[i],i,obj);}}
return t;}});})();}
if(!dojo._hasResource["dojox.lang.functional"]){dojo._hasResource["dojox.lang.functional"]=true;dojo.provide("dojox.lang.functional");}
if(!dojo._hasResource["dojox.lang.functional.fold"]){dojo._hasResource["dojox.lang.functional.fold"]=true;dojo.provide("dojox.lang.functional.fold");(function(){var d=dojo,df=dojox.lang.functional,empty={};d.mixin(df,{foldl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var i,n;if(d.isArray(a)){for(i=0,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i);}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){for(i=0;a.hasNext();z=f.call(o,z,a.next(),i++,a));}else{for(i in a){if(!(i in empty)){z=f.call(o,z,a[i],i,a);}}}
return z;},foldl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var z,i,n;if(d.isArray(a)){z=a[0];for(i=1,n=a.length;i<n;z=f.call(o,z,a[i],i,a),++i);}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){z=a.next();for(i=1;a.hasNext();z=f.call(o,z,a.next(),i++,a));}}else{var first=true;for(i in a){if(!(i in empty)){if(first){z=a[i];first=false;}else{z=f.call(o,z,a[i],i,a);}}}}
return z;},foldr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);for(var i=a.length;i>0;--i,z=f.call(o,z,a[i],i,a));return z;},foldr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var n=a.length,z=a[n-1],i=n-1;for(;i>0;--i,z=f.call(o,z,a[i],i,a));return z;},reduce:function(a,f,z){return arguments.length<3?df.foldl1(a,f):df.foldl(a,f,z);},reduceRight:function(a,f,z){return arguments.length<3?df.foldr1(a,f):df.foldr(a,f,z);},unfold:function(pr,f,g,z,o){o=o||d.global;f=df.lambda(f);g=df.lambda(g);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(f.call(o,z)),z=g.call(o,z));return t;}});})();}
if(!dojo._hasResource["dojox.lang.functional.reversed"]){dojo._hasResource["dojox.lang.functional.reversed"]=true;dojo.provide("dojox.lang.functional.reversed");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{filterRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var t=[],v,i=a.length-1;for(;i>=0;--i){v=a[i];if(f.call(o,v,i,a)){t.push(v);}}
return t;},forEachRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;f.call(o,a[i],i,a),--i);},mapRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),i=n-1,j=0;for(;i>=0;t[j++]=f.call(o,a[i],i,a),--i);return t;},everyRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(!f.call(o,a[i],i,a)){return false;}}
return true;},someRev:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);for(var i=a.length-1;i>=0;--i){if(f.call(o,a[i],i,a)){return true;}}
return false;}});})();}
if(!dojo._hasResource["dojo.colors"]){dojo._hasResource["dojo.colors"]=true;dojo.provide("dojo.colors");(function(){var hue2rgb=function(m1,m2,h){if(h<0){++h;}
if(h>1){--h;}
var h6=6*h;if(h6<1){return m1+(m2-m1)*h6;}
if(2*h<1){return m2;}
if(3*h<2){return m1+(m2-m1)*(2/3-h)*6;}
return m1;};dojo.colorFromRgb=function(color,obj){var m=color.toLowerCase().match(/^(rgba?|hsla?)\(([\s\.\-,%0-9]+)\)/);if(m){var c=m[2].split(/\s*,\s*/),l=c.length,t=m[1],a;if((t=="rgb"&&l==3)||(t=="rgba"&&l==4)){var r=c[0];if(r.charAt(r.length-1)=="%"){a=dojo.map(c,function(x){return parseFloat(x)*2.56;});if(l==4){a[3]=c[3];}
return dojo.colorFromArray(a,obj);}
return dojo.colorFromArray(c,obj);}
if((t=="hsl"&&l==3)||(t=="hsla"&&l==4)){var H=((parseFloat(c[0])%360)+360)%360/360,S=parseFloat(c[1])/100,L=parseFloat(c[2])/100,m2=L<=0.5?L*(S+1):L+S-L*S,m1=2*L-m2;a=[hue2rgb(m1,m2,H+1/3)*256,hue2rgb(m1,m2,H)*256,hue2rgb(m1,m2,H-1/3)*256,1];if(l==4){a[3]=c[3];}
return dojo.colorFromArray(a,obj);}}
return null;};var confine=function(c,low,high){c=Number(c);return isNaN(c)?high:c<low?low:c>high?high:c;};dojo.Color.prototype.sanitize=function(){var t=this;t.r=Math.round(confine(t.r,0,255));t.g=Math.round(confine(t.g,0,255));t.b=Math.round(confine(t.b,0,255));t.a=confine(t.a,0,1);return this;};})();dojo.colors.makeGrey=function(g,a){return dojo.colorFromArray([g,g,g,a]);};dojo.mixin(dojo.Color.named,{aliceblue:[240,248,255],antiquewhite:[250,235,215],aquamarine:[127,255,212],azure:[240,255,255],beige:[245,245,220],bisque:[255,228,196],blanchedalmond:[255,235,205],blueviolet:[138,43,226],brown:[165,42,42],burlywood:[222,184,135],cadetblue:[95,158,160],chartreuse:[127,255,0],chocolate:[210,105,30],coral:[255,127,80],cornflowerblue:[100,149,237],cornsilk:[255,248,220],crimson:[220,20,60],cyan:[0,255,255],darkblue:[0,0,139],darkcyan:[0,139,139],darkgoldenrod:[184,134,11],darkgray:[169,169,169],darkgreen:[0,100,0],darkgrey:[169,169,169],darkkhaki:[189,183,107],darkmagenta:[139,0,139],darkolivegreen:[85,107,47],darkorange:[255,140,0],darkorchid:[153,50,204],darkred:[139,0,0],darksalmon:[233,150,122],darkseagreen:[143,188,143],darkslateblue:[72,61,139],darkslategray:[47,79,79],darkslategrey:[47,79,79],darkturquoise:[0,206,209],darkviolet:[148,0,211],deeppink:[255,20,147],deepskyblue:[0,191,255],dimgray:[105,105,105],dimgrey:[105,105,105],dodgerblue:[30,144,255],firebrick:[178,34,34],floralwhite:[255,250,240],forestgreen:[34,139,34],gainsboro:[220,220,220],ghostwhite:[248,248,255],gold:[255,215,0],goldenrod:[218,165,32],greenyellow:[173,255,47],grey:[128,128,128],honeydew:[240,255,240],hotpink:[255,105,180],indianred:[205,92,92],indigo:[75,0,130],ivory:[255,255,240],khaki:[240,230,140],lavender:[230,230,250],lavenderblush:[255,240,245],lawngreen:[124,252,0],lemonchiffon:[255,250,205],lightblue:[173,216,230],lightcoral:[240,128,128],lightcyan:[224,255,255],lightgoldenrodyellow:[250,250,210],lightgray:[211,211,211],lightgreen:[144,238,144],lightgrey:[211,211,211],lightpink:[255,182,193],lightsalmon:[255,160,122],lightseagreen:[32,178,170],lightskyblue:[135,206,250],lightslategray:[119,136,153],lightslategrey:[119,136,153],lightsteelblue:[176,196,222],lightyellow:[255,255,224],limegreen:[50,205,50],linen:[250,240,230],magenta:[255,0,255],mediumaquamarine:[102,205,170],mediumblue:[0,0,205],mediumorchid:[186,85,211],mediumpurple:[147,112,219],mediumseagreen:[60,179,113],mediumslateblue:[123,104,238],mediumspringgreen:[0,250,154],mediumturquoise:[72,209,204],mediumvioletred:[199,21,133],midnightblue:[25,25,112],mintcream:[245,255,250],mistyrose:[255,228,225],moccasin:[255,228,181],navajowhite:[255,222,173],oldlace:[253,245,230],olivedrab:[107,142,35],orange:[255,165,0],orangered:[255,69,0],orchid:[218,112,214],palegoldenrod:[238,232,170],palegreen:[152,251,152],paleturquoise:[175,238,238],palevioletred:[219,112,147],papayawhip:[255,239,213],peachpuff:[255,218,185],peru:[205,133,63],pink:[255,192,203],plum:[221,160,221],powderblue:[176,224,230],rosybrown:[188,143,143],royalblue:[65,105,225],saddlebrown:[139,69,19],salmon:[250,128,114],sandybrown:[244,164,96],seagreen:[46,139,87],seashell:[255,245,238],sienna:[160,82,45],skyblue:[135,206,235],slateblue:[106,90,205],slategray:[112,128,144],slategrey:[112,128,144],snow:[255,250,250],springgreen:[0,255,127],steelblue:[70,130,180],tan:[210,180,140],thistle:[216,191,216],tomato:[255,99,71],transparent:[0,0,0,0],turquoise:[64,224,208],violet:[238,130,238],wheat:[245,222,179],whitesmoke:[245,245,245],yellowgreen:[154,205,50]});}
if(!dojo._hasResource["dojox.color._base"]){dojo._hasResource["dojox.color._base"]=true;dojo.provide("dojox.color._base");dojox.color.Color=dojo.Color;dojox.color.blend=dojo.blendColors;dojox.color.fromRgb=dojo.colorFromRgb;dojox.color.fromHex=dojo.colorFromHex;dojox.color.fromArray=dojo.colorFromArray;dojox.color.fromString=dojo.colorFromString;dojox.color.greyscale=dojo.colors.makeGrey;dojo.mixin(dojox.color,{fromCmy:function(cyan,magenta,yellow){if(dojo.isArray(cyan)){magenta=cyan[1],yellow=cyan[2],cyan=cyan[0];}else if(dojo.isObject(cyan)){magenta=cyan.m,yellow=cyan.y,cyan=cyan.c;}
cyan/=100,magenta/=100,yellow/=100;var r=1-cyan,g=1-magenta,b=1-yellow;return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromCmyk:function(cyan,magenta,yellow,black){if(dojo.isArray(cyan)){magenta=cyan[1],yellow=cyan[2],black=cyan[3],cyan=cyan[0];}else if(dojo.isObject(cyan)){magenta=cyan.m,yellow=cyan.y,black=cyan.b,cyan=cyan.c;}
cyan/=100,magenta/=100,yellow/=100,black/=100;var r,g,b;r=1-Math.min(1,cyan*(1-black)+black);g=1-Math.min(1,magenta*(1-black)+black);b=1-Math.min(1,yellow*(1-black)+black);return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsl:function(hue,saturation,luminosity){if(dojo.isArray(hue)){saturation=hue[1],luminosity=hue[2],hue=hue[0];}else if(dojo.isObject(hue)){saturation=hue.s,luminosity=hue.l,hue=hue.h;}
saturation/=100;luminosity/=100;while(hue<0){hue+=360;}
while(hue>=360){hue-=360;}
var r,g,b;if(hue<120){r=(120-hue)/60,g=hue/60,b=0;}else if(hue<240){r=0,g=(240-hue)/60,b=(hue-120)/60;}else{r=(hue-240)/60,g=0,b=(360-hue)/60;}
r=2*saturation*Math.min(r,1)+(1-saturation);g=2*saturation*Math.min(g,1)+(1-saturation);b=2*saturation*Math.min(b,1)+(1-saturation);if(luminosity<0.5){r*=luminosity,g*=luminosity,b*=luminosity;}else{r=(1-luminosity)*r+2*luminosity-1;g=(1-luminosity)*g+2*luminosity-1;b=(1-luminosity)*b+2*luminosity-1;}
return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});},fromHsv:function(hue,saturation,value){if(dojo.isArray(hue)){saturation=hue[1],value=hue[2],hue=hue[0];}else if(dojo.isObject(hue)){saturation=hue.s,value=hue.v,hue=hue.h;}
if(hue==360){hue=0;}
saturation/=100;value/=100;var r,g,b;if(saturation==0){r=value,b=value,g=value;}else{var hTemp=hue/60,i=Math.floor(hTemp),f=hTemp-i;var p=value*(1-saturation);var q=value*(1-(saturation*f));var t=value*(1-(saturation*(1-f)));switch(i){case 0:{r=value,g=t,b=p;break;}
case 1:{r=q,g=value,b=p;break;}
case 2:{r=p,g=value,b=t;break;}
case 3:{r=p,g=q,b=value;break;}
case 4:{r=t,g=p,b=value;break;}
case 5:{r=value,g=p,b=q;break;}}}
return new dojox.color.Color({r:Math.round(r*255),g:Math.round(g*255),b:Math.round(b*255)});}});dojo.extend(dojox.color.Color,{toCmy:function(){var cyan=1-(this.r/255),magenta=1-(this.g/255),yellow=1-(this.b/255);return{c:Math.round(cyan*100),m:Math.round(magenta*100),y:Math.round(yellow*100)};},toCmyk:function(){var cyan,magenta,yellow,black;var r=this.r/255,g=this.g/255,b=this.b/255;black=Math.min(1-r,1-g,1-b);cyan=(1-r-black)/(1-black);magenta=(1-g-black)/(1-black);yellow=(1-b-black)/(1-black);return{c:Math.round(cyan*100),m:Math.round(magenta*100),y:Math.round(yellow*100),b:Math.round(black*100)};},toHsl:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var delta=max-min;var h=0,s=0,l=(min+max)/2;if(l>0&&l<1){s=delta/((l<0.5)?(2*l):(2-2*l));}
if(delta>0){if(max==r&&max!=g){h+=(g-b)/delta;}
if(max==g&&max!=b){h+=(2+(b-r)/delta);}
if(max==b&&max!=r){h+=(4+(r-g)/delta);}
h*=60;}
return{h:h,s:Math.round(s*100),l:Math.round(l*100)};},toHsv:function(){var r=this.r/255,g=this.g/255,b=this.b/255;var min=Math.min(r,b,g),max=Math.max(r,g,b);var delta=max-min;var h=null,s=(max==0)?0:(delta/max);if(s==0){h=0;}else{if(r==max){h=60*(g-b)/delta;}else if(g==max){h=120+60*(b-r)/delta;}else{h=240+60*(r-g)/delta;}
if(h<0){h+=360;}}
return{h:h,s:Math.round(s*100),v:Math.round(max*100)};}});}
if(!dojo._hasResource["dojox.color"]){dojo._hasResource["dojox.color"]=true;dojo.provide("dojox.color");}
if(!dojo._hasResource["dojox.color.Palette"]){dojo._hasResource["dojox.color.Palette"]=true;dojo.provide("dojox.color.Palette");(function(){var dxc=dojox.color;dxc.Palette=function(base){this.colors=[];if(base instanceof dojox.color.Palette){this.colors=base.colors.slice(0);}
else if(base instanceof dojox.color.Color){this.colors=[null,null,base,null,null];}
else if(dojo.isArray(base)){this.colors=dojo.map(base.slice(0),function(item){if(dojo.isString(item)){return new dojox.color.Color(item);}
return item;});}
else if(dojo.isString(base)){this.colors=[null,null,new dojox.color.Color(base),null,null];}}
function tRGBA(p,param,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var r=(param=="dr")?item.r+val:item.r,g=(param=="dg")?item.g+val:item.g,b=(param=="db")?item.b+val:item.b,a=(param=="da")?item.a+val:item.a
ret.colors.push(new dojox.color.Color({r:Math.min(255,Math.max(0,r)),g:Math.min(255,Math.max(0,g)),b:Math.min(255,Math.max(0,b)),a:Math.min(1,Math.max(0,a))}));});return ret;}
function tCMY(p,param,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toCmy(),c=(param=="dc")?o.c+val:o.c,m=(param=="dm")?o.m+val:o.m,y=(param=="dy")?o.y+val:o.y;ret.colors.push(dojox.color.fromCmy(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y))));});return ret;}
function tCMYK(p,param,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toCmyk(),c=(param=="dc")?o.c+val:o.c,m=(param=="dm")?o.m+val:o.m,y=(param=="dy")?o.y+val:o.y,k=(param=="dk")?o.b+val:o.b;ret.colors.push(dojox.color.fromCmyk(Math.min(100,Math.max(0,c)),Math.min(100,Math.max(0,m)),Math.min(100,Math.max(0,y)),Math.min(100,Math.max(0,k))));});return ret;}
function tHSL(p,param,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toHsl(),h=(param=="dh")?o.h+val:o.h,s=(param=="ds")?o.s+val:o.s,l=(param=="dl")?o.l+val:o.l;ret.colors.push(dojox.color.fromHsl(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,l))));});return ret;}
function tHSV(p,param,val){var ret=new dojox.color.Palette();ret.colors=[];dojo.forEach(p.colors,function(item){var o=item.toHsv(),h=(param=="dh")?o.h+val:o.h,s=(param=="ds")?o.s+val:o.s,v=(param=="dv")?o.v+val:o.v;ret.colors.push(dojox.color.fromHsv(h%360,Math.min(100,Math.max(0,s)),Math.min(100,Math.max(0,v))));});return ret;}
function rangeDiff(val,low,high){return high-((high-val)*((high-low)/high));}
dojo.extend(dxc.Palette,{transform:function(kwArgs){var fn=tRGBA;if(kwArgs.use){var use=kwArgs.use.toLowerCase();if(use.indexOf("hs")==0){if(use.charAt(2)=="l"){fn=tHSL;}
else{fn=tHSV;}}
else if(use.indexOf("cmy")==0){if(use.charAt(3)=="k"){fn=tCMYK;}
else{fn=tCMY;}}}
else if("dc"in kwArgs||"dm"in kwArgs||"dy"in kwArgs){if("dk"in kwArgs){fn=tCMYK;}
else{fn=tCMY;}}
else if("dh"in kwArgs||"ds"in kwArgs){if("dv"in kwArgs){fn=tHSV;}
else{fn=tHSL;}}
var palette=this;for(var p in kwArgs){if(p=="use"){continue;}
palette=fn(palette,p,kwArgs[p]);}
return palette;},clone:function(){return new dxc.Palette(this);}});dojo.mixin(dxc.Palette,{generators:{analogous:function(args){var high=args.high||60,low=args.low||18,base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h=[(hsv.h+low+360)%360,(hsv.h+Math.round(low/2)+360)%360,hsv.h,(hsv.h-Math.round(high/2)+360)%360,(hsv.h-high+360)%360];var s1=Math.max(10,(hsv.s<=95)?hsv.s+5:(100-(hsv.s-95))),s2=(hsv.s>1)?hsv.s-1:21-hsv.s,v1=(hsv.v>=92)?hsv.v-9:Math.max(hsv.v+9,20),v2=(hsv.v<=90)?Math.max(hsv.v+5,20):(95+Math.ceil((hsv.v-90)/2)),s=[s1,s2,hsv.s,s1,s1],v=[v1,v2,hsv.v,v1,v2]
return new dxc.Palette(dojo.map(h,function(hue,i){return dojox.color.fromHsv(hue,s[i],v[i]);}));},monochromatic:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var s1=(hsv.s-30>9)?hsv.s-30:hsv.s+30,s2=hsv.s,v1=rangeDiff(hsv.v,20,100),v2=(hsv.v-20>20)?hsv.v-20:hsv.v+60,v3=(hsv.v-50>20)?hsv.v-50:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v3),base,dojox.color.fromHsv(hsv.h,s1,v3),dojox.color.fromHsv(hsv.h,s2,v2)]);},triadic:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=(hsv.h+57+360)%360,h2=(hsv.h-157+360)%360,s1=(hsv.s>20)?hsv.s-10:hsv.s+10,s2=(hsv.s>90)?hsv.s-10:hsv.s+10,s3=(hsv.s>95)?hsv.s-5:hsv.s+5,v1=(hsv.v-20>20)?hsv.v-20:hsv.v+20,v2=(hsv.v-30>20)?hsv.v-30:hsv.v+30,v3=(hsv.v-30>70)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,hsv.v),dojox.color.fromHsv(hsv.h,s2,v2),base,dojox.color.fromHsv(h2,s2,v1),dojox.color.fromHsv(h2,s3,v3)]);},complementary:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,s1=Math.max(hsv.s-10,0),s2=rangeDiff(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(hsv.h,s1,v1),dojox.color.fromHsv(hsv.h,s2,v2),base,dojox.color.fromHsv(h1,s3,v2),dojox.color.fromHsv(h1,hsv.s,hsv.v)]);},splitComplementary:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,dangle=args.da||30,hsv=base.toHsv();var baseh=((hsv.h*2)+137<360)?(hsv.h*2)+137:Math.floor(hsv.h/2)-137,h1=(baseh-dangle+360)%360,h2=(baseh+dangle)%360,s1=Math.max(hsv.s-10,0),s2=rangeDiff(hsv.s,10,100),s3=Math.min(100,hsv.s+20),v1=Math.min(100,hsv.v+30),v2=(hsv.v>20)?hsv.v-30:hsv.v+30;return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),base,dojox.color.fromHsv(h2,s3,v2),dojox.color.fromHsv(h2,hsv.s,hsv.v)]);},compound:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var h1=((hsv.h*2)+18<360)?(hsv.h*2)+18:Math.floor(hsv.h/2)-18,h2=((hsv.h*2)+120<360)?(hsv.h*2)+120:Math.floor(hsv.h/2)-120,h3=((hsv.h*2)+99<360)?(hsv.h*2)+99:Math.floor(hsv.h/2)-99,s1=(hsv.s-40>10)?hsv.s-40:hsv.s+40,s2=(hsv.s-10>80)?hsv.s-10:hsv.s+10,s3=(hsv.s-25>10)?hsv.s-25:hsv.s+25,v1=(hsv.v-40>10)?hsv.v-40:hsv.v+40,v2=(hsv.v-20>80)?hsv.v-20:hsv.v+20,v3=Math.max(hsv.v,20);return new dxc.Palette([dojox.color.fromHsv(h1,s1,v1),dojox.color.fromHsv(h1,s2,v2),base,dojox.color.fromHsv(h2,s3,v3),dojox.color.fromHsv(h3,s2,v2)]);},shades:function(args){var base=dojo.isString(args.base)?new dojox.color.Color(args.base):args.base,hsv=base.toHsv();var s=(hsv.s==100&&hsv.v==0)?0:hsv.s,v1=(hsv.v-50>20)?hsv.v-50:hsv.v+30,v2=(hsv.v-25>=20)?hsv.v-25:hsv.v+55,v3=(hsv.v-75>=20)?hsv.v-75:hsv.v+5,v4=Math.max(hsv.v-10,20);return new dxc.Palette([new dojox.color.fromHsv(hsv.h,s,v1),new dojox.color.fromHsv(hsv.h,s,v2),base,new dojox.color.fromHsv(hsv.h,s,v3),new dojox.color.fromHsv(hsv.h,s,v4)]);}},generate:function(base,type){if(dojo.isFunction(type)){return type({base:base});}
else if(dxc.Palette.generators[type]){return dxc.Palette.generators[type]({base:base});}
throw new Error("dojox.color.Palette.generate: the specified generator ('"+type+"') does not exist.");}});})();}
if(!dojo._hasResource["dojox.lang.utils"]){dojo._hasResource["dojox.lang.utils"]=true;dojo.provide("dojox.lang.utils");(function(){var empty={},du=dojox.lang.utils,opts=Object.prototype.toString;var clone=function(o){if(o){switch(opts.call(o)){case"[object Array]":return o.slice(0);case"[object Object]":return dojo.delegate(o);}}
return o;}
dojo.mixin(du,{coerceType:function(target,source){switch(typeof target){case"number":return Number(eval("("+source+")"));case"string":return String(source);case"boolean":return Boolean(eval("("+source+")"));}
return eval("("+source+")");},updateWithObject:function(target,source,conv){if(!source){return target;}
for(var x in target){if(x in source&&!(x in empty)){var t=target[x];if(t&&typeof t=="object"){du.updateWithObject(t,source[x],conv);}else{target[x]=conv?du.coerceType(t,source[x]):clone(source[x]);}}}
return target;},updateWithPattern:function(target,source,pattern,conv){if(!source||!pattern){return target;}
for(var x in pattern){if(x in source&&!(x in empty)){target[x]=conv?du.coerceType(pattern[x],source[x]):clone(source[x]);}}
return target;},merge:function(object,mixin){if(mixin){var otype=opts.call(object),mtype=opts.call(mixin),t,i,l,m;switch(mtype){case"[object Array]":if(mtype==otype){t=new Array(Math.max(object.length,mixin.length));for(i=0,l=t.length;i<l;++i){t[i]=du.merge(object[i],mixin[i]);}
return t;}
return mixin.slice(0);case"[object Object]":if(mtype==otype&&object){t=dojo.delegate(object);for(i in mixin){if(i in object){l=object[i];m=mixin[i];if(m!==l){t[i]=du.merge(l,m);}}else{t[i]=dojo.clone(mixin[i]);}}
return t;}
return dojo.clone(mixin);}}
return mixin;}});})();}
if(!dojo._hasResource["dojox.gfx.gradutils"]){dojo._hasResource["dojox.gfx.gradutils"]=true;dojo.provide("dojox.gfx.gradutils");(function(){var d=dojo,m=dojox.gfx.matrix,C=d.Color;function findColor(o,c){if(o<=0){return c[0].color;}
var len=c.length;if(o>=1){return c[len-1].color;}
for(var i=0;i<len;++i){var stop=c[i];if(stop.offset>=o){if(i){var prev=c[i-1];return d.blendColors(new C(prev.color),new C(stop.color),(o-prev.offset)/(stop.offset-prev.offset));}
return stop.color;}}
return c[len-1].color;}
dojox.gfx.gradutils.getColor=function(fill,pt){var o;if(fill){switch(fill.type){case"linear":var angle=Math.atan2(fill.y2-fill.y1,fill.x2-fill.x1),rotation=m.rotate(-angle),projection=m.project(fill.x2-fill.x1,fill.y2-fill.y1),p=m.multiplyPoint(projection,pt),pf1=m.multiplyPoint(projection,fill.x1,fill.y1),pf2=m.multiplyPoint(projection,fill.x2,fill.y2),scale=m.multiplyPoint(rotation,pf2.x-pf1.x,pf2.y-pf1.y).x,o=m.multiplyPoint(rotation,p.x-pf1.x,p.y-pf1.y).x/scale;break;case"radial":var dx=pt.x-fill.cx,dy=pt.y-fill.cy,o=Math.sqrt(dx*dx+dy*dy)/fill.r;break;}
return findColor(o,fill.colors);}
return new C(fill||[0,0,0,0]);};dojox.gfx.gradutils.reverse=function(fill){if(fill){switch(fill.type){case"linear":case"radial":fill=dojo.delegate(fill);if(fill.colors){var c=fill.colors,l=c.length,i=0,stop,n=fill.colors=new Array(c.length);for(;i<l;++i){stop=c[i];n[i]={offset:1-stop.offset,color:stop.color};}
n.sort(function(a,b){return a.offset-b.offset;});}
break;}}
return fill;};})();}
if(!dojo._hasResource["dojox.charting.Theme"]){dojo._hasResource["dojox.charting.Theme"]=true;dojo.provide("dojox.charting.Theme");dojo.declare("dojox.charting.Theme",null,{shapeSpaces:{shape:1,shapeX:1,shapeY:1},constructor:function(kwArgs){kwArgs=kwArgs||{};var def=dojox.charting.Theme.defaultTheme;dojo.forEach(["chart","plotarea","axis","series","marker"],function(name){this[name]=dojo.delegate(def[name],kwArgs[name]);},this);if(kwArgs.seriesThemes&&kwArgs.seriesThemes.length){this.colors=null;this.seriesThemes=kwArgs.seriesThemes.slice(0);}else{this.seriesThemes=null;this.colors=(kwArgs.colors||dojox.charting.Theme.defaultColors).slice(0);}
this.markerThemes=null;if(kwArgs.markerThemes&&kwArgs.markerThemes.length){this.markerThemes=kwArgs.markerThemes.slice(0);}
this.markers=dojo.delegate(dojox.charting.Theme.defaultMarkers,kwArgs.markers);this.noGradConv=kwArgs.noGradConv;this.noRadialConv=kwArgs.noRadialConv;if(kwArgs.reverseFills){this.reverseFills();}
this._current=0;this._buildMarkerArray();},clone:function(){var theme=new dojox.charting.Theme({chart:this.chart,plotarea:this.plotarea,axis:this.axis,series:this.series,marker:this.marker,colors:this.colors,markers:this.markers,seriesThemes:this.seriesThemes,markerThemes:this.markerThemes,noGradConv:this.noGradConv,noRadialConv:this.noRadialConv});dojo.forEach(["clone","clear","next","skip","addMixin","post","getTick"],function(name){if(this.hasOwnProperty(name)){theme[name]=this[name];}},this);return theme;},clear:function(){this._current=0;},next:function(elementType,mixin,doPost){var merge=dojox.lang.utils.merge,series,marker;if(this.colors){series=dojo.delegate(this.series);marker=dojo.delegate(this.marker);var color=new dojo.Color(this.colors[this._current%this.colors.length]),old;if(series.stroke&&series.stroke.color){series.stroke=dojo.delegate(series.stroke);old=new dojo.Color(series.stroke.color);series.stroke.color=new dojo.Color(color);series.stroke.color.a=old.a;}else{series.stroke={color:color};}
if(marker.stroke&&marker.stroke.color){marker.stroke=dojo.delegate(marker.stroke);old=new dojo.Color(marker.stroke.color);marker.stroke.color=new dojo.Color(color);marker.stroke.color.a=old.a;}else{marker.stroke={color:color};}
if(!series.fill||series.fill.type){series.fill=color;}else{old=new dojo.Color(series.fill);series.fill=new dojo.Color(color);series.fill.a=old.a;}
if(!marker.fill||marker.fill.type){marker.fill=color;}else{old=new dojo.Color(marker.fill);marker.fill=new dojo.Color(color);marker.fill.a=old.a;}}else{series=this.seriesThemes?merge(this.series,this.seriesThemes[this._current%this.seriesThemes.length]):this.series;marker=this.markerThemes?merge(this.marker,this.markerThemes[this._current%this.markerThemes.length]):series;}
var symbol=marker&&marker.symbol||this._markers[this._current%this._markers.length];var theme={series:series,marker:marker,symbol:symbol};++this._current;if(mixin){theme=this.addMixin(theme,elementType,mixin);}
if(doPost){theme=this.post(theme,elementType);}
return theme;},skip:function(){++this._current;},addMixin:function(theme,elementType,mixin,doPost){if(dojo.isArray(mixin)){dojo.forEach(mixin,function(m){theme=this.addMixin(theme,elementType,m);},this);}else{var t={};if("color"in mixin){if(elementType=="line"||elementType=="area"){dojo.setObject("series.stroke.color",mixin.color,t);dojo.setObject("marker.stroke.color",mixin.color,t);}else{dojo.setObject("series.fill",mixin.color,t);}}
dojo.forEach(["stroke","outline","shadow","fill","font","fontColor"],function(name){var markerName="marker"+name.charAt(0).toUpperCase()+name.substr(1),b=markerName in mixin;if(name in mixin){dojo.setObject("series."+name,mixin[name],t);if(!b){dojo.setObject("marker."+name,mixin[name],t);}}
if(b){dojo.setObject("marker."+name,mixin[markerName],t);}});if("marker"in mixin){t.symbol=mixin.marker;}
theme=dojox.lang.utils.merge(theme,t);}
if(doPost){theme=this.post(theme,elementType);}
return theme;},post:function(theme,elementType){var fill=theme.series.fill,t;if(!this.noGradConv&&this.shapeSpaces[fill.space]&&fill.type=="linear"){if(elementType=="bar"){t={x1:fill.y1,y1:fill.x1,x2:fill.y2,y2:fill.x2};}else if(!this.noRadialConv&&fill.space=="shape"&&(elementType=="slice"||elementType=="circle")){t={type:"radial",cx:0,cy:0,r:100};}
if(t){return dojox.lang.utils.merge(theme,{series:{fill:t}});}}
return theme;},getTick:function(name,mixin){var tick=this.axis.tick,tickName=name+"Tick";merge=dojox.lang.utils.merge;if(tick){if(this.axis[tickName]){tick=merge(tick,this.axis[tickName]);}}else{tick=this.axis[tickName];}
if(mixin){if(tick){if(mixin[tickName]){tick=merge(tick,mixin[tickName]);}}else{tick=mixin[tickName];}}
return tick;},inspectObjects:function(f){dojo.forEach(["chart","plotarea","axis","series","marker"],function(name){f(this[name]);},this);if(this.seriesThemes){dojo.forEach(this.seriesThemes,f);}
if(this.markerThemes){dojo.forEach(this.markerThemes,f);}},reverseFills:function(){this.inspectObjects(function(o){if(o&&o.fill){o.fill=dojox.gfx.gradutils.reverse(o.fill);}});},addMarker:function(name,segment){this.markers[name]=segment;this._buildMarkerArray();},setMarkers:function(obj){this.markers=obj;this._buildMarkerArray();},_buildMarkerArray:function(){this._markers=[];for(var p in this.markers){this._markers.push(this.markers[p]);}}});dojo.mixin(dojox.charting.Theme,{defaultMarkers:{CIRCLE:"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0",SQUARE:"m-3,-3 l0,6 6,0 0,-6 z",DIAMOND:"m0,-3 l3,3 -3,3 -3,-3 z",CROSS:"m0,-3 l0,6 m-3,-3 l6,0",X:"m-3,-3 l6,6 m0,-6 l-6,6",TRIANGLE:"m-3,3 l3,-6 3,6 z",TRIANGLE_INVERTED:"m-3,-3 l3,6 3,-6 z"},defaultColors:["#54544c","#858e94","#6e767a","#948585","#474747"],defaultTheme:{chart:{stroke:null,fill:"white",pageStyle:null},plotarea:{stroke:null,fill:"white"},axis:{stroke:{color:"#333",width:1},tick:{color:"#666",position:"center",font:"normal normal normal 7pt Tahoma",fontColor:"#333"},majorTick:{width:1,length:6},minorTick:{width:0.8,length:3},microTick:{width:0.5,length:1}},series:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"},marker:{stroke:{width:1.5,color:"#333"},outline:{width:0.1,color:"#ccc"},shadow:null,fill:"#ccc",font:"normal normal normal 8pt Tahoma",fontColor:"#000"}},defineColors:function(kwArgs){kwArgs=kwArgs||{};var c=[],n=kwArgs.num||5;if(kwArgs.colors){var l=kwArgs.colors.length;for(var i=0;i<n;i++){c.push(kwArgs.colors[i%l]);}
return c;}
if(kwArgs.hue){var s=kwArgs.saturation||100;var st=kwArgs.low||30;var end=kwArgs.high||90;var l=(end+st)/2;return dojox.color.Palette.generate(dojox.color.fromHsv(kwArgs.hue,s,l),"monochromatic").colors;}
if(kwArgs.generator){return dojox.color.Palette.generate(kwArgs.base,kwArgs.generator).colors;}
return c;},generateGradient:function(fillPattern,colorFrom,colorTo){var fill=dojo.delegate(fillPattern);fill.colors=[{offset:0,color:colorFrom},{offset:1,color:colorTo}];return fill;},generateHslColor:function(color,luminance){color=new dojox.color.Color(color);var hsl=color.toHsl(),result=dojox.color.fromHsl(hsl.h,hsl.s,luminance);result.a=color.a;return result;},generateHslGradient:function(color,fillPattern,lumFrom,lumTo){color=new dojox.color.Color(color);var hsl=color.toHsl(),colorFrom=dojox.color.fromHsl(hsl.h,hsl.s,lumFrom),colorTo=dojox.color.fromHsl(hsl.h,hsl.s,lumTo);colorFrom.a=colorTo.a=color.a;return dojox.charting.Theme.generateGradient(fillPattern,colorFrom,colorTo);}});}
if(!dojo._hasResource["dojox.charting.Element"]){dojo._hasResource["dojox.charting.Element"]=true;dojo.provide("dojox.charting.Element");dojo.declare("dojox.charting.Element",null,{chart:null,group:null,htmlElements:null,dirty:true,constructor:function(chart){this.chart=chart;this.group=null;this.htmlElements=[];this.dirty=true;},createGroup:function(creator){if(!creator){creator=this.chart.surface;}
if(!this.group){this.group=creator.createGroup();}
return this;},purgeGroup:function(){this.destroyHtmlElements();if(this.group){this.group.clear();this.group.removeShape();this.group=null;}
this.dirty=true;return this;},cleanGroup:function(creator){this.destroyHtmlElements();if(!creator){creator=this.chart.surface;}
if(this.group){this.group.clear();}else{this.group=creator.createGroup();}
this.dirty=true;return this;},destroyHtmlElements:function(){if(this.htmlElements.length){dojo.forEach(this.htmlElements,dojo.destroy);this.htmlElements=[];}},destroy:function(){this.purgeGroup();},_plotFill:function(fill,dim,offsets){if(!fill||!fill.type||!fill.space){return fill;}
var space=fill.space;switch(fill.type){case"linear":if(space==="plot"||space==="shapeX"||space==="shapeY"){fill=dojox.gfx.makeParameters(dojox.gfx.defaultLinearGradient,fill);fill.space=space;if(space==="plot"||space==="shapeX"){var span=dim.height-offsets.t-offsets.b;fill.y1=offsets.t+span*fill.y1/100;fill.y2=offsets.t+span*fill.y2/100;}
if(space==="plot"||space==="shapeY"){var span=dim.width-offsets.l-offsets.r;fill.x1=offsets.l+span*fill.x1/100;fill.x2=offsets.l+span*fill.x2/100;}}
break;case"radial":if(space==="plot"){fill=dojox.gfx.makeParameters(dojox.gfx.defaultRadialGradient,fill);fill.space=space;var spanX=dim.width-offsets.l-offsets.r,spanY=dim.height-offsets.t-offsets.b;fill.cx=offsets.l+spanX*fill.cx/100;fill.cy=offsets.t+spanY*fill.cy/100;fill.r=fill.r*Math.sqrt(spanX*spanX+spanY*spanY)/200;}
break;case"pattern":if(space==="plot"||space==="shapeX"||space==="shapeY"){fill=dojox.gfx.makeParameters(dojox.gfx.defaultPattern,fill);fill.space=space;if(space==="plot"||space==="shapeX"){var span=dim.height-offsets.t-offsets.b;fill.y=offsets.t+span*fill.y/100;fill.height=span*fill.height/100;}
if(space==="plot"||space==="shapeY"){var span=dim.width-offsets.l-offsets.r;fill.x=offsets.l+span*fill.x/100;fill.width=span*fill.width/100;}}
break;}
return fill;},_shapeFill:function(fill,bbox){if(!fill||!fill.space){return fill;}
var space=fill.space;switch(fill.type){case"linear":if(space==="shape"||space==="shapeX"||space==="shapeY"){fill=dojox.gfx.makeParameters(dojox.gfx.defaultLinearGradient,fill);fill.space=space;if(space==="shape"||space==="shapeX"){var span=bbox.width;fill.x1=bbox.x+span*fill.x1/100;fill.x2=bbox.x+span*fill.x2/100;}
if(space==="shape"||space==="shapeY"){var span=bbox.height;fill.y1=bbox.y+span*fill.y1/100;fill.y2=bbox.y+span*fill.y2/100;}}
break;case"radial":if(space==="shape"){fill=dojox.gfx.makeParameters(dojox.gfx.defaultRadialGradient,fill);fill.space=space;fill.cx=bbox.x+bbox.width/2;fill.cy=bbox.y+bbox.height/2;fill.r=fill.r*bbox.width/200;}
break;case"pattern":if(space==="shape"||space==="shapeX"||space==="shapeY"){fill=dojox.gfx.makeParameters(dojox.gfx.defaultPattern,fill);fill.space=space;if(space==="shape"||space==="shapeX"){var span=bbox.width;fill.x=bbox.x+span*fill.x/100;fill.width=span*fill.width/100;}
if(space==="shape"||space==="shapeY"){var span=bbox.height;fill.y=bbox.y+span*fill.y/100;fill.height=span*fill.height/100;}}
break;}
return fill;},_pseudoRadialFill:function(fill,center,radius,start,end){if(!fill||fill.type!=="radial"||fill.space!=="shape"){return fill;}
var space=fill.space;fill=dojox.gfx.makeParameters(dojox.gfx.defaultRadialGradient,fill);fill.space=space;if(arguments.length<4){fill.cx=center.x;fill.cy=center.y;fill.r=fill.r*radius/100;return fill;}
var angle=arguments.length<5?start:(end+start)/2;return{type:"linear",x1:center.x,y1:center.y,x2:center.x+fill.r*radius*Math.cos(angle)/100,y2:center.y+fill.r*radius*Math.sin(angle)/100,colors:fill.colors};return fill;}});}
if(!dojo._hasResource["dojox.charting.Series"]){dojo._hasResource["dojox.charting.Series"]=true;dojo.provide("dojox.charting.Series");dojo.declare("dojox.charting.Series",dojox.charting.Element,{constructor:function(chart,data,kwArgs){dojo.mixin(this,kwArgs);if(typeof this.plot!="string"){this.plot="default";}
this.update(data);},clear:function(){this.dyn={};},update:function(data){if(dojo.isArray(data)){this.data=data;}else{this.source=data;this.data=this.source.data;if(this.source.setSeriesObject){this.source.setSeriesObject(this);}}
this.dirty=true;this.clear();}});}
if(!dojo._hasResource["dojox.charting.scaler.common"]){dojo._hasResource["dojox.charting.scaler.common"]=true;dojo.provide("dojox.charting.scaler.common");(function(){var eq=function(a,b){return Math.abs(a-b)<=1e-6*(Math.abs(a)+Math.abs(b));};dojo.mixin(dojox.charting.scaler.common,{findString:function(val,text){val=val.toLowerCase();for(var i=0;i<text.length;++i){if(val==text[i]){return true;}}
return false;},getNumericLabel:function(number,precision,kwArgs){var def=kwArgs.fixed?number.toFixed(precision<0?-precision:0):number.toString();if(kwArgs.labelFunc){var r=kwArgs.labelFunc(def,number,precision);if(r){return r;}}
if(kwArgs.labels){var l=kwArgs.labels,lo=0,hi=l.length;while(lo<hi){var mid=Math.floor((lo+hi)/2),val=l[mid].value;if(val<number){lo=mid+1;}else{hi=mid;}}
if(lo<l.length&&eq(l[lo].value,number)){return l[lo].text;}
--lo;if(lo>=0&&lo<l.length&&eq(l[lo].value,number)){return l[lo].text;}
lo+=2;if(lo<l.length&&eq(l[lo].value,number)){return l[lo].text;}}
return def;}});})();}
if(!dojo._hasResource["dojox.charting.scaler.linear"]){dojo._hasResource["dojox.charting.scaler.linear"]=true;dojo.provide("dojox.charting.scaler.linear");(function(){var deltaLimit=3,dc=dojox.charting,dcs=dc.scaler,dcsc=dcs.common,findString=dcsc.findString,getLabel=dcsc.getNumericLabel;var calcTicks=function(min,max,kwArgs,majorTick,minorTick,microTick,span){kwArgs=dojo.delegate(kwArgs);if(!majorTick){if(kwArgs.fixUpper=="major"){kwArgs.fixUpper="minor";}
if(kwArgs.fixLower=="major"){kwArgs.fixLower="minor";}}
if(!minorTick){if(kwArgs.fixUpper=="minor"){kwArgs.fixUpper="micro";}
if(kwArgs.fixLower=="minor"){kwArgs.fixLower="micro";}}
if(!microTick){if(kwArgs.fixUpper=="micro"){kwArgs.fixUpper="none";}
if(kwArgs.fixLower=="micro"){kwArgs.fixLower="none";}}
var lowerBound=findString(kwArgs.fixLower,["major"])?Math.floor(kwArgs.min/majorTick)*majorTick:findString(kwArgs.fixLower,["minor"])?Math.floor(kwArgs.min/minorTick)*minorTick:findString(kwArgs.fixLower,["micro"])?Math.floor(kwArgs.min/microTick)*microTick:kwArgs.min,upperBound=findString(kwArgs.fixUpper,["major"])?Math.ceil(kwArgs.max/majorTick)*majorTick:findString(kwArgs.fixUpper,["minor"])?Math.ceil(kwArgs.max/minorTick)*minorTick:findString(kwArgs.fixUpper,["micro"])?Math.ceil(kwArgs.max/microTick)*microTick:kwArgs.max;if(kwArgs.useMin){min=lowerBound;}
if(kwArgs.useMax){max=upperBound;}
var majorStart=(!majorTick||kwArgs.useMin&&findString(kwArgs.fixLower,["major"]))?min:Math.ceil(min/majorTick)*majorTick,minorStart=(!minorTick||kwArgs.useMin&&findString(kwArgs.fixLower,["major","minor"]))?min:Math.ceil(min/minorTick)*minorTick,microStart=(!microTick||kwArgs.useMin&&findString(kwArgs.fixLower,["major","minor","micro"]))?min:Math.ceil(min/microTick)*microTick,majorCount=!majorTick?0:(kwArgs.useMax&&findString(kwArgs.fixUpper,["major"])?Math.round((max-majorStart)/majorTick):Math.floor((max-majorStart)/majorTick))+1,minorCount=!minorTick?0:(kwArgs.useMax&&findString(kwArgs.fixUpper,["major","minor"])?Math.round((max-minorStart)/minorTick):Math.floor((max-minorStart)/minorTick))+1,microCount=!microTick?0:(kwArgs.useMax&&findString(kwArgs.fixUpper,["major","minor","micro"])?Math.round((max-microStart)/microTick):Math.floor((max-microStart)/microTick))+1,minorPerMajor=minorTick?Math.round(majorTick/minorTick):0,microPerMinor=microTick?Math.round(minorTick/microTick):0,majorPrecision=majorTick?Math.floor(Math.log(majorTick)/Math.LN10):0,minorPrecision=minorTick?Math.floor(Math.log(minorTick)/Math.LN10):0,scale=span/(max-min);if(!isFinite(scale)){scale=1;}
return{bounds:{lower:lowerBound,upper:upperBound,from:min,to:max,scale:scale,span:span},major:{tick:majorTick,start:majorStart,count:majorCount,prec:majorPrecision},minor:{tick:minorTick,start:minorStart,count:minorCount,prec:minorPrecision},micro:{tick:microTick,start:microStart,count:microCount,prec:0},minorPerMajor:minorPerMajor,microPerMinor:microPerMinor,scaler:dcs.linear};};dojo.mixin(dojox.charting.scaler.linear,{buildScaler:function(min,max,span,kwArgs){var h={fixUpper:"none",fixLower:"none",natural:false};if(kwArgs){if("fixUpper"in kwArgs){h.fixUpper=String(kwArgs.fixUpper);}
if("fixLower"in kwArgs){h.fixLower=String(kwArgs.fixLower);}
if("natural"in kwArgs){h.natural=Boolean(kwArgs.natural);}}
if("min"in kwArgs){min=kwArgs.min;}
if("max"in kwArgs){max=kwArgs.max;}
if(kwArgs.includeZero){if(min>0){min=0;}
if(max<0){max=0;}}
h.min=min;h.useMin=true;h.max=max;h.useMax=true;if("from"in kwArgs){min=kwArgs.from;h.useMin=false;}
if("to"in kwArgs){max=kwArgs.to;h.useMax=false;}
if(max<=min){return calcTicks(min,max,h,0,0,0,span);}
var mag=Math.floor(Math.log(max-min)/Math.LN10),major=kwArgs&&("majorTickStep"in kwArgs)?kwArgs.majorTickStep:Math.pow(10,mag),minor=0,micro=0,ticks;if(kwArgs&&("minorTickStep"in kwArgs)){minor=kwArgs.minorTickStep;}else{do{minor=major/10;if(!h.natural||minor>0.9){ticks=calcTicks(min,max,h,major,minor,0,span);if(ticks.bounds.scale*ticks.minor.tick>deltaLimit){break;}}
minor=major/5;if(!h.natural||minor>0.9){ticks=calcTicks(min,max,h,major,minor,0,span);if(ticks.bounds.scale*ticks.minor.tick>deltaLimit){break;}}
minor=major/2;if(!h.natural||minor>0.9){ticks=calcTicks(min,max,h,major,minor,0,span);if(ticks.bounds.scale*ticks.minor.tick>deltaLimit){break;}}
return calcTicks(min,max,h,major,0,0,span);}while(false);}
if(kwArgs&&("microTickStep"in kwArgs)){micro=kwArgs.microTickStep;ticks=calcTicks(min,max,h,major,minor,micro,span);}else{do{micro=minor/10;if(!h.natural||micro>0.9){ticks=calcTicks(min,max,h,major,minor,micro,span);if(ticks.bounds.scale*ticks.micro.tick>deltaLimit){break;}}
micro=minor/5;if(!h.natural||micro>0.9){ticks=calcTicks(min,max,h,major,minor,micro,span);if(ticks.bounds.scale*ticks.micro.tick>deltaLimit){break;}}
micro=minor/2;if(!h.natural||micro>0.9){ticks=calcTicks(min,max,h,major,minor,micro,span);if(ticks.bounds.scale*ticks.micro.tick>deltaLimit){break;}}
micro=0;}while(false);}
return micro?ticks:calcTicks(min,max,h,major,minor,0,span);},buildTicks:function(scaler,kwArgs){var step,next,tick,nextMajor=scaler.major.start,nextMinor=scaler.minor.start,nextMicro=scaler.micro.start;if(kwArgs.microTicks&&scaler.micro.tick){step=scaler.micro.tick,next=nextMicro;}else if(kwArgs.minorTicks&&scaler.minor.tick){step=scaler.minor.tick,next=nextMinor;}else if(scaler.major.tick){step=scaler.major.tick,next=nextMajor;}else{return null;}
var revScale=1/scaler.bounds.scale;if(scaler.bounds.to<=scaler.bounds.from||isNaN(revScale)||!isFinite(revScale)||step<=0||isNaN(step)||!isFinite(step)){return null;}
var majorTicks=[],minorTicks=[],microTicks=[];while(next<=scaler.bounds.to+revScale){if(Math.abs(nextMajor-next)<step/2){tick={value:nextMajor};if(kwArgs.majorLabels){tick.label=getLabel(nextMajor,scaler.major.prec,kwArgs);}
majorTicks.push(tick);nextMajor+=scaler.major.tick;nextMinor+=scaler.minor.tick;nextMicro+=scaler.micro.tick;}else if(Math.abs(nextMinor-next)<step/2){if(kwArgs.minorTicks){tick={value:nextMinor};if(kwArgs.minorLabels&&(scaler.minMinorStep<=scaler.minor.tick*scaler.bounds.scale)){tick.label=getLabel(nextMinor,scaler.minor.prec,kwArgs);}
minorTicks.push(tick);}
nextMinor+=scaler.minor.tick;nextMicro+=scaler.micro.tick;}else{if(kwArgs.microTicks){microTicks.push({value:nextMicro});}
nextMicro+=scaler.micro.tick;}
next+=step;}
return{major:majorTicks,minor:minorTicks,micro:microTicks};},getTransformerFromModel:function(scaler){var offset=scaler.bounds.from,scale=scaler.bounds.scale;return function(x){return(x-offset)*scale;};},getTransformerFromPlot:function(scaler){var offset=scaler.bounds.from,scale=scaler.bounds.scale;return function(x){return x/scale+offset;};}});})();}
if(!dojo._hasResource["dojox.charting.axis2d.common"]){dojo._hasResource["dojox.charting.axis2d.common"]=true;dojo.provide("dojox.charting.axis2d.common");(function(){var g=dojox.gfx;var clearNode=function(s){s.marginLeft="0px";s.marginTop="0px";s.marginRight="0px";s.marginBottom="0px";s.paddingLeft="0px";s.paddingTop="0px";s.paddingRight="0px";s.paddingBottom="0px";s.borderLeftWidth="0px";s.borderTopWidth="0px";s.borderRightWidth="0px";s.borderBottomWidth="0px";};var getBoxWidth=function(n){if(n["getBoundingClientRect"]){var bcr=n.getBoundingClientRect();return bcr.width||(bcr.right-bcr.left);}else{return dojo.marginBox(n).w;}};dojo.mixin(dojox.charting.axis2d.common,{createText:{gfx:function(chart,creator,x,y,align,text,font,fontColor){return creator.createText({x:x,y:y,text:text,align:align}).setFont(font).setFill(fontColor);},html:function(chart,creator,x,y,align,text,font,fontColor,labelWidth){var p=dojo.doc.createElement("div"),s=p.style,boxWidth;clearNode(s);s.font=font;p.innerHTML=String(text).replace(/\s/g,"&nbsp;");s.color=fontColor;s.position="absolute";s.left="-10000px";dojo.body().appendChild(p);var size=g.normalizedLength(g.splitFontString(font).size);if(!labelWidth){boxWidth=getBoxWidth(p);}
dojo.body().removeChild(p);s.position="relative";if(labelWidth){s.width=labelWidth+"px";switch(align){case"middle":s.textAlign="center";s.left=(x-labelWidth/2)+"px";break;case"end":s.textAlign="right";s.left=(x-labelWidth)+"px";break;default:s.left=x+"px";s.textAlign="left";break;}}else{switch(align){case"middle":s.left=Math.floor(x-boxWidth/2)+"px";break;case"end":s.left=Math.floor(x-boxWidth)+"px";break;default:s.left=Math.floor(x)+"px";break;}}
s.top=Math.floor(y-size)+"px";s.whiteSpace="nowrap";var wrap=dojo.doc.createElement("div"),w=wrap.style;clearNode(w);w.width="0px";w.height="0px";wrap.appendChild(p)
chart.node.insertBefore(wrap,chart.node.firstChild);return wrap;}}});})();}
if(!dojo._hasResource["dojox.charting.axis2d.Base"]){dojo._hasResource["dojox.charting.axis2d.Base"]=true;dojo.provide("dojox.charting.axis2d.Base");dojo.declare("dojox.charting.axis2d.Base",dojox.charting.Element,{constructor:function(chart,kwArgs){this.vertical=kwArgs&&kwArgs.vertical;},clear:function(){return this;},initialized:function(){return false;},calculate:function(min,max,span){return this;},getScaler:function(){return null;},getTicks:function(){return null;},getOffsets:function(){return{l:0,r:0,t:0,b:0};},render:function(dim,offsets){this.dirty=false;return this;}});}
if(!dojo._hasResource["dojo.string"]){dojo._hasResource["dojo.string"]=true;dojo.provide("dojo.string");dojo.string.rep=function(str,num){if(num<=0||!str){return"";}
var buf=[];for(;;){if(num&1){buf.push(str);}
if(!(num>>=1)){break;}
str+=str;}
return buf.join("");};dojo.string.pad=function(text,size,ch,end){if(!ch){ch='0';}
var out=String(text),pad=dojo.string.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};dojo.string.substitute=function(template,map,transform,thisObject){thisObject=thisObject||dojo.global;transform=transform?dojo.hitch(thisObject,transform):function(v){return v;};return template.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(match,key,format){var value=dojo.getObject(key,false,map);if(format){value=dojo.getObject(format,false,thisObject).call(thisObject,value,key);}
return transform(value,key).toString();});};dojo.string.trim=String.prototype.trim?dojo.trim:function(str){str=str.replace(/^\s+/,'');for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}
return str;};}
if(!dojo._hasResource["dojox.charting.axis2d.Invisible"]){dojo._hasResource["dojox.charting.axis2d.Invisible"]=true;dojo.provide("dojox.charting.axis2d.Invisible");(function(){var dc=dojox.charting,df=dojox.lang.functional,du=dojox.lang.utils,g=dojox.gfx,lin=dc.scaler.linear,merge=du.merge,labelGap=4,centerAnchorLimit=45;dojo.declare("dojox.charting.axis2d.Invisible",dojox.charting.axis2d.Base,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0},constructor:function(chart,kwArgs){this.opt=dojo.delegate(this.defaultParams,kwArgs);du.updateWithPattern(this.opt,kwArgs,this.optionalParams);},dependOnData:function(){return!("min"in this.opt)||!("max"in this.opt);},clear:function(){delete this.scaler;delete this.ticks;this.dirty=true;return this;},initialized:function(){return"scaler"in this&&!(this.dirty&&this.dependOnData());},setWindow:function(scale,offset){this.scale=scale;this.offset=offset;return this.clear();},getWindowScale:function(){return"scale"in this?this.scale:1;},getWindowOffset:function(){return"offset"in this?this.offset:0;},_groupLabelWidth:function(labels,font){if(!labels.length){return 0;}
if(dojo.isObject(labels[0])){labels=df.map(labels,function(label){return label.text;});}
var s=labels.join("<br>");return dojox.gfx._base._getTextBox(s,{font:font}).w||0;},calculate:function(min,max,span,labels){if(this.initialized()){return this;}
var o=this.opt;this.labels="labels"in o?o.labels:labels;this.scaler=lin.buildScaler(min,max,span,o);var tsb=this.scaler.bounds;if("scale"in this){o.from=tsb.lower+this.offset;o.to=(tsb.upper-tsb.lower)/this.scale+o.from;if(!isFinite(o.from)||isNaN(o.from)||!isFinite(o.to)||isNaN(o.to)||o.to-o.from>=tsb.upper-tsb.lower){delete o.from;delete o.to;delete this.scale;delete this.offset;}else{if(o.from<tsb.lower){o.to+=tsb.lower-o.from;o.from=tsb.lower;}else if(o.to>tsb.upper){o.from+=tsb.upper-o.to;o.to=tsb.upper;}
this.offset=o.from-tsb.lower;}
this.scaler=lin.buildScaler(min,max,span,o);tsb=this.scaler.bounds;if(this.scale==1&&this.offset==0){delete this.scale;delete this.offset;}}
var ta=this.chart.theme.axis,labelWidth=0,rotation=o.rotation%360,taFont=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),size=taFont?g.normalizedLength(g.splitFontString(taFont).size):0,cosr=Math.abs(Math.cos(rotation*Math.PI/180)),sinr=Math.abs(Math.sin(rotation*Math.PI/180));if(rotation<0){rotation+=360;}
if(size){if(this.vertical?rotation!=0&&rotation!=180:rotation!=90&&rotation!=270){if(o.maxLabelSize){labelWidth=o.maxLabelSize;}else if(this.labels){labelWidth=this._groupLabelWidth(this.labels,taFont);}else{var labelLength=Math.ceil(Math.log(Math.max(Math.abs(tsb.from),Math.abs(tsb.to)))/Math.LN10),t=[];if(tsb.from<0||tsb.to<0){t.push("-");}
t.push(dojo.string.rep("9",labelLength));var precision=Math.floor(Math.log(tsb.to-tsb.from)/Math.LN10);if(precision>0){t.push(".");t.push(dojo.string.rep("9",precision));}
labelWidth=dojox.gfx._base._getTextBox(t.join(""),{font:taFont}).w;}}else{labelWidth=size;}
switch(rotation){case 0:case 90:case 180:case 270:break;default:var gap1=Math.sqrt(labelWidth*labelWidth+size*size),gap2=this.vertical?size*cosr+labelWidth*sinr:labelWidth*cosr+size*sinr;labelWidth=Math.min(gap1,gap2);break;}}
this.scaler.minMinorStep=labelWidth+labelGap;this.ticks=lin.buildTicks(this.scaler,o);return this;},getScaler:function(){return this.scaler;},getTicks:function(){return this.ticks;}});})();}
if(!dojo._hasResource["dojox.charting.axis2d.Default"]){dojo._hasResource["dojox.charting.axis2d.Default"]=true;dojo.provide("dojox.charting.axis2d.Default");(function(){var dc=dojox.charting,du=dojox.lang.utils,g=dojox.gfx,lin=dc.scaler.linear,labelGap=4,centerAnchorLimit=45;dojo.declare("dojox.charting.axis2d.Default",dojox.charting.axis2d.Invisible,{defaultParams:{vertical:false,fixUpper:"none",fixLower:"none",natural:false,leftBottom:true,includeZero:false,fixed:true,majorLabels:true,minorTicks:true,minorLabels:true,microTicks:false,rotation:0,htmlLabels:true},optionalParams:{min:0,max:1,from:0,to:1,majorTickStep:4,minorTickStep:2,microTickStep:1,labels:[],labelFunc:null,maxLabelSize:0,stroke:{},majorTick:{},minorTick:{},microTick:{},tick:{},font:"",fontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.delegate(this.defaultParams,kwArgs);du.updateWithPattern(this.opt,kwArgs,this.optionalParams);},getOffsets:function(){var s=this.scaler,offsets={l:0,r:0,t:0,b:0};if(!s){return offsets;}
var o=this.opt,labelWidth=0,a,b,c,d,gl=dc.scaler.common.getNumericLabel,offset=0,ma=s.major,mi=s.minor,ta=this.chart.theme.axis,taFont=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),taMajorTick=this.chart.theme.getTick("major",o),taMinorTick=this.chart.theme.getTick("minor",o),size=taFont?g.normalizedLength(g.splitFontString(taFont).size):0,rotation=o.rotation%360,leftBottom=o.leftBottom,cosr=Math.abs(Math.cos(rotation*Math.PI/180)),sinr=Math.abs(Math.sin(rotation*Math.PI/180));if(rotation<0){rotation+=360;}
if(size){if(o.maxLabelSize){labelWidth=o.maxLabelSize;}else if(this.labels){labelWidth=this._groupLabelWidth(this.labels,taFont);}else{labelWidth=this._groupLabelWidth([gl(ma.start,ma.prec,o),gl(ma.start+ma.count*ma.tick,ma.prec,o),gl(mi.start,mi.prec,o),gl(mi.start+mi.count*mi.tick,mi.prec,o)],taFont);}
if(this.vertical){var side=leftBottom?"l":"r";switch(rotation){case 0:case 180:offsets[side]=labelWidth;offsets.t=offsets.b=size/2;break;case 90:case 270:offsets[side]=size;offsets.t=offsets.b=labelWidth/2;break;default:if(rotation<=centerAnchorLimit||(180<rotation&&rotation<=(180+centerAnchorLimit))){offsets[side]=size*sinr/2+labelWidth*cosr;offsets[leftBottom?"t":"b"]=size*cosr/2+labelWidth*sinr;offsets[leftBottom?"b":"t"]=size*cosr/2;}else if(rotation>(360-centerAnchorLimit)||(180>rotation&&rotation>(180-centerAnchorLimit))){offsets[side]=size*sinr/2+labelWidth*cosr;offsets[leftBottom?"b":"t"]=size*cosr/2+labelWidth*sinr;offsets[leftBottom?"t":"b"]=size*cosr/2;}else if(rotation<90||(180<rotation&&rotation<270)){offsets[side]=size*sinr+labelWidth*cosr;offsets[leftBottom?"t":"b"]=size*cosr+labelWidth*sinr;}else{offsets[side]=size*sinr+labelWidth*cosr;offsets[leftBottom?"b":"t"]=size*cosr+labelWidth*sinr;}
break;}
offsets[side]+=labelGap+Math.max(taMajorTick.length,taMinorTick.length);}else{var side=leftBottom?"b":"t";switch(rotation){case 0:case 180:offsets[side]=size;offsets.l=offsets.r=labelWidth/2;break;case 90:case 270:offsets[side]=labelWidth;offsets.l=offsets.r=size/2;break;default:if((90-centerAnchorLimit)<=rotation&&rotation<=90||(270-centerAnchorLimit)<=rotation&&rotation<=270){offsets[side]=size*sinr/2+labelWidth*cosr;offsets[leftBottom?"r":"l"]=size*cosr/2+labelWidth*sinr;offsets[leftBottom?"l":"r"]=size*cosr/2;}else if(90<=rotation&&rotation<=(90+centerAnchorLimit)||270<=rotation&&rotation<=(270+centerAnchorLimit)){offsets[side]=size*sinr/2+labelWidth*cosr;offsets[leftBottom?"l":"r"]=size*cosr/2+labelWidth*sinr;offsets[leftBottom?"r":"l"]=size*cosr/2;}else if(rotation<centerAnchorLimit||(180<rotation&&rotation<(180-centerAnchorLimit))){offsets[side]=size*sinr+labelWidth*cosr;offsets[leftBottom?"r":"l"]=size*cosr+labelWidth*sinr;}else{offsets[side]=size*sinr+labelWidth*cosr;offsets[leftBottom?"l":"r"]=size*cosr+labelWidth*sinr;}
break;}
offsets[side]+=labelGap+Math.max(taMajorTick.length,taMinorTick.length);}}
if(labelWidth){this._cachedLabelWidth=labelWidth;}
return offsets;},render:function(dim,offsets){if(!this.dirty){return this;}
var o=this.opt,ta=this.chart.theme.axis,leftBottom=o.leftBottom,rotation=o.rotation%360,start,stop,axisVector,tickVector,anchorOffset,labelOffset,labelAlign,taFont=o.font||(ta.majorTick&&ta.majorTick.font)||(ta.tick&&ta.tick.font),taFontColor=o.fontColor||(ta.majorTick&&ta.majorTick.fontColor)||(ta.tick&&ta.tick.fontColor)||"black",taMajorTick=this.chart.theme.getTick("major",o),taMinorTick=this.chart.theme.getTick("minor",o),taMicroTick=this.chart.theme.getTick("micro",o),tickSize=Math.max(taMajorTick.length,taMinorTick.length,taMicroTick.length),taStroke="stroke"in o?o.stroke:ta.stroke,size=taFont?g.normalizedLength(g.splitFontString(taFont).size):0;if(rotation<0){rotation+=360;}
if(this.vertical){start={y:dim.height-offsets.b};stop={y:offsets.t};axisVector={x:0,y:-1};labelOffset={x:0,y:0};tickVector={x:1,y:0};anchorOffset={x:labelGap,y:0};switch(rotation){case 0:labelAlign="end";labelOffset.y=size*0.4;break;case 90:labelAlign="middle";labelOffset.x=-size;break;case 180:labelAlign="start";labelOffset.y=-size*0.4;break;case 270:labelAlign="middle";break;default:if(rotation<centerAnchorLimit){labelAlign="end";labelOffset.y=size*0.4;}else if(rotation<90){labelAlign="end";labelOffset.y=size*0.4;}else if(rotation<(180-centerAnchorLimit)){labelAlign="start";}else if(rotation<(180+centerAnchorLimit)){labelAlign="start";labelOffset.y=-size*0.4;}else if(rotation<270){labelAlign="start";labelOffset.x=leftBottom?0:size*0.4;}else if(rotation<(360-centerAnchorLimit)){labelAlign="end";labelOffset.x=leftBottom?0:size*0.4;}else{labelAlign="end";labelOffset.y=size*0.4;}}
if(leftBottom){start.x=stop.x=offsets.l;tickVector.x=-1;anchorOffset.x=-anchorOffset.x;}else{start.x=stop.x=dim.width-offsets.r;switch(labelAlign){case"start":labelAlign="end";break;case"end":labelAlign="start";break;case"middle":labelOffset.x+=size;break;}}}else{start={x:offsets.l};stop={x:dim.width-offsets.r};axisVector={x:1,y:0};labelOffset={x:0,y:0};tickVector={x:0,y:1};anchorOffset={x:0,y:labelGap};switch(rotation){case 0:labelAlign="middle";labelOffset.y=size;break;case 90:labelAlign="start";labelOffset.x=-size*0.4;break;case 180:labelAlign="middle";break;case 270:labelAlign="end";labelOffset.x=size*0.4;break;default:if(rotation<(90-centerAnchorLimit)){labelAlign="start";labelOffset.y=leftBottom?size:0;}else if(rotation<(90+centerAnchorLimit)){labelAlign="start";labelOffset.x=-size*0.4;}else if(rotation<180){labelAlign="start";labelOffset.y=leftBottom?0:-size;}else if(rotation<(270-centerAnchorLimit)){labelAlign="end";labelOffset.y=leftBottom?0:-size;}else if(rotation<(270+centerAnchorLimit)){labelAlign="end";labelOffset.y=leftBottom?size*0.4:0;}else{labelAlign="end";labelOffset.y=leftBottom?size:0;}}
if(leftBottom){start.y=stop.y=dim.height-offsets.b;}else{start.y=stop.y=offsets.t;tickVector.y=-1;anchorOffset.y=-anchorOffset.y;switch(labelAlign){case"start":labelAlign="end";break;case"end":labelAlign="start";break;case"middle":labelOffset.y-=size;break;}}}
this.cleanGroup();try{var s=this.group,c=this.scaler,t=this.ticks,canLabel,f=lin.getTransformerFromModel(this.scaler),forceHtmlLabels=(dojox.gfx.renderer=="canvas"),labelType=forceHtmlLabels||!rotation&&this.opt.htmlLabels&&!dojo.isIE&&!dojo.isOpera?"html":"gfx",dx=tickVector.x*taMajorTick.length,dy=tickVector.y*taMajorTick.length;s.createLine({x1:start.x,y1:start.y,x2:stop.x,y2:stop.y}).setStroke(taStroke);dojo.forEach(t.major,function(tick){var offset=f(tick.value),elem,x=start.x+axisVector.x*offset,y=start.y+axisVector.y*offset;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(taMajorTick);if(tick.label){elem=dc.axis2d.common.createText[labelType](this.chart,s,x+dx+anchorOffset.x+(rotation?0:labelOffset.x),y+dy+anchorOffset.y+(rotation?0:labelOffset.y),labelAlign,tick.label,taFont,taFontColor);if(labelType=="html"){this.htmlElements.push(elem);}else if(rotation){elem.setTransform([{dx:labelOffset.x,dy:labelOffset.y},g.matrix.rotategAt(rotation,x+dx+anchorOffset.x,y+dy+anchorOffset.y)]);}}},this);dx=tickVector.x*taMinorTick.length;dy=tickVector.y*taMinorTick.length;canLabel=c.minMinorStep<=c.minor.tick*c.bounds.scale;dojo.forEach(t.minor,function(tick){var offset=f(tick.value),elem,x=start.x+axisVector.x*offset,y=start.y+axisVector.y*offset;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(taMinorTick);if(canLabel&&tick.label){elem=dc.axis2d.common.createText[labelType](this.chart,s,x+dx+anchorOffset.x+(rotation?0:labelOffset.x),y+dy+anchorOffset.y+(rotation?0:labelOffset.y),labelAlign,tick.label,taFont,taFontColor);if(labelType=="html"){this.htmlElements.push(elem);}else if(rotation){elem.setTransform([{dx:labelOffset.x,dy:labelOffset.y},g.matrix.rotategAt(rotation,x+dx+anchorOffset.x,y+dy+anchorOffset.y)]);}}},this);dx=tickVector.x*taMicroTick.length;dy=tickVector.y*taMicroTick.length;dojo.forEach(t.micro,function(tick){var offset=f(tick.value),elem,x=start.x+axisVector.x*offset,y=start.y+axisVector.y*offset;s.createLine({x1:x,y1:y,x2:x+dx,y2:y+dy}).setStroke(taMicroTick);},this);}catch(e){}
this.dirty=false;return this;}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.common"]){dojo._hasResource["dojox.charting.plot2d.common"]=true;dojo.provide("dojox.charting.plot2d.common");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common;dojo.mixin(dojox.charting.plot2d.common,{makeStroke:function(stroke){if(!stroke){return stroke;}
if(typeof stroke=="string"||stroke instanceof dojo.Color){stroke={color:stroke};}
return dojox.gfx.makeParameters(dojox.gfx.defaultStroke,stroke);},augmentColor:function(target,color){var t=new dojo.Color(target),c=new dojo.Color(color);c.a=t.a;return c;},augmentStroke:function(stroke,color){var s=dc.makeStroke(stroke);if(s){s.color=dc.augmentColor(s.color,color);}
return s;},augmentFill:function(fill,color){var fc,c=new dojo.Color(color);if(typeof fill=="string"||fill instanceof dojo.Color){return dc.augmentColor(fill,color);}
return fill;},defaultStats:{hmin:Number.POSITIVE_INFINITY,hmax:Number.NEGATIVE_INFINITY,vmin:Number.POSITIVE_INFINITY,vmax:Number.NEGATIVE_INFINITY},collectSimpleStats:function(series){var stats=dojo.delegate(dc.defaultStats);for(var i=0;i<series.length;++i){var run=series[i];for(var j=0;j<run.data.length;j++){if(run.data[j]!==null){if(typeof run.data[j]=="number"){var old_vmin=stats.vmin,old_vmax=stats.vmax;if(!("ymin"in run)||!("ymax"in run)){dojo.forEach(run.data,function(val,i){if(val!==null){var x=i+1,y=val;if(isNaN(y)){y=0;}
stats.hmin=Math.min(stats.hmin,x);stats.hmax=Math.max(stats.hmax,x);stats.vmin=Math.min(stats.vmin,y);stats.vmax=Math.max(stats.vmax,y);}});}
if("ymin"in run){stats.vmin=Math.min(old_vmin,run.ymin);}
if("ymax"in run){stats.vmax=Math.max(old_vmax,run.ymax);}}else{var old_hmin=stats.hmin,old_hmax=stats.hmax,old_vmin=stats.vmin,old_vmax=stats.vmax;if(!("xmin"in run)||!("xmax"in run)||!("ymin"in run)||!("ymax"in run)){dojo.forEach(run.data,function(val,i){if(val!==null){var x="x"in val?val.x:i+1,y=val.y;if(isNaN(x)){x=0;}
if(isNaN(y)){y=0;}
stats.hmin=Math.min(stats.hmin,x);stats.hmax=Math.max(stats.hmax,x);stats.vmin=Math.min(stats.vmin,y);stats.vmax=Math.max(stats.vmax,y);}});}
if("xmin"in run){stats.hmin=Math.min(old_hmin,run.xmin);}
if("xmax"in run){stats.hmax=Math.max(old_hmax,run.xmax);}
if("ymin"in run){stats.vmin=Math.min(old_vmin,run.ymin);}
if("ymax"in run){stats.vmax=Math.max(old_vmax,run.ymax);}}
break;}}}
return stats;},calculateBarSize:function(availableSize,opt,clusterSize){if(!clusterSize){clusterSize=1;}
var gap=opt.gap,size=(availableSize-2*gap)/clusterSize;if("minBarSize"in opt){size=Math.max(size,opt.minBarSize);}
if("maxBarSize"in opt){size=Math.min(size,opt.maxBarSize);}
size=Math.max(size,1);gap=(availableSize-size*clusterSize)/2;return{size:size,gap:gap};},collectStackedStats:function(series){var stats=dojo.clone(dc.defaultStats);if(series.length){stats.hmin=Math.min(stats.hmin,1);stats.hmax=df.foldl(series,"seed, run -> Math.max(seed, run.data.length)",stats.hmax);for(var i=0;i<stats.hmax;++i){var v=series[0].data[i];if(isNaN(v)){v=0;}
stats.vmin=Math.min(stats.vmin,v);for(var j=1;j<series.length;++j){var t=series[j].data[i];if(isNaN(t)){t=0;}
v+=t;}
stats.vmax=Math.max(stats.vmax,v);}}
return stats;},curve:function(a,tension){var arr=a.slice(0);if(tension=="x"){arr[arr.length]=arr[0];}
var p=dojo.map(arr,function(item,i){if(i==0){return"M"+item.x+","+item.y;}
if(!isNaN(tension)){var dx=item.x-arr[i-1].x,dy=arr[i-1].y;return"C"+(item.x-(tension-1)*(dx/tension))+","+dy+" "+(item.x-(dx/tension))+","+item.y+" "+item.x+","+item.y;}else if(tension=="X"||tension=="x"||tension=="S"){var p0,p1=arr[i-1],p2=arr[i],p3;var bz1x,bz1y,bz2x,bz2y;var f=1/6;if(i==1){if(tension=="x"){p0=arr[arr.length-2];}else{p0=p1;}
f=1/3;}else{p0=arr[i-2];}
if(i==(arr.length-1)){if(tension=="x"){p3=arr[1];}else{p3=p2;}
f=1/3;}else{p3=arr[i+1];}
var p1p2=Math.sqrt((p2.x-p1.x)*(p2.x-p1.x)+(p2.y-p1.y)*(p2.y-p1.y));var p0p2=Math.sqrt((p2.x-p0.x)*(p2.x-p0.x)+(p2.y-p0.y)*(p2.y-p0.y));var p1p3=Math.sqrt((p3.x-p1.x)*(p3.x-p1.x)+(p3.y-p1.y)*(p3.y-p1.y));var p0p2f=p0p2*f;var p1p3f=p1p3*f;if(p0p2f>p1p2/2&&p1p3f>p1p2/2){p0p2f=p1p2/2;p1p3f=p1p2/2;}else if(p0p2f>p1p2/2){p0p2f=p1p2/2;p1p3f=p1p2/2*p1p3/p0p2;}else if(p1p3f>p1p2/2){p1p3f=p1p2/2;p0p2f=p1p2/2*p0p2/p1p3;}
if(tension=="S"){if(p0==p1){p0p2f=0;}
if(p2==p3){p1p3f=0;}}
bz1x=p1.x+p0p2f*(p2.x-p0.x)/p0p2;bz1y=p1.y+p0p2f*(p2.y-p0.y)/p0p2;bz2x=p2.x-p1p3f*(p3.x-p1.x)/p1p3;bz2y=p2.y-p1p3f*(p3.y-p1.y)/p1p3;}
return"C"+(bz1x+","+bz1y+" "+bz2x+","+bz2y+" "+p2.x+","+p2.y);});return p.join(" ");}});})();}
if(!dojo._hasResource["dojox.charting.scaler.primitive"]){dojo._hasResource["dojox.charting.scaler.primitive"]=true;dojo.provide("dojox.charting.scaler.primitive");dojox.charting.scaler.primitive={buildScaler:function(min,max,span,kwArgs){if(min==max){min-=0.5;max+=0.5;}
return{bounds:{lower:min,upper:max,from:min,to:max,scale:span/(max-min),span:span},scaler:dojox.charting.scaler.primitive};},buildTicks:function(scaler,kwArgs){return{major:[],minor:[],micro:[]};},getTransformerFromModel:function(scaler){var offset=scaler.bounds.from,scale=scaler.bounds.scale;return function(x){return(x-offset)*scale;};},getTransformerFromPlot:function(scaler){var offset=scaler.bounds.from,scale=scaler.bounds.scale;return function(x){return x/scale+offset;};}};}
if(!dojo._hasResource["dojox.charting.plot2d._PlotEvents"]){dojo._hasResource["dojox.charting.plot2d._PlotEvents"]=true;dojo.provide("dojox.charting.plot2d._PlotEvents");dojo.declare("dojox.charting.plot2d._PlotEvents",null,{constructor:function(){this._shapeEvents=[];this._eventSeries={};},destroy:function(){this.resetEvents();this.inherited(arguments);},plotEvent:function(o){},raiseEvent:function(o){this.plotEvent(o);var t=dojo.delegate(o);t.originalEvent=o.type;t.originalPlot=o.plot;t.type="onindirect";dojo.forEach(this.chart.stack,function(plot){if(plot!==this&&plot.plotEvent){t.plot=plot;plot.plotEvent(t);}},this);},connect:function(object,method){this.dirty=true;return dojo.connect(this,"plotEvent",object,method);},events:function(){var ls=this.plotEvent._listeners;if(!ls||!ls.length){return false;}
for(var i in ls){if(!(i in Array.prototype)){return true;}}
return false;},resetEvents:function(){if(this._shapeEvents.length){dojo.forEach(this._shapeEvents,function(item){item.shape.disconnect(item.handle);});this._shapeEvents=[];}
this.raiseEvent({type:"onplotreset",plot:this});},_connectSingleEvent:function(o,eventName){this._shapeEvents.push({shape:o.eventMask,handle:o.eventMask.connect(eventName,this,function(e){o.type=eventName;o.event=e;this.raiseEvent(o);o.event=null;})});},_connectEvents:function(o){o.chart=this.chart;o.plot=this;o.hAxis=this.hAxis||null;o.vAxis=this.vAxis||null;o.eventMask=o.eventMask||o.shape;this._connectSingleEvent(o,"onmouseover");this._connectSingleEvent(o,"onmouseout");this._connectSingleEvent(o,"onclick");},_reconnectEvents:function(seriesName){var a=this._eventSeries[seriesName];if(a){dojo.forEach(a,this._connectEvents,this);}},fireEvent:function(seriesName,eventName,index,eventObject){var s=this._eventSeries[seriesName];if(s&&s.length&&index<s.length){var o=s[index];o.type=eventName;o.event=eventObject||null;this.raiseEvent(o);o.event=null;}}});}
if(!dojo._hasResource["dojox.charting.plot2d.Base"]){dojo._hasResource["dojox.charting.plot2d.Base"]=true;dojo.provide("dojox.charting.plot2d.Base");dojo.declare("dojox.charting.plot2d.Base",[dojox.charting.Element,dojox.charting.plot2d._PlotEvents],{constructor:function(chart,kwArgs){this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};},clear:function(){this.series=[];this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}
return this;},addSeries:function(run){this.series.push(run);return this;},getSeriesStats:function(){return dojox.charting.plot2d.common.collectSimpleStats(this.series);},calculateAxes:function(dim){this.initializeScalers(dim,this.getSeriesStats());return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},isDataDirty:function(){return dojo.some(this.series,function(item){return item.dirty;});},performZoom:function(dim,offsets){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,vOffset=dim.height-offsets.b,hBounds=this._hScaler.bounds,xOffset=(hBounds.from-hBounds.lower)*hBounds.scale,vBounds=this._vScaler.bounds,yOffset=(vBounds.from-vBounds.lower)*vBounds.scale;rVScale=vs/this.lastWindow.vscale,rHScale=hs/this.lastWindow.hscale,rXOffset=(this.lastWindow.xoffset-xOffset)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),rYOffset=(yOffset-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),shape=this.group,anim=dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,0],end:[offsets.l*(1-rHScale),vOffset*(1-rVScale)]},{name:"scale",start:[1,1],end:[rHScale,rVScale]},{name:"original"},{name:"translate",start:[0,0],end:[rXOffset,rYOffset]}]},this.zoom));dojo.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:xOffset,yoffset:yOffset});this.zoomQueue.push(anim);dojo.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}
return this;},render:function(dim,offsets){return this;},getRequiredColors:function(){return this.series.length;},initializeScalers:function(dim,stats){if(this._hAxis){if(!this._hAxis.initialized()){this._hAxis.calculate(stats.hmin,stats.hmax,dim.width);}
this._hScaler=this._hAxis.getScaler();}else{this._hScaler=dojox.charting.scaler.primitive.buildScaler(stats.hmin,stats.hmax,dim.width);}
if(this._vAxis){if(!this._vAxis.initialized()){this._vAxis.calculate(stats.vmin,stats.vmax,dim.height);}
this._vScaler=this._vAxis.getScaler();}else{this._vScaler=dojox.charting.scaler.primitive.buildScaler(stats.vmin,stats.vmax,dim.height);}
return this;}});}
if(!dojo._hasResource["dojox.gfx.fx"]){dojo._hasResource["dojox.gfx.fx"]=true;dojo.provide("dojox.gfx.fx");(function(){var d=dojo,g=dojox.gfx,m=g.matrix;var InterpolNumber=function(start,end){this.start=start,this.end=end;};d.extend(InterpolNumber,{getValue:function(r){return(this.end-this.start)*r+this.start;}});var InterpolUnit=function(start,end,units){this.start=start,this.end=end;this.units=units;};d.extend(InterpolUnit,{getValue:function(r){return(this.end-this.start)*r+this.start+this.units;}});var InterpolColor=function(start,end){this.start=start,this.end=end;this.temp=new dojo.Color();};d.extend(InterpolColor,{getValue:function(r){return d.blendColors(this.start,this.end,r,this.temp);}});var InterpolValues=function(values){this.values=values;this.length=values.length;};d.extend(InterpolValues,{getValue:function(r){return this.values[Math.min(Math.floor(r*this.length),this.length-1)];}});var InterpolObject=function(values,def){this.values=values;this.def=def?def:{};};d.extend(InterpolObject,{getValue:function(r){var ret=dojo.clone(this.def);for(var i in this.values){ret[i]=this.values[i].getValue(r);}
return ret;}});var InterpolTransform=function(stack,original){this.stack=stack;this.original=original;};d.extend(InterpolTransform,{getValue:function(r){var ret=[];dojo.forEach(this.stack,function(t){if(t instanceof m.Matrix2D){ret.push(t);return;}
if(t.name=="original"&&this.original){ret.push(this.original);return;}
if(!(t.name in m)){return;}
var f=m[t.name];if(typeof f!="function"){ret.push(f);return;}
var val=dojo.map(t.start,function(v,i){return(t.end[i]-v)*r+v;}),matrix=f.apply(m,val);if(matrix instanceof m.Matrix2D){ret.push(matrix);}},this);return ret;}});var transparent=new d.Color(0,0,0,0);var getColorInterpol=function(prop,obj,name,def){if(prop.values){return new InterpolValues(prop.values);}
var value,start,end;if(prop.start){start=g.normalizeColor(prop.start);}else{start=value=obj?(name?obj[name]:obj):def;}
if(prop.end){end=g.normalizeColor(prop.end);}else{if(!value){value=obj?(name?obj[name]:obj):def;}
end=value;}
return new InterpolColor(start,end);};var getNumberInterpol=function(prop,obj,name,def){if(prop.values){return new InterpolValues(prop.values);}
var value,start,end;if(prop.start){start=prop.start;}else{start=value=obj?obj[name]:def;}
if(prop.end){end=prop.end;}else{if(typeof value!="number"){value=obj?obj[name]:def;}
end=value;}
return new InterpolNumber(start,end);};g.fx.animateStroke=function(args){if(!args.easing){args.easing=d._defaultEasing;}
var anim=new d.Animation(args),shape=args.shape,stroke;d.connect(anim,"beforeBegin",anim,function(){stroke=shape.getStroke();var prop=args.color,values={},value,start,end;if(prop){values.color=getColorInterpol(prop,stroke,"color",transparent);}
prop=args.style;if(prop&&prop.values){values.style=new InterpolValues(prop.values);}
prop=args.width;if(prop){values.width=getNumberInterpol(prop,stroke,"width",1);}
prop=args.cap;if(prop&&prop.values){values.cap=new InterpolValues(prop.values);}
prop=args.join;if(prop){if(prop.values){values.join=new InterpolValues(prop.values);}else{start=prop.start?prop.start:(stroke&&stroke.join||0);end=prop.end?prop.end:(stroke&&stroke.join||0);if(typeof start=="number"&&typeof end=="number"){values.join=new InterpolNumber(start,end);}}}
this.curve=new InterpolObject(values,stroke);});d.connect(anim,"onAnimate",shape,"setStroke");return anim;};g.fx.animateFill=function(args){if(!args.easing){args.easing=d._defaultEasing;}
var anim=new d.Animation(args),shape=args.shape,fill;d.connect(anim,"beforeBegin",anim,function(){fill=shape.getFill();var prop=args.color,values={};if(prop){this.curve=getColorInterpol(prop,fill,"",transparent);}});d.connect(anim,"onAnimate",shape,"setFill");return anim;};g.fx.animateFont=function(args){if(!args.easing){args.easing=d._defaultEasing;}
var anim=new d.Animation(args),shape=args.shape,font;d.connect(anim,"beforeBegin",anim,function(){font=shape.getFont();var prop=args.style,values={},value,start,end;if(prop&&prop.values){values.style=new InterpolValues(prop.values);}
prop=args.variant;if(prop&&prop.values){values.variant=new InterpolValues(prop.values);}
prop=args.weight;if(prop&&prop.values){values.weight=new InterpolValues(prop.values);}
prop=args.family;if(prop&&prop.values){values.family=new InterpolValues(prop.values);}
prop=args.size;if(prop&&prop.units){start=parseFloat(prop.start?prop.start:(shape.font&&shape.font.size||"0"));end=parseFloat(prop.end?prop.end:(shape.font&&shape.font.size||"0"));values.size=new InterpolUnit(start,end,prop.units);}
this.curve=new InterpolObject(values,font);});d.connect(anim,"onAnimate",shape,"setFont");return anim;};g.fx.animateTransform=function(args){if(!args.easing){args.easing=d._defaultEasing;}
var anim=new d.Animation(args),shape=args.shape,original;d.connect(anim,"beforeBegin",anim,function(){original=shape.getTransform();this.curve=new InterpolTransform(args.transform,original);});d.connect(anim,"onAnimate",shape,"setTransform");return anim;};})();}
if(!dojo._hasResource["dojox.charting.plot2d.Default"]){dojo._hasResource["dojox.charting.plot2d.Default"]=true;dojo.provide("dojox.charting.plot2d.Default");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");var DEFAULT_ANIMATION_LENGTH=1200;dojo.declare("dojox.charting.plot2d.Default",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",lines:true,areas:false,markers:false,tension:"",animate:false},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:"",markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();this.group.setTransform(null);var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,stroke,outline,marker,events=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}
var theme=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,rsegments=[],startindexes=[],rseg=null,lpoly,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),eventSeries=this._eventSeries[run.name]=new Array(run.data.length);for(var j=0;j<run.data.length;j++){if(run.data[j]!=null){if(!rseg){rseg=[];startindexes.push(j);rsegments.push(rseg)}
rseg.push(run.data[j]);}else{rseg=null;}}
for(var seg=0;seg<rsegments.length;seg++){if(typeof rsegments[seg][0]=="number"){lpoly=dojo.map(rsegments[seg],function(v,i){return{x:ht(i+startindexes[seg]+1)+offsets.l,y:dim.height-offsets.b-vt(v)};},this);}else{lpoly=dojo.map(rsegments[seg],function(v,i){return{x:ht(v.x)+offsets.l,y:dim.height-offsets.b-vt(v.y)};},this);}
var lpath=this.opt.tension?dc.curve(lpoly,this.opt.tension):"";if(this.opt.areas&&lpoly.length>1){var fill=theme.series.fill;var apoly=dojo.clone(lpoly);if(this.opt.tension){var apath="L"+apoly[apoly.length-1].x+","+(dim.height-offsets.b)+" L"+apoly[0].x+","+(dim.height-offsets.b)+" L"+apoly[0].x+","+apoly[0].y;run.dyn.fill=s.createPath(lpath+" "+apath).setFill(fill).getFill();}else{apoly.push({x:lpoly[lpoly.length-1].x,y:dim.height-offsets.b});apoly.push({x:lpoly[0].x,y:dim.height-offsets.b});apoly.push(lpoly[0]);run.dyn.fill=s.createPolyline(apoly).setFill(fill).getFill();}}
if(this.opt.lines||this.opt.markers){stroke=theme.series.stroke;if(theme.series.outline){outline=run.dyn.outline=dc.makeStroke(theme.series.outline);outline.width=2*outline.width+stroke.width;}}
if(this.opt.markers){run.dyn.marker=theme.symbol;}
var frontMarkers=null,outlineMarkers=null,shadowMarkers=null;if(stroke&&theme.series.shadow&&lpoly.length>1){var shadow=theme.series.shadow,spoly=dojo.map(lpoly,function(c){return{x:c.x+shadow.dx,y:c.y+shadow.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(spoly,this.opt.tension)).setStroke(shadow).getStroke();}else{run.dyn.shadow=s.createPolyline(spoly).setStroke(shadow).getStroke();}}
if(this.opt.markers&&theme.marker.shadow){shadow=theme.marker.shadow;shadowMarkers=dojo.map(spoly,function(c){return s.createPath("M"+c.x+" "+c.y+" "+theme.symbol).setStroke(shadow).setFill(shadow.color);},this);}}
if(this.opt.lines&&lpoly.length>1){if(outline){if(this.opt.tension){run.dyn.outline=s.createPath(lpath).setStroke(outline).getStroke();}else{run.dyn.outline=s.createPolyline(lpoly).setStroke(outline).getStroke();}}
if(this.opt.tension){run.dyn.stroke=s.createPath(lpath).setStroke(stroke).getStroke();}else{run.dyn.stroke=s.createPolyline(lpoly).setStroke(stroke).getStroke();}}
if(this.opt.markers){frontMarkers=new Array(lpoly.length);outlineMarkers=new Array(lpoly.length);outline=null;if(theme.marker.outline){outline=dc.makeStroke(theme.marker.outline);outline.width=2*outline.width+(theme.marker.stroke?theme.marker.stroke.width:0);}
dojo.forEach(lpoly,function(c,i){var path="M"+c.x+" "+c.y+" "+theme.symbol;if(outline){outlineMarkers[i]=s.createPath(path).setStroke(outline);}
frontMarkers[i]=s.createPath(path).setStroke(theme.marker.stroke).setFill(theme.marker.fill);},this);if(events){dojo.forEach(frontMarkers,function(s,i){var o={element:"marker",index:i+startindexes[seg],run:run,shape:s,outline:outlineMarkers[i]||null,shadow:shadowMarkers&&shadowMarkers[i]||null,cx:lpoly[i].x,cy:lpoly[i].y};if(typeof rsegments[seg][0]=="number"){o.x=i+startindexes[seg]+1;o.y=rsegments[seg][i];}else{o.x=rsegments[seg][i].x;o.y=rsegments[seg][i].y;}
this._connectEvents(o);eventSeries[i+startindexes[seg]]=o;},this);}else{delete this._eventSeries[run.name];}}}
run.dirty=false;}
if(this.animate){var plotGroup=this.group;dojox.gfx.fx.animateTransform(dojo.delegate({shape:plotGroup,duration:DEFAULT_ANIMATION_LENGTH,transform:[{name:"translate",start:[0,dim.height-offsets.b],end:[0,0]},{name:"scale",start:[1,0],end:[1,1]},{name:"original"}]},this.animate)).play();}
this.dirty=false;return this;}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.Lines"]){dojo._hasResource["dojox.charting.plot2d.Lines"]=true;dojo.provide("dojox.charting.plot2d.Lines");dojo.declare("dojox.charting.plot2d.Lines",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;}});}
if(!dojo._hasResource["dojox.charting.plot2d.Areas"]){dojo._hasResource["dojox.charting.plot2d.Areas"]=true;dojo.provide("dojox.charting.plot2d.Areas");dojo.declare("dojox.charting.plot2d.Areas",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}
if(!dojo._hasResource["dojox.charting.plot2d.Markers"]){dojo._hasResource["dojox.charting.plot2d.Markers"]=true;dojo.provide("dojox.charting.plot2d.Markers");dojo.declare("dojox.charting.plot2d.Markers",dojox.charting.plot2d.Default,{constructor:function(){this.opt.markers=true;}});}
if(!dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]){dojo._hasResource["dojox.charting.plot2d.MarkersOnly"]=true;dojo.provide("dojox.charting.plot2d.MarkersOnly");dojo.declare("dojox.charting.plot2d.MarkersOnly",dojox.charting.plot2d.Default,{constructor:function(){this.opt.lines=false;this.opt.markers=true;}});}
if(!dojo._hasResource["dojox.charting.plot2d.Scatter"]){dojo._hasResource["dojox.charting.plot2d.Scatter"]=true;dojo.provide("dojox.charting.plot2d.Scatter");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Scatter",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",shadows:null,animate:null},optionalParams:{markerStroke:{},markerOutline:{},markerShadow:{},markerFill:{},markerFont:"",markerFontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,events=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}
var theme=t.next("marker",[this.opt,run]),s=run.group,lpoly,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);if(typeof run.data[0]=="number"){lpoly=dojo.map(run.data,function(v,i){return{x:ht(i+1)+offsets.l,y:dim.height-offsets.b-vt(v)};},this);}else{lpoly=dojo.map(run.data,function(v,i){return{x:ht(v.x)+offsets.l,y:dim.height-offsets.b-vt(v.y)};},this);}
var shadowMarkers=new Array(lpoly.length),frontMarkers=new Array(lpoly.length),outlineMarkers=new Array(lpoly.length);dojo.forEach(lpoly,function(c,i){var finalTheme=typeof run.data[i]=="number"?t.post(theme,"marker"):t.addMixin(theme,"marker",run.data[i],true),path="M"+c.x+" "+c.y+" "+finalTheme.symbol;if(finalTheme.marker.shadow){shadowMarkers[i]=s.createPath("M"+(c.x+finalTheme.marker.shadow.dx)+" "+
(c.y+finalTheme.marker.shadow.dy)+" "+finalTheme.symbol).setStroke(finalTheme.marker.shadow).setFill(finalTheme.marker.shadow.color);if(this.animate){this._animateScatter(shadowMarkers[i],dim.height-offsets.b);}}
if(finalTheme.marker.outline){var outline=dc.makeStroke(finalTheme.marker.outline);outline.width=2*outline.width+finalTheme.marker.stroke.width;outlineMarkers[i]=s.createPath(path).setStroke(outline);if(this.animate){this._animateScatter(outlineMarkers[i],dim.height-offsets.b);}}
var stroke=dc.makeStroke(finalTheme.marker.stroke),fill=this._plotFill(finalTheme.marker.fill,dim,offsets);if(fill&&(fill.type==="linear"||fill.type=="radial")){var color=dojox.gfx.gradutils.getColor(fill,{x:c.x,y:c.y});if(stroke){stroke.color=color;}
frontMarkers[i]=s.createPath(path).setStroke(stroke).setFill(color);}else{frontMarkers[i]=s.createPath(path).setStroke(stroke).setFill(fill);}
if(this.animate){this._animateScatter(frontMarkers[i],dim.height-offsets.b);}},this);if(frontMarkers.length){run.dyn.stroke=frontMarkers[frontMarkers.length-1].getStroke();run.dyn.fill=frontMarkers[frontMarkers.length-1].getFill();}
if(events){var eventSeries=new Array(frontMarkers.length);dojo.forEach(frontMarkers,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:outlineMarkers&&outlineMarkers[i]||null,shadow:shadowMarkers&&shadowMarkers[i]||null,cx:lpoly[i].x,cy:lpoly[i].y};if(typeof run.data[0]=="number"){o.x=i+1;o.y=run.data[i];}else{o.x=run.data[i].x;o.y=run.data[i].y;}
this._connectEvents(o);eventSeries[i]=o;},this);this._eventSeries[run.name]=eventSeries;}else{delete this._eventSeries[run.name];}
run.dirty=false;}
this.dirty=false;return this;},_animateScatter:function(shape,offset){dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,offset],end:[0,0]},{name:"scale",start:[0,0],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}
if(!dojo._hasResource["dojox.lang.functional.sequence"]){dojo._hasResource["dojox.lang.functional.sequence"]=true;dojo.provide("dojox.lang.functional.sequence");(function(){var d=dojo,df=dojox.lang.functional;d.mixin(df,{repeat:function(n,f,z,o){o=o||d.global;f=df.lambda(f);var t=new Array(n),i=1;t[0]=z;for(;i<n;t[i]=z=f.call(o,z),++i);return t;},until:function(pr,f,z,o){o=o||d.global;f=df.lambda(f);pr=df.lambda(pr);var t=[];for(;!pr.call(o,z);t.push(z),z=f.call(o,z));return t;}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.Stacked"]){dojo._hasResource["dojox.charting.plot2d.Stacked"]=true;dojo.provide("dojox.charting.plot2d.Stacked");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Stacked",dojox.charting.plot2d.Default,{getSeriesStats:function(){var stats=dc.collectStackedStats(this.series);this._maxRunLength=stats.hmax;return stats;},render:function(dim,offsets){if(this._maxRunLength<=0){return this;}
var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){if(isNaN(v)){v=0;}
acc[j]+=v;}}}
if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,events=this.events(),ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler);for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next(this.opt.areas?"area":"line",[this.opt,run],true),s=run.group,outline,lpoly=dojo.map(acc,function(v,i){return{x:ht(i+1)+offsets.l,y:dim.height-offsets.b-vt(v)};},this);var lpath=this.opt.tension?dc.curve(lpoly,this.opt.tension):"";if(this.opt.areas){var apoly=dojo.clone(lpoly);if(this.opt.tension){var p=dc.curve(apoly,this.opt.tension);p+=" L"+lpoly[lpoly.length-1].x+","+(dim.height-offsets.b)+" L"+lpoly[0].x+","+(dim.height-offsets.b)+" L"+lpoly[0].x+","+lpoly[0].y;run.dyn.fill=s.createPath(p).setFill(theme.series.fill).getFill();}else{apoly.push({x:lpoly[lpoly.length-1].x,y:dim.height-offsets.b});apoly.push({x:lpoly[0].x,y:dim.height-offsets.b});apoly.push(lpoly[0]);run.dyn.fill=s.createPolyline(apoly).setFill(theme.series.fill).getFill();}}
if(this.opt.lines||this.opt.markers){if(theme.series.outline){outline=dc.makeStroke(theme.series.outline);outline.width=2*outline.width+theme.series.stroke.width;}}
if(this.opt.markers){run.dyn.marker=theme.symbol;}
var frontMarkers,outlineMarkers,shadowMarkers;if(theme.series.shadow&&theme.series.stroke){var shadow=theme.series.shadow,spoly=dojo.map(lpoly,function(c){return{x:c.x+shadow.dx,y:c.y+shadow.dy};});if(this.opt.lines){if(this.opt.tension){run.dyn.shadow=s.createPath(dc.curve(spoly,this.opt.tension)).setStroke(shadow).getStroke();}else{run.dyn.shadow=s.createPolyline(spoly).setStroke(shadow).getStroke();}}
if(this.opt.markers){shadow=theme.marker.shadow;shadowMarkers=dojo.map(spoly,function(c){return s.createPath("M"+c.x+" "+c.y+" "+theme.symbol).setStroke(shadow).setFill(shadow.color);},this);}}
if(this.opt.lines){if(outline){if(this.opt.tension){run.dyn.outline=s.createPath(lpath).setStroke(outline).getStroke();}else{run.dyn.outline=s.createPolyline(lpoly).setStroke(outline).getStroke();}}
if(this.opt.tension){run.dyn.stroke=s.createPath(lpath).setStroke(theme.series.stroke).getStroke();}else{run.dyn.stroke=s.createPolyline(lpoly).setStroke(theme.series.stroke).getStroke();}}
if(this.opt.markers){frontMarkers=new Array(lpoly.length);outlineMarkers=new Array(lpoly.length);outline=null;if(theme.marker.outline){outline=dc.makeStroke(theme.marker.outline);outline.width=2*outline.width+(theme.marker.stroke?theme.marker.stroke.width:0);}
dojo.forEach(lpoly,function(c,i){var path="M"+c.x+" "+c.y+" "+theme.symbol;if(outline){outlineMarkers[i]=s.createPath(path).setStroke(outline);}
frontMarkers[i]=s.createPath(path).setStroke(theme.marker.stroke).setFill(theme.marker.fill);},this);if(events){var eventSeries=new Array(frontMarkers.length);dojo.forEach(frontMarkers,function(s,i){var o={element:"marker",index:i,run:run,shape:s,outline:outlineMarkers[i]||null,shadow:shadowMarkers&&shadowMarkers[i]||null,cx:lpoly[i].x,cy:lpoly[i].y,x:i+1,y:run.data[i]};this._connectEvents(o);eventSeries[i]=o;},this);this._eventSeries[run.name]=eventSeries;}else{delete this._eventSeries[run.name];}}
run.dirty=false;for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){if(isNaN(v)){v=0;}
acc[j]-=v;}}}
this.dirty=false;return this;}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.StackedLines"]){dojo._hasResource["dojox.charting.plot2d.StackedLines"]=true;dojo.provide("dojox.charting.plot2d.StackedLines");dojo.declare("dojox.charting.plot2d.StackedLines",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;}});}
if(!dojo._hasResource["dojox.charting.plot2d.StackedAreas"]){dojo._hasResource["dojox.charting.plot2d.StackedAreas"]=true;dojo.provide("dojox.charting.plot2d.StackedAreas");dojo.declare("dojox.charting.plot2d.StackedAreas",dojox.charting.plot2d.Stacked,{constructor:function(){this.opt.lines=true;this.opt.areas=true;}});}
if(!dojo._hasResource["dojox.charting.plot2d.Columns"]){dojo._hasResource["dojox.charting.plot2d.Columns"]=true;dojo.provide("dojox.charting.plot2d.Columns");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Columns",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);du.updateWithPattern(this.opt,kwArgs,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var stats=dc.collectSimpleStats(this.series);stats.hmin-=0.5;stats.hmax+=0.5;return stats;},render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,f,gap,width,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),baseline=Math.max(0,this._vScaler.bounds.lower),baselineHeight=vt(baseline),events=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;width=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next("column",[this.opt,run]),s=run.group,eventSeries=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y,vv=vt(v),height=vv-baselineHeight,h=Math.abs(height),finalTheme=typeof value!="number"?t.addMixin(theme,"column",value,true):t.post(theme,"column");if(width>=1&&h>=1){var rect={x:offsets.l+ht(j+0.5)+gap,y:dim.height-offsets.b-(v>baseline?vv:baselineHeight),width:width,height:h};var specialFill=this._plotFill(finalTheme.series.fill,dim,offsets);specialFill=this._shapeFill(specialFill,rect);var shape=s.createRect(rect).setFill(specialFill).setStroke(finalTheme.series.stroke);run.dyn.fill=shape.getFill();run.dyn.stroke=shape.getStroke();if(events){var o={element:"column",index:j,run:run,shape:shape,x:j+0.5,y:v};this._connectEvents(o);eventSeries[j]=o;}
if(this.animate){this._animateColumn(shape,dim.height-offsets.b-baselineHeight,h);}}}}
this._eventSeries[run.name]=eventSeries;run.dirty=false;}
this.dirty=false;return this;},_animateColumn:function(shape,voffset,vsize){dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,voffset-(voffset/vsize)],end:[0,0]},{name:"scale",start:[1,1/vsize],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.StackedColumns"]){dojo._hasResource["dojox.charting.plot2d.StackedColumns"]=true;dojo.provide("dojox.charting.plot2d.StackedColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedColumns",dojox.charting.plot2d.Columns,{getSeriesStats:function(){var stats=dc.collectStackedStats(this.series);this._maxRunLength=stats.hmax;stats.hmin-=0.5;stats.hmax+=0.5;return stats;},render:function(dim,offsets){if(this._maxRunLength<=0){return this;}
var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y;if(isNaN(v)){v=0;}
acc[j]+=v;}}}
if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,f,gap,width,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),events=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;width=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next("column",[this.opt,run]),s=run.group,eventSeries=new Array(acc.length);for(var j=0;j<acc.length;++j){var value=run.data[j];if(value!==null){var v=acc[j],height=vt(v),finalTheme=typeof value!="number"?t.addMixin(theme,"column",value,true):t.post(theme,"column");if(width>=1&&height>=1){var rect={x:offsets.l+ht(j+0.5)+gap,y:dim.height-offsets.b-vt(v),width:width,height:height};var specialFill=this._plotFill(finalTheme.series.fill,dim,offsets);specialFill=this._shapeFill(specialFill,rect);var shape=s.createRect(rect).setFill(specialFill).setStroke(finalTheme.series.stroke);run.dyn.fill=shape.getFill();run.dyn.stroke=shape.getStroke();if(events){var o={element:"column",index:j,run:run,shape:shape,x:j+0.5,y:v};this._connectEvents(o);eventSeries[j]=o;}
if(this.animate){this._animateColumn(shape,dim.height-offsets.b,height);}}}}
this._eventSeries[run.name]=eventSeries;run.dirty=false;for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y;if(isNaN(v)){v=0;}
acc[j]-=v;}}}
this.dirty=false;return this;}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]){dojo._hasResource["dojox.charting.plot2d.ClusteredColumns"]=true;dojo.provide("dojox.charting.plot2d.ClusteredColumns");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredColumns",dojox.charting.plot2d.Columns,{render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,f,gap,width,thickness,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),baseline=Math.max(0,this._vScaler.bounds.lower),baselineHeight=vt(baseline),events=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;width=thickness=f.size;for(var i=0;i<this.series.length;++i){var run=this.series[i],shift=thickness*i;if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next("column",[this.opt,run]),s=run.group,eventSeries=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y,vv=vt(v),height=vv-baselineHeight,h=Math.abs(height),finalTheme=typeof value!="number"?t.addMixin(theme,"column",value,true):t.post(theme,"column");if(width>=1&&h>=1){var rect={x:offsets.l+ht(j+0.5)+gap+shift,y:dim.height-offsets.b-(v>baseline?vv:baselineHeight),width:width,height:h};var specialFill=this._plotFill(finalTheme.series.fill,dim,offsets);specialFill=this._shapeFill(specialFill,rect);var shape=s.createRect(rect).setFill(specialFill).setStroke(finalTheme.series.stroke);run.dyn.fill=shape.getFill();run.dyn.stroke=shape.getStroke();if(events){var o={element:"column",index:j,run:run,shape:shape,x:j+0.5,y:v};this._connectEvents(o);eventSeries[j]=o;}
if(this.animate){this._animateColumn(shape,dim.height-offsets.b-baselineHeight,h);}}}}
this._eventSeries[run.name]=eventSeries;run.dirty=false;}
this.dirty=false;return this;}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.Bars"]){dojo._hasResource["dojox.charting.plot2d.Bars"]=true;dojo.provide("dojox.charting.plot2d.Bars");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bars",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:0,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);du.updateWithPattern(this.opt,kwArgs,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},getSeriesStats:function(){var stats=dc.collectSimpleStats(this.series),t;stats.hmin-=0.5;stats.hmax+=0.5;t=stats.hmin,stats.hmin=stats.vmin,stats.vmin=t;t=stats.hmax,stats.hmax=stats.vmax,stats.vmax=t;return stats;},render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.dirty=this.isDirty();this.resetEvents();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,f,gap,height,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),baseline=Math.max(0,this._hScaler.bounds.lower),baselineWidth=ht(baseline),events=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;height=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next("bar",[this.opt,run]),s=run.group,eventSeries=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y,hv=ht(v),width=hv-baselineWidth,w=Math.abs(width),finalTheme=typeof value!="number"?t.addMixin(theme,"bar",value,true):t.post(theme,"bar");if(w>=1&&height>=1){var rect={x:offsets.l+(v<baseline?hv:baselineWidth),y:dim.height-offsets.b-vt(j+1.5)+gap,width:w,height:height};var specialFill=this._plotFill(finalTheme.series.fill,dim,offsets);specialFill=this._shapeFill(specialFill,rect);var shape=s.createRect(rect).setFill(specialFill).setStroke(finalTheme.series.stroke);run.dyn.fill=shape.getFill();run.dyn.stroke=shape.getStroke();if(events){var o={element:"bar",index:j,run:run,shape:shape,x:v,y:j+1.5};this._connectEvents(o);eventSeries[j]=o;}
if(this.animate){this._animateBar(shape,offsets.l+baselineWidth,-w);}}}}
this._eventSeries[run.name]=eventSeries;run.dirty=false;}
this.dirty=false;return this;},_animateBar:function(shape,hoffset,hsize){dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[hoffset-(hoffset/hsize),0],end:[0,0]},{name:"scale",start:[1/hsize,1],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.StackedBars"]){dojo._hasResource["dojox.charting.plot2d.StackedBars"]=true;dojo.provide("dojox.charting.plot2d.StackedBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.StackedBars",dojox.charting.plot2d.Bars,{getSeriesStats:function(){var stats=dc.collectStackedStats(this.series),t;this._maxRunLength=stats.hmax;stats.hmin-=0.5;stats.hmax+=0.5;t=stats.hmin,stats.hmin=stats.vmin,stats.vmin=t;t=stats.hmax,stats.hmax=stats.vmax,stats.vmax=t;return stats;},render:function(dim,offsets){if(this._maxRunLength<=0){return this;}
var acc=df.repeat(this._maxRunLength,"-> 0",0);for(var i=0;i<this.series.length;++i){var run=this.series[i];for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y;if(isNaN(v)){v=0;}
acc[j]+=v;}}}
if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,f,gap,height,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),events=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt);gap=f.gap;height=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next("bar",[this.opt,run]),s=run.group,eventSeries=new Array(acc.length);for(var j=0;j<acc.length;++j){var value=run.data[j];if(value!==null){var v=acc[j],width=ht(v),finalTheme=typeof value!="number"?t.addMixin(theme,"bar",value,true):t.post(theme,"bar");if(width>=1&&height>=1){var rect={x:offsets.l,y:dim.height-offsets.b-vt(j+1.5)+gap,width:width,height:height};var specialFill=this._plotFill(finalTheme.series.fill,dim,offsets);specialFill=this._shapeFill(specialFill,rect);var shape=s.createRect(rect).setFill(specialFill).setStroke(finalTheme.series.stroke);run.dyn.fill=shape.getFill();run.dyn.stroke=shape.getStroke();if(events){var o={element:"bar",index:j,run:run,shape:shape,x:v,y:j+1.5};this._connectEvents(o);eventSeries[j]=o;}
if(this.animate){this._animateBar(shape,offsets.l,-width);}}}}
this._eventSeries[run.name]=eventSeries;run.dirty=false;for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y;if(isNaN(v)){v=0;}
acc[j]-=v;}}}
this.dirty=false;return this;}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]){dojo._hasResource["dojox.charting.plot2d.ClusteredBars"]=true;dojo.provide("dojox.charting.plot2d.ClusteredBars");(function(){var df=dojox.lang.functional,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.ClusteredBars",dojox.charting.plot2d.Bars,{render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,f,gap,height,thickness,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),baseline=Math.max(0,this._hScaler.bounds.lower),baselineWidth=ht(baseline),events=this.events();f=dc.calculateBarSize(this._vScaler.bounds.scale,this.opt,this.series.length);gap=f.gap;height=thickness=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i],shift=thickness*(this.series.length-i-1);if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next("bar",[this.opt,run]),s=run.group,eventSeries=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var value=run.data[j];if(value!==null){var v=typeof value=="number"?value:value.y,hv=ht(v),width=hv-baselineWidth,w=Math.abs(width),finalTheme=typeof value!="number"?t.addMixin(theme,"bar",value,true):t.post(theme,"bar");if(w>=1&&height>=1){var rect={x:offsets.l+(v<baseline?hv:baselineWidth),y:dim.height-offsets.b-vt(j+1.5)+gap+shift,width:w,height:height};var specialFill=this._plotFill(finalTheme.series.fill,dim,offsets);specialFill=this._shapeFill(specialFill,rect);var shape=s.createRect(rect).setFill(specialFill).setStroke(finalTheme.series.stroke);run.dyn.fill=shape.getFill();run.dyn.stroke=shape.getStroke();if(events){var o={element:"bar",index:j,run:run,shape:shape,x:v,y:j+1.5};this._connectEvents(o);eventSeries[j]=o;}
if(this.animate){this._animateBar(shape,offsets.l+baselineWidth,-width);}}}}
this._eventSeries[run.name]=eventSeries;run.dirty=false;}
this.dirty=false;return this;}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.Grid"]){dojo._hasResource["dojox.charting.plot2d.Grid"]=true;dojo.provide("dojox.charting.plot2d.Grid");(function(){var du=dojox.lang.utils,dc=dojox.charting.plot2d.common;dojo.declare("dojox.charting.plot2d.Grid",dojox.charting.Element,{defaultParams:{hAxis:"x",vAxis:"y",hMajorLines:true,hMinorLines:false,vMajorLines:true,vMinorLines:false,hStripes:"none",vStripes:"none",animate:null},optionalParams:{},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.dirty=true;this.animate=this.opt.animate;this.zoom=null,this.zoomQueue=[];this.lastWindow={vscale:1,hscale:1,xoffset:0,yoffset:0};},clear:function(){this._hAxis=null;this._vAxis=null;this.dirty=true;return this;},setAxis:function(axis){if(axis){this[axis.vertical?"_vAxis":"_hAxis"]=axis;}
return this;},addSeries:function(run){return this;},getSeriesStats:function(){return dojo.delegate(dc.defaultStats);},initializeScalers:function(){return this;},isDirty:function(){return this.dirty||this._hAxis&&this._hAxis.dirty||this._vAxis&&this._vAxis.dirty;},performZoom:function(dim,offsets){var vs=this._vAxis.scale||1,hs=this._hAxis.scale||1,vOffset=dim.height-offsets.b,hBounds=this._hAxis.getScaler().bounds,xOffset=(hBounds.from-hBounds.lower)*hBounds.scale,vBounds=this._vAxis.getScaler().bounds,yOffset=(vBounds.from-vBounds.lower)*vBounds.scale;rVScale=vs/this.lastWindow.vscale,rHScale=hs/this.lastWindow.hscale,rXOffset=(this.lastWindow.xoffset-xOffset)/((this.lastWindow.hscale==1)?hs:this.lastWindow.hscale),rYOffset=(yOffset-this.lastWindow.yoffset)/((this.lastWindow.vscale==1)?vs:this.lastWindow.vscale),shape=this.group,anim=dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,0],end:[offsets.l*(1-rHScale),vOffset*(1-rVScale)]},{name:"scale",start:[1,1],end:[rHScale,rVScale]},{name:"original"},{name:"translate",start:[0,0],end:[rXOffset,rYOffset]}]},this.zoom));dojo.mixin(this.lastWindow,{vscale:vs,hscale:hs,xoffset:xOffset,yoffset:yOffset});this.zoomQueue.push(anim);dojo.connect(anim,"onEnd",this,function(){this.zoom=null;this.zoomQueue.shift();if(this.zoomQueue.length>0){this.zoomQueue[0].play();}});if(this.zoomQueue.length==1){this.zoomQueue[0].play();}
return this;},getRequiredColors:function(){return 0;},render:function(dim,offsets){if(this.zoom){return this.performZoom(dim,offsets);}
this.dirty=this.isDirty();if(!this.dirty){return this;}
this.cleanGroup();var s=this.group,ta=this.chart.theme.axis;try{var vScaler=this._vAxis.getScaler(),vt=vScaler.scaler.getTransformerFromModel(vScaler),ticks=this._vAxis.getTicks();if(this.opt.hMinorLines){dojo.forEach(ticks.minor,function(tick){var y=dim.height-offsets.b-vt(tick.value);var hMinorLine=s.createLine({x1:offsets.l,y1:y,x2:dim.width-offsets.r,y2:y}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(hMinorLine,"h",offsets.l,offsets.r+offsets.l-dim.width);}},this);}
if(this.opt.hMajorLines){dojo.forEach(ticks.major,function(tick){var y=dim.height-offsets.b-vt(tick.value);var hMajorLine=s.createLine({x1:offsets.l,y1:y,x2:dim.width-offsets.r,y2:y}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(hMajorLine,"h",offsets.l,offsets.r+offsets.l-dim.width);}},this);}}catch(e){}
try{var hScaler=this._hAxis.getScaler(),ht=hScaler.scaler.getTransformerFromModel(hScaler),ticks=this._hAxis.getTicks();if(ticks&&this.opt.vMinorLines){dojo.forEach(ticks.minor,function(tick){var x=offsets.l+ht(tick.value);var vMinorLine=s.createLine({x1:x,y1:offsets.t,x2:x,y2:dim.height-offsets.b}).setStroke(ta.minorTick);if(this.animate){this._animateGrid(vMinorLine,"v",dim.height-offsets.b,dim.height-offsets.b-offsets.t);}},this);}
if(ticks&&this.opt.vMajorLines){dojo.forEach(ticks.major,function(tick){var x=offsets.l+ht(tick.value);var vMajorLine=s.createLine({x1:x,y1:offsets.t,x2:x,y2:dim.height-offsets.b}).setStroke(ta.majorTick);if(this.animate){this._animateGrid(vMajorLine,"v",dim.height-offsets.b,dim.height-offsets.b-offsets.t);}},this);}}catch(e){}
this.dirty=false;return this;},_animateGrid:function(shape,type,offset,size){var transStart=type=="h"?[offset,0]:[0,offset];var scaleStart=type=="h"?[1/size,1]:[1,1/size];dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:transStart,end:[0,0]},{name:"scale",start:scaleStart,end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}
if(!dojo._hasResource["dojo.i18n"]){dojo._hasResource["dojo.i18n"]=true;dojo.provide("dojo.i18n");dojo.i18n.getLocalization=function(packageName,bundleName,locale){locale=dojo.i18n.normalizeLocale(locale);var elements=locale.split('-');var module=[packageName,"nls",bundleName].join('.');var bundle=dojo._loadedModules[module];if(bundle){var localization;for(var i=elements.length;i>0;i--){var loc=elements.slice(0,i).join('_');if(bundle[loc]){localization=bundle[loc];break;}}
if(!localization){localization=bundle.ROOT;}
if(localization){var clazz=function(){};clazz.prototype=localization;return new clazz();}}
throw new Error("Bundle not found: "+bundleName+" in "+packageName+" , locale="+locale);};dojo.i18n.normalizeLocale=function(locale){var result=locale?locale.toLowerCase():dojo.locale;if(result=="root"){result="ROOT";}
return result;};dojo.i18n._requireLocalization=function(moduleName,bundleName,locale,availableFlatLocales){var targetLocale=dojo.i18n.normalizeLocale(locale);var bundlePackage=[moduleName,"nls",bundleName].join(".");var bestLocale="";if(availableFlatLocales){var flatLocales=availableFlatLocales.split(",");for(var i=0;i<flatLocales.length;i++){if(targetLocale["indexOf"](flatLocales[i])==0){if(flatLocales[i].length>bestLocale.length){bestLocale=flatLocales[i];}}}
if(!bestLocale){bestLocale="ROOT";}}
var tempLocale=availableFlatLocales?bestLocale:targetLocale;var bundle=dojo._loadedModules[bundlePackage];var localizedBundle=null;if(bundle){if(dojo.config.localizationComplete&&bundle._built){return;}
var jsLoc=tempLocale.replace(/-/g,'_');var translationPackage=bundlePackage+"."+jsLoc;localizedBundle=dojo._loadedModules[translationPackage];}
if(!localizedBundle){bundle=dojo["provide"](bundlePackage);var syms=dojo._getModuleSymbols(moduleName);var modpath=syms.concat("nls").join("/");var parent;dojo.i18n._searchLocalePath(tempLocale,availableFlatLocales,function(loc){var jsLoc=loc.replace(/-/g,'_');var translationPackage=bundlePackage+"."+jsLoc;var loaded=false;if(!dojo._loadedModules[translationPackage]){dojo["provide"](translationPackage);var module=[modpath];if(loc!="ROOT"){module.push(loc);}
module.push(bundleName);var filespec=module.join("/")+'.js';loaded=dojo._loadPath(filespec,null,function(hash){var clazz=function(){};clazz.prototype=parent;bundle[jsLoc]=new clazz();for(var j in hash){bundle[jsLoc][j]=hash[j];}});}else{loaded=true;}
if(loaded&&bundle[jsLoc]){parent=bundle[jsLoc];}else{bundle[jsLoc]=parent;}
if(availableFlatLocales){return true;}});}
if(availableFlatLocales&&targetLocale!=bestLocale){bundle[targetLocale.replace(/-/g,'_')]=bundle[bestLocale.replace(/-/g,'_')];}};(function(){var extra=dojo.config.extraLocale;if(extra){if(!extra instanceof Array){extra=[extra];}
var req=dojo.i18n._requireLocalization;dojo.i18n._requireLocalization=function(m,b,locale,availableFlatLocales){req(m,b,locale,availableFlatLocales);if(locale){return;}
for(var i=0;i<extra.length;i++){req(m,b,extra[i],availableFlatLocales);}};}})();dojo.i18n._searchLocalePath=function(locale,down,searchFunc){locale=dojo.i18n.normalizeLocale(locale);var elements=locale.split('-');var searchlist=[];for(var i=elements.length;i>0;i--){searchlist.push(elements.slice(0,i).join('-'));}
searchlist.push(false);if(down){searchlist.reverse();}
for(var j=searchlist.length-1;j>=0;j--){var loc=searchlist[j]||"ROOT";var stop=searchFunc(loc);if(stop){break;}}};dojo.i18n._preloadLocalizations=function(bundlePrefix,localesGenerated){function preload(locale){locale=dojo.i18n.normalizeLocale(locale);dojo.i18n._searchLocalePath(locale,true,function(loc){for(var i=0;i<localesGenerated.length;i++){if(localesGenerated[i]==loc){dojo["require"](bundlePrefix+"_"+loc);return true;}}
return false;});}
preload();var extra=dojo.config.extraLocale||[];for(var i=0;i<extra.length;i++){preload(extra[i]);}};}
if(!dojo._hasResource["dojo.regexp"]){dojo._hasResource["dojo.regexp"]=true;dojo.provide("dojo.regexp");dojo.regexp.escapeString=function(str,except){return str.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g,function(ch){if(except&&except.indexOf(ch)!=-1){return ch;}
return"\\"+ch;});}
dojo.regexp.buildGroupRE=function(arr,re,nonCapture){if(!(arr instanceof Array)){return re(arr);}
var b=[];for(var i=0;i<arr.length;i++){b.push(re(arr[i]));}
return dojo.regexp.group(b.join("|"),nonCapture);}
dojo.regexp.group=function(expression,nonCapture){return"("+(nonCapture?"?:":"")+expression+")";}}
if(!dojo._hasResource["dojo.number"]){dojo._hasResource["dojo.number"]=true;dojo.provide("dojo.number");dojo.number.format=function(value,options){options=dojo.mixin({},options||{});var locale=dojo.i18n.normalizeLocale(options.locale),bundle=dojo.i18n.getLocalization("dojo.cldr","number",locale);options.customs=bundle;var pattern=options.pattern||bundle[(options.type||"decimal")+"Format"];if(isNaN(value)||Math.abs(value)==Infinity){return null;}
return dojo.number._applyPattern(value,pattern,options);};dojo.number._numberPatternRE=/[#0,]*[#0](?:\.0*#*)?/;dojo.number._applyPattern=function(value,pattern,options){options=options||{};var group=options.customs.group,decimal=options.customs.decimal,patternList=pattern.split(';'),positivePattern=patternList[0];pattern=patternList[(value<0)?1:0]||("-"+positivePattern);if(pattern.indexOf('%')!=-1){value*=100;}else if(pattern.indexOf('\u2030')!=-1){value*=1000;}else if(pattern.indexOf('\u00a4')!=-1){group=options.customs.currencyGroup||group;decimal=options.customs.currencyDecimal||decimal;pattern=pattern.replace(/\u00a4{1,3}/,function(match){var prop=["symbol","currency","displayName"][match.length-1];return options[prop]||options.currency||"";});}else if(pattern.indexOf('E')!=-1){throw new Error("exponential notation not supported");}
var numberPatternRE=dojo.number._numberPatternRE;var numberPattern=positivePattern.match(numberPatternRE);if(!numberPattern){throw new Error("unable to find a number expression in pattern: "+pattern);}
if(options.fractional===false){options.places=0;}
return pattern.replace(numberPatternRE,dojo.number._formatAbsolute(value,numberPattern[0],{decimal:decimal,group:group,places:options.places,round:options.round}));}
dojo.number.round=function(value,places,increment){var factor=10/(increment||10);return(factor*+value).toFixed(places)/factor;}
if((0.9).toFixed()==0){(function(){var round=dojo.number.round;dojo.number.round=function(v,p,m){var d=Math.pow(10,-p||0),a=Math.abs(v);if(!v||a>=d||a*Math.pow(10,p+1)<5){d=0;}
return round(v,p,m)+(v>0?d:-d);}})();}
dojo.number._formatAbsolute=function(value,pattern,options){options=options||{};if(options.places===true){options.places=0;}
if(options.places===Infinity){options.places=6;}
var patternParts=pattern.split("."),comma=typeof options.places=="string"&&options.places.indexOf(","),maxPlaces=options.places;if(comma){maxPlaces=options.places.substring(comma+1);}else if(!(maxPlaces>=0)){maxPlaces=(patternParts[1]||[]).length;}
if(!(options.round<0)){value=dojo.number.round(value,maxPlaces,options.round);}
var valueParts=String(Math.abs(value)).split("."),fractional=valueParts[1]||"";if(patternParts[1]||options.places){if(comma){options.places=options.places.substring(0,comma);}
var pad=options.places!==undefined?options.places:(patternParts[1]&&patternParts[1].lastIndexOf("0")+1);if(pad>fractional.length){valueParts[1]=dojo.string.pad(fractional,pad,'0',true);}
if(maxPlaces<fractional.length){valueParts[1]=fractional.substr(0,maxPlaces);}}else{if(valueParts[1]){valueParts.pop();}}
var patternDigits=patternParts[0].replace(',','');pad=patternDigits.indexOf("0");if(pad!=-1){pad=patternDigits.length-pad;if(pad>valueParts[0].length){valueParts[0]=dojo.string.pad(valueParts[0],pad);}
if(patternDigits.indexOf("#")==-1){valueParts[0]=valueParts[0].substr(valueParts[0].length-pad);}}
var index=patternParts[0].lastIndexOf(','),groupSize,groupSize2;if(index!=-1){groupSize=patternParts[0].length-index-1;var remainder=patternParts[0].substr(0,index);index=remainder.lastIndexOf(',');if(index!=-1){groupSize2=remainder.length-index-1;}}
var pieces=[];for(var whole=valueParts[0];whole;){var off=whole.length-groupSize;pieces.push((off>0)?whole.substr(off):whole);whole=(off>0)?whole.slice(0,off):"";if(groupSize2){groupSize=groupSize2;delete groupSize2;}}
valueParts[0]=pieces.reverse().join(options.group||",");return valueParts.join(options.decimal||".");};dojo.number.regexp=function(options){return dojo.number._parseInfo(options).regexp;}
dojo.number._parseInfo=function(options){options=options||{};var locale=dojo.i18n.normalizeLocale(options.locale),bundle=dojo.i18n.getLocalization("dojo.cldr","number",locale),pattern=options.pattern||bundle[(options.type||"decimal")+"Format"],group=bundle.group,decimal=bundle.decimal,factor=1;if(pattern.indexOf('%')!=-1){factor/=100;}else if(pattern.indexOf('\u2030')!=-1){factor/=1000;}else{var isCurrency=pattern.indexOf('\u00a4')!=-1;if(isCurrency){group=bundle.currencyGroup||group;decimal=bundle.currencyDecimal||decimal;}}
var patternList=pattern.split(';');if(patternList.length==1){patternList.push("-"+patternList[0]);}
var re=dojo.regexp.buildGroupRE(patternList,function(pattern){pattern="(?:"+dojo.regexp.escapeString(pattern,'.')+")";return pattern.replace(dojo.number._numberPatternRE,function(format){var flags={signed:false,separator:options.strict?group:[group,""],fractional:options.fractional,decimal:decimal,exponent:false},parts=format.split('.'),places=options.places;if(parts.length==1&&factor!=1){parts[1]="###";}
if(parts.length==1||places===0){flags.fractional=false;}else{if(places===undefined){places=options.pattern?parts[1].lastIndexOf('0')+1:Infinity;}
if(places&&options.fractional==undefined){flags.fractional=true;}
if(!options.places&&(places<parts[1].length)){places+=","+parts[1].length;}
flags.places=places;}
var groups=parts[0].split(',');if(groups.length>1){flags.groupSize=groups.pop().length;if(groups.length>1){flags.groupSize2=groups.pop().length;}}
return"("+dojo.number._realNumberRegexp(flags)+")";});},true);if(isCurrency){re=re.replace(/([\s\xa0]*)(\u00a4{1,3})([\s\xa0]*)/g,function(match,before,target,after){var prop=["symbol","currency","displayName"][target.length-1],symbol=dojo.regexp.escapeString(options[prop]||options.currency||"");before=before?"[\\s\\xa0]":"";after=after?"[\\s\\xa0]":"";if(!options.strict){if(before){before+="*";}
if(after){after+="*";}
return"(?:"+before+symbol+after+")?";}
return before+symbol+after;});}
return{regexp:re.replace(/[\xa0 ]/g,"[\\s\\xa0]"),group:group,decimal:decimal,factor:factor};}
dojo.number.parse=function(expression,options){var info=dojo.number._parseInfo(options),results=(new RegExp("^"+info.regexp+"$")).exec(expression);if(!results){return NaN;}
var absoluteMatch=results[1];if(!results[1]){if(!results[2]){return NaN;}
absoluteMatch=results[2];info.factor*=-1;}
absoluteMatch=absoluteMatch.replace(new RegExp("["+info.group+"\\s\\xa0"+"]","g"),"").replace(info.decimal,".");return absoluteMatch*info.factor;};dojo.number._realNumberRegexp=function(flags){flags=flags||{};if(!("places"in flags)){flags.places=Infinity;}
if(typeof flags.decimal!="string"){flags.decimal=".";}
if(!("fractional"in flags)||/^0/.test(flags.places)){flags.fractional=[true,false];}
if(!("exponent"in flags)){flags.exponent=[true,false];}
if(!("eSigned"in flags)){flags.eSigned=[true,false];}
var integerRE=dojo.number._integerRegexp(flags),decimalRE=dojo.regexp.buildGroupRE(flags.fractional,function(q){var re="";if(q&&(flags.places!==0)){re="\\"+flags.decimal;if(flags.places==Infinity){re="(?:"+re+"\\d+)?";}else{re+="\\d{"+flags.places+"}";}}
return re;},true);var exponentRE=dojo.regexp.buildGroupRE(flags.exponent,function(q){if(q){return"([eE]"+dojo.number._integerRegexp({signed:flags.eSigned})+")";}
return"";});var realRE=integerRE+decimalRE;if(decimalRE){realRE="(?:(?:"+realRE+")|(?:"+decimalRE+"))";}
return realRE+exponentRE;};dojo.number._integerRegexp=function(flags){flags=flags||{};if(!("signed"in flags)){flags.signed=[true,false];}
if(!("separator"in flags)){flags.separator="";}else if(!("groupSize"in flags)){flags.groupSize=3;}
var signRE=dojo.regexp.buildGroupRE(flags.signed,function(q){return q?"[-+]":"";},true);var numberRE=dojo.regexp.buildGroupRE(flags.separator,function(sep){if(!sep){return"(?:\\d+)";}
sep=dojo.regexp.escapeString(sep);if(sep==" "){sep="\\s";}
else if(sep=="\xa0"){sep="\\s\\xa0";}
var grp=flags.groupSize,grp2=flags.groupSize2;if(grp2){var grp2RE="(?:0|[1-9]\\d{0,"+(grp2-1)+"}(?:["+sep+"]\\d{"+grp2+"})*["+sep+"]\\d{"+grp+"})";return((grp-grp2)>0)?"(?:"+grp2RE+"|(?:0|[1-9]\\d{0,"+(grp-1)+"}))":grp2RE;}
return"(?:0|[1-9]\\d{0,"+(grp-1)+"}(?:["+sep+"]\\d{"+grp+"})*)";},true);return signRE+numberRE;}}
if(!dojo._hasResource["dojox.charting.plot2d.Pie"]){dojo._hasResource["dojox.charting.plot2d.Pie"]=true;dojo.provide("dojox.charting.plot2d.Pie");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,da=dojox.charting.axis2d.common,g=dojox.gfx,m=g.matrix,FUDGE_FACTOR=0.2;dojo.declare("dojox.charting.plot2d.Pie",[dojox.charting.Element,dojox.charting.plot2d._PlotEvents],{defaultParams:{labels:true,ticks:false,fixed:true,precision:1,labelOffset:20,labelStyle:"default",htmlLabels:true,radGrad:"native",fanSize:5,startAngle:0},optionalParams:{radius:0,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);du.updateWithPattern(this.opt,kwArgs,this.optionalParams);this.run=null;this.dyn=[];},clear:function(){this.dirty=true;this.dyn=[];this.run=null;return this;},setAxis:function(axis){return this;},addSeries:function(run){this.run=run;return this;},getSeriesStats:function(){return dojo.delegate(dc.defaultStats);},initializeScalers:function(){return this;},getRequiredColors:function(){return this.run?this.run.data.length:0;},render:function(dim,offsets){if(!this.dirty){return this;}
this.resetEvents();this.dirty=false;this._eventSeries={};this.cleanGroup();var s=this.group,t=this.chart.theme;if(!this.run||!this.run.data.length){return this;}
var rx=(dim.width-offsets.l-offsets.r)/2,ry=(dim.height-offsets.t-offsets.b)/2,r=Math.min(rx,ry),taFont="font"in this.opt?this.opt.font:t.axis.font,size=taFont?g.normalizedLength(g.splitFontString(taFont).size):0,taFontColor="fontColor"in this.opt?this.opt.fontColor:t.axis.fontColor,startAngle=m._degToRad(this.opt.startAngle),start=startAngle,step,filteredRun,slices,labels,shift,labelR,run=this.run.data,events=this.events();if(typeof run[0]=="number"){filteredRun=df.map(run,"x ? Math.max(x, 0) : 0");if(df.every(filteredRun,"<= 0")){return this;}
slices=df.map(filteredRun,"/this",df.foldl(filteredRun,"+",0));if(this.opt.labels){labels=dojo.map(slices,function(x){return x>0?this._getLabel(x*100)+"%":"";},this);}}else{filteredRun=df.map(run,"x ? Math.max(x.y, 0) : 0");if(df.every(filteredRun,"<= 0")){return this;}
slices=df.map(filteredRun,"/this",df.foldl(filteredRun,"+",0));if(this.opt.labels){labels=dojo.map(slices,function(x,i){if(x<=0){return"";}
var v=run[i];return"text"in v?v.text:this._getLabel(x*100)+"%";},this);}}
var themes=df.map(run,function(v,i){if(v===null||typeof v=="number"){return t.next("slice",[this.opt,this.run],true);}
return t.next("slice",[this.opt,this.run,v],true);},this);if(this.opt.labels){shift=df.foldl1(df.map(labels,function(label,i){var font=themes[i].series.font;return dojox.gfx._base._getTextBox(label,{font:font}).w;},this),"Math.max(a, b)")/2;if(this.opt.labelOffset<0){r=Math.min(rx-2*shift,ry-size)+this.opt.labelOffset;}
labelR=r-this.opt.labelOffset;}
if("radius"in this.opt){r=this.opt.radius;labelR=r-this.opt.labelOffset;}
var circle={cx:offsets.l+rx,cy:offsets.t+ry,r:r};this.dyn=[];var eventSeries=new Array(slices.length);dojo.some(slices,function(slice,i){if(slice<=0){return false;}
var v=run[i],theme=themes[i],specialFill;if(slice>=1){specialFill=this._plotFill(theme.series.fill,dim,offsets);specialFill=this._shapeFill(specialFill,{x:circle.cx-circle.r,y:circle.cy-circle.r,width:2*circle.r,height:2*circle.r});specialFill=this._pseudoRadialFill(specialFill,{x:circle.cx,y:circle.cy},circle.r);var shape=s.createCircle(circle).setFill(specialFill).setStroke(theme.series.stroke);this.dyn.push({fill:specialFill,stroke:theme.series.stroke});if(events){var o={element:"slice",index:i,run:this.run,shape:shape,x:i,y:typeof v=="number"?v:v.y,cx:circle.cx,cy:circle.cy,cr:r};this._connectEvents(o);eventSeries[i]=o;}
return true;}
var end=start+slice*2*Math.PI;if(i+1==slices.length){end=startAngle+2*Math.PI;}
var step=end-start,x1=circle.cx+r*Math.cos(start),y1=circle.cy+r*Math.sin(start),x2=circle.cx+r*Math.cos(end),y2=circle.cy+r*Math.sin(end);var fanSize=m._degToRad(this.opt.fanSize);if(theme.series.fill&&theme.series.fill.type==="radial"&&this.opt.radGrad==="fan"&&step>fanSize){var group=s.createGroup(),nfans=Math.ceil(step/fanSize),delta=step/nfans;specialFill=this._shapeFill(theme.series.fill,{x:circle.cx-circle.r,y:circle.cy-circle.r,width:2*circle.r,height:2*circle.r});for(var j=0;j<nfans;++j){var fansx=j==0?x1:circle.cx+r*Math.cos(start+(j-FUDGE_FACTOR)*delta),fansy=j==0?y1:circle.cy+r*Math.sin(start+(j-FUDGE_FACTOR)*delta),fanex=j==nfans-1?x2:circle.cx+r*Math.cos(start+(j+1+FUDGE_FACTOR)*delta),faney=j==nfans-1?y2:circle.cy+r*Math.sin(start+(j+1+FUDGE_FACTOR)*delta),fan=group.createPath({}).moveTo(circle.cx,circle.cy).lineTo(fansx,fansy).arcTo(r,r,0,delta>Math.PI,true,fanex,faney).lineTo(circle.cx,circle.cy).closePath().setFill(this._pseudoRadialFill(specialFill,{x:circle.cx,y:circle.cy},r,start+(j+0.5)*delta,start+(j+0.5)*delta));}
group.createPath({}).moveTo(circle.cx,circle.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(circle.cx,circle.cy).closePath().setStroke(theme.series.stroke);shape=group;}else{shape=s.createPath({}).moveTo(circle.cx,circle.cy).lineTo(x1,y1).arcTo(r,r,0,step>Math.PI,true,x2,y2).lineTo(circle.cx,circle.cy).closePath().setStroke(theme.series.stroke);var specialFill=theme.series.fill;if(specialFill&&specialFill.type==="radial"){specialFill=this._shapeFill(specialFill,{x:circle.cx-circle.r,y:circle.cy-circle.r,width:2*circle.r,height:2*circle.r});if(this.opt.radGrad==="linear"){specialFill=this._pseudoRadialFill(specialFill,{x:circle.cx,y:circle.cy},r,start,end);}}else if(specialFill&&specialFill.type==="linear"){specialFill=this._plotFill(specialFill,dim,offsets);specialFill=this._shapeFill(specialFill,shape.getBoundingBox());}
shape.setFill(specialFill);}
this.dyn.push({fill:specialFill,stroke:theme.series.stroke});if(events){var o={element:"slice",index:i,run:this.run,shape:shape,x:i,y:typeof v=="number"?v:v.y,cx:circle.cx,cy:circle.cy,cr:r};this._connectEvents(o);eventSeries[i]=o;}
start=end;return false;},this);if(this.opt.labels){start=startAngle;dojo.some(slices,function(slice,i){if(slice<=0){return false;}
var theme=themes[i];if(slice>=1){var v=run[i],elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"](this.chart,s,circle.cx,circle.cy+size/2,"middle",labels[i],theme.series.font,theme.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(elem);}
return true;}
var end=start+slice*2*Math.PI,v=run[i];if(i+1==slices.length){end=startAngle+2*Math.PI;}
var labelAngle=(start+end)/2,x=circle.cx+labelR*Math.cos(labelAngle),y=circle.cy+labelR*Math.sin(labelAngle)+size/2;var elem=da.createText[this.opt.htmlLabels&&dojox.gfx.renderer!="vml"?"html":"gfx"]
(this.chart,s,x,y,"middle",labels[i],theme.series.font,theme.series.fontColor);if(this.opt.htmlLabels){this.htmlElements.push(elem);}
start=end;return false;},this);}
var esi=0;this._eventSeries[this.run.name]=df.map(run,function(v){return v<=0?null:eventSeries[esi++];});return this;},_getLabel:function(number){return this.opt.fixed?dojo.number.format(number,{places:this.opt.precision}):number.toString();}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.Bubble"]){dojo._hasResource["dojox.charting.plot2d.Bubble"]=true;dojo.provide("dojox.charting.plot2d.Bubble");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Bubble",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",animate:null},optionalParams:{stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),events=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();if(!run.data.length){run.dirty=false;t.skip();continue;}
if(typeof run.data[0]=="number"){console.warn("dojox.charting.plot2d.Bubble: the data in the following series cannot be rendered as a bubble chart; ",run);continue;}
var theme=t.next("circle",[this.opt,run]),s=run.group,points=dojo.map(run.data,function(v,i){return v?{x:ht(v.x)+offsets.l,y:dim.height-offsets.b-vt(v.y),radius:this._vScaler.bounds.scale*(v.size/2)}:null;},this);var frontCircles=null,outlineCircles=null,shadowCircles=null;if(theme.series.shadow){shadowCircles=dojo.map(points,function(item){if(item!==null){var finalTheme=t.addMixin(theme,"circle",item,true),shadow=finalTheme.series.shadow;var shape=s.createCircle({cx:item.x+shadow.dx,cy:item.y+shadow.dy,r:item.radius}).setStroke(shadow).setFill(shadow.color);if(this.animate){this._animateBubble(shape,dim.height-offsets.b,item.radius);}
return shape;}
return null;},this);if(shadowCircles.length){run.dyn.shadow=shadowCircles[shadowCircles.length-1].getStroke();}}
if(theme.series.outline){outlineCircles=dojo.map(points,function(item){if(item!==null){var finalTheme=t.addMixin(theme,"circle",item,true),outline=dc.makeStroke(finalTheme.series.outline);outline.width=2*outline.width+theme.series.stroke.width;var shape=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setStroke(outline);if(this.animate){this._animateBubble(shape,dim.height-offsets.b,item.radius);}
return shape;}
return null;},this);if(outlineCircles.length){run.dyn.outline=outlineCircles[outlineCircles.length-1].getStroke();}}
frontCircles=dojo.map(points,function(item){if(item!==null){var finalTheme=t.addMixin(theme,"circle",item,true),rect={x:item.x-item.radius,y:item.y-item.radius,width:2*item.radius,height:2*item.radius};var specialFill=this._plotFill(finalTheme.series.fill,dim,offsets);specialFill=this._shapeFill(specialFill,rect);var shape=s.createCircle({cx:item.x,cy:item.y,r:item.radius}).setFill(specialFill).setStroke(finalTheme.series.stroke);if(this.animate){this._animateBubble(shape,dim.height-offsets.b,item.radius);}
return shape;}
return null;},this);if(frontCircles.length){run.dyn.fill=frontCircles[frontCircles.length-1].getFill();run.dyn.stroke=frontCircles[frontCircles.length-1].getStroke();}
if(events){var eventSeries=new Array(frontCircles.length);dojo.forEach(frontCircles,function(s,i){if(s!==null){var o={element:"circle",index:i,run:run,shape:s,outline:outlineCircles&&outlineCircles[i]||null,shadow:shadowCircles&&shadowCircles[i]||null,x:run.data[i].x,y:run.data[i].y,r:run.data[i].size/2,cx:points[i].x,cy:points[i].y,cr:points[i].radius};this._connectEvents(o);eventSeries[i]=o;}},this);this._eventSeries[run.name]=eventSeries;}else{delete this._eventSeries[run.name];}
run.dirty=false;}
this.dirty=false;return this;},_animateBubble:function(shape,offset,size){dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,offset],end:[0,0]},{name:"scale",start:[0,1/size],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.Candlesticks"]){dojo._hasResource["dojox.charting.plot2d.Candlesticks"]=true;dojo.provide("dojox.charting.plot2d.Candlesticks");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Candlesticks",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);du.updateWithPattern(this.opt,kwArgs,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(series){var stats=dojo.delegate(dc.defaultStats);for(var i=0;i<series.length;i++){var run=series[i];if(!run.data.length){continue;}
var old_vmin=stats.vmin,old_vmax=stats.vmax;if(!("ymin"in run)||!("ymax"in run)){dojo.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;stats.hmin=Math.min(stats.hmin,x);stats.hmax=Math.max(stats.hmax,x);stats.vmin=Math.min(stats.vmin,val.open,val.close,val.high,val.low);stats.vmax=Math.max(stats.vmax,val.open,val.close,val.high,val.low);}});}
if("ymin"in run){stats.vmin=Math.min(old_vmin,run.ymin);}
if("ymax"in run){stats.vmax=Math.max(old_vmax,run.ymax);}}
return stats;},getSeriesStats:function(){var stats=this.collectStats(this.series);stats.hmin-=0.5;stats.hmax+=0.5;return stats;},render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,f,gap,width,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),baseline=Math.max(0,this._vScaler.bounds.lower),baselineHeight=vt(baseline),events=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;width=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next("candlestick",[this.opt,run]),s=run.group,eventSeries=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var finalTheme=t.addMixin(theme,"candlestick",v,true);var x=ht(v.x||(j+0.5))+offsets.l+gap,y=dim.height-offsets.b,open=vt(v.open),close=vt(v.close),high=vt(v.high),low=vt(v.low);if("mid"in v){var mid=vt(v.mid);}
if(low>high){var tmp=high;high=low;low=tmp;}
if(width>=1){var doFill=open>close;var line={x1:width/2,x2:width/2,y1:y-high,y2:y-low},rect={x:0,y:y-Math.max(open,close),width:width,height:Math.max(doFill?open-close:close-open,1)};shape=s.createGroup();shape.setTransform({dx:x,dy:0});var inner=shape.createGroup();inner.createLine(line).setStroke(finalTheme.series.stroke);inner.createRect(rect).setStroke(finalTheme.series.stroke).setFill(doFill?finalTheme.series.fill:"white");if("mid"in v){inner.createLine({x1:(finalTheme.series.stroke.width||1),x2:width-(finalTheme.series.stroke.width||1),y1:y-mid,y2:y-mid}).setStroke(doFill?"white":finalTheme.series.stroke);}
run.dyn.fill=finalTheme.series.fill;run.dyn.stroke=finalTheme.series.stroke;if(events){var o={element:"candlestick",index:j,run:run,shape:inner,x:x,y:y-Math.max(open,close),cx:width/2,cy:(y-Math.max(open,close))+(Math.max(doFill?open-close:close-open,1)/2),width:width,height:Math.max(doFill?open-close:close-open,1),data:v};this._connectEvents(o);eventSeries[j]=o;}}
if(this.animate){this._animateCandlesticks(shape,y-low,high-low);}}}
this._eventSeries[run.name]=eventSeries;run.dirty=false;}
this.dirty=false;return this;},_animateCandlesticks:function(shape,voffset,vsize){dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,voffset-(voffset/vsize)],end:[0,0]},{name:"scale",start:[1,1/vsize],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}
if(!dojo._hasResource["dojox.charting.plot2d.OHLC"]){dojo._hasResource["dojox.charting.plot2d.OHLC"]=true;dojo.provide("dojox.charting.plot2d.OHLC");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.OHLC",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:2,animate:null},optionalParams:{minBarSize:1,maxBarSize:1,stroke:{},outline:{},shadow:{},fill:{},font:"",fontColor:""},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);du.updateWithPattern(this.opt,kwArgs,this.optionalParams);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.animate=this.opt.animate;},collectStats:function(series){var stats=dojo.delegate(dc.defaultStats);for(var i=0;i<series.length;i++){var run=series[i];if(!run.data.length){continue;}
var old_vmin=stats.vmin,old_vmax=stats.vmax;if(!("ymin"in run)||!("ymax"in run)){dojo.forEach(run.data,function(val,idx){if(val!==null){var x=val.x||idx+1;stats.hmin=Math.min(stats.hmin,x);stats.hmax=Math.max(stats.hmax,x);stats.vmin=Math.min(stats.vmin,val.open,val.close,val.high,val.low);stats.vmax=Math.max(stats.vmax,val.open,val.close,val.high,val.low);}});}
if("ymin"in run){stats.vmin=Math.min(old_vmin,run.ymin);}
if("ymax"in run){stats.vmax=Math.max(old_vmax,run.ymax);}}
return stats;},getSeriesStats:function(){var stats=this.collectStats(this.series);stats.hmin-=0.5;stats.hmax+=0.5;return stats;},render:function(dim,offsets){if(this.zoom&&!this.isDataDirty()){return this.performZoom(dim,offsets);}
this.resetEvents();this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this._eventSeries={};this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,f,gap,width,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),baseline=Math.max(0,this._vScaler.bounds.lower),baselineHeight=vt(baseline),events=this.events();f=dc.calculateBarSize(this._hScaler.bounds.scale,this.opt);gap=f.gap;width=f.size;for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){t.skip();this._reconnectEvents(run.name);continue;}
run.cleanGroup();var theme=t.next("candlestick",[this.opt,run]),s=run.group,eventSeries=new Array(run.data.length);for(var j=0;j<run.data.length;++j){var v=run.data[j];if(v!==null){var finalTheme=t.addMixin(theme,"candlestick",v,true);var x=ht(v.x||(j+0.5))+offsets.l+gap,y=dim.height-offsets.b,open=vt(v.open),close=vt(v.close),high=vt(v.high),low=vt(v.low);if(low>high){var tmp=high;high=low;low=tmp;}
if(width>=1){var hl={x1:width/2,x2:width/2,y1:y-high,y2:y-low},op={x1:0,x2:((width/2)+((finalTheme.series.stroke.width||1)/2)),y1:y-open,y2:y-open},cl={x1:((width/2)-((finalTheme.series.stroke.width||1)/2)),x2:width,y1:y-close,y2:y-close};shape=s.createGroup();shape.setTransform({dx:x,dy:0});var inner=shape.createGroup();inner.createLine(hl).setStroke(finalTheme.series.stroke);inner.createLine(op).setStroke(finalTheme.series.stroke);inner.createLine(cl).setStroke(finalTheme.series.stroke);run.dyn.stroke=finalTheme.series.stroke;if(events){var o={element:"candlestick",index:j,run:run,shape:inner,x:x,y:y-Math.max(open,close),cx:width/2,cy:(y-Math.max(open,close))+(Math.max(open>close?open-close:close-open,1)/2),width:width,height:Math.max(open>close?open-close:close-open,1),data:v};this._connectEvents(o);eventSeries[j]=o;}}
if(this.animate){this._animateOHLC(shape,y-low,high-low);}}}
this._eventSeries[run.name]=eventSeries;run.dirty=false;}
this.dirty=false;return this;},_animateOHLC:function(shape,voffset,vsize){dojox.gfx.fx.animateTransform(dojo.delegate({shape:shape,duration:1200,transform:[{name:"translate",start:[0,voffset-(voffset/vsize)],end:[0,0]},{name:"scale",start:[1,1/vsize],end:[1,1]},{name:"original"}]},this.animate)).play();}});})();}
if(!dojo._hasResource["dojox.charting.Chart2D"]){dojo._hasResource["dojox.charting.Chart2D"]=true;dojo.provide("dojox.charting.Chart2D");(function(){var df=dojox.lang.functional,dc=dojox.charting,clear=df.lambda("item.clear()"),purge=df.lambda("item.purgeGroup()"),destroy=df.lambda("item.destroy()"),makeClean=df.lambda("item.dirty = false"),makeDirty=df.lambda("item.dirty = true"),getName=df.lambda("item.name");dojo.declare("dojox.charting.Chart2D",null,{constructor:function(node,kwArgs){if(!kwArgs){kwArgs={};}
this.margins=kwArgs.margins?kwArgs.margins:{l:10,t:10,r:10,b:10};this.stroke=kwArgs.stroke;this.fill=kwArgs.fill;this.delayInMs=kwArgs.delayInMs||200;this.yTitleOffset=kwArgs.yTitleOffset?kwArgs.yTitleOffset:45;this.theme=null;this.axes={};this.stack=[];this.plots={};this.series=[];this.runs={};this.dirty=true;this.coords=null;this.node=dojo.byId(node);var box=dojo.marginBox(node);this.surface=dojox.gfx.createSurface(this.node,box.w||400,box.h||300);},destroy:function(){dojo.forEach(this.series,destroy);dojo.forEach(this.stack,destroy);df.forIn(this.axes,destroy);this.surface.destroy();},getCoords:function(){if(!this.coords){this.coords=dojo.coords(this.node,true);}
return this.coords;},setTheme:function(theme){this.theme=theme.clone();this.dirty=true;return this;},addAxis:function(name,kwArgs){var axis;if(!kwArgs||!("type"in kwArgs)){axis=new dc.axis2d.Default(this,kwArgs);}else{axis=typeof kwArgs.type=="string"?new dc.axis2d[kwArgs.type](this,kwArgs):new kwArgs.type(this,kwArgs);}
axis.name=name;axis.dirty=true;if(name in this.axes){this.axes[name].destroy();}
this.axes[name]=axis;this.dirty=true;return this;},getAxis:function(name){return this.axes[name];},removeAxis:function(name){if(name in this.axes){this.axes[name].destroy();delete this.axes[name];this.dirty=true;}
return this;},addPlot:function(name,kwArgs){var plot;if(!kwArgs||!("type"in kwArgs)){plot=new dc.plot2d.Default(this,kwArgs);}else{plot=typeof kwArgs.type=="string"?new dc.plot2d[kwArgs.type](this,kwArgs):new kwArgs.type(this,kwArgs);}
plot.name=name;plot.dirty=true;if(name in this.plots){this.stack[this.plots[name]].destroy();this.stack[this.plots[name]]=plot;}else{this.plots[name]=this.stack.length;this.stack.push(plot);}
this.dirty=true;return this;},removePlot:function(name){if(name in this.plots){var index=this.plots[name];delete this.plots[name];this.stack[index].destroy();this.stack.splice(index,1);df.forIn(this.plots,function(idx,name,plots){if(idx>index){plots[name]=idx-1;}});this.dirty=true;}
return this;},getPlotOrder:function(){return df.map(this.stack,getName);},setPlotOrder:function(newOrder){var names={},order=df.filter(newOrder,function(name){if(!(name in this.plots)||(name in names)){return false;}
names[name]=1;return true;},this);if(order.length<this.stack.length){df.forEach(this.stack,function(plot){var name=plot.name;if(!(name in names)){order.push(name);}});}
var newStack=df.map(order,function(name){return this.stack[this.plots[name]];},this);df.forEach(newStack,function(plot,i){this.plots[plot.name]=i;},this);this.stack=newStack;this.dirty=true;return this;},movePlotToFront:function(name){if(name in this.plots){var index=this.plots[name];if(index){var newOrder=this.getPlotOrder();newOrder.splice(index,1);newOrder.unshift(name);return this.setPlotOrder(newOrder);}}
return this;},movePlotToBack:function(name){if(name in this.plots){var index=this.plots[name];if(index<this.stack.length-1){var newOrder=this.getPlotOrder();newOrder.splice(index,1);newOrder.push(name);return this.setPlotOrder(newOrder);}}
return this;},addSeries:function(name,data,kwArgs){var run=new dc.Series(this,data,kwArgs);run.name=name;if(name in this.runs){this.series[this.runs[name]].destroy();this.series[this.runs[name]]=run;}else{this.runs[name]=this.series.length;this.series.push(run);}
this.dirty=true;if(!("ymin"in run)&&"min"in run){run.ymin=run.min;}
if(!("ymax"in run)&&"max"in run){run.ymax=run.max;}
return this;},removeSeries:function(name){if(name in this.runs){var index=this.runs[name],plotName=this.series[index].plot;delete this.runs[name];this.series[index].destroy();this.series.splice(index,1);df.forIn(this.runs,function(idx,name,runs){if(idx>index){runs[name]=idx-1;}});this.dirty=true;}
return this;},updateSeries:function(name,data){if(name in this.runs){var run=this.series[this.runs[name]];run.update(data);this._invalidateDependentPlots(run.plot,false);this._invalidateDependentPlots(run.plot,true);}
return this;},getSeriesOrder:function(plotName){return df.map(df.filter(this.series,function(run){return run.plot==plotName;}),getName);},setSeriesOrder:function(newOrder){var plotName,names={},order=df.filter(newOrder,function(name){if(!(name in this.runs)||(name in names)){return false;}
var run=this.series[this.runs[name]];if(plotName){if(run.plot!=plotName){return false;}}else{plotName=run.plot;}
names[name]=1;return true;},this);df.forEach(this.series,function(run){var name=run.name;if(!(name in names)&&run.plot==plotName){order.push(name);}});var newSeries=df.map(order,function(name){return this.series[this.runs[name]];},this);this.series=newSeries.concat(df.filter(this.series,function(run){return run.plot!=plotName;}));df.forEach(this.series,function(run,i){this.runs[run.name]=i;},this);this.dirty=true;return this;},moveSeriesToFront:function(name){if(name in this.runs){var index=this.runs[name],newOrder=this.getSeriesOrder(this.series[index].plot);if(name!=newOrder[0]){newOrder.splice(index,1);newOrder.unshift(name);return this.setSeriesOrder(newOrder);}}
return this;},moveSeriesToBack:function(name){if(name in this.runs){var index=this.runs[name],newOrder=this.getSeriesOrder(this.series[index].plot);if(name!=newOrder[newOrder.length-1]){newOrder.splice(index,1);newOrder.push(name);return this.setSeriesOrder(newOrder);}}
return this;},resize:function(width,height){var box;switch(arguments.length){case 0:box=dojo.marginBox(this.node);break;case 1:box=width;break;default:box={w:width,h:height};break;}
dojo.marginBox(this.node,box);this.surface.setDimensions(box.w,box.h);this.dirty=true;this.coords=null;return this.render();},getGeometry:function(){var ret={};df.forIn(this.axes,function(axis){if(axis.initialized()){ret[axis.name]={name:axis.name,vertical:axis.vertical,scaler:axis.scaler,ticks:axis.ticks};}});return ret;},setAxisWindow:function(name,scale,offset,zoom){var axis=this.axes[name];if(axis){axis.setWindow(scale,offset);dojo.forEach(this.stack,function(plot){if(plot.hAxis==name||plot.vAxis==name){plot.zoom=zoom;}})}
return this;},setWindow:function(sx,sy,dx,dy,zoom){if(!("plotArea"in this)){this.calculateGeometry();}
df.forIn(this.axes,function(axis){var scale,offset,bounds=axis.getScaler().bounds,s=bounds.span/(bounds.upper-bounds.lower);if(axis.vertical){scale=sy;offset=dy/s/scale;}else{scale=sx;offset=dx/s/scale;}
axis.setWindow(scale,offset);});dojo.forEach(this.stack,function(plot){plot.zoom=zoom;});return this;},zoomIn:function(name,range){var axis=this.axes[name];if(axis){var scale,offset,bounds=axis.getScaler().bounds;var lower=Math.min(range[0],range[1]);var upper=Math.max(range[0],range[1]);lower=range[0]<bounds.lower?bounds.lower:lower;upper=range[1]>bounds.upper?bounds.upper:upper;scale=(bounds.upper-bounds.lower)/(upper-lower);offset=lower-bounds.lower;this.setAxisWindow(name,scale,offset);this.render();}},calculateGeometry:function(){if(this.dirty){return this.fullGeometry();}
var dirty=dojo.filter(this.stack,function(plot){return plot.dirty||(plot.hAxis&&this.axes[plot.hAxis].dirty)||(plot.vAxis&&this.axes[plot.vAxis].dirty);},this);calculateAxes(dirty,this.plotArea);return this;},fullGeometry:function(){this._makeDirty();dojo.forEach(this.stack,clear);if(!this.theme){this.setTheme(new dojox.charting.Theme(dojox.charting._def));}
dojo.forEach(this.series,function(run){if(!(run.plot in this.plots)){var plot=new dc.plot2d.Default(this,{});plot.name=run.plot;this.plots[run.plot]=this.stack.length;this.stack.push(plot);}
this.stack[this.plots[run.plot]].addSeries(run);},this);dojo.forEach(this.stack,function(plot){if(plot.hAxis){plot.setAxis(this.axes[plot.hAxis]);}
if(plot.vAxis){plot.setAxis(this.axes[plot.vAxis]);}},this);var dim=this.dim=this.surface.getDimensions();dim.width=dojox.gfx.normalizedLength(dim.width);dim.height=dojox.gfx.normalizedLength(dim.height);df.forIn(this.axes,clear);calculateAxes(this.stack,dim);var offsets=this.offsets={l:0,r:0,t:0,b:0};df.forIn(this.axes,function(axis){df.forIn(axis.getOffsets(),function(o,i){offsets[i]+=o;});});df.forIn(this.margins,function(o,i){offsets[i]+=o;});if(offsets.l>150){offsets.l=150};this.plotArea={width:dim.width-offsets.l-offsets.r,height:dim.height-offsets.t-offsets.b};df.forIn(this.axes,clear);calculateAxes(this.stack,this.plotArea);return this;},render:function(){if(this.theme){this.theme.clear();}
if(this.dirty){return this.fullRender();}
this.calculateGeometry();df.forEachRev(this.stack,function(plot){plot.render(this.dim,this.offsets);},this);df.forIn(this.axes,function(axis){axis.render(this.dim,this.offsets);},this);this._makeClean();if(this.surface.render){this.surface.render();};return this;},fullRender:function(){this.fullGeometry();var offsets=this.offsets,dim=this.dim;dojo.forEach(this.series,purge);df.forIn(this.axes,purge);dojo.forEach(this.stack,purge);this.surface.clear();var t=this.theme,fill=t.plotarea&&t.plotarea.fill,stroke=t.plotarea&&t.plotarea.stroke;if(fill){this.surface.createRect({x:offsets.l-1,y:offsets.t-1,width:dim.width-offsets.l-offsets.r+2,height:dim.height-offsets.t-offsets.b+2}).setFill(fill);}
if(stroke){this.surface.createRect({x:offsets.l,y:offsets.t,width:dim.width-offsets.l-offsets.r+1,height:dim.height-offsets.t-offsets.b+1}).setStroke(stroke);}
df.foldr(this.stack,function(z,plot){return plot.render(dim,offsets),0;},0);fill=this.fill!==undefined?this.fill:(t.chart&&t.chart.fill);stroke=this.stroke!==undefined?this.stroke:(t.chart&&t.chart.stroke);if(fill=="inherit"){var node=this.node,fill=new dojo.Color(dojo.style(node,"backgroundColor"));while(fill.a==0&&node!=document.documentElement){fill=new dojo.Color(dojo.style(node,"backgroundColor"));node=node.parentNode;}}
if(fill){if(offsets.l){this.surface.createRect({width:offsets.l,height:dim.height+1}).setFill(fill);}
if(offsets.r){this.surface.createRect({x:dim.width-offsets.r,width:offsets.r+1,height:dim.height+2}).setFill(fill);}
if(offsets.t){this.surface.createRect({width:dim.width+1,height:offsets.t}).setFill(fill);}
if(offsets.b){this.surface.createRect({y:dim.height-offsets.b,width:dim.width+1,height:offsets.b+2}).setFill(fill);}}
if(stroke){this.surface.createRect({width:dim.width-1,height:dim.height-1}).setStroke(stroke);}
df.forIn(this.axes,function(axis){axis.render(dim,offsets);});var axes=this.axes,theme_tick=this.theme.axis.tick,theme_font=theme_tick.font,theme_font_color=theme_tick.fontColor,dim=this.dim,offsets=this.offsets,x_middle=(dim.width/2)+(offsets.l/2),y_middle=(dim.height/2)-(offsets.b/2),m=dojox.gfx.matrix;for(var i in axes){var axis=axes[i];if(axis.opt.title){var x,y,rotate=0;if(axis.vertical){rotate=270;y=y_middle;x=this.yTitleOffset;}else{x=x_middle;y=dim.height-2;}
var elem=axis.group.createText({x:x_middle,y:y_middle,text:axis.opt.title,align:'middle'});var origTitleFont=axis.opt.font||theme_font;var fontParts=origTitleFont.split(' ');var newTitleFont=fontParts[0]+' '+fontParts[1]+' bold '+fontParts[3]+' '+fontParts[4];elem.setFont(newTitleFont).setFill(axis.opt.fontColor||theme_font_color)
if(rotate){elem.setTransform([m.rotategAt(rotate,x_middle,y_middle),m.translate(0,offsets.l-(x_middle+x))]);}else{elem.setTransform(m.translate(0,y-y_middle-3))}}};var xLoc=dim.width+5-offsets.r;var yLoc=y_middle-25;var elemAttribution=this.surface.createText({x:xLoc,y:yLoc,text:"sofastatistics.com",align:'middle'});elemAttribution.setFont("normal normal normal 10px Arial").setFill(theme_font_color)
elemAttribution.setTransform([m.rotategAt(90,xLoc,yLoc)]);this._makeClean();if(this.surface.render){this.surface.render();};return this;},delayedRender:function(){if(!this._delayedRenderHandle){this._delayedRenderHandle=setTimeout(dojo.hitch(this,function(){clearTimeout(this._delayedRenderHandle);this._delayedRenderHandle=null;this.render();}),this.delayInMs);}
return this;},connectToPlot:function(name,object,method){return name in this.plots?this.stack[this.plots[name]].connect(object,method):null;},fireEvent:function(seriesName,eventName,index){if(seriesName in this.runs){var plotName=this.series[this.runs[seriesName]].plot;if(plotName in this.plots){var plot=this.stack[this.plots[plotName]];if(plot){plot.fireEvent(seriesName,eventName,index);}}}
return this;},_makeClean:function(){dojo.forEach(this.axes,makeClean);dojo.forEach(this.stack,makeClean);dojo.forEach(this.series,makeClean);this.dirty=false;},_makeDirty:function(){dojo.forEach(this.axes,makeDirty);dojo.forEach(this.stack,makeDirty);dojo.forEach(this.series,makeDirty);this.dirty=true;},_invalidateDependentPlots:function(plotName,verticalAxis){if(plotName in this.plots){var plot=this.stack[this.plots[plotName]],axis,axisName=verticalAxis?"vAxis":"hAxis";if(plot[axisName]){axis=this.axes[plot[axisName]];if(axis&&axis.dependOnData()){axis.dirty=true;dojo.forEach(this.stack,function(p){if(p[axisName]&&p[axisName]==plot[axisName]){p.dirty=true;}});}}else{plot.dirty=true;}}}});function hSection(stats){return{min:stats.hmin,max:stats.hmax};}
function vSection(stats){return{min:stats.vmin,max:stats.vmax};}
function hReplace(stats,h){stats.hmin=h.min;stats.hmax=h.max;}
function vReplace(stats,v){stats.vmin=v.min;stats.vmax=v.max;}
function combineStats(target,source){if(target&&source){target.min=Math.min(target.min,source.min);target.max=Math.max(target.max,source.max);}
return target||source;}
function calculateAxes(stack,plotArea){var plots={},axes={};dojo.forEach(stack,function(plot){var stats=plots[plot.name]=plot.getSeriesStats();if(plot.hAxis){axes[plot.hAxis]=combineStats(axes[plot.hAxis],hSection(stats));}
if(plot.vAxis){axes[plot.vAxis]=combineStats(axes[plot.vAxis],vSection(stats));}});dojo.forEach(stack,function(plot){var stats=plots[plot.name];if(plot.hAxis){hReplace(stats,axes[plot.hAxis]);}
if(plot.vAxis){vReplace(stats,axes[plot.vAxis]);}
plot.initializeScalers(plotArea,stats);});}})();}
if(!dojo._hasResource["dojo.fx.easing"]){dojo._hasResource["dojo.fx.easing"]=true;dojo.provide("dojo.fx.easing");dojo.fx.easing={linear:function(n){return n;},quadIn:function(n){return Math.pow(n,2);},quadOut:function(n){return n*(n-2)*-1;},quadInOut:function(n){n=n*2;if(n<1){return Math.pow(n,2)/2;}
return-1*((--n)*(n-2)-1)/2;},cubicIn:function(n){return Math.pow(n,3);},cubicOut:function(n){return Math.pow(n-1,3)+1;},cubicInOut:function(n){n=n*2;if(n<1){return Math.pow(n,3)/2;}
n-=2;return(Math.pow(n,3)+2)/2;},quartIn:function(n){return Math.pow(n,4);},quartOut:function(n){return-1*(Math.pow(n-1,4)-1);},quartInOut:function(n){n=n*2;if(n<1){return Math.pow(n,4)/2;}
n-=2;return-1/2*(Math.pow(n,4)-2);},quintIn:function(n){return Math.pow(n,5);},quintOut:function(n){return Math.pow(n-1,5)+1;},quintInOut:function(n){n=n*2;if(n<1){return Math.pow(n,5)/2;};n-=2;return(Math.pow(n,5)+2)/2;},sineIn:function(n){return-1*Math.cos(n*(Math.PI/2))+1;},sineOut:function(n){return Math.sin(n*(Math.PI/2));},sineInOut:function(n){return-1*(Math.cos(Math.PI*n)-1)/2;},expoIn:function(n){return(n==0)?0:Math.pow(2,10*(n-1));},expoOut:function(n){return(n==1)?1:(-1*Math.pow(2,-10*n)+1);},expoInOut:function(n){if(n==0){return 0;}
if(n==1){return 1;}
n=n*2;if(n<1){return Math.pow(2,10*(n-1))/2;}
--n;return(-1*Math.pow(2,-10*n)+2)/2;},circIn:function(n){return-1*(Math.sqrt(1-Math.pow(n,2))-1);},circOut:function(n){n=n-1;return Math.sqrt(1-Math.pow(n,2));},circInOut:function(n){n=n*2;if(n<1){return-1/2*(Math.sqrt(1-Math.pow(n,2))-1);}
n-=2;return 1/2*(Math.sqrt(1-Math.pow(n,2))+1);},backIn:function(n){var s=1.70158;return Math.pow(n,2)*((s+1)*n-s);},backOut:function(n){n=n-1;var s=1.70158;return Math.pow(n,2)*((s+1)*n+s)+1;},backInOut:function(n){var s=1.70158*1.525;n=n*2;if(n<1){return(Math.pow(n,2)*((s+1)*n-s))/2;}
n-=2;return(Math.pow(n,2)*((s+1)*n+s)+2)/2;},elasticIn:function(n){if(n==0||n==1){return n;}
var p=.3;var s=p/4;n=n-1;return-1*Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p);},elasticOut:function(n){if(n==0||n==1){return n;}
var p=.3;var s=p/4;return Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p)+1;},elasticInOut:function(n){if(n==0)return 0;n=n*2;if(n==2)return 1;var p=.3*1.5;var s=p/4;if(n<1){n-=1;return-.5*(Math.pow(2,10*n)*Math.sin((n-s)*(2*Math.PI)/p));}
n-=1;return.5*(Math.pow(2,-10*n)*Math.sin((n-s)*(2*Math.PI)/p))+1;},bounceIn:function(n){return(1-dojo.fx.easing.bounceOut(1-n));},bounceOut:function(n){var s=7.5625;var p=2.75;var l;if(n<(1/p)){l=s*Math.pow(n,2);}else if(n<(2/p)){n-=(1.5/p);l=s*Math.pow(n,2)+.75;}else if(n<(2.5/p)){n-=(2.25/p);l=s*Math.pow(n,2)+.9375;}else{n-=(2.625/p);l=s*Math.pow(n,2)+.984375;}
return l;},bounceInOut:function(n){if(n<0.5){return dojo.fx.easing.bounceIn(n*2)/2;}
return(dojo.fx.easing.bounceOut(n*2-1)/2)+0.5;}};}
if(!dojo._hasResource["dojox.charting.action2d.Base"]){dojo._hasResource["dojox.charting.action2d.Base"]=true;dojo.provide("dojox.charting.action2d.Base");(function(){var DEFAULT_DURATION=400,DEFAULT_EASING=dojo.fx.easing.backOut,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.Base",null,{overOutEvents:{onmouseover:1,onmouseout:1},constructor:function(chart,plot,kwargs){this.chart=chart;this.plot=plot||"default";this.anim={};if(!kwargs){kwargs={};}
this.duration=kwargs.duration?kwargs.duration:DEFAULT_DURATION;this.easing=kwargs.easing?kwargs.easing:DEFAULT_EASING;},connect:function(){this.handle=this.chart.connectToPlot(this.plot,this,"process");},disconnect:function(){if(this.handle){dojo.disconnect(this.handle);this.handle=null;}},reset:function(){},destroy:function(){this.disconnect();df.forIn(this.anim,function(o){df.forIn(o,function(anim){anim.action.stop(true);});});this.anim={};}});})();}
if(!dojo._hasResource["dojox.charting.action2d.Highlight"]){dojo._hasResource["dojox.charting.action2d.Highlight"]=true;dojo.provide("dojox.charting.action2d.Highlight");(function(){var DEFAULT_SATURATION=100,DEFAULT_LUMINOSITY1=75,DEFAULT_LUMINOSITY2=50,c=dojox.color,cc=function(color){return function(){return color;};},hl=function(color){var a=new c.Color(color),x=a.toHsl();if(x.s==0){x.l=x.l<50?100:0;}else{x.s=DEFAULT_SATURATION;if(x.l<DEFAULT_LUMINOSITY2){x.l=DEFAULT_LUMINOSITY1;}else if(x.l>DEFAULT_LUMINOSITY1){x.l=DEFAULT_LUMINOSITY2;}else{x.l=x.l-DEFAULT_LUMINOSITY2>DEFAULT_LUMINOSITY1-x.l?DEFAULT_LUMINOSITY2:DEFAULT_LUMINOSITY1;}}
return c.fromHsl(x);};dojo.declare("dojox.charting.action2d.Highlight",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut},optionalParams:{highlight:"red"},constructor:function(chart,plot,kwArgs){var a=kwArgs&&kwArgs.highlight;this.colorFun=a?(dojo.isFunction(a)?a:cc(a)):hl;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}
var runName=o.run.name,index=o.index,anim,startFill,endFill;if(runName in this.anim){anim=this.anim[runName][index];}else{this.anim[runName]={};}
if(anim){anim.action.stop(true);}else{var color=o.shape.getFill();if(!color||!(color instanceof dojo.Color)){return;}
this.anim[runName][index]=anim={start:color,end:this.colorFun(color)};}
var start=anim.start,end=anim.end;if(o.type=="onmouseout"){var t=start;start=end;end=t;}
anim.action=dojox.gfx.fx.animateFill({shape:o.shape,duration:this.duration,easing:this.easing,color:{start:start,end:end}});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[runName]){delete this.anim[runName][index];}});}
anim.action.play();}});})();}
if(!dojo._hasResource["dojo.fx.Toggler"]){dojo._hasResource["dojo.fx.Toggler"]=true;dojo.provide("dojo.fx.Toggler");dojo.declare("dojo.fx.Toggler",null,{node:null,showFunc:dojo.fadeIn,hideFunc:dojo.fadeOut,showDuration:200,hideDuration:200,constructor:function(args){var _t=this;dojo.mixin(_t,args);_t.node=args.node;_t._showArgs=dojo.mixin({},args);_t._showArgs.node=_t.node;_t._showArgs.duration=_t.showDuration;_t.showAnim=_t.showFunc(_t._showArgs);_t._hideArgs=dojo.mixin({},args);_t._hideArgs.node=_t.node;_t._hideArgs.duration=_t.hideDuration;_t.hideAnim=_t.hideFunc(_t._hideArgs);dojo.connect(_t.showAnim,"beforeBegin",dojo.hitch(_t.hideAnim,"stop",true));dojo.connect(_t.hideAnim,"beforeBegin",dojo.hitch(_t.showAnim,"stop",true));},show:function(delay){return this.showAnim.play(delay||0);},hide:function(delay){return this.hideAnim.play(delay||0);}});}
if(!dojo._hasResource["dojo.fx"]){dojo._hasResource["dojo.fx"]=true;dojo.provide("dojo.fx");(function(){var d=dojo,_baseObj={_fire:function(evt,args){if(this[evt]){this[evt].apply(this,args||[]);}
return this;}};var _chain=function(animations){this._index=-1;this._animations=animations||[];this._current=this._onAnimateCtx=this._onEndCtx=null;this.duration=0;d.forEach(this._animations,function(a){this.duration+=a.duration;if(a.delay){this.duration+=a.delay;}},this);};d.extend(_chain,{_onAnimate:function(){this._fire("onAnimate",arguments);},_onEnd:function(){d.disconnect(this._onAnimateCtx);d.disconnect(this._onEndCtx);this._onAnimateCtx=this._onEndCtx=null;if(this._index+1==this._animations.length){this._fire("onEnd");}else{this._current=this._animations[++this._index];this._onAnimateCtx=d.connect(this._current,"onAnimate",this,"_onAnimate");this._onEndCtx=d.connect(this._current,"onEnd",this,"_onEnd");this._current.play(0,true);}},play:function(delay,gotoStart){if(!this._current){this._current=this._animations[this._index=0];}
if(!gotoStart&&this._current.status()=="playing"){return this;}
var beforeBegin=d.connect(this._current,"beforeBegin",this,function(){this._fire("beforeBegin");}),onBegin=d.connect(this._current,"onBegin",this,function(arg){this._fire("onBegin",arguments);}),onPlay=d.connect(this._current,"onPlay",this,function(arg){this._fire("onPlay",arguments);d.disconnect(beforeBegin);d.disconnect(onBegin);d.disconnect(onPlay);});if(this._onAnimateCtx){d.disconnect(this._onAnimateCtx);}
this._onAnimateCtx=d.connect(this._current,"onAnimate",this,"_onAnimate");if(this._onEndCtx){d.disconnect(this._onEndCtx);}
this._onEndCtx=d.connect(this._current,"onEnd",this,"_onEnd");this._current.play.apply(this._current,arguments);return this;},pause:function(){if(this._current){var e=d.connect(this._current,"onPause",this,function(arg){this._fire("onPause",arguments);d.disconnect(e);});this._current.pause();}
return this;},gotoPercent:function(percent,andPlay){this.pause();var offset=this.duration*percent;this._current=null;d.some(this._animations,function(a){if(a.duration<=offset){this._current=a;return true;}
offset-=a.duration;return false;});if(this._current){this._current.gotoPercent(offset/this._current.duration,andPlay);}
return this;},stop:function(gotoEnd){if(this._current){if(gotoEnd){for(;this._index+1<this._animations.length;++this._index){this._animations[this._index].stop(true);}
this._current=this._animations[this._index];}
var e=d.connect(this._current,"onStop",this,function(arg){this._fire("onStop",arguments);d.disconnect(e);});this._current.stop();}
return this;},status:function(){return this._current?this._current.status():"stopped";},destroy:function(){if(this._onAnimateCtx){d.disconnect(this._onAnimateCtx);}
if(this._onEndCtx){d.disconnect(this._onEndCtx);}}});d.extend(_chain,_baseObj);dojo.fx.chain=function(animations){return new _chain(animations)};var _combine=function(animations){this._animations=animations||[];this._connects=[];this._finished=0;this.duration=0;d.forEach(animations,function(a){var duration=a.duration;if(a.delay){duration+=a.delay;}
if(this.duration<duration){this.duration=duration;}
this._connects.push(d.connect(a,"onEnd",this,"_onEnd"));},this);this._pseudoAnimation=new d.Animation({curve:[0,1],duration:this.duration});var self=this;d.forEach(["beforeBegin","onBegin","onPlay","onAnimate","onPause","onStop","onEnd"],function(evt){self._connects.push(d.connect(self._pseudoAnimation,evt,function(){self._fire(evt,arguments);}));});};d.extend(_combine,{_doAction:function(action,args){d.forEach(this._animations,function(a){a[action].apply(a,args);});return this;},_onEnd:function(){if(++this._finished>this._animations.length){this._fire("onEnd");}},_call:function(action,args){var t=this._pseudoAnimation;t[action].apply(t,args);},play:function(delay,gotoStart){this._finished=0;this._doAction("play",arguments);this._call("play",arguments);return this;},pause:function(){this._doAction("pause",arguments);this._call("pause",arguments);return this;},gotoPercent:function(percent,andPlay){var ms=this.duration*percent;d.forEach(this._animations,function(a){a.gotoPercent(a.duration<ms?1:(ms/a.duration),andPlay);});this._call("gotoPercent",arguments);return this;},stop:function(gotoEnd){this._doAction("stop",arguments);this._call("stop",arguments);return this;},status:function(){return this._pseudoAnimation.status();},destroy:function(){d.forEach(this._connects,dojo.disconnect);}});d.extend(_combine,_baseObj);dojo.fx.combine=function(animations){return new _combine(animations);};dojo.fx.wipeIn=function(args){var node=args.node=d.byId(args.node),s=node.style,o;var anim=d.animateProperty(d.mixin({properties:{height:{start:function(){o=s.overflow;s.overflow="hidden";if(s.visibility=="hidden"||s.display=="none"){s.height="1px";s.display="";s.visibility="";return 1;}else{var height=d.style(node,"height");return Math.max(height,1);}},end:function(){return node.scrollHeight;}}}},args));d.connect(anim,"onEnd",function(){s.height="auto";s.overflow=o;});return anim;}
dojo.fx.wipeOut=function(args){var node=args.node=d.byId(args.node),s=node.style,o;var anim=d.animateProperty(d.mixin({properties:{height:{end:1}}},args));d.connect(anim,"beforeBegin",function(){o=s.overflow;s.overflow="hidden";s.display="";});d.connect(anim,"onEnd",function(){s.overflow=o;s.height="auto";s.display="none";});return anim;}
dojo.fx.slideTo=function(args){var node=args.node=d.byId(args.node),top=null,left=null;var init=(function(n){return function(){var cs=d.getComputedStyle(n);var pos=cs.position;top=(pos=='absolute'?n.offsetTop:parseInt(cs.top)||0);left=(pos=='absolute'?n.offsetLeft:parseInt(cs.left)||0);if(pos!='absolute'&&pos!='relative'){var ret=d.position(n,true);top=ret.y;left=ret.x;n.style.position="absolute";n.style.top=top+"px";n.style.left=left+"px";}};})(node);init();var anim=d.animateProperty(d.mixin({properties:{top:args.top||0,left:args.left||0}},args));d.connect(anim,"beforeBegin",anim,init);return anim;}})();}
if(!dojo._hasResource["dojox.charting.action2d.Magnify"]){dojo._hasResource["dojox.charting.action2d.Magnify"]=true;dojo.provide("dojox.charting.action2d.Magnify");(function(){var DEFAULT_SCALE=2,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Magnify",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:DEFAULT_SCALE},optionalParams:{},constructor:function(chart,plot,kwArgs){this.scale=kwArgs&&typeof kwArgs.scale=="number"?kwArgs.scale:DEFAULT_SCALE;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)||!("cx"in o)||!("cy"in o)){return;}
var runName=o.run.name,index=o.index,vector=[],anim,init,scale;if(runName in this.anim){anim=this.anim[runName][index];}else{this.anim[runName]={};}
if(anim){anim.action.stop(true);}else{this.anim[runName][index]=anim={};}
if(o.type=="onmouseover"){init=m.identity;scale=this.scale;}else{init=m.scaleAt(this.scale,o.cx,o.cy);scale=1/this.scale;}
var kwArgs={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"scaleAt",start:[1,o.cx,o.cy],end:[scale,o.cx,o.cy]},init]};if(o.shape){vector.push(gf.animateTransform(kwArgs));}
if(o.oultine){kwArgs.shape=o.outline;vector.push(gf.animateTransform(kwArgs));}
if(o.shadow){kwArgs.shape=o.shadow;vector.push(gf.animateTransform(kwArgs));}
if(!vector.length){delete this.anim[runName][index];return;}
anim.action=dojo.fx.combine(vector);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[runName]){delete this.anim[runName][index];}});}
anim.action.play();}});})();}
if(!dojo._hasResource["dojox.lang.functional.scan"]){dojo._hasResource["dojox.lang.functional.scan"]=true;dojo.provide("dojox.lang.functional.scan");(function(){var d=dojo,df=dojox.lang.functional,empty={};d.mixin(df,{scanl:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var t,n,i;if(d.isArray(a)){t=new Array((n=a.length)+1);t[0]=z;for(i=0;i<n;z=f.call(o,z,a[i],i,a),t[++i]=z);}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){t=[z];for(i=0;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a)));}else{t=[z];for(i in a){if(!(i in empty)){t.push(z=f.call(o,z,a[i],i,a));}}}
return t;},scanl1:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var t,n,z,first=true;if(d.isArray(a)){t=new Array(n=a.length);t[0]=z=a[0];for(var i=1;i<n;t[i]=z=f.call(o,z,a[i],i,a),++i);}else if(typeof a.hasNext=="function"&&typeof a.next=="function"){if(a.hasNext()){t=[z=a.next()];for(var i=1;a.hasNext();t.push(z=f.call(o,z,a.next(),i++,a)));}}else{for(var i in a){if(!(i in empty)){if(first){t=[z=a[i]];first=false;}else{t.push(z=f.call(o,z,a[i],i,a));}}}}
return t;},scanr:function(a,f,z,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n+1),i=n;t[n]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z);return t;},scanr1:function(a,f,o){if(typeof a=="string"){a=a.split("");}
o=o||d.global;f=df.lambda(f);var n=a.length,t=new Array(n),z=a[n-1],i=n-1;t[i]=z;for(;i>0;--i,z=f.call(o,z,a[i],i,a),t[i]=z);return t;}});})();}
if(!dojo._hasResource["dojox.charting.action2d.MoveSlice"]){dojo._hasResource["dojox.charting.action2d.MoveSlice"]=true;dojo.provide("dojox.charting.action2d.MoveSlice");(function(){var DEFAULT_SCALE=1.05,DEFAULT_SHIFT=7,m=dojox.gfx.matrix,gf=dojox.gfx.fx,df=dojox.lang.functional;dojo.declare("dojox.charting.action2d.MoveSlice",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,scale:DEFAULT_SCALE,shift:DEFAULT_SHIFT},optionalParams:{},constructor:function(chart,plot,kwArgs){if(!kwArgs){kwArgs={};}
this.scale=typeof kwArgs.scale=="number"?kwArgs.scale:DEFAULT_SCALE;this.shift=typeof kwArgs.shift=="number"?kwArgs.shift:DEFAULT_SHIFT;this.connect();},process:function(o){if(!o.shape||o.element!="slice"||!(o.type in this.overOutEvents)){return;}
if(!this.angles){var startAngle=m._degToRad(o.plot.opt.startAngle);if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",startAngle),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",startAngle),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}
var index=o.index,anim,startScale,endScale,startOffset,endOffset,angle=(this.angles[index]+this.angles[index+1])/2,rotateTo0=m.rotateAt(-angle,o.cx,o.cy),rotateBack=m.rotateAt(angle,o.cx,o.cy);anim=this.anim[index];if(anim){anim.action.stop(true);}else{this.anim[index]=anim={};}
if(o.type=="onmouseover"){startOffset=0;endOffset=this.shift;startScale=1;endScale=this.scale;}else{startOffset=this.shift;endOffset=0;startScale=this.scale;endScale=1;}
anim.action=dojox.gfx.fx.animateTransform({shape:o.shape,duration:this.duration,easing:this.easing,transform:[rotateBack,{name:"translate",start:[startOffset,0],end:[endOffset,0]},{name:"scaleAt",start:[startScale,o.cx,o.cy],end:[endScale,o.cx,o.cy]},rotateTo0]});if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){delete this.anim[index];});}
anim.action.play();},reset:function(){delete this.angles;}});})();}
if(!dojo._hasResource["dojox.charting.action2d.Shake"]){dojo._hasResource["dojox.charting.action2d.Shake"]=true;dojo.provide("dojox.charting.action2d.Shake");(function(){var DEFAULT_SHIFT=3,m=dojox.gfx.matrix,gf=dojox.gfx.fx;dojo.declare("dojox.charting.action2d.Shake",dojox.charting.action2d.Base,{defaultParams:{duration:400,easing:dojo.fx.easing.backOut,shiftX:DEFAULT_SHIFT,shiftY:DEFAULT_SHIFT},optionalParams:{},constructor:function(chart,plot,kwArgs){if(!kwArgs){kwArgs={};}
this.shiftX=typeof kwArgs.shiftX=="number"?kwArgs.shiftX:DEFAULT_SHIFT;this.shiftY=typeof kwArgs.shiftY=="number"?kwArgs.shiftY:DEFAULT_SHIFT;this.connect();},process:function(o){if(!o.shape||!(o.type in this.overOutEvents)){return;}
var runName=o.run.name,index=o.index,vector=[],anim,shiftX=o.type=="onmouseover"?this.shiftX:-this.shiftX,shiftY=o.type=="onmouseover"?this.shiftY:-this.shiftY;if(runName in this.anim){anim=this.anim[runName][index];}else{this.anim[runName]={};}
if(anim){anim.action.stop(true);}else{this.anim[runName][index]=anim={};}
var kwArgs={shape:o.shape,duration:this.duration,easing:this.easing,transform:[{name:"translate",start:[this.shiftX,this.shiftY],end:[0,0]},m.identity]};if(o.shape){vector.push(gf.animateTransform(kwArgs));}
if(o.oultine){kwArgs.shape=o.outline;vector.push(gf.animateTransform(kwArgs));}
if(o.shadow){kwArgs.shape=o.shadow;vector.push(gf.animateTransform(kwArgs));}
if(!vector.length){delete this.anim[runName][index];return;}
anim.action=dojo.fx.combine(vector);if(o.type=="onmouseout"){dojo.connect(anim.action,"onEnd",this,function(){if(this.anim[runName]){delete this.anim[runName][index];}});}
anim.action.play();}});})();}
if(!dojo._hasResource["dojo.window"]){dojo._hasResource["dojo.window"]=true;dojo.provide("dojo.window");dojo.window.getBox=function(){var scrollRoot=(dojo.doc.compatMode=='BackCompat')?dojo.body():dojo.doc.documentElement;var scroll=dojo._docScroll();return{w:scrollRoot.clientWidth,h:scrollRoot.clientHeight,l:scroll.x,t:scroll.y};};dojo.window.get=function(doc){if(dojo.isIE&&window!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}
return doc.parentWindow||doc.defaultView;};dojo.window.scrollIntoView=function(node,pos){try{node=dojo.byId(node);var doc=node.ownerDocument||dojo.doc,body=doc.body||dojo.body(),html=doc.documentElement||body.parentNode,isIE=dojo.isIE,isWK=dojo.isWebKit;if((!(dojo.isMoz||isIE||isWK||dojo.isOpera)||node==body||node==html)&&(typeof node.scrollIntoView!="undefined")){node.scrollIntoView(false);return;}
var backCompat=doc.compatMode=='BackCompat',clientAreaRoot=backCompat?body:html,scrollRoot=isWK?body:clientAreaRoot,rootWidth=clientAreaRoot.clientWidth,rootHeight=clientAreaRoot.clientHeight,rtl=!dojo._isBodyLtr(),nodePos=pos||dojo.position(node),el=node.parentNode,isFixed=function(el){return((isIE<=6||(isIE&&backCompat))?false:(dojo.style(el,'position').toLowerCase()=="fixed"));};if(isFixed(node)){return;}
while(el){if(el==body){el=scrollRoot;}
var elPos=dojo.position(el),fixedPos=isFixed(el);if(el==scrollRoot){elPos.w=rootWidth;elPos.h=rootHeight;if(scrollRoot==html&&isIE&&rtl){elPos.x+=scrollRoot.offsetWidth-elPos.w;}
if(elPos.x<0||!isIE){elPos.x=0;}
if(elPos.y<0||!isIE){elPos.y=0;}}else{var pb=dojo._getPadBorderExtents(el);elPos.w-=pb.w;elPos.h-=pb.h;elPos.x+=pb.l;elPos.y+=pb.t;}
if(el!=scrollRoot){var clientSize=el.clientWidth,scrollBarSize=elPos.w-clientSize;if(clientSize>0&&scrollBarSize>0){elPos.w=clientSize;if(isIE&&rtl){elPos.x+=scrollBarSize;}}
clientSize=el.clientHeight;scrollBarSize=elPos.h-clientSize;if(clientSize>0&&scrollBarSize>0){elPos.h=clientSize;}}
if(fixedPos){if(elPos.y<0){elPos.h+=elPos.y;elPos.y=0;}
if(elPos.x<0){elPos.w+=elPos.x;elPos.x=0;}
if(elPos.y+elPos.h>rootHeight){elPos.h=rootHeight-elPos.y;}
if(elPos.x+elPos.w>rootWidth){elPos.w=rootWidth-elPos.x;}}
var l=nodePos.x-elPos.x,t=nodePos.y-Math.max(elPos.y,0),r=l+nodePos.w-elPos.w,bot=t+nodePos.h-elPos.h;if(r*l>0){var s=Math[l<0?"max":"min"](l,r);nodePos.x+=el.scrollLeft;el.scrollLeft+=(isIE>=8&&!backCompat&&rtl)?-s:s;nodePos.x-=el.scrollLeft;}
if(bot*t>0){nodePos.y+=el.scrollTop;el.scrollTop+=Math[t<0?"max":"min"](t,bot);nodePos.y-=el.scrollTop;}
el=(el!=scrollRoot)&&!fixedPos&&el.parentNode;}}catch(error){console.error('scrollIntoView: '+error);node.scrollIntoView(false);}};}
if(!dojo._hasResource["dijit._base.manager"]){dojo._hasResource["dijit._base.manager"]=true;dojo.provide("dijit._base.manager");dojo.declare("dijit.WidgetSet",null,{constructor:function(){this._hash={};this.length=0;},add:function(widget){if(this._hash[widget.id]){throw new Error("Tried to register widget with id=="+widget.id+" but that id is already registered");}
this._hash[widget.id]=widget;this.length++;},remove:function(id){if(this._hash[id]){delete this._hash[id];this.length--;}},forEach:function(func,thisObj){thisObj=thisObj||dojo.global;var i=0,id;for(id in this._hash){func.call(thisObj,this._hash[id],i++,this._hash);}
return this;},filter:function(filter,thisObj){thisObj=thisObj||dojo.global;var res=new dijit.WidgetSet(),i=0,id;for(id in this._hash){var w=this._hash[id];if(filter.call(thisObj,w,i++,this._hash)){res.add(w);}}
return res;},byId:function(id){return this._hash[id];},byClass:function(cls){var res=new dijit.WidgetSet(),id,widget;for(id in this._hash){widget=this._hash[id];if(widget.declaredClass==cls){res.add(widget);}}
return res;},toArray:function(){var ar=[];for(var id in this._hash){ar.push(this._hash[id]);}
return ar;},map:function(func,thisObj){return dojo.map(this.toArray(),func,thisObj);},every:function(func,thisObj){thisObj=thisObj||dojo.global;var x=0,i;for(i in this._hash){if(!func.call(thisObj,this._hash[i],x++,this._hash)){return false;}}
return true;},some:function(func,thisObj){thisObj=thisObj||dojo.global;var x=0,i;for(i in this._hash){if(func.call(thisObj,this._hash[i],x++,this._hash)){return true;}}
return false;}});(function(){dijit.registry=new dijit.WidgetSet();var hash=dijit.registry._hash,attr=dojo.attr,hasAttr=dojo.hasAttr,style=dojo.style;dijit.byId=function(id){return typeof id=="string"?hash[id]:id;};var _widgetTypeCtr={};dijit.getUniqueId=function(widgetType){var id;do{id=widgetType+"_"+
(widgetType in _widgetTypeCtr?++_widgetTypeCtr[widgetType]:_widgetTypeCtr[widgetType]=0);}while(hash[id]);return dijit._scopeName=="dijit"?id:dijit._scopeName+"_"+id;};dijit.findWidgets=function(root){var outAry=[];function getChildrenHelper(root){for(var node=root.firstChild;node;node=node.nextSibling){if(node.nodeType==1){var widgetId=node.getAttribute("widgetId");if(widgetId){outAry.push(hash[widgetId]);}else{getChildrenHelper(node);}}}}
getChildrenHelper(root);return outAry;};dijit._destroyAll=function(){dijit._curFocus=null;dijit._prevFocus=null;dijit._activeStack=[];dojo.forEach(dijit.findWidgets(dojo.body()),function(widget){if(!widget._destroyed){if(widget.destroyRecursive){widget.destroyRecursive();}else if(widget.destroy){widget.destroy();}}});};if(dojo.isIE){dojo.addOnWindowUnload(function(){dijit._destroyAll();});}
dijit.byNode=function(node){return hash[node.getAttribute("widgetId")];};dijit.getEnclosingWidget=function(node){while(node){var id=node.getAttribute&&node.getAttribute("widgetId");if(id){return hash[id];}
node=node.parentNode;}
return null;};var shown=(dijit._isElementShown=function(elem){var s=style(elem);return(s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(attr(elem,"type")!="hidden");});dijit.hasDefaultTabStop=function(elem){switch(elem.nodeName.toLowerCase()){case"a":return hasAttr(elem,"href");case"area":case"button":case"input":case"object":case"select":case"textarea":return true;case"iframe":if(dojo.isMoz){try{return elem.contentDocument.designMode=="on";}catch(err){return false;}}else if(dojo.isWebKit){var doc=elem.contentDocument,body=doc&&doc.body;return body&&body.contentEditable=='true';}else{try{doc=elem.contentWindow.document;body=doc&&doc.body;return body&&body.firstChild&&body.firstChild.contentEditable=='true';}catch(e){return false;}}
default:return elem.contentEditable=='true';}};var isTabNavigable=(dijit.isTabNavigable=function(elem){if(attr(elem,"disabled")){return false;}else if(hasAttr(elem,"tabIndex")){return attr(elem,"tabIndex")>=0;}else{return dijit.hasDefaultTabStop(elem);}});dijit._getTabNavigable=function(root){var first,last,lowest,lowestTabindex,highest,highestTabindex;var walkTree=function(parent){dojo.query("> *",parent).forEach(function(child){if((dojo.isIE&&child.scopeName!=="HTML")||!shown(child)){return;}
if(isTabNavigable(child)){var tabindex=attr(child,"tabIndex");if(!hasAttr(child,"tabIndex")||tabindex==0){if(!first){first=child;}
last=child;}else if(tabindex>0){if(!lowest||tabindex<lowestTabindex){lowestTabindex=tabindex;lowest=child;}
if(!highest||tabindex>=highestTabindex){highestTabindex=tabindex;highest=child;}}}
if(child.nodeName.toUpperCase()!='SELECT'){walkTree(child);}});};if(shown(root)){walkTree(root)}
return{first:first,last:last,lowest:lowest,highest:highest};}
dijit.getFirstInTabbingOrder=function(root){var elems=dijit._getTabNavigable(dojo.byId(root));return elems.lowest?elems.lowest:elems.first;};dijit.getLastInTabbingOrder=function(root){var elems=dijit._getTabNavigable(dojo.byId(root));return elems.last?elems.last:elems.highest;};dijit.defaultDuration=dojo.config["defaultDuration"]||200;})();}
if(!dojo._hasResource["dijit._base.focus"]){dojo._hasResource["dijit._base.focus"]=true;dojo.provide("dijit._base.focus");dojo.mixin(dijit,{_curFocus:null,_prevFocus:null,isCollapsed:function(){return dijit.getBookmark().isCollapsed;},getBookmark:function(){var bm,rg,tg,sel=dojo.doc.selection,cf=dijit._curFocus;if(dojo.global.getSelection){sel=dojo.global.getSelection();if(sel){if(sel.isCollapsed){tg=cf?cf.tagName:"";if(tg){tg=tg.toLowerCase();if(tg=="textarea"||(tg=="input"&&(!cf.type||cf.type.toLowerCase()=="text"))){sel={start:cf.selectionStart,end:cf.selectionEnd,node:cf,pRange:true};return{isCollapsed:(sel.end<=sel.start),mark:sel};}}
bm={isCollapsed:true};}else{rg=sel.getRangeAt(0);bm={isCollapsed:false,mark:rg.cloneRange()};}}}else if(sel){tg=cf?cf.tagName:"";tg=tg.toLowerCase();if(cf&&tg&&(tg=="button"||tg=="textarea"||tg=="input")){if(sel.type&&sel.type.toLowerCase()=="none"){return{isCollapsed:true,mark:null}}else{rg=sel.createRange();return{isCollapsed:rg.text&&rg.text.length?false:true,mark:{range:rg,pRange:true}};}}
bm={};try{rg=sel.createRange();bm.isCollapsed=!(sel.type=='Text'?rg.htmlText.length:rg.length);}catch(e){bm.isCollapsed=true;return bm;}
if(sel.type.toUpperCase()=='CONTROL'){if(rg.length){bm.mark=[];var i=0,len=rg.length;while(i<len){bm.mark.push(rg.item(i++));}}else{bm.isCollapsed=true;bm.mark=null;}}else{bm.mark=rg.getBookmark();}}else{console.warn("No idea how to store the current selection for this browser!");}
return bm;},moveToBookmark:function(bookmark){var _doc=dojo.doc,mark=bookmark.mark;if(mark){if(dojo.global.getSelection){var sel=dojo.global.getSelection();if(sel&&sel.removeAllRanges){if(mark.pRange){var r=mark;var n=r.node;n.selectionStart=r.start;n.selectionEnd=r.end;}else{sel.removeAllRanges();sel.addRange(mark);}}else{console.warn("No idea how to restore selection for this browser!");}}else if(_doc.selection&&mark){var rg;if(mark.pRange){rg=mark.range;}else if(dojo.isArray(mark)){rg=_doc.body.createControlRange();dojo.forEach(mark,function(n){rg.addElement(n);});}else{rg=_doc.body.createTextRange();rg.moveToBookmark(mark);}
rg.select();}}},getFocus:function(menu,openedForWindow){var node=!dijit._curFocus||(menu&&dojo.isDescendant(dijit._curFocus,menu.domNode))?dijit._prevFocus:dijit._curFocus;return{node:node,bookmark:(node==dijit._curFocus)&&dojo.withGlobal(openedForWindow||dojo.global,dijit.getBookmark),openedForWindow:openedForWindow};},focus:function(handle){if(!handle){return;}
var node="node"in handle?handle.node:handle,bookmark=handle.bookmark,openedForWindow=handle.openedForWindow,collapsed=bookmark?bookmark.isCollapsed:false;if(node){var focusNode=(node.tagName.toLowerCase()=="iframe")?node.contentWindow:node;if(focusNode&&focusNode.focus){try{focusNode.focus();}catch(e){}}
dijit._onFocusNode(node);}
if(bookmark&&dojo.withGlobal(openedForWindow||dojo.global,dijit.isCollapsed)&&!collapsed){if(openedForWindow){openedForWindow.focus();}
try{dojo.withGlobal(openedForWindow||dojo.global,dijit.moveToBookmark,null,[bookmark]);}catch(e2){}}},_activeStack:[],registerIframe:function(iframe){return dijit.registerWin(iframe.contentWindow,iframe);},unregisterIframe:function(handle){dijit.unregisterWin(handle);},registerWin:function(targetWindow,effectiveNode){var mousedownListener=function(evt){dijit._justMouseDowned=true;setTimeout(function(){dijit._justMouseDowned=false;},0);if(dojo.isIE&&evt&&evt.srcElement&&evt.srcElement.parentNode==null){return;}
dijit._onTouchNode(effectiveNode||evt.target||evt.srcElement,"mouse");};var doc=dojo.isIE?targetWindow.document.documentElement:targetWindow.document;if(doc){if(dojo.isIE){doc.attachEvent('onmousedown',mousedownListener);var activateListener=function(evt){if(evt.srcElement.tagName.toLowerCase()!="#document"&&dijit.isTabNavigable(evt.srcElement)){dijit._onFocusNode(effectiveNode||evt.srcElement);}else{dijit._onTouchNode(effectiveNode||evt.srcElement);}};doc.attachEvent('onactivate',activateListener);var deactivateListener=function(evt){dijit._onBlurNode(effectiveNode||evt.srcElement);};doc.attachEvent('ondeactivate',deactivateListener);return function(){doc.detachEvent('onmousedown',mousedownListener);doc.detachEvent('onactivate',activateListener);doc.detachEvent('ondeactivate',deactivateListener);doc=null;};}else{doc.addEventListener('mousedown',mousedownListener,true);var focusListener=function(evt){dijit._onFocusNode(effectiveNode||evt.target);};doc.addEventListener('focus',focusListener,true);var blurListener=function(evt){dijit._onBlurNode(effectiveNode||evt.target);};doc.addEventListener('blur',blurListener,true);return function(){doc.removeEventListener('mousedown',mousedownListener,true);doc.removeEventListener('focus',focusListener,true);doc.removeEventListener('blur',blurListener,true);doc=null;};}}},unregisterWin:function(handle){handle&&handle();},_onBlurNode:function(node){dijit._prevFocus=dijit._curFocus;dijit._curFocus=null;if(dijit._justMouseDowned){return;}
if(dijit._clearActiveWidgetsTimer){clearTimeout(dijit._clearActiveWidgetsTimer);}
dijit._clearActiveWidgetsTimer=setTimeout(function(){delete dijit._clearActiveWidgetsTimer;dijit._setStack([]);dijit._prevFocus=null;},100);},_onTouchNode:function(node,by){if(dijit._clearActiveWidgetsTimer){clearTimeout(dijit._clearActiveWidgetsTimer);delete dijit._clearActiveWidgetsTimer;}
var newStack=[];try{while(node){var popupParent=dojo.attr(node,"dijitPopupParent");if(popupParent){node=dijit.byId(popupParent).domNode;}else if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===dojo.body()){break;}
node=dojo.window.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),widget=id&&dijit.byId(id);if(widget&&!(by=="mouse"&&widget.get("disabled"))){newStack.unshift(id);}
node=node.parentNode;}}}catch(e){}
dijit._setStack(newStack,by);},_onFocusNode:function(node){if(!node){return;}
if(node.nodeType==9){return;}
dijit._onTouchNode(node);if(node==dijit._curFocus){return;}
if(dijit._curFocus){dijit._prevFocus=dijit._curFocus;}
dijit._curFocus=node;dojo.publish("focusNode",[node]);},_setStack:function(newStack,by){var oldStack=dijit._activeStack;dijit._activeStack=newStack;for(var nCommon=0;nCommon<Math.min(oldStack.length,newStack.length);nCommon++){if(oldStack[nCommon]!=newStack[nCommon]){break;}}
var widget;for(var i=oldStack.length-1;i>=nCommon;i--){widget=dijit.byId(oldStack[i]);if(widget){widget._focused=false;widget._hasBeenBlurred=true;if(widget._onBlur){widget._onBlur(by);}
dojo.publish("widgetBlur",[widget,by]);}}
for(i=nCommon;i<newStack.length;i++){widget=dijit.byId(newStack[i]);if(widget){widget._focused=true;if(widget._onFocus){widget._onFocus(by);}
dojo.publish("widgetFocus",[widget,by]);}}}});dojo.addOnLoad(function(){var handle=dijit.registerWin(window);if(dojo.isIE){dojo.addOnWindowUnload(function(){dijit.unregisterWin(handle);handle=null;})}});}
if(!dojo._hasResource["dojo.AdapterRegistry"]){dojo._hasResource["dojo.AdapterRegistry"]=true;dojo.provide("dojo.AdapterRegistry");dojo.AdapterRegistry=function(returnWrappers){this.pairs=[];this.returnWrappers=returnWrappers||false;}
dojo.extend(dojo.AdapterRegistry,{register:function(name,check,wrap,directReturn,override){this.pairs[((override)?"unshift":"push")]([name,check,wrap,directReturn]);},match:function(){for(var i=0;i<this.pairs.length;i++){var pair=this.pairs[i];if(pair[1].apply(this,arguments)){if((pair[3])||(this.returnWrappers)){return pair[2];}else{return pair[2].apply(this,arguments);}}}
throw new Error("No match found");},unregister:function(name){for(var i=0;i<this.pairs.length;i++){var pair=this.pairs[i];if(pair[0]==name){this.pairs.splice(i,1);return true;}}
return false;}});}
if(!dojo._hasResource["dijit._base.place"]){dojo._hasResource["dijit._base.place"]=true;dojo.provide("dijit._base.place");dijit.getViewport=function(){return dojo.window.getBox();};dijit.placeOnScreen=function(node,pos,corners,padding){var choices=dojo.map(corners,function(corner){var c={corner:corner,pos:{x:pos.x,y:pos.y}};if(padding){c.pos.x+=corner.charAt(1)=='L'?padding.x:-padding.x;c.pos.y+=corner.charAt(0)=='T'?padding.y:-padding.y;}
return c;});return dijit._place(node,choices);}
dijit._place=function(node,choices,layoutNode){var view=dojo.window.getBox();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){dojo.body().appendChild(node);}
var best=null;dojo.some(choices,function(choice){var corner=choice.corner;var pos=choice.pos;if(layoutNode){layoutNode(node,choice.aroundCorner,corner);}
var style=node.style;var oldDisplay=style.display;var oldVis=style.visibility;style.visibility="hidden";style.display="";var mb=dojo.marginBox(node);style.display=oldDisplay;style.visibility=oldVis;var startX=Math.max(view.l,corner.charAt(1)=='L'?pos.x:(pos.x-mb.w)),startY=Math.max(view.t,corner.charAt(0)=='T'?pos.y:(pos.y-mb.h)),endX=Math.min(view.l+view.w,corner.charAt(1)=='L'?(startX+mb.w):pos.x),endY=Math.min(view.t+view.h,corner.charAt(0)=='T'?(startY+mb.h):pos.y),width=endX-startX,height=endY-startY,overflow=(mb.w-width)+(mb.h-height);if(best==null||overflow<best.overflow){best={corner:corner,aroundCorner:choice.aroundCorner,x:startX,y:startY,w:width,h:height,overflow:overflow};}
return!overflow;});node.style.left=best.x+"px";node.style.top=best.y+"px";if(best.overflow&&layoutNode){layoutNode(node,best.aroundCorner,best.corner);}
return best;}
dijit.placeOnScreenAroundNode=function(node,aroundNode,aroundCorners,layoutNode){aroundNode=dojo.byId(aroundNode);var oldDisplay=aroundNode.style.display;aroundNode.style.display="";var aroundNodePos=dojo.position(aroundNode,true);aroundNode.style.display=oldDisplay;return dijit._placeOnScreenAroundRect(node,aroundNodePos.x,aroundNodePos.y,aroundNodePos.w,aroundNodePos.h,aroundCorners,layoutNode);};dijit.placeOnScreenAroundRectangle=function(node,aroundRect,aroundCorners,layoutNode){return dijit._placeOnScreenAroundRect(node,aroundRect.x,aroundRect.y,aroundRect.width,aroundRect.height,aroundCorners,layoutNode);};dijit._placeOnScreenAroundRect=function(node,x,y,width,height,aroundCorners,layoutNode){var choices=[];for(var nodeCorner in aroundCorners){choices.push({aroundCorner:nodeCorner,corner:aroundCorners[nodeCorner],pos:{x:x+(nodeCorner.charAt(1)=='L'?0:width),y:y+(nodeCorner.charAt(0)=='T'?0:height)}});}
return dijit._place(node,choices,layoutNode);};dijit.placementRegistry=new dojo.AdapterRegistry();dijit.placementRegistry.register("node",function(n,x){return typeof x=="object"&&typeof x.offsetWidth!="undefined"&&typeof x.offsetHeight!="undefined";},dijit.placeOnScreenAroundNode);dijit.placementRegistry.register("rect",function(n,x){return typeof x=="object"&&"x"in x&&"y"in x&&"width"in x&&"height"in x;},dijit.placeOnScreenAroundRectangle);dijit.placeOnScreenAroundElement=function(node,aroundElement,aroundCorners,layoutNode){return dijit.placementRegistry.match.apply(dijit.placementRegistry,arguments);};dijit.getPopupAroundAlignment=function(position,leftToRight){var align={};dojo.forEach(position,function(pos){switch(pos){case"after":align[leftToRight?"BR":"BL"]=leftToRight?"BL":"BR";break;case"before":align[leftToRight?"BL":"BR"]=leftToRight?"BR":"BL";break;case"below":align[leftToRight?"BL":"BR"]=leftToRight?"TL":"TR";align[leftToRight?"BR":"BL"]=leftToRight?"TR":"TL";break;case"above":default:align[leftToRight?"TL":"TR"]=leftToRight?"BL":"BR";align[leftToRight?"TR":"TL"]=leftToRight?"BR":"BL";break;}});return align;};}
if(!dojo._hasResource["dijit._base.window"]){dojo._hasResource["dijit._base.window"]=true;dojo.provide("dijit._base.window");dijit.getDocumentWindow=function(doc){return dojo.window.get(doc);};}
if(!dojo._hasResource["dijit._base.popup"]){dojo._hasResource["dijit._base.popup"]=true;dojo.provide("dijit._base.popup");dijit.popup={_stack:[],_beginZIndex:1000,_idGen:1,moveOffScreen:function(node){var wrapper=node.parentNode;if(!wrapper||!dojo.hasClass(wrapper,"dijitPopup")){wrapper=dojo.create("div",{"class":"dijitPopup",style:{visibility:"hidden",top:"-9999px"}},dojo.body());dijit.setWaiRole(wrapper,"presentation");wrapper.appendChild(node);}
var s=node.style;s.display="";s.visibility="";s.position="";s.top="0px";dojo.style(wrapper,{visibility:"hidden",top:"-9999px"});},getTopPopup:function(){var stack=this._stack;for(var pi=stack.length-1;pi>0&&stack[pi].parent===stack[pi-1].widget;pi--){}
return stack[pi];},open:function(args){var stack=this._stack,widget=args.popup,orient=args.orient||((args.parent?args.parent.isLeftToRight():dojo._isBodyLtr())?{'BL':'TL','BR':'TR','TL':'BL','TR':'BR'}:{'BR':'TR','BL':'TL','TR':'BR','TL':'BL'}),around=args.around,id=(args.around&&args.around.id)?(args.around.id+"_dropdown"):("popup_"+this._idGen++);var wrapper=widget.domNode.parentNode;if(!wrapper||!dojo.hasClass(wrapper,"dijitPopup")){this.moveOffScreen(widget.domNode);wrapper=widget.domNode.parentNode;}
dojo.attr(wrapper,{id:id,style:{zIndex:this._beginZIndex+stack.length},"class":"dijitPopup "+(widget.baseClass||widget["class"]||"").split(" ")[0]+"Popup",dijitPopupParent:args.parent?args.parent.id:""});if(dojo.isIE||dojo.isMoz){var iframe=wrapper.childNodes[1];if(!iframe){iframe=new dijit.BackgroundIframe(wrapper);}}
var best=around?dijit.placeOnScreenAroundElement(wrapper,around,orient,widget.orient?dojo.hitch(widget,"orient"):null):dijit.placeOnScreen(wrapper,args,orient=='R'?['TR','BR','TL','BL']:['TL','BL','TR','BR'],args.padding);wrapper.style.visibility="visible";widget.domNode.style.visibility="visible";var handlers=[];handlers.push(dojo.connect(wrapper,"onkeypress",this,function(evt){if(evt.charOrCode==dojo.keys.ESCAPE&&args.onCancel){dojo.stopEvent(evt);args.onCancel();}else if(evt.charOrCode===dojo.keys.TAB){dojo.stopEvent(evt);var topPopup=this.getTopPopup();if(topPopup&&topPopup.onCancel){topPopup.onCancel();}}}));if(widget.onCancel){handlers.push(dojo.connect(widget,"onCancel",args.onCancel));}
handlers.push(dojo.connect(widget,widget.onExecute?"onExecute":"onChange",this,function(){var topPopup=this.getTopPopup();if(topPopup&&topPopup.onExecute){topPopup.onExecute();}}));stack.push({wrapper:wrapper,iframe:iframe,widget:widget,parent:args.parent,onExecute:args.onExecute,onCancel:args.onCancel,onClose:args.onClose,handlers:handlers});if(widget.onOpen){widget.onOpen(best);}
return best;},close:function(popup){var stack=this._stack;while(dojo.some(stack,function(elem){return elem.widget==popup;})){var top=stack.pop(),wrapper=top.wrapper,iframe=top.iframe,widget=top.widget,onClose=top.onClose;if(widget.onClose){widget.onClose();}
dojo.forEach(top.handlers,dojo.disconnect);if(widget&&widget.domNode){this.moveOffScreen(widget.domNode);}else{dojo.destroy(wrapper);}
if(onClose){onClose();}}}};dijit._frames=new function(){var queue=[];this.pop=function(){var iframe;if(queue.length){iframe=queue.pop();iframe.style.display="";}else{if(dojo.isIE){var burl="blank.htm";var html="<iframe src='"+burl+"'"
+" style='position: absolute; left: 0px; top: 0px;"
+"z-index: -1; filter:Alpha(Opacity=\"0\");'>";iframe=dojo.doc.createElement(html);}else{iframe=dojo.create("iframe");iframe.src='javascript:""';iframe.className="dijitBackgroundIframe";dojo.style(iframe,"opacity",0.1);}
iframe.tabIndex=-1;dijit.setWaiRole(iframe,"presentation");}
return iframe;};this.push=function(iframe){iframe.style.display="none";queue.push(iframe);}}();dijit.BackgroundIframe=function(node){if(!node.id){throw new Error("no id");}
if(dojo.isIE||dojo.isMoz){var iframe=dijit._frames.pop();node.appendChild(iframe);if(dojo.isIE<7){this.resize(node);this._conn=dojo.connect(node,'onresize',this,function(){this.resize(node);});}else{dojo.style(iframe,{width:'100%',height:'100%'});}
this.iframe=iframe;}};dojo.extend(dijit.BackgroundIframe,{resize:function(node){if(this.iframe&&dojo.isIE<7){dojo.style(this.iframe,{width:node.offsetWidth+'px',height:node.offsetHeight+'px'});}},destroy:function(){if(this._conn){dojo.disconnect(this._conn);this._conn=null;}
if(this.iframe){dijit._frames.push(this.iframe);delete this.iframe;}}});}
if(!dojo._hasResource["dijit._base.scroll"]){dojo._hasResource["dijit._base.scroll"]=true;dojo.provide("dijit._base.scroll");dijit.scrollIntoView=function(node,pos){dojo.window.scrollIntoView(node,pos);};}
if(!dojo._hasResource["dojo.uacss"]){dojo._hasResource["dojo.uacss"]=true;dojo.provide("dojo.uacss");(function(){var d=dojo,html=d.doc.documentElement,ie=d.isIE,opera=d.isOpera,maj=Math.floor,ff=d.isFF,boxModel=d.boxModel.replace(/-/,''),classes={dj_ie:ie,dj_ie6:maj(ie)==6,dj_ie7:maj(ie)==7,dj_ie8:maj(ie)==8,dj_quirks:d.isQuirks,dj_iequirks:ie&&d.isQuirks,dj_opera:opera,dj_khtml:d.isKhtml,dj_webkit:d.isWebKit,dj_safari:d.isSafari,dj_chrome:d.isChrome,dj_gecko:d.isMozilla,dj_ff3:maj(ff)==3};classes["dj_"+boxModel]=true;var classStr="";for(var clz in classes){if(classes[clz]){classStr+=clz+" ";}}
html.className=d.trim(html.className+" "+classStr);dojo._loaders.unshift(function(){if(!dojo._isBodyLtr()){var rtlClassStr="dj_rtl dijitRtl "+classStr.replace(/ /g,"-rtl ")
html.className=d.trim(html.className+" "+rtlClassStr);}});})();}
if(!dojo._hasResource["dijit._base.sniff"]){dojo._hasResource["dijit._base.sniff"]=true;dojo.provide("dijit._base.sniff");}
if(!dojo._hasResource["dijit._base.typematic"]){dojo._hasResource["dijit._base.typematic"]=true;dojo.provide("dijit._base.typematic");dijit.typematic={_fireEventAndReload:function(){this._timer=null;this._callback(++this._count,this._node,this._evt);this._currentTimeout=Math.max(this._currentTimeout<0?this._initialDelay:(this._subsequentDelay>1?this._subsequentDelay:Math.round(this._currentTimeout*this._subsequentDelay)),this._minDelay);this._timer=setTimeout(dojo.hitch(this,"_fireEventAndReload"),this._currentTimeout);},trigger:function(evt,_this,node,callback,obj,subsequentDelay,initialDelay,minDelay){if(obj!=this._obj){this.stop();this._initialDelay=initialDelay||500;this._subsequentDelay=subsequentDelay||0.90;this._minDelay=minDelay||10;this._obj=obj;this._evt=evt;this._node=node;this._currentTimeout=-1;this._count=-1;this._callback=dojo.hitch(_this,callback);this._fireEventAndReload();this._evt=dojo.mixin({faux:true},evt);}},stop:function(){if(this._timer){clearTimeout(this._timer);this._timer=null;}
if(this._obj){this._callback(-1,this._node,this._evt);this._obj=null;}},addKeyListener:function(node,keyObject,_this,callback,subsequentDelay,initialDelay,minDelay){if(keyObject.keyCode){keyObject.charOrCode=keyObject.keyCode;dojo.deprecated("keyCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");}else if(keyObject.charCode){keyObject.charOrCode=String.fromCharCode(keyObject.charCode);dojo.deprecated("charCode attribute parameter for dijit.typematic.addKeyListener is deprecated. Use charOrCode instead.","","2.0");}
return[dojo.connect(node,"onkeypress",this,function(evt){if(evt.charOrCode==keyObject.charOrCode&&(keyObject.ctrlKey===undefined||keyObject.ctrlKey==evt.ctrlKey)&&(keyObject.altKey===undefined||keyObject.altKey==evt.altKey)&&(keyObject.metaKey===undefined||keyObject.metaKey==(evt.metaKey||false))&&(keyObject.shiftKey===undefined||keyObject.shiftKey==evt.shiftKey)){dojo.stopEvent(evt);dijit.typematic.trigger(evt,_this,node,callback,keyObject,subsequentDelay,initialDelay,minDelay);}else if(dijit.typematic._obj==keyObject){dijit.typematic.stop();}}),dojo.connect(node,"onkeyup",this,function(evt){if(dijit.typematic._obj==keyObject){dijit.typematic.stop();}})];},addMouseListener:function(node,_this,callback,subsequentDelay,initialDelay,minDelay){var dc=dojo.connect;return[dc(node,"mousedown",this,function(evt){dojo.stopEvent(evt);dijit.typematic.trigger(evt,_this,node,callback,node,subsequentDelay,initialDelay,minDelay);}),dc(node,"mouseup",this,function(evt){dojo.stopEvent(evt);dijit.typematic.stop();}),dc(node,"mouseout",this,function(evt){dojo.stopEvent(evt);dijit.typematic.stop();}),dc(node,"mousemove",this,function(evt){evt.preventDefault();}),dc(node,"dblclick",this,function(evt){dojo.stopEvent(evt);if(dojo.isIE){dijit.typematic.trigger(evt,_this,node,callback,node,subsequentDelay,initialDelay,minDelay);setTimeout(dojo.hitch(this,dijit.typematic.stop),50);}})];},addListener:function(mouseNode,keyNode,keyObject,_this,callback,subsequentDelay,initialDelay,minDelay){return this.addKeyListener(keyNode,keyObject,_this,callback,subsequentDelay,initialDelay,minDelay).concat(this.addMouseListener(mouseNode,_this,callback,subsequentDelay,initialDelay,minDelay));}};}
if(!dojo._hasResource["dijit._base.wai"]){dojo._hasResource["dijit._base.wai"]=true;dojo.provide("dijit._base.wai");dijit.wai={onload:function(){var div=dojo.create("div",{id:"a11yTestNode",style:{cssText:'border: 1px solid;'
+'border-color:red green;'
+'position: absolute;'
+'height: 5px;'
+'top: -999px;'
+'background-image: url("sofastats_report_extras/blank.gif");'}},dojo.body());var cs=dojo.getComputedStyle(div);if(cs){var bkImg=cs.backgroundImage;var needsA11y=(cs.borderTopColor==cs.borderRightColor)||(bkImg!=null&&(bkImg=="none"||bkImg=="url(invalid-url:)"));dojo[needsA11y?"addClass":"removeClass"](dojo.body(),"dijit_a11y");if(dojo.isIE){div.outerHTML="";}else{dojo.body().removeChild(div);}}}};if(dojo.isIE||dojo.isMoz){dojo._loaders.unshift(dijit.wai.onload);}
dojo.mixin(dijit,{_XhtmlRoles:/banner|contentinfo|definition|main|navigation|search|note|secondary|seealso/,hasWaiRole:function(elem,role){var waiRole=this.getWaiRole(elem);return role?(waiRole.indexOf(role)>-1):(waiRole.length>0);},getWaiRole:function(elem){return dojo.trim((dojo.attr(elem,"role")||"").replace(this._XhtmlRoles,"").replace("wairole:",""));},setWaiRole:function(elem,role){var curRole=dojo.attr(elem,"role")||"";if(!this._XhtmlRoles.test(curRole)){dojo.attr(elem,"role",role);}else{if((" "+curRole+" ").indexOf(" "+role+" ")<0){var clearXhtml=dojo.trim(curRole.replace(this._XhtmlRoles,""));var cleanRole=dojo.trim(curRole.replace(clearXhtml,""));dojo.attr(elem,"role",cleanRole+(cleanRole?' ':'')+role);}}},removeWaiRole:function(elem,role){var roleValue=dojo.attr(elem,"role");if(!roleValue){return;}
if(role){var t=dojo.trim((" "+roleValue+" ").replace(" "+role+" "," "));dojo.attr(elem,"role",t);}else{elem.removeAttribute("role");}},hasWaiState:function(elem,state){return elem.hasAttribute?elem.hasAttribute("aria-"+state):!!elem.getAttribute("aria-"+state);},getWaiState:function(elem,state){return elem.getAttribute("aria-"+state)||"";},setWaiState:function(elem,state,value){elem.setAttribute("aria-"+state,value);},removeWaiState:function(elem,state){elem.removeAttribute("aria-"+state);}});}
if(!dojo._hasResource["dijit._base"]){dojo._hasResource["dijit._base"]=true;dojo.provide("dijit._base");}
if(!dojo._hasResource["dijit._Widget"]){dojo._hasResource["dijit._Widget"]=true;dojo.provide("dijit._Widget");dojo.require("dijit._base");dojo.connect(dojo,"_connect",function(widget,event){if(widget&&dojo.isFunction(widget._onConnect)){widget._onConnect(event);}});dijit._connectOnUseEventHandler=function(event){};dijit._lastKeyDownNode=null;if(dojo.isIE){(function(){var keydownCallback=function(evt){dijit._lastKeyDownNode=evt.srcElement;};dojo.doc.attachEvent('onkeydown',keydownCallback);dojo.addOnWindowUnload(function(){dojo.doc.detachEvent('onkeydown',keydownCallback);});})();}else{dojo.doc.addEventListener('keydown',function(evt){dijit._lastKeyDownNode=evt.target;},true);}
(function(){var _attrReg={},getSetterAttributes=function(widget){var dc=widget.declaredClass;if(!_attrReg[dc]){var r=[],attrs,proto=widget.constructor.prototype;for(var fxName in proto){if(dojo.isFunction(proto[fxName])&&(attrs=fxName.match(/^_set([a-zA-Z]*)Attr$/))&&attrs[1]){r.push(attrs[1].charAt(0).toLowerCase()+attrs[1].substr(1));}}
_attrReg[dc]=r;}
return _attrReg[dc]||[];};dojo.declare("dijit._Widget",null,{id:"",lang:"",dir:"","class":"",style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,attributeMap:{id:"",dir:"",lang:"","class":"",style:"",title:""},_deferredConnects:{onClick:"",onDblClick:"",onKeyDown:"",onKeyPress:"",onKeyUp:"",onMouseMove:"",onMouseDown:"",onMouseOut:"",onMouseOver:"",onMouseLeave:"",onMouseEnter:"",onMouseUp:""},onClick:dijit._connectOnUseEventHandler,onDblClick:dijit._connectOnUseEventHandler,onKeyDown:dijit._connectOnUseEventHandler,onKeyPress:dijit._connectOnUseEventHandler,onKeyUp:dijit._connectOnUseEventHandler,onMouseDown:dijit._connectOnUseEventHandler,onMouseMove:dijit._connectOnUseEventHandler,onMouseOut:dijit._connectOnUseEventHandler,onMouseOver:dijit._connectOnUseEventHandler,onMouseLeave:dijit._connectOnUseEventHandler,onMouseEnter:dijit._connectOnUseEventHandler,onMouseUp:dijit._connectOnUseEventHandler,_blankGif:(dojo.config.blankGif||dojo.moduleUrl("dojo","resources/blank.gif")).toString(),postscript:function(params,srcNodeRef){this.create(params,srcNodeRef);},create:function(params,srcNodeRef){this.srcNodeRef=dojo.byId(srcNodeRef);this._connects=[];this._subscribes=[];this._deferredConnects=dojo.clone(this._deferredConnects);for(var attr in this.attributeMap){delete this._deferredConnects[attr];}
for(attr in this._deferredConnects){if(this[attr]!==dijit._connectOnUseEventHandler){delete this._deferredConnects[attr];}}
if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}
if(params){this.params=params;dojo.mixin(this,params);}
this.postMixInProperties();if(!this.id){this.id=dijit.getUniqueId(this.declaredClass.replace(/\./g,"_"));}
dijit.registry.add(this);this.buildRendering();if(this.domNode){this._applyAttributes();var source=this.srcNodeRef;if(source&&source.parentNode){source.parentNode.replaceChild(this.domNode,source);}
for(attr in this.params){this._onConnect(attr);}}
if(this.domNode){this.domNode.setAttribute("widgetId",this.id);}
this.postCreate();if(this.srcNodeRef&&!this.srcNodeRef.parentNode){delete this.srcNodeRef;}
this._created=true;},_applyAttributes:function(){var condAttrApply=function(attr,scope){if((scope.params&&attr in scope.params)||scope[attr]){scope.set(attr,scope[attr]);}};for(var attr in this.attributeMap){condAttrApply(attr,this);}
dojo.forEach(getSetterAttributes(this),function(a){if(!(a in this.attributeMap)){condAttrApply(a,this);}},this);},postMixInProperties:function(){},buildRendering:function(){this.domNode=this.srcNodeRef||dojo.create('div');},postCreate:function(){if(this.baseClass){var classes=this.baseClass.split(" ");if(!this.isLeftToRight()){classes=classes.concat(dojo.map(classes,function(name){return name+"Rtl";}));}
dojo.addClass(this.domNode,classes);}},startup:function(){this._started=true;},destroyRecursive:function(preserveDom){this._beingDestroyed=true;this.destroyDescendants(preserveDom);this.destroy(preserveDom);},destroy:function(preserveDom){this._beingDestroyed=true;this.uninitialize();var d=dojo,dfe=d.forEach,dun=d.unsubscribe;dfe(this._connects,function(array){dfe(array,d.disconnect);});dfe(this._subscribes,function(handle){dun(handle);});dfe(this._supportingWidgets||[],function(w){if(w.destroyRecursive){w.destroyRecursive();}else if(w.destroy){w.destroy();}});this.destroyRendering(preserveDom);dijit.registry.remove(this.id);this._destroyed=true;},destroyRendering:function(preserveDom){if(this.bgIframe){this.bgIframe.destroy(preserveDom);delete this.bgIframe;}
if(this.domNode){if(preserveDom){dojo.removeAttr(this.domNode,"widgetId");}else{dojo.destroy(this.domNode);}
delete this.domNode;}
if(this.srcNodeRef){if(!preserveDom){dojo.destroy(this.srcNodeRef);}
delete this.srcNodeRef;}},destroyDescendants:function(preserveDom){dojo.forEach(this.getChildren(),function(widget){if(widget.destroyRecursive){widget.destroyRecursive(preserveDom);}});},uninitialize:function(){return false;},onFocus:function(){},onBlur:function(){},_onFocus:function(e){this.onFocus();},_onBlur:function(){this.onBlur();},_onConnect:function(event){if(event in this._deferredConnects){var mapNode=this[this._deferredConnects[event]||'domNode'];this.connect(mapNode,event.toLowerCase(),event);delete this._deferredConnects[event];}},_setClassAttr:function(value){var mapNode=this[this.attributeMap["class"]||'domNode'];dojo.removeClass(mapNode,this["class"])
this["class"]=value;dojo.addClass(mapNode,value);},_setStyleAttr:function(value){var mapNode=this[this.attributeMap.style||'domNode'];if(dojo.isObject(value)){dojo.style(mapNode,value);}else{if(mapNode.style.cssText){mapNode.style.cssText+="; "+value;}else{mapNode.style.cssText=value;}}
this.style=value;},setAttribute:function(attr,value){dojo.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,value);},_attrToDom:function(attr,value){var commands=this.attributeMap[attr];dojo.forEach(dojo.isArray(commands)?commands:[commands],function(command){var mapNode=this[command.node||command||"domNode"];var type=command.type||"attribute";switch(type){case"attribute":if(dojo.isFunction(value)){value=dojo.hitch(this,value);}
var attrName=command.attribute?command.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);dojo.attr(mapNode,attrName,value);break;case"innerText":mapNode.innerHTML="";mapNode.appendChild(dojo.doc.createTextNode(value));break;case"innerHTML":mapNode.innerHTML=value;break;case"class":dojo.removeClass(mapNode,this[attr]);dojo.addClass(mapNode,value);break;}},this);this[attr]=value;},attr:function(name,value){if(dojo.config.isDebug){var alreadyCalledHash=arguments.callee._ach||(arguments.callee._ach={}),caller=(arguments.callee.caller||"unknown caller").toString();if(!alreadyCalledHash[caller]){dojo.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+
caller,"","2.0");alreadyCalledHash[caller]=true;}}
var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},get:function(name){var names=this._getAttrNames(name);return this[names.g]?this[names.g]():this[name];},set:function(name,value){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}
return this;}
var names=this._getAttrNames(name);if(this[names.s]){var result=this[names.s].apply(this,Array.prototype.slice.call(arguments,1));}else{if(name in this.attributeMap){this._attrToDom(name,value);}
var oldValue=this[name];this[name]=value;}
return result||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}
var uc=name.charAt(0).toUpperCase()+name.substr(1);return(apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr"});},toString:function(){return'[Widget '+this.declaredClass+', '+(this.id||'NO ID')+']';},getDescendants:function(){return this.containerNode?dojo.query('[widgetId]',this.containerNode).map(dijit.byNode):[];},getChildren:function(){return this.containerNode?dijit.findWidgets(this.containerNode):[];},nodesWithKeyClick:["input","button"],connect:function(obj,event,method){var d=dojo,dc=d._connect,handles=[];if(event=="ondijitclick"){if(dojo.indexOf(this.nodesWithKeyClick,obj.nodeName.toLowerCase())==-1){var m=d.hitch(this,method);handles.push(dc(obj,"onkeydown",this,function(e){if((e.keyCode==d.keys.ENTER||e.keyCode==d.keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey){dijit._lastKeyDownNode=e.target;e.preventDefault();}}),dc(obj,"onkeyup",this,function(e){if((e.keyCode==d.keys.ENTER||e.keyCode==d.keys.SPACE)&&e.target===dijit._lastKeyDownNode&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey){dijit._lastKeyDownNode=null;return m(e);}}));}
event="onclick";}
handles.push(dc(obj,event,this,method));this._connects.push(handles);return handles;},disconnect:function(handles){for(var i=0;i<this._connects.length;i++){if(this._connects[i]==handles){dojo.forEach(handles,dojo.disconnect);this._connects.splice(i,1);return;}}},subscribe:function(topic,method){var d=dojo,handle=d.subscribe(topic,this,method);this._subscribes.push(handle);return handle;},unsubscribe:function(handle){for(var i=0;i<this._subscribes.length;i++){if(this._subscribes[i]==handle){dojo.unsubscribe(handle);this._subscribes.splice(i,1);return;}}},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):dojo._isBodyLtr();},isFocusable:function(){return this.focus&&(dojo.style(this.domNode,"display")!="none");},placeAt:function(reference,position){if(reference.declaredClass&&reference.addChild){reference.addChild(this,position);}else{dojo.place(this.domNode,reference,position);}
return this;},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});})();}
if(!dojo._hasResource["dojo.date.stamp"]){dojo._hasResource["dojo.date.stamp"]=true;dojo.provide("dojo.date.stamp");dojo.date.stamp.fromISOString=function(formattedString,defaultTime){if(!dojo.date.stamp._isoRegExp){dojo.date.stamp._isoRegExp=/^(?:(\d{4})(?:-(\d{2})(?:-(\d{2}))?)?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(.\d+)?)?((?:[+-](\d{2}):(\d{2}))|Z)?)?$/;}
var match=dojo.date.stamp._isoRegExp.exec(formattedString),result=null;if(match){match.shift();if(match[1]){match[1]--;}
if(match[6]){match[6]*=1000;}
if(defaultTime){defaultTime=new Date(defaultTime);dojo.forEach(dojo.map(["FullYear","Month","Date","Hours","Minutes","Seconds","Milliseconds"],function(prop){return defaultTime["get"+prop]();}),function(value,index){match[index]=match[index]||value;});}
result=new Date(match[0]||1970,match[1]||0,match[2]||1,match[3]||0,match[4]||0,match[5]||0,match[6]||0);if(match[0]<100){result.setFullYear(match[0]||1970);}
var offset=0,zoneSign=match[7]&&match[7].charAt(0);if(zoneSign!='Z'){offset=((match[8]||0)*60)+(Number(match[9])||0);if(zoneSign!='-'){offset*=-1;}}
if(zoneSign){offset-=result.getTimezoneOffset();}
if(offset){result.setTime(result.getTime()+offset*60000);}}
return result;}
dojo.date.stamp.toISOString=function(dateObject,options){var _=function(n){return(n<10)?"0"+n:n;};options=options||{};var formattedDate=[],getter=options.zulu?"getUTC":"get",date="";if(options.selector!="time"){var year=dateObject[getter+"FullYear"]();date=["0000".substr((year+"").length)+year,_(dateObject[getter+"Month"]()+1),_(dateObject[getter+"Date"]())].join('-');}
formattedDate.push(date);if(options.selector!="date"){var time=[_(dateObject[getter+"Hours"]()),_(dateObject[getter+"Minutes"]()),_(dateObject[getter+"Seconds"]())].join(':');var millis=dateObject[getter+"Milliseconds"]();if(options.milliseconds){time+="."+(millis<100?"0":"")+_(millis);}
if(options.zulu){time+="Z";}else if(options.selector!="time"){var timezoneOffset=dateObject.getTimezoneOffset();var absOffset=Math.abs(timezoneOffset);time+=(timezoneOffset>0?"-":"+")+
_(Math.floor(absOffset/60))+":"+_(absOffset%60);}
formattedDate.push(time);}
return formattedDate.join('T');}}
if(!dojo._hasResource["dojo.parser"]){dojo._hasResource["dojo.parser"]=true;dojo.provide("dojo.parser");new Date("X");dojo.parser=new function(){var d=dojo;this._attrName=d._scopeName+"Type";this._query="["+this._attrName+"]";function val2type(value){if(d.isString(value)){return"string";}
if(typeof value=="number"){return"number";}
if(typeof value=="boolean"){return"boolean";}
if(d.isFunction(value)){return"function";}
if(d.isArray(value)){return"array";}
if(value instanceof Date){return"date";}
if(value instanceof d._Url){return"url";}
return"object";}
function str2obj(value,type){switch(type){case"string":return value;case"number":return value.length?Number(value):NaN;case"boolean":return typeof value=="boolean"?value:!(value.toLowerCase()=="false");case"function":if(d.isFunction(value)){value=value.toString();value=d.trim(value.substring(value.indexOf('{')+1,value.length-1));}
try{if(value===""||value.search(/[^\w\.]+/i)!=-1){return new Function(value);}else{return d.getObject(value,false)||new Function(value);}}catch(e){return new Function();}
case"array":return value?value.split(/\s*,\s*/):[];case"date":switch(value){case"":return new Date("");case"now":return new Date();default:return d.date.stamp.fromISOString(value);}
case"url":return d.baseUrl+value;default:return d.fromJson(value);}}
var instanceClasses={};dojo.connect(dojo,"extend",function(){instanceClasses={};});function getClassInfo(className){if(!instanceClasses[className]){var cls=d.getObject(className);if(!cls){return null;}
var proto=cls.prototype;var params={},dummyClass={};for(var name in proto){if(name.charAt(0)=="_"){continue;}
if(name in dummyClass){continue;}
var defVal=proto[name];params[name]=val2type(defVal);}
instanceClasses[className]={cls:cls,params:params};}
return instanceClasses[className];}
this._functionFromScript=function(script){var preamble="";var suffix="";var argsStr=script.getAttribute("args");if(argsStr){d.forEach(argsStr.split(/\s*,\s*/),function(part,idx){preamble+="var "+part+" = arguments["+idx+"]; ";});}
var withStr=script.getAttribute("with");if(withStr&&withStr.length){d.forEach(withStr.split(/\s*,\s*/),function(part){preamble+="with("+part+"){";suffix+="}";});}
return new Function(preamble+script.innerHTML+suffix);}
this.instantiate=function(nodes,mixin,args){var thelist=[],dp=dojo.parser;mixin=mixin||{};args=args||{};d.forEach(nodes,function(obj){if(!obj){return;}
var node,type,clsInfo,clazz,scripts;if(obj.node){node=obj.node;type=obj.type;clsInfo=obj.clsInfo||(type&&getClassInfo(type));clazz=clsInfo&&clsInfo.cls;scripts=obj.scripts;}else{node=obj;type=dp._attrName in mixin?mixin[dp._attrName]:node.getAttribute(dp._attrName);clsInfo=type&&getClassInfo(type);clazz=clsInfo&&clsInfo.cls;scripts=(clazz&&(clazz._noScript||clazz.prototype._noScript)?[]:d.query("> script[type^='dojo/']",node));}
if(!clsInfo){throw new Error("Could not load class '"+type);}
var params={},attributes=node.attributes;if(args.defaults){dojo.mixin(params,args.defaults);}
if(obj.inherited){dojo.mixin(params,obj.inherited);}
for(var name in clsInfo.params){var item=name in mixin?{value:mixin[name],specified:true}:attributes.getNamedItem(name);if(!item||(!item.specified&&(!dojo.isIE||name.toLowerCase()!="value"))){continue;}
var value=item.value;switch(name){case"class":value="className"in mixin?mixin.className:node.className;break;case"style":value="style"in mixin?mixin.style:(node.style&&node.style.cssText);}
var _type=clsInfo.params[name];if(typeof value=="string"){params[name]=str2obj(value,_type);}else{params[name]=value;}}
var connects=[],calls=[];d.forEach(scripts,function(script){node.removeChild(script);var event=script.getAttribute("event"),type=script.getAttribute("type"),nf=d.parser._functionFromScript(script);if(event){if(type=="dojo/connect"){connects.push({event:event,func:nf});}else{params[event]=nf;}}else{calls.push(nf);}});var markupFactory=clazz.markupFactory||clazz.prototype&&clazz.prototype.markupFactory;var instance=markupFactory?markupFactory(params,node,clazz):new clazz(params,node);thelist.push(instance);var jsname=node.getAttribute("jsId");if(jsname){d.setObject(jsname,instance);}
d.forEach(connects,function(connect){d.connect(instance,connect.event,null,connect.func);});d.forEach(calls,function(func){func.call(instance);});});if(!mixin._started){d.forEach(thelist,function(instance){if(!args.noStart&&instance&&instance.startup&&!instance._started&&(!instance.getParent||!instance.getParent())){instance.startup();}});}
return thelist;};this.parse=function(rootNode,args){var root;if(!args&&rootNode&&rootNode.rootNode){args=rootNode;root=args.rootNode;}else{root=rootNode;}
var attrName=this._attrName;function scan(parent,list){var inherited=dojo.clone(parent.inherited);dojo.forEach(["dir","lang"],function(name){var val=parent.node.getAttribute(name);if(val){inherited[name]=val;}});var scripts=parent.scripts;var recurse=!parent.clsInfo||!parent.clsInfo.cls.prototype.stopParser;for(var child=parent.node.firstChild;child;child=child.nextSibling){if(child.nodeType==1){var type=recurse&&child.getAttribute(attrName);if(type){var params={"type":type,clsInfo:getClassInfo(type),node:child,scripts:[],inherited:inherited};list.push(params);scan(params,list);}else if(scripts&&child.nodeName.toLowerCase()=="script"){type=child.getAttribute("type");if(type&&/^dojo\//i.test(type)){scripts.push(child);}}else if(recurse){scan({node:child,inherited:inherited},list);}}}}
var list=[];scan({node:root?dojo.byId(root):dojo.body(),inherited:(args&&args.inherited)||{dir:dojo._isBodyLtr()?"ltr":"rtl"}},list);return this.instantiate(list,null,args);};}();(function(){var parseRunner=function(){if(dojo.config.parseOnLoad){dojo.parser.parse();}};if(dojo.exists("dijit.wai.onload")&&(dijit.wai.onload===dojo._loaders[0])){dojo._loaders.splice(1,0,parseRunner);}else{dojo._loaders.unshift(parseRunner);}})();}
if(!dojo._hasResource["dojo.cache"]){dojo._hasResource["dojo.cache"]=true;dojo.provide("dojo.cache");(function(){var cache={};dojo.cache=function(module,url,value){if(typeof module=="string"){var pathObj=dojo.moduleUrl(module,url);}else{pathObj=module;value=url;}
var key=pathObj.toString();var val=value;if(value!=undefined&&!dojo.isString(value)){val=("value"in value?value.value:undefined);}
var sanitize=value&&value.sanitize?true:false;if(typeof val=="string"){val=cache[key]=sanitize?dojo.cache._sanitize(val):val;}else if(val===null){delete cache[key];}else{if(!(key in cache)){val=dojo._getText(key);cache[key]=sanitize?dojo.cache._sanitize(val):val;}
val=cache[key];}
return val;};dojo.cache._sanitize=function(val){if(val){val=val.replace(/^\s*<\?xml(\s)+version=[\'\"](\d)*.(\d)*[\'\"](\s)*\?>/im,"");var matches=val.match(/<body[^>]*>\s*([\s\S]+)\s*<\/body>/im);if(matches){val=matches[1];}}else{val="";}
return val;};})();}
if(!dojo._hasResource["dijit._Templated"]){dojo._hasResource["dijit._Templated"]=true;dojo.provide("dijit._Templated");dojo.declare("dijit._Templated",null,{templateString:null,templatePath:null,widgetsInTemplate:false,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){this._attachPoints=[];},_stringRepl:function(tmpl){var className=this.declaredClass,_this=this;return dojo.string.substitute(tmpl,this,function(value,key){if(key.charAt(0)=='!'){value=dojo.getObject(key.substr(1),false,_this);}
if(typeof value=="undefined"){throw new Error(className+" template:"+key);}
if(value==null){return"";}
return key.charAt(0)=="!"?value:value.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){var cached=dijit._Templated.getCachedTemplate(this.templatePath,this.templateString,this._skipNodeCache);var node;if(dojo.isString(cached)){node=dojo._toDom(this._stringRepl(cached));if(node.nodeType!=1){throw new Error("Invalid template: "+cached);}}else{node=cached.cloneNode(true);}
this.domNode=node;this._attachTemplateNodes(node);if(this.widgetsInTemplate){var parser=dojo.parser,qry,attr;if(parser._query!="[dojoType]"){qry=parser._query;attr=parser._attrName;parser._query="[dojoType]";parser._attrName="dojoType";}
var cw=(this._startupWidgets=dojo.parser.parse(node,{noStart:!this._earlyTemplatedStartup,inherited:{dir:this.dir,lang:this.lang}}));if(qry){parser._query=qry;parser._attrName=attr;}
this._supportingWidgets=dijit.findWidgets(node);this._attachTemplateNodes(cw,function(n,p){return n[p];});}
this._fillContent(this.srcNodeRef);},_fillContent:function(source){var dest=this.containerNode;if(source&&dest){while(source.hasChildNodes()){dest.appendChild(source.firstChild);}}},_attachTemplateNodes:function(rootNode,getAttrFunc){getAttrFunc=getAttrFunc||function(n,p){return n.getAttribute(p);};var nodes=dojo.isArray(rootNode)?rootNode:(rootNode.all||rootNode.getElementsByTagName("*"));var x=dojo.isArray(rootNode)?0:-1;for(;x<nodes.length;x++){var baseNode=(x==-1)?rootNode:nodes[x];if(this.widgetsInTemplate&&getAttrFunc(baseNode,"dojoType")){continue;}
var attachPoint=getAttrFunc(baseNode,"dojoAttachPoint");if(attachPoint){var point,points=attachPoint.split(/\s*,\s*/);while((point=points.shift())){if(dojo.isArray(this[point])){this[point].push(baseNode);}else{this[point]=baseNode;}
this._attachPoints.push(point);}}
var attachEvent=getAttrFunc(baseNode,"dojoAttachEvent");if(attachEvent){var event,events=attachEvent.split(/\s*,\s*/);var trim=dojo.trim;while((event=events.shift())){if(event){var thisFunc=null;if(event.indexOf(":")!=-1){var funcNameArr=event.split(":");event=trim(funcNameArr[0]);thisFunc=trim(funcNameArr[1]);}else{event=trim(event);}
if(!thisFunc){thisFunc=event;}
this.connect(baseNode,event,thisFunc);}}}
var role=getAttrFunc(baseNode,"waiRole");if(role){dijit.setWaiRole(baseNode,role);}
var values=getAttrFunc(baseNode,"waiState");if(values){dojo.forEach(values.split(/\s*,\s*/),function(stateValue){if(stateValue.indexOf('-')!=-1){var pair=stateValue.split('-');dijit.setWaiState(baseNode,pair[0],pair[1]);}});}}},startup:function(){dojo.forEach(this._startupWidgets,function(w){if(w&&!w._started&&w.startup){w.startup();}});this.inherited(arguments);},destroyRendering:function(){dojo.forEach(this._attachPoints,function(point){delete this[point];},this);this._attachPoints=[];this.inherited(arguments);}});dijit._Templated._templateCache={};dijit._Templated.getCachedTemplate=function(templatePath,templateString,alwaysUseString){var tmplts=dijit._Templated._templateCache;var key=templateString||templatePath;var cached=tmplts[key];if(cached){try{if(!cached.ownerDocument||cached.ownerDocument==dojo.doc){return cached;}}catch(e){}
dojo.destroy(cached);}
if(!templateString){templateString=dojo.cache(templatePath,{sanitize:true});}
templateString=dojo.string.trim(templateString);if(alwaysUseString||templateString.match(/\$\{([^\}]+)\}/g)){return(tmplts[key]=templateString);}else{var node=dojo._toDom(templateString);if(node.nodeType!=1){throw new Error("Invalid template: "+templateString);}
return(tmplts[key]=node);}};if(dojo.isIE){dojo.addOnWindowUnload(function(){var cache=dijit._Templated._templateCache;for(var key in cache){var value=cache[key];if(typeof value=="object"){dojo.destroy(value);}
delete cache[key];}});}
dojo.extend(dijit._Widget,{dojoAttachEvent:"",dojoAttachPoint:"",waiRole:"",waiState:""});}
if(!dojo._hasResource["dijit.Tooltip"]){dojo._hasResource["dijit.Tooltip"]=true;dojo.provide("dijit.Tooltip");dojo.declare("dijit._MasterTooltip",[dijit._Widget,dijit._Templated],{duration:dijit.defaultDuration,templateString:dojo.cache("dijit","templates/Tooltip.html","<div class=\"dijitTooltip dijitTooltipLeft\" id=\"dojoTooltip\">\n\t<div class=\"dijitTooltipContainer dijitTooltipContents\" dojoAttachPoint=\"containerNode\" waiRole='alert'></div>\n\t<div class=\"dijitTooltipConnector\"></div>\n</div>\n"),postCreate:function(){dojo.body().appendChild(this.domNode);this.bgIframe=new dijit.BackgroundIframe(this.domNode);this.fadeIn=dojo.fadeIn({node:this.domNode,duration:this.duration,onEnd:dojo.hitch(this,"_onShow")});this.fadeOut=dojo.fadeOut({node:this.domNode,duration:this.duration,onEnd:dojo.hitch(this,"_onHide")});},show:function(innerHTML,aroundNode,position,rtl){if(this.aroundNode&&this.aroundNode===aroundNode){return;}
if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}
this.containerNode.innerHTML=innerHTML;var pos=dijit.placeOnScreenAroundElement(this.domNode,aroundNode,dijit.getPopupAroundAlignment((position&&position.length)?position:dijit.Tooltip.defaultPosition,!rtl),dojo.hitch(this,"orient"));dojo.style(this.domNode,"opacity",0);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=aroundNode;},orient:function(node,aroundCorner,tooltipCorner){node.className="dijitTooltip "+
{"BL-TL":"dijitTooltipBelow"+"-"+this.connectorStyle+" dijitTooltipABLeft","TL-BL":"dijitTooltipAbove"+"-"+this.connectorStyle+" dijitTooltipABLeft","BR-TR":"dijitTooltipBelow"+"-"+this.connectorStyle+" dijitTooltipABRight","TR-BR":"dijitTooltipAbove"+"-"+this.connectorStyle+" dijitTooltipABRight","BR-BL":"dijitTooltipRight"+"-"+this.connectorStyle,"BL-BR":"dijitTooltipLeft"+"-"+this.connectorStyle}[aroundCorner+"-"+tooltipCorner];},_onShow:function(){if(dojo.isIE){this.domNode.style.filter="";}},hide:function(aroundNode){if(this._onDeck&&this._onDeck[1]==aroundNode){this._onDeck=null;}else if(this.aroundNode===aroundNode){this.fadeIn.stop();this.isShowingNow=false;this.aroundNode=null;this.fadeOut.play();}else{}},_onHide:function(){this.domNode.style.cssText="";this.containerNode.innerHTML="";if(this._onDeck){this.show.apply(this,this._onDeck);this._onDeck=null;}}});dijit.showTooltip=function(innerHTML,aroundNode,position,rtl){if(!dijit._masterTT){dijit._masterTT=new dijit._MasterTooltip();}
return dijit._masterTT.show(innerHTML,aroundNode,position,rtl);};dijit.hideTooltip=function(aroundNode){if(!dijit._masterTT){dijit._masterTT=new dijit._MasterTooltip();}
return dijit._masterTT.hide(aroundNode);};dojo.declare("dijit.Tooltip",dijit._Widget,{label:"",showDelay:400,connectId:[],position:[],constructor:function(){this._nodeConnectionsById={};},_setConnectIdAttr:function(newIds){for(var oldId in this._nodeConnectionsById){this.removeTarget(oldId);}
dojo.forEach(dojo.isArrayLike(newIds)?newIds:[newIds],this.addTarget,this);},_getConnectIdAttr:function(){var ary=[];for(var id in this._nodeConnectionsById){ary.push(id);}
return ary;},addTarget:function(id){var node=dojo.byId(id);if(!node){return;}
if(node.id in this._nodeConnectionsById){return;}
this._nodeConnectionsById[node.id]=[this.connect(node,"onmouseenter","_onTargetMouseEnter"),this.connect(node,"onmouseleave","_onTargetMouseLeave"),this.connect(node,"onfocus","_onTargetFocus"),this.connect(node,"onblur","_onTargetBlur")];},removeTarget:function(node){var id=node.id||node;if(id in this._nodeConnectionsById){dojo.forEach(this._nodeConnectionsById[id],this.disconnect,this);delete this._nodeConnectionsById[id];}},postCreate:function(){dojo.addClass(this.domNode,"dijitTooltipData");},startup:function(){this.inherited(arguments);var ids=this.connectId;dojo.forEach(dojo.isArrayLike(ids)?ids:[ids],this.addTarget,this);},_onTargetMouseEnter:function(e){this._onHover(e);},_onTargetMouseLeave:function(e){this._onUnHover(e);},_onTargetFocus:function(e){this._focus=true;this._onHover(e);},_onTargetBlur:function(e){this._focus=false;this._onUnHover(e);},_onHover:function(e){if(!this._showTimer){var target=e.target;this._showTimer=setTimeout(dojo.hitch(this,function(){this.open(target)}),this.showDelay);}},_onUnHover:function(e){if(this._focus){return;}
if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}
this.close();},open:function(target){if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}
dijit.showTooltip(this.label||this.domNode.innerHTML,target,this.position,!this.isLeftToRight());this._connectNode=target;this.onShow(target,this.position);},close:function(){if(this._connectNode){dijit.hideTooltip(this._connectNode);delete this._connectNode;this.onHide();}
if(this._showTimer){clearTimeout(this._showTimer);delete this._showTimer;}},onShow:function(target,position){},onHide:function(){},uninitialize:function(){this.close();this.inherited(arguments);}});dijit.Tooltip.defaultPosition=["after","before"];}
if(!dojo._hasResource["dojox.charting.action2d.Tooltip"]){dojo._hasResource["dojox.charting.action2d.Tooltip"]=true;dojo.provide("dojox.charting.action2d.Tooltip");(function(){var DEFAULT_TEXT=function(o){var t=o.run&&o.run.data&&o.run.data[o.index];if(t&&typeof t!="number"&&(t.tooltip||t.text)){return t.tooltip||t.text;}
if(o.element=="candlestick"){return'<table cellpadding="1" cellspacing="0" border="0" style="font-size:0.9em;">'
+'<tr><td>Open:</td><td align="right"><strong>'+o.data.open+'</strong></td></tr>'
+'<tr><td>High:</td><td align="right"><strong>'+o.data.high+'</strong></td></tr>'
+'<tr><td>Low:</td><td align="right"><strong>'+o.data.low+'</strong></td></tr>'
+'<tr><td>Close:</td><td align="right"><strong>'+o.data.close+'</strong></td></tr>'
+(o.data.mid!==undefined?'<tr><td>Mid:</td><td align="right"><strong>'+o.data.mid+'</strong></td></tr>':'')
+'</table>';}
return o.element=="bar"?o.x:o.y;};var df=dojox.lang.functional,m=dojox.gfx.matrix,pi4=Math.PI/4,pi2=Math.PI/2;dojo.declare("dojox.charting.action2d.Tooltip",dojox.charting.action2d.Base,{defaultParams:{text:DEFAULT_TEXT},optionalParams:{},constructor:function(chart,plot,kwArgs){this.text=kwArgs&&kwArgs.text?kwArgs.text:DEFAULT_TEXT;this.tooltipBorderColour=kwArgs.tooltipBorderColour
this.connectorStyle=kwArgs.connectorStyle
this.connect();},process:function(o){if(o.type==="onplotreset"||o.type==="onmouseout"){hideChartingTooltip(this.aroundRect);this.aroundRect=null;return;}
if(!o.shape||o.type!=="onmouseover"){return;}
var aroundRect={type:"rect"},position=["after","before"];switch(o.element){case"marker":aroundRect.x=o.cx;aroundRect.y=o.cy;aroundRect.width=aroundRect.height=1;break;case"circle":aroundRect.x=o.cx-o.cr;aroundRect.y=o.cy-o.cr;aroundRect.width=aroundRect.height=2*o.cr;break;case"column":position=["above","below"];case"bar":aroundRect=dojo.clone(o.shape.getShape());break;case"candlestick":aroundRect.x=o.x;aroundRect.y=o.y;aroundRect.width=o.width;aroundRect.height=o.height;break;default:if(!this.angles){if(typeof o.run.data[0]=="number"){this.angles=df.map(df.scanl(o.run.data,"+",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"+",0));}else{this.angles=df.map(df.scanl(o.run.data,"a + b.y",0),"* 2 * Math.PI / this",df.foldl(o.run.data,"a + b.y",0));}}
var startAngle=m._degToRad(o.plot.opt.startAngle),angle=(this.angles[o.index]+this.angles[o.index+1])/2+startAngle;aroundRect.x=o.cx+o.cr*Math.cos(angle);aroundRect.y=o.cy+o.cr*Math.sin(angle);aroundRect.width=aroundRect.height=1;if(angle<pi4){}else if(angle<pi2+pi4){position=["below","above"];}else if(angle<Math.PI+pi4){position=["before","after"];}else if(angle<2*Math.PI-pi4){position=["above","below"];}
break;}
var lt=dojo.coords(this.chart.node,true);aroundRect.x+=lt.x;aroundRect.y+=lt.y;aroundRect.x=Math.round(aroundRect.x);aroundRect.y=Math.round(aroundRect.y);aroundRect.width=Math.ceil(aroundRect.width);aroundRect.height=Math.ceil(aroundRect.height);this.aroundRect=aroundRect;showChartingTooltip(this.text(o),this.aroundRect,position,"center",this.tooltipBorderColour,this.connectorStyle);}});var MasterTooltip=dojo.declare(dijit._MasterTooltip,{show:function(innerHTML,aroundNode,position,alignment,tooltipBorderColour,connectorStyle){if(this.aroundNode&&this.aroundNode===aroundNode){return;}
if(this.fadeOut.status()=="playing"){this._onDeck=arguments;return;}
this.containerNode.innerHTML=innerHTML;this.domNode.style.top=(this.domNode.offsetTop+1)+"px";if(!this.connectorNode)this.connectorNode=dojo.query(".dijitTooltipConnector",this.domNode)[0];var connectorPos=dojo.coords(this.connectorNode);this.arrowWidth=connectorPos.w,this.arrowHeight=connectorPos.h;this.connectorStyle=connectorStyle
this.place=(alignment&&alignment=="center")?this.placeChartingTooltip:dijit.placeOnScreenAroundElement,this.place(this.domNode,aroundNode,dijit.getPopupAroundAlignment((position&&position.length)?position:dijit.Tooltip.defaultPosition,this.isLeftToRight()),dojo.hitch(this,"orient"));dojo.style(this.domNode,"opacity",0);dojo.style(this.containerNode,"borderColor",tooltipBorderColour);this.fadeIn.play();this.isShowingNow=true;this.aroundNode=aroundNode;},placeChartingTooltip:function(node,aroundRect,aroundCorners,layoutNode){return this._placeOnScreenAroundRect(node,aroundRect.x,aroundRect.y,aroundRect.width,aroundRect.height,aroundCorners,layoutNode);},_placeOnScreenAroundRect:function(node,x,y,width,height,aroundCorners,layoutNode){var choices=[];for(var nodeCorner in aroundCorners){choices.push({aroundCorner:nodeCorner,corner:aroundCorners[nodeCorner],pos:{x:x+(nodeCorner.charAt(1)=='L'?0:width),y:y+(nodeCorner.charAt(0)=='T'?0:height),w:width,h:height}});}
return this._place(node,choices,layoutNode);},_place:function(node,choices,layoutNode){var view=dijit.getViewport();if(!node.parentNode||String(node.parentNode.tagName).toLowerCase()!="body"){dojo.body().appendChild(node);}
var best=null;var arrowLeft=null,arrowTop=null;dojo.some(choices,function(choice){var corner=choice.corner;var aroundCorner=choice.aroundCorner;var pos=choice.pos;if(layoutNode){layoutNode(node,choice.aroundCorner,corner);}
var style=node.style;var oldDisplay=style.display;var oldVis=style.visibility;style.visibility="hidden";style.display="";var mb=dojo.marginBox(node);style.display=oldDisplay;style.visibility=oldVis;var startX,startY,endX,endY,width,height,overflow;arrowLeft=null,arrowTop=null;if(aroundCorner.charAt(0)==corner.charAt(0)){startX=(corner.charAt(1)=='L'?pos.x:Math.max(view.l,pos.x-mb.w)),startY=(corner.charAt(0)=='T'?(pos.y+pos.h/2-mb.h/2):(pos.y-pos.h/2-mb.h/2)),endX=(corner.charAt(1)=='L'?Math.min(view.l+view.w,startX+mb.w):pos.x),endY=startY+mb.h,width=endX-startX,height=endY-startY,overflow=(mb.w-width)+(mb.h-height);arrowTop=(mb.h-this.arrowHeight)/2;}
else{startX=(corner.charAt(1)=='L'?(pos.x+pos.w/2-mb.w/2):(pos.x-pos.w/2-mb.w/2)),startY=(corner.charAt(0)=='T'?pos.y:Math.max(view.t,pos.y-mb.h)),endX=startX+mb.w,endY=(corner.charAt(0)=='T'?Math.min(view.t+view.h,startY+mb.h):pos.y),width=endX-startX,height=endY-startY,overflow=(mb.w-width)+(mb.h-height);arrowLeft=(mb.w-this.arrowWidth)/2;}
if(best==null||overflow<best.overflow){best={corner:corner,aroundCorner:choice.aroundCorner,x:startX,y:startY,w:width,h:height,overflow:overflow};}
return!overflow;},this);node.style.left=best.x+"px";node.style.top=best.y+"px";this.connectorNode.style.top="";this.connectorNode.style.left="";if(arrowTop){this.connectorNode.style.top=arrowTop+"px";}
if(arrowLeft){this.connectorNode.style.left=arrowLeft+"px";}
if(best.overflow&&layoutNode){layoutNode(node,best.aroundCorner,best.corner);}
return best;}});var masterTT=null;function showChartingTooltip(innerHTML,aroundNode,position,alignment,tooltipBorderColour,connectorStyle){if(!masterTT){masterTT=new MasterTooltip();}
return masterTT.show(innerHTML,aroundNode,position,alignment,tooltipBorderColour,connectorStyle);}
function hideChartingTooltip(aroundNode){if(!masterTT){masterTT=new MasterTooltip();}
return masterTT.hide(aroundNode);}})();}
if(!dojo._hasResource["dojox.charting.widget.Legend"]){dojo._hasResource["dojox.charting.widget.Legend"]=true;dojo.provide("dojox.charting.widget.Legend");dojo.declare("dojox.charting.widget.Legend",[dijit._Widget,dijit._Templated],{chartRef:"",horizontal:true,swatchSize:18,templateString:"<table dojoAttachPoint='legendNode' class='dojoxLegendNode'><tbody dojoAttachPoint='legendBody'></tbody></table>",legendNode:null,legendBody:null,postCreate:function(){if(!this.chart){if(!this.chartRef){return;}
this.chart=dijit.byId(this.chartRef);if(!this.chart){var node=dojo.byId(this.chartRef);if(node){this.chart=dijit.byNode(node);}else{console.log("Could not find chart instance with id: "+this.chartRef);return;}}
this.series=this.chart.chart.series;}else{this.series=this.chart.series;}
this.refresh();},refresh:function(){var df=dojox.lang.functional;if(this._surfaces){dojo.forEach(this._surfaces,function(surface){surface.destroy();});}
this._surfaces=[];while(this.legendBody.lastChild){dojo.destroy(this.legendBody.lastChild);}
if(this.horizontal){dojo.addClass(this.legendNode,"dojoxLegendHorizontal");this._tr=dojo.doc.createElement("tr");this.legendBody.appendChild(this._tr);this._inrow=0;}
var s=this.series;if(s.length==0){return;}
if(s[0].chart.stack[0].declaredClass=="dojox.charting.plot2d.Pie"){var t=s[0].chart.stack[0];if(typeof t.run.data[0]=="number"){var filteredRun=df.map(t.run.data,"Math.max(x, 0)");if(df.every(filteredRun,"<= 0")){return;}
var slices=df.map(filteredRun,"/this",df.foldl(filteredRun,"+",0));dojo.forEach(slices,function(x,i){this._addLabel(t.dyn[i],t._getLabel(x*100)+"%");},this);}else{dojo.forEach(t.run.data,function(x,i){this._addLabel(t.dyn[i],x.legend||x.text||x.y);},this);}}else{dojo.forEach(s,function(x){this._addLabel(x.dyn,x.legend||x.name);},this);}},_addLabel:function(dyn,label){var icon=dojo.doc.createElement("td"),text=dojo.doc.createElement("td"),div=dojo.doc.createElement("div");dojo.addClass(icon,"dojoxLegendIcon");dojo.addClass(text,"dojoxLegendText");div.style.width=this.swatchSize+"px";div.style.height=this.swatchSize+"px";icon.appendChild(div);if(this._tr){this._tr.appendChild(icon);this._tr.appendChild(text);if(++this._inrow===this.horizontal){this._tr=dojo.doc.createElement("tr");this.legendBody.appendChild(this._tr);this._inrow=0;}}else{var tr=dojo.doc.createElement("tr");this.legendBody.appendChild(tr);tr.appendChild(icon);tr.appendChild(text);}
this._makeIcon(div,dyn);text.innerHTML=String(label);},_makeIcon:function(div,dyn){var mb={h:this.swatchSize,w:this.swatchSize};var surface=dojox.gfx.createSurface(div,mb.w,mb.h);this._surfaces.push(surface);if(dyn.fill){surface.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setFill(dyn.fill).setStroke(dyn.stroke);}else if(dyn.stroke||dyn.marker){var line={x1:0,y1:mb.h/2,x2:mb.w,y2:mb.h/2};if(dyn.stroke){surface.createLine(line).setStroke(dyn.stroke);}
if(dyn.marker){var c={x:mb.w/2,y:mb.h/2};if(dyn.stroke){surface.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.stroke.color).setStroke(dyn.stroke);}else{surface.createPath({path:"M"+c.x+" "+c.y+" "+dyn.marker}).setFill(dyn.color).setStroke(dyn.color);}}}else{surface.createRect({x:2,y:2,width:mb.w-4,height:mb.h-4}).setStroke("black");surface.createLine({x1:2,y1:2,x2:mb.w-2,y2:mb.h-2}).setStroke("black");surface.createLine({x1:2,y1:mb.h-2,x2:mb.w-2,y2:2}).setStroke("black");}}});}
if(!dojo._hasResource["dojox.gfx.shape"]){dojo._hasResource["dojox.gfx.shape"]=true;dojo.provide("dojox.gfx.shape");dojo.declare("dojox.gfx.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}
var m=this._getRealMatrix();gm=dojox.gfx.matrix;return[gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setShape:function(shape){this.shape=dojox.gfx.makeParameters(this.shape,shape);this.bbox=null;return this;},setFill:function(fill){if(!fill){this.fillStyle=null;return this;}
var f=null;if(typeof(fill)=="object"&&"type"in fill){switch(fill.type){case"linear":f=dojox.gfx.makeParameters(dojox.gfx.defaultLinearGradient,fill);break;case"radial":f=dojox.gfx.makeParameters(dojox.gfx.defaultRadialGradient,fill);break;case"pattern":f=dojox.gfx.makeParameters(dojox.gfx.defaultPattern,fill);break;}}else{f=dojox.gfx.normalizeColor(fill);}
this.fillStyle=f;return this;},setStroke:function(stroke){if(!stroke){this.strokeStyle=null;return this;}
if(typeof stroke=="string"||dojo.isArray(stroke)||stroke instanceof dojo.Color){stroke={color:stroke};}
var s=this.strokeStyle=dojox.gfx.makeParameters(dojox.gfx.defaultStroke,stroke);s.color=dojox.gfx.normalizeColor(s.color);return this;},setTransform:function(matrix){this.matrix=dojox.gfx.matrix.clone(matrix?dojox.gfx.matrix.normalize(matrix):dojox.gfx.matrix.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}
return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}
return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(matrix){return matrix?this.setTransform([this.matrix,matrix]):this;},applyLeftTransform:function(matrix){return matrix?this.setTransform([matrix,this.matrix]):this;},applyTransform:function(matrix){return matrix?this.setTransform([this.matrix,matrix]):this;},removeShape:function(silently){if(this.parent){this.parent.remove(this,silently);}
return this;},_setParent:function(parent,matrix){this.parent=parent;return this._updateParentMatrix(matrix);},_updateParentMatrix:function(matrix){this.parentMatrix=matrix?dojox.gfx.matrix.clone(matrix):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=dojox.gfx.matrix.multiply(p.matrix,m);}
p=p.parent;}
return m;}});dojox.gfx.shape._eventsProcessing={connect:function(name,object,method){return arguments.length>2?dojo.connect(this.getEventSource(),name,object,method):dojo.connect(this.getEventSource(),name,object);},disconnect:function(token){dojo.disconnect(token);}};dojo.extend(dojox.gfx.Shape,dojox.gfx.shape._eventsProcessing);dojox.gfx.shape.Container={_init:function(){this.children=[];},openBatch:function(){},closeBatch:function(){},add:function(shape){var oldParent=shape.getParent();if(oldParent){oldParent.remove(shape,true);}
this.children.push(shape);return shape._setParent(this,this._getRealMatrix());},remove:function(shape,silently){for(var i=0;i<this.children.length;++i){if(this.children[i]==shape){if(silently){}else{shape.parent=null;shape.parentMatrix=null;}
this.children.splice(i,1);break;}}
return this;},clear:function(){this.children=[];return this;},_moveChildToFront:function(shape){for(var i=0;i<this.children.length;++i){if(this.children[i]==shape){this.children.splice(i,1);this.children.push(shape);break;}}
return this;},_moveChildToBack:function(shape){for(var i=0;i<this.children.length;++i){if(this.children[i]==shape){this.children.splice(i,1);this.children.unshift(shape);break;}}
return this;}};dojo.declare("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){dojo.forEach(this._nodes,dojo.destroy);this._nodes=[];dojo.forEach(this._events,dojo.disconnect);this._events=[];this.rawNode=null;if(dojo.isIE){while(this._parent.lastChild){dojo.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}
this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(surface){},whenLoaded:function(context,method){var f=dojo.hitch(context,method);if(this.isLoaded){f(this);}else{var h=dojo.connect(this,"onLoad",function(surface){dojo.disconnect(h);f(surface);});}}});dojo.extend(dojox.gfx.shape.Surface,dojox.gfx.shape._eventsProcessing);dojo.declare("dojox.gfx.Point",null,{});dojo.declare("dojox.gfx.Rectangle",null,{});dojo.declare("dojox.gfx.shape.Rect",dojox.gfx.Shape,{constructor:function(rawNode){this.shape=dojox.gfx.getDefault("Rect");this.rawNode=rawNode;},getBoundingBox:function(){return this.shape;}});dojo.declare("dojox.gfx.shape.Ellipse",dojox.gfx.Shape,{constructor:function(rawNode){this.shape=dojox.gfx.getDefault("Ellipse");this.rawNode=rawNode;},getBoundingBox:function(){if(!this.bbox){var shape=this.shape;this.bbox={x:shape.cx-shape.rx,y:shape.cy-shape.ry,width:2*shape.rx,height:2*shape.ry};}
return this.bbox;}});dojo.declare("dojox.gfx.shape.Circle",dojox.gfx.Shape,{constructor:function(rawNode){this.shape=dojox.gfx.getDefault("Circle");this.rawNode=rawNode;},getBoundingBox:function(){if(!this.bbox){var shape=this.shape;this.bbox={x:shape.cx-shape.r,y:shape.cy-shape.r,width:2*shape.r,height:2*shape.r};}
return this.bbox;}});dojo.declare("dojox.gfx.shape.Line",dojox.gfx.Shape,{constructor:function(rawNode){this.shape=dojox.gfx.getDefault("Line");this.rawNode=rawNode;},getBoundingBox:function(){if(!this.bbox){var shape=this.shape;this.bbox={x:Math.min(shape.x1,shape.x2),y:Math.min(shape.y1,shape.y2),width:Math.abs(shape.x2-shape.x1),height:Math.abs(shape.y2-shape.y1)};}
return this.bbox;}});dojo.declare("dojox.gfx.shape.Polyline",dojox.gfx.Shape,{constructor:function(rawNode){this.shape=dojox.gfx.getDefault("Polyline");this.rawNode=rawNode;},setShape:function(points,closed){if(points&&points instanceof Array){dojox.gfx.Shape.prototype.setShape.call(this,{points:points});if(closed&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{dojox.gfx.Shape.prototype.setShape.call(this,points);}
return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var points=[];for(var i=0;i<l;i+=2){points.push({x:p[i],y:p[i+1]});}
this.shape.points=points;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var bbox={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(bbox.l>t.x)bbox.l=t.x;if(bbox.r<t.x)bbox.r=t.x;if(bbox.t>t.y)bbox.t=t.y;if(bbox.b<t.y)bbox.b=t.y;}
this.bbox={x:bbox.l,y:bbox.t,width:bbox.r-bbox.l,height:bbox.b-bbox.t};}
return this.bbox;}});dojo.declare("dojox.gfx.shape.Image",dojox.gfx.Shape,{constructor:function(rawNode){this.shape=dojox.gfx.getDefault("Image");this.rawNode=rawNode;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});dojo.declare("dojox.gfx.shape.Text",dojox.gfx.Shape,{constructor:function(rawNode){this.fontStyle=null;this.shape=dojox.gfx.getDefault("Text");this.rawNode=rawNode;},getFont:function(){return this.fontStyle;},setFont:function(newFont){this.fontStyle=typeof newFont=="string"?dojox.gfx.splitFontString(newFont):dojox.gfx.makeParameters(dojox.gfx.defaultFont,newFont);this._setFont();return this;}});dojox.gfx.shape.Creator={createShape:function(shape){var gfx=dojox.gfx;switch(shape.type){case gfx.defaultPath.type:return this.createPath(shape);case gfx.defaultRect.type:return this.createRect(shape);case gfx.defaultCircle.type:return this.createCircle(shape);case gfx.defaultEllipse.type:return this.createEllipse(shape);case gfx.defaultLine.type:return this.createLine(shape);case gfx.defaultPolyline.type:return this.createPolyline(shape);case gfx.defaultImage.type:return this.createImage(shape);case gfx.defaultText.type:return this.createText(shape);case gfx.defaultTextPath.type:return this.createTextPath(shape);}
return null;},createGroup:function(){return this.createObject(dojox.gfx.Group);},createRect:function(rect){return this.createObject(dojox.gfx.Rect,rect);},createEllipse:function(ellipse){return this.createObject(dojox.gfx.Ellipse,ellipse);},createCircle:function(circle){return this.createObject(dojox.gfx.Circle,circle);},createLine:function(line){return this.createObject(dojox.gfx.Line,line);},createPolyline:function(points){return this.createObject(dojox.gfx.Polyline,points);},createImage:function(image){return this.createObject(dojox.gfx.Image,image);},createText:function(text){return this.createObject(dojox.gfx.Text,text);},createPath:function(path){return this.createObject(dojox.gfx.Path,path);},createTextPath:function(text){return this.createObject(dojox.gfx.TextPath,{}).setText(text);},createObject:function(shapeType,rawShape){return null;}};}
if(!dojo._hasResource["dojox.gfx.path"]){dojo._hasResource["dojox.gfx.path"]=true;dojo.provide("dojox.gfx.path");dojo.declare("dojox.gfx.path.Path",dojox.gfx.Shape,{constructor:function(rawNode){this.shape=dojo.clone(dojox.gfx.defaultPath);this.segments=[];this.tbbox=null;this.absolute=true;this.last={};this.rawNode=rawNode;this.segmented=false;},setAbsoluteMode:function(mode){this._confirmSegmented();this.absolute=typeof mode=="string"?(mode=="absolute"):mode;return this;},getAbsoluteMode:function(){this._confirmSegmented();return this.absolute;},getBoundingBox:function(){this._confirmSegmented();return(this.bbox&&("l"in this.bbox))?{x:this.bbox.l,y:this.bbox.t,width:this.bbox.r-this.bbox.l,height:this.bbox.b-this.bbox.t}:null;},_getRealBBox:function(){this._confirmSegmented();if(this.tbbox){return this.tbbox;}
var bbox=this.bbox,matrix=this._getRealMatrix();this.bbox=null;for(var i=0,len=this.segments.length;i<len;++i){this._updateWithSegment(this.segments[i],matrix);}
var t=this.bbox;this.bbox=bbox;this.tbbox=t?[{x:t.l,y:t.t},{x:t.r,y:t.t},{x:t.r,y:t.b},{x:t.l,y:t.b}]:null;return this.tbbox;},getLastPosition:function(){this._confirmSegmented();return"x"in this.last?this.last:null;},_applyTransform:function(){this.tbbox=null;return dojox.gfx.Shape.prototype._applyTransform.call(this);},_updateBBox:function(x,y,matrix){if(matrix){var t=dojox.gfx.matrix.multiplyPoint(matrix,x,y);x=t.x;y=t.y;}
if(this.bbox&&("l"in this.bbox)){if(this.bbox.l>x)this.bbox.l=x;if(this.bbox.r<x)this.bbox.r=x;if(this.bbox.t>y)this.bbox.t=y;if(this.bbox.b<y)this.bbox.b=y;}else{this.bbox={l:x,b:y,r:x,t:y};}},_updateWithSegment:function(segment,matrix){var n=segment.args,l=n.length;switch(segment.action){case"M":case"L":case"C":case"S":case"Q":case"T":for(var i=0;i<l;i+=2){this._updateBBox(n[i],n[i+1],matrix);}
this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case"H":for(var i=0;i<l;++i){this._updateBBox(n[i],this.last.y,matrix);}
this.last.x=n[l-1];this.absolute=true;break;case"V":for(var i=0;i<l;++i){this._updateBBox(this.last.x,n[i],matrix);}
this.last.y=n[l-1];this.absolute=true;break;case"m":var start=0;if(!("x"in this.last)){this._updateBBox(this.last.x=n[0],this.last.y=n[1],matrix);start=2;}
for(var i=start;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],matrix);}
this.absolute=false;break;case"l":case"t":for(var i=0;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],matrix);}
this.absolute=false;break;case"h":for(var i=0;i<l;++i){this._updateBBox(this.last.x+=n[i],this.last.y,matrix);}
this.absolute=false;break;case"v":for(var i=0;i<l;++i){this._updateBBox(this.last.x,this.last.y+=n[i],matrix);}
this.absolute=false;break;case"c":for(var i=0;i<l;i+=6){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],matrix);this._updateBBox(this.last.x+n[i+2],this.last.y+n[i+3],matrix);this._updateBBox(this.last.x+=n[i+4],this.last.y+=n[i+5],matrix);}
this.absolute=false;break;case"s":case"q":for(var i=0;i<l;i+=4){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],matrix);this._updateBBox(this.last.x+=n[i+2],this.last.y+=n[i+3],matrix);}
this.absolute=false;break;case"A":for(var i=0;i<l;i+=7){this._updateBBox(n[i+5],n[i+6],matrix);}
this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case"a":for(var i=0;i<l;i+=7){this._updateBBox(this.last.x+=n[i+5],this.last.y+=n[i+6],matrix);}
this.absolute=false;break;}
var path=[segment.action];for(var i=0;i<l;++i){path.push(dojox.gfx.formatNumber(n[i],true));}
if(typeof this.shape.path=="string"){this.shape.path+=path.join("");}else{Array.prototype.push.apply(this.shape.path,path);}},_validSegments:{m:2,l:2,h:1,v:1,c:6,s:4,q:4,t:2,a:7,z:0},_pushSegment:function(action,args){this.tbbox=null;var group=this._validSegments[action.toLowerCase()];if(typeof group=="number"){if(group){if(args.length>=group){var segment={action:action,args:args.slice(0,args.length-args.length%group)};this.segments.push(segment);this._updateWithSegment(segment);}}else{var segment={action:action,args:[]};this.segments.push(segment);this._updateWithSegment(segment);}}},_collectArgs:function(array,args){for(var i=0;i<args.length;++i){var t=args[i];if(typeof t=="boolean"){array.push(t?1:0);}else if(typeof t=="number"){array.push(t);}else if(t instanceof Array){this._collectArgs(array,t);}else if("x"in t&&"y"in t){array.push(t.x,t.y);}}},moveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"M":"m",args);return this;},lineTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"L":"l",args);return this;},hLineTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"H":"h",args);return this;},vLineTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"V":"v",args);return this;},curveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"C":"c",args);return this;},smoothCurveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"S":"s",args);return this;},qCurveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"Q":"q",args);return this;},qSmoothCurveTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"T":"t",args);return this;},arcTo:function(){this._confirmSegmented();var args=[];this._collectArgs(args,arguments);this._pushSegment(this.absolute?"A":"a",args);return this;},closePath:function(){this._confirmSegmented();this._pushSegment("Z",[]);return this;},_confirmSegmented:function(){if(!this.segmented){var path=this.shape.path;this.shape.path=[];this._setPath(path);this.shape.path=this.shape.path.join("");this.segmented=true;}},_setPath:function(path){var p=dojo.isArray(path)?path:path.match(dojox.gfx.pathSvgRegExp);this.segments=[];this.absolute=true;this.bbox={};this.last={};if(!p)return;var action="",args=[],l=p.length;for(var i=0;i<l;++i){var t=p[i],x=parseFloat(t);if(isNaN(x)){if(action){this._pushSegment(action,args);}
args=[];action=t;}else{args.push(x);}}
this._pushSegment(action,args);},setShape:function(newShape){dojox.gfx.Shape.prototype.setShape.call(this,typeof newShape=="string"?{path:newShape}:newShape);this.segmented=false;this.segments=[];if(!dojox.gfx.lazyPathSegmentation){this._confirmSegmented();}
return this;},_2PI:Math.PI*2});dojo.declare("dojox.gfx.path.TextPath",dojox.gfx.path.Path,{constructor:function(rawNode){if(!("text"in this)){this.text=dojo.clone(dojox.gfx.defaultTextPath);}
if(!("fontStyle"in this)){this.fontStyle=dojo.clone(dojox.gfx.defaultFont);}},getText:function(){return this.text;},setText:function(newText){this.text=dojox.gfx.makeParameters(this.text,typeof newText=="string"?{text:newText}:newText);this._setText();return this;},getFont:function(){return this.fontStyle;},setFont:function(newFont){this.fontStyle=typeof newFont=="string"?dojox.gfx.splitFontString(newFont):dojox.gfx.makeParameters(dojox.gfx.defaultFont,newFont);this._setFont();return this;}});}
if(!dojo._hasResource["dojox.gfx.svg"]){dojo._hasResource["dojox.gfx.svg"]=true;dojo.provide("dojox.gfx.svg");(function(){var d=dojo,g=dojox.gfx,gs=g.shape,svg=g.svg;svg.useSvgWeb=(typeof(window.svgweb)!=='undefined');var _createElementNS=function(ns,nodeType){if(dojo.doc.createElementNS){return dojo.doc.createElementNS(ns,nodeType);}else{return dojo.doc.createElement(nodeType);}}
var _createTextNode=function(text){if(svg.useSvgWeb){return dojo.doc.createTextNode(text,true);}else{return dojo.doc.createTextNode(text);}}
var _createFragment=function(){if(svg.useSvgWeb){return dojo.doc.createDocumentFragment(true);}else{return dojo.doc.createDocumentFragment();}}
svg.xmlns={xlink:"http://www.w3.org/1999/xlink",svg:"http://www.w3.org/2000/svg"};svg.getRef=function(name){if(!name||name=="none")return null;if(name.match(/^url\(#.+\)$/)){return d.byId(name.slice(5,-1));}
if(name.match(/^#dojoUnique\d+$/)){return d.byId(name.slice(1));}
return null;};svg.dasharray={solid:"none",shortdash:[4,1],shortdot:[1,1],shortdashdot:[4,1,1,1],shortdashdotdot:[4,1,1,1,1,1],dot:[1,3],dash:[4,3],longdash:[8,3],dashdot:[4,3,1,3],longdashdot:[8,3,1,3],longdashdotdot:[8,3,1,3,1,3]};d.extend(g.Shape,{setFill:function(fill){if(!fill){this.fillStyle=null;this.rawNode.setAttribute("fill","none");this.rawNode.setAttribute("fill-opacity",0);return this;}
var f;var setter=function(x){this.setAttribute(x,f[x].toFixed(8));};if(typeof(fill)=="object"&&"type"in fill){switch(fill.type){case"linear":f=g.makeParameters(g.defaultLinearGradient,fill);var gradient=this._setFillObject(f,"linearGradient");d.forEach(["x1","y1","x2","y2"],setter,gradient);break;case"radial":f=g.makeParameters(g.defaultRadialGradient,fill);var gradient=this._setFillObject(f,"radialGradient");d.forEach(["cx","cy","r"],setter,gradient);break;case"pattern":f=g.makeParameters(g.defaultPattern,fill);var pattern=this._setFillObject(f,"pattern");d.forEach(["x","y","width","height"],setter,pattern);break;}
this.fillStyle=f;return this;}
var f=g.normalizeColor(fill);this.fillStyle=f;this.rawNode.setAttribute("fill",f.toCss());this.rawNode.setAttribute("fill-opacity",f.a);this.rawNode.setAttribute("fill-rule","evenodd");return this;},setStroke:function(stroke){var rn=this.rawNode;if(!stroke){this.strokeStyle=null;rn.setAttribute("stroke","none");rn.setAttribute("stroke-opacity",0);return this;}
if(typeof stroke=="string"||d.isArray(stroke)||stroke instanceof d.Color){stroke={color:stroke};}
var s=this.strokeStyle=g.makeParameters(g.defaultStroke,stroke);s.color=g.normalizeColor(s.color);if(s){rn.setAttribute("stroke",s.color.toCss());rn.setAttribute("stroke-opacity",s.color.a);rn.setAttribute("stroke-width",s.width);rn.setAttribute("stroke-linecap",s.cap);if(typeof s.join=="number"){rn.setAttribute("stroke-linejoin","miter");rn.setAttribute("stroke-miterlimit",s.join);}else{rn.setAttribute("stroke-linejoin",s.join);}
var da=s.style.toLowerCase();if(da in svg.dasharray){da=svg.dasharray[da];}
if(da instanceof Array){da=d._toArray(da);for(var i=0;i<da.length;++i){da[i]*=s.width;}
if(s.cap!="butt"){for(var i=0;i<da.length;i+=2){da[i]-=s.width;if(da[i]<1){da[i]=1;}}
for(var i=1;i<da.length;i+=2){da[i]+=s.width;}}
da=da.join(",");}
rn.setAttribute("stroke-dasharray",da);rn.setAttribute("dojoGfxStrokeStyle",s.style);}
return this;},_getParentSurface:function(){var surface=this.parent;for(;surface&&!(surface instanceof g.Surface);surface=surface.parent);return surface;},_setFillObject:function(f,nodeType){var svgns=svg.xmlns.svg;this.fillStyle=f;var surface=this._getParentSurface(),defs=surface.defNode,fill=this.rawNode.getAttribute("fill"),ref=svg.getRef(fill);if(ref){fill=ref;if(fill.tagName.toLowerCase()!=nodeType.toLowerCase()){var id=fill.id;fill.parentNode.removeChild(fill);fill=_createElementNS(svgns,nodeType);fill.setAttribute("id",id);defs.appendChild(fill);}else{while(fill.childNodes.length){fill.removeChild(fill.lastChild);}}}else{fill=_createElementNS(svgns,nodeType);fill.setAttribute("id",g._base._getUniqueId());defs.appendChild(fill);}
if(nodeType=="pattern"){fill.setAttribute("patternUnits","userSpaceOnUse");var img=_createElementNS(svgns,"image");img.setAttribute("x",0);img.setAttribute("y",0);img.setAttribute("width",f.width.toFixed(8));img.setAttribute("height",f.height.toFixed(8));img.setAttributeNS(svg.xmlns.xlink,"xlink:href",f.src);fill.appendChild(img);}else{fill.setAttribute("gradientUnits","userSpaceOnUse");for(var i=0;i<f.colors.length;++i){var c=f.colors[i],t=_createElementNS(svgns,"stop"),cc=c.color=g.normalizeColor(c.color);t.setAttribute("offset",c.offset.toFixed(8));t.setAttribute("stop-color",cc.toCss());t.setAttribute("stop-opacity",cc.a);fill.appendChild(t);}}
this.rawNode.setAttribute("fill","url(#"+fill.getAttribute("id")+")");this.rawNode.removeAttribute("fill-opacity");this.rawNode.setAttribute("fill-rule","evenodd");return fill;},_applyTransform:function(){var matrix=this.matrix;if(matrix){var tm=this.matrix;this.rawNode.setAttribute("transform","matrix("+
tm.xx.toFixed(8)+","+tm.yx.toFixed(8)+","+
tm.xy.toFixed(8)+","+tm.yy.toFixed(8)+","+
tm.dx.toFixed(8)+","+tm.dy.toFixed(8)+")");}else{this.rawNode.removeAttribute("transform");}
return this;},setRawNode:function(rawNode){var r=this.rawNode=rawNode;if(this.shape.type!="image"){r.setAttribute("fill","none");}
r.setAttribute("fill-opacity",0);r.setAttribute("stroke","none");r.setAttribute("stroke-opacity",0);r.setAttribute("stroke-width",1);r.setAttribute("stroke-linecap","butt");r.setAttribute("stroke-linejoin","miter");r.setAttribute("stroke-miterlimit",4);},setShape:function(newShape){this.shape=g.makeParameters(this.shape,newShape);for(var i in this.shape){if(i!="type"){this.rawNode.setAttribute(i,this.shape[i]);}}
this.bbox=null;return this;},_moveToFront:function(){this.rawNode.parentNode.appendChild(this.rawNode);return this;},_moveToBack:function(){this.rawNode.parentNode.insertBefore(this.rawNode,this.rawNode.parentNode.firstChild);return this;}});dojo.declare("dojox.gfx.Group",g.Shape,{constructor:function(){svg.Container._init.call(this);},setRawNode:function(rawNode){this.rawNode=rawNode;}});g.Group.nodeType="g";dojo.declare("dojox.gfx.Rect",gs.Rect,{setShape:function(newShape){this.shape=g.makeParameters(this.shape,newShape);this.bbox=null;for(var i in this.shape){if(i!="type"&&i!="r"){this.rawNode.setAttribute(i,this.shape[i]);}}
if(this.shape.r){this.rawNode.setAttribute("ry",this.shape.r);this.rawNode.setAttribute("rx",this.shape.r);}
return this;}});g.Rect.nodeType="rect";g.Ellipse=gs.Ellipse;g.Ellipse.nodeType="ellipse";g.Circle=gs.Circle;g.Circle.nodeType="circle";g.Line=gs.Line;g.Line.nodeType="line";dojo.declare("dojox.gfx.Polyline",gs.Polyline,{setShape:function(points,closed){if(points&&points instanceof Array){this.shape=g.makeParameters(this.shape,{points:points});if(closed&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.shape=g.makeParameters(this.shape,points);}
this.bbox=null;this._normalizePoints();var attr=[],p=this.shape.points;for(var i=0;i<p.length;++i){attr.push(p[i].x.toFixed(8),p[i].y.toFixed(8));}
this.rawNode.setAttribute("points",attr.join(" "));return this;}});g.Polyline.nodeType="polyline";dojo.declare("dojox.gfx.Image",gs.Image,{setShape:function(newShape){this.shape=g.makeParameters(this.shape,newShape);this.bbox=null;var rawNode=this.rawNode;for(var i in this.shape){if(i!="type"&&i!="src"){rawNode.setAttribute(i,this.shape[i]);}}
rawNode.setAttribute("preserveAspectRatio","none");rawNode.setAttributeNS(svg.xmlns.xlink,"xlink:href",this.shape.src);return this;}});g.Image.nodeType="image";dojo.declare("dojox.gfx.Text",gs.Text,{setShape:function(newShape){this.shape=g.makeParameters(this.shape,newShape);this.bbox=null;var r=this.rawNode,s=this.shape;r.setAttribute("x",s.x);r.setAttribute("y",s.y);r.setAttribute("text-anchor",s.align);r.setAttribute("text-decoration",s.decoration);r.setAttribute("rotate",s.rotated?90:0);r.setAttribute("kerning",s.kerning?"auto":0);r.setAttribute("text-rendering","optimizeLegibility");if(r.firstChild){r.firstChild.nodeValue=s.text;}else{r.appendChild(_createTextNode(s.text));}
return this;},getTextWidth:function(){var rawNode=this.rawNode,oldParent=rawNode.parentNode,_measurementNode=rawNode.cloneNode(true);_measurementNode.style.visibility="hidden";var _width=0,_text=_measurementNode.firstChild.nodeValue;oldParent.appendChild(_measurementNode);if(_text!=""){while(!_width){if(_measurementNode.getBBox)
_width=parseInt(_measurementNode.getBBox().width);else
_width=68;}}
oldParent.removeChild(_measurementNode);return _width;}});g.Text.nodeType="text";dojo.declare("dojox.gfx.Path",g.path.Path,{_updateWithSegment:function(segment){g.Path.superclass._updateWithSegment.apply(this,arguments);if(typeof(this.shape.path)=="string"){this.rawNode.setAttribute("d",this.shape.path);}},setShape:function(newShape){g.Path.superclass.setShape.apply(this,arguments);if(this.shape.path){this.rawNode.setAttribute("d",this.shape.path);}else{this.rawNode.removeAttribute("d");}
return this;}});g.Path.nodeType="path";dojo.declare("dojox.gfx.TextPath",g.path.TextPath,{_updateWithSegment:function(segment){g.Path.superclass._updateWithSegment.apply(this,arguments);this._setTextPath();},setShape:function(newShape){g.Path.superclass.setShape.apply(this,arguments);this._setTextPath();return this;},_setTextPath:function(){if(typeof this.shape.path!="string"){return;}
var r=this.rawNode;if(!r.firstChild){var tp=_createElementNS(svg.xmlns.svg,"textPath"),tx=_createTextNode("");tp.appendChild(tx);r.appendChild(tp);}
var ref=r.firstChild.getAttributeNS(svg.xmlns.xlink,"href"),path=ref&&svg.getRef(ref);if(!path){var surface=this._getParentSurface();if(surface){var defs=surface.defNode;path=_createElementNS(svg.xmlns.svg,"path");var id=g._base._getUniqueId();path.setAttribute("id",id);defs.appendChild(path);r.firstChild.setAttributeNS(svg.xmlns.xlink,"xlink:href","#"+id);}}
if(path){path.setAttribute("d",this.shape.path);}},_setText:function(){var r=this.rawNode;if(!r.firstChild){var tp=_createElementNS(svg.xmlns.svg,"textPath"),tx=_createTextNode("");tp.appendChild(tx);r.appendChild(tp);}
r=r.firstChild;var t=this.text;r.setAttribute("alignment-baseline","middle");switch(t.align){case"middle":r.setAttribute("text-anchor","middle");r.setAttribute("startOffset","50%");break;case"end":r.setAttribute("text-anchor","end");r.setAttribute("startOffset","100%");break;default:r.setAttribute("text-anchor","start");r.setAttribute("startOffset","0%");break;}
r.setAttribute("baseline-shift","0.5ex");r.setAttribute("text-decoration",t.decoration);r.setAttribute("rotate",t.rotated?90:0);r.setAttribute("kerning",t.kerning?"auto":0);r.firstChild.data=t.text;}});g.TextPath.nodeType="text";dojo.declare("dojox.gfx.Surface",gs.Surface,{constructor:function(){svg.Container._init.call(this);},destroy:function(){this.defNode=null;this.inherited(arguments);},setDimensions:function(width,height){if(!this.rawNode){return this;}
this.rawNode.setAttribute("width",width);this.rawNode.setAttribute("height",height);return this;},getDimensions:function(){var t=this.rawNode?{width:g.normalizedLength(this.rawNode.getAttribute("width")),height:g.normalizedLength(this.rawNode.getAttribute("height"))}:null;return t;}});g.createSurface=function(parentNode,width,height){var s=new g.Surface();s.rawNode=_createElementNS(svg.xmlns.svg,"svg");if(width){s.rawNode.setAttribute("width",width);}
if(height){s.rawNode.setAttribute("height",height);}
var defNode=_createElementNS(svg.xmlns.svg,"defs");s.rawNode.appendChild(defNode);s.defNode=defNode;s._parent=d.byId(parentNode);s._parent.appendChild(s.rawNode);return s;};svg.Font={_setFont:function(){var f=this.fontStyle;this.rawNode.setAttribute("font-style",f.style);this.rawNode.setAttribute("font-variant",f.variant);this.rawNode.setAttribute("font-weight",f.weight);this.rawNode.setAttribute("font-size",f.size);this.rawNode.setAttribute("font-family",f.family);}};svg.Container={_init:function(){gs.Container._init.call(this);},openBatch:function(){this.fragment=_createFragment();},closeBatch:function(){if(this.fragment){this.rawNode.appendChild(this.fragment);delete this.fragment;}},add:function(shape){if(this!=shape.getParent()){if(this.fragment){this.fragment.appendChild(shape.rawNode);}else{this.rawNode.appendChild(shape.rawNode);}
gs.Container.add.apply(this,arguments);}
return this;},remove:function(shape,silently){if(this==shape.getParent()){if(this.rawNode==shape.rawNode.parentNode){this.rawNode.removeChild(shape.rawNode);}
if(this.fragment&&this.fragment==shape.rawNode.parentNode){this.fragment.removeChild(shape.rawNode);}
gs.Container.remove.apply(this,arguments);}
return this;},clear:function(){var r=this.rawNode;while(r.lastChild){r.removeChild(r.lastChild);}
var defNode=this.defNode;if(defNode){while(defNode.lastChild){defNode.removeChild(defNode.lastChild);}
r.appendChild(defNode);}
return gs.Container.clear.apply(this,arguments);},_moveChildToFront:gs.Container._moveChildToFront,_moveChildToBack:gs.Container._moveChildToBack};d.mixin(gs.Creator,{createObject:function(shapeType,rawShape){if(!this.rawNode){return null;}
var shape=new shapeType(),node=_createElementNS(svg.xmlns.svg,shapeType.nodeType);shape.setRawNode(node);shape.setShape(rawShape);this.add(shape);return shape;}});d.extend(g.Text,svg.Font);d.extend(g.TextPath,svg.Font);d.extend(g.Group,svg.Container);d.extend(g.Group,gs.Creator);d.extend(g.Surface,svg.Container);d.extend(g.Surface,gs.Creator);if(svg.useSvgWeb){g.createSurface=function(parentNode,width,height){var s=new g.Surface();if(!width||!height){var pos=d.position(parentNode);width=width||pos.w;height=height||pos.h;}
parentNode=d.byId(parentNode);var id=parentNode.id?parentNode.id+'_svgweb':g._base._getUniqueId();var mockSvg=_createElementNS(svg.xmlns.svg,'svg');mockSvg.id=id;mockSvg.setAttribute('width',width);mockSvg.setAttribute('height',height);svgweb.appendChild(mockSvg,parentNode);mockSvg.addEventListener('SVGLoad',function(){s.rawNode=this;s.isLoaded=true;var defNode=_createElementNS(svg.xmlns.svg,"defs");s.rawNode.appendChild(defNode);s.defNode=defNode;if(s.onLoad)
s.onLoad(s);},false);s.isLoaded=false;return s;}
dojo.extend(dojox.gfx.shape.Surface,{destroy:function(){var mockSvg=this.rawNode;svgweb.removeChild(mockSvg,mockSvg.parentNode);}});gs._eventsProcessing.connect=function(name,object,method){if(name.substring(0,2)==='on'){name=name.substring(2);}
if(arguments.length==2){method=object;}else{method=d.hitch(object,method);}
this.getEventSource().addEventListener(name,method,false);return[this,name,method];}
gs._eventsProcessing.disconnect=function(token){this.getEventSource().removeEventListener(token[1],token[2],false);delete token[0];}
dojo.extend(dojox.gfx.Shape,dojox.gfx.shape._eventsProcessing);dojo.extend(dojox.gfx.shape.Surface,dojox.gfx.shape._eventsProcessing);}})();}
dojo.provide("dojox.charting.plot2d.Boxplot");dojo.require("dojox.charting.plot2d.common");dojo.require("dojox.charting.plot2d.Base");dojo.require("dojox.lang.utils");dojo.require("dojox.lang.functional");dojo.require("dojox.lang.functional.reversed");(function(){var df=dojox.lang.functional,du=dojox.lang.utils,dc=dojox.charting.plot2d.common,purgeGroup=df.lambda("item.purgeGroup()");dojo.declare("dojox.charting.plot2d.Boxplot",dojox.charting.plot2d.Base,{defaultParams:{hAxis:"x",vAxis:"y",gap:15,markers:true},optionalParams:{},constructor:function(chart,kwArgs){this.opt=dojo.clone(this.defaultParams);du.updateWithObject(this.opt,kwArgs);this.series=[];this.hAxis=this.opt.hAxis;this.vAxis=this.opt.vAxis;this.center=this.opt.center;},calculateAxes:function(dim){var stats=dojo.clone(dc.defaultStats);for(var i=0;i<this.series.length;++i){var run=this.series[i];stats.hmin=Math.min(stats.vmin,run.center);stats.hmax=Math.max(stats.vmax,run.center);if(run.data.constructor==Array){dojo.forEach(run.data,function(val,i){stats.vmin=Math.min(stats.vmin,val);stats.vmax=Math.max(stats.vmax,val);});}else{stats.vmin=Math.min(stats.vmin,run.data.lwhisker);stats.vmin=Math.min(stats.vmin,run.data.lbox);dojo.forEach(run.data.outliers,function(val,i){stats.vmin=Math.min(stats.vmin,val);stats.vmax=Math.max(stats.vmax,val);});}}
stats.hmax+=0.5;stats.hmin-=0.5;var vpad=0.05*(stats.vmax-stats.vmin);stats.vmin-=vpad;stats.vmax+=vpad;this._calc(dim,stats);return this;},render:function(dim,offsets){this.dirty=this.isDirty();if(this.dirty){dojo.forEach(this.series,purgeGroup);this.cleanGroup();var s=this.group;df.forEachRev(this.series,function(item){item.cleanGroup(s);});}
var t=this.chart.theme,stroke,fill,color,marker,events=this.events();for(var i=this.series.length-1;i>=0;--i){var run=this.series[i];if(!this.dirty&&!run.dirty){continue;}
run.cleanGroup();var s=run.group;if(!run.fill||!run.stroke){color=run.dyn.color=new dojo.Color(t.next("color"));}
stroke=run.stroke?run.stroke:dc.augmentStroke(t.series.stroke,color);fill=run.fill?run.fill:dc.augmentFill(t.series.fill,color);var s=run.group,lowerLine,upperLine,medianLine,ht=this._hScaler.scaler.getTransformerFromModel(this._hScaler),vt=this._vScaler.scaler.getTransformerFromModel(this._vScaler),gap=this.opt.gap<this._hScaler.bounds.scale/3?this.opt.gap:0,baseline=this._vScaler.bounds.lower,baselineHeight=vt(baseline);var width;if(typeof run.width!=undefined){width=ht(run.width+this._hScaler.bounds.lower);}else{width=this._hScaler.bounds.scale-2*gap;}
width=width+2
var lw,lq,med,uq,uw,outliers;lw=run.summary_data.lwhisker;lq=run.summary_data.lbox;med=run.summary_data.median;uq=run.summary_data.ubox;uw=run.summary_data.uwhisker;outliers=run.summary_data.outliers;indiv_boxlbl=run.indiv_boxlbl;var center=offsets.l+ht(run.center),yoff=dim.height-offsets.b;var rect={x:center-width/2,y:yoff-(uq>baseline?vt(uq):baselineHeight),width:width,height:(uq>baseline?vt(uq):baselineHeight)-(lq>baseline?vt(lq):baselineHeight)},quartileBox=s.createRect(rect).setFill(fill).setStroke(stroke);var whiskerStroke={color:stroke,width:2};var endLineWidth=width*0.5;lowerLine=s.createRect({x:center-endLineWidth/2,y:yoff-(lw>baseline?vt(lw):baselineHeight),width:endLineWidth,height:1}).setStroke(whiskerStroke);medianLine=s.createRect({x:center-width/2-1,y:yoff-(med>baseline?vt(med):baselineHeight),width:width+2,height:1}).setStroke(whiskerStroke);upperLine=s.createRect({x:center-endLineWidth/2,y:yoff-(uw>baseline?vt(uw):baselineHeight),width:endLineWidth,height:1}).setStroke(whiskerStroke);var lowerConnector=s.createLine({x1:center,y1:yoff-(lq>baseline?vt(lq):baselineHeight),x2:center,y2:yoff-(lw>baseline?vt(lw):baselineHeight)}).setStroke(stroke);var upperConnector=s.createLine({x1:center,y1:yoff-(uw>baseline?vt(uw):baselineHeight),x2:center,y2:yoff-(uq>baseline?vt(uq):baselineHeight)}).setStroke(stroke);if(events){var o={element:"bar",index:i,run:run,shape:quartileBox,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,x:indiv_boxlbl+" ["+lq+", "+uq+"]",y:indiv_boxlbl+" ["+lq+", "+uq+"]"};this._connectEvents(o);o={element:"column",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:lowerLine,x:indiv_boxlbl+" "+lw,y:indiv_boxlbl+" "+lw}
this._connectEvents(o);o={element:"column",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:medianLine,x:indiv_boxlbl+" "+med,y:indiv_boxlbl+" "+med}
this._connectEvents(o);o={element:"column",index:i,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:upperLine,x:indiv_boxlbl+" "+uw,y:indiv_boxlbl+" "+uw}
this._connectEvents(o);}
if(this.opt.markers){var markers=new Array(outliers.length);marker=run.dyn.marker=run.marker?run.marker:t.next("marker");var jitters=new Array(outliers.length);dojo.forEach(outliers,function(y,k){var xp=(center+(Math.random()*width)-width/2);jitters[k]=xp;var yp=yoff-(y>baseline?vt(y):baselineHeight);var path="M"+xp+" "+yp+" "+"m-3,0 c0,-4 6,-4 6,0 m-6,0 c0,4 6,4 6,0";markers[k]=s.createPath(path).setStroke(stroke).setFill(fill);},this);if(events){dojo.forEach(markers,function(s,k){var o={element:"marker",index:k,run:run,plot:this,hAxis:this.hAxis||null,vAxis:this.vAxis||null,shape:s,outline:markers[k]||null,shadow:null,cx:jitters[k],cy:yoff-(outliers[k]>baseline?vt(outliers[k]):baselineHeight)};o.x=outliers[k];o.y=outliers[k];this._connectEvents(o);},this);}}
run.dirty=false;}
this.dirty=false;return this;}});})();