#! /bin/bash
# Installation script for SOFA Statistics.
# These defaults may be altered for customized installations.
sofastats_dir_location=/usr/share
bin_dir=/usr/bin
python_command=/usr/bin/python
# assumes this script is in sofastats-version folder inside tar.gz file
echo "This script will need to be run as root or superuser to succeed"
echo "if you are installing to system directories (the default)."
echo "About to transfer all SOFA Statistics files into $sofastats_dir_location/sofastats."
echo "Press any key to proceed."
read OK
# the application
mkdir -p $sofastats_dir_location/sofastats
cp -r sofa_main/* $sofastats_dir_location/sofastats
chmod -R u=rwx $sofastats_dir_location/sofastats
# the shell script
echo "#!/bin/bash" > $bin_dir/sofastats
echo "$python_command $sofastats_dir_location/sofastats/start.py" >> $bin_dir/sofastats
chmod a+x $bin_dir/sofastats
echo "About to launch SOFA Statistics. NB to look for any warnings about missing dependencies e.g. wxPython."
echo "If this fails with a message about the X display, just run the following command manually (assumes python 2.6 or 2.7):"
echo "$python_command $sofastats_dir_location/sofastats/start.py"
echo "Press any key to proceed."
read OK
$python_command $sofastats_dir_location/sofastats/start.py
