/*
 * Decompiled with CFR 0.152.
 */
package com.joestelmach.natty;

import com.joestelmach.natty.ANTLRNoCaseInputStream;
import com.joestelmach.natty.DateGroup;
import com.joestelmach.natty.NattyTokenSource;
import com.joestelmach.natty.ParseListener;
import com.joestelmach.natty.ParseLocation;
import com.joestelmach.natty.generated.DateLexer;
import com.joestelmach.natty.generated.DateParser;
import com.joestelmach.natty.generated.DateWalker;
import com.joestelmach.natty.generated.TreeRewrite;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.debug.DebugEventListener;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeNodeStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private TimeZone _defaultTimeZone;
    private static final Logger _logger = Logger.getLogger("com.joestelmach.natty");

    public Parser(TimeZone defaultTimeZone) {
        this._defaultTimeZone = defaultTimeZone;
    }

    public Parser() {
        this._defaultTimeZone = TimeZone.getDefault();
    }

    public List<DateGroup> parse(String value) {
        ANTLRNoCaseInputStream input = null;
        try {
            input = new ANTLRNoCaseInputStream(new ByteArrayInputStream(value.trim().getBytes()));
        }
        catch (IOException e) {
            _logger.log(Level.SEVERE, "could not lex input", e);
        }
        DateLexer lexer = new DateLexer((CharStream)input);
        List<TokenStream> streams = this.collectTokenStreams((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ArrayList<DateGroup> groups = new ArrayList<DateGroup>();
        for (TokenStream stream : streams) {
            DateGroup group = this.singleParse(stream);
            if (group == null || group.getDates().size() <= 0) continue;
            groups.add(group);
        }
        return groups;
    }

    private DateGroup singleParse(TokenStream stream) {
        StringBuilder tokenString = new StringBuilder();
        for (Token token : ((NattyTokenSource)stream.getTokenSource()).getTokens()) {
            tokenString.append(DateParser.tokenNames[token.getType()]);
            tokenString.append(" ");
        }
        _logger.fine("sub-token stream: " + tokenString.toString());
        DateGroup group = null;
        try {
            ParseListener listener = new ParseListener();
            DateParser parser = new DateParser(stream, (DebugEventListener)listener);
            DateParser.parse_return parseReturn = parser.parse();
            Tree tree = (Tree)parseReturn.getTree();
            _logger.fine("AST: " + tree.toStringTree());
            if (tree.getChildCount() > 0) {
                CommonTreeNodeStream nodes = new CommonTreeNodeStream((Object)tree);
                TreeRewrite s = new TreeRewrite((TreeNodeStream)nodes);
                tree = (CommonTree)s.downup(tree);
                nodes = new CommonTreeNodeStream((Object)tree);
                nodes.setTokenStream(stream);
                DateWalker walker = new DateWalker((TreeNodeStream)nodes);
                walker.getState().setDefaultTimeZone(this._defaultTimeZone);
                walker.parse();
                group = walker.getState().getDateGroup();
                ParseLocation location = listener.getDateGroupLocation();
                group.setLine(location.getLine());
                group.setText(location.getText());
                group.setPosition(location.getStart());
                group.setSyntaxTree(tree);
                group.setParseLocations(listener.getLocations());
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Could not parse input", e);
        }
        return group;
    }

    private List<TokenStream> collectTokenStreams(TokenStream stream) {
        Token currentToken;
        ArrayList<Token> currentGroup = null;
        ArrayList<TokenStream> groups = new ArrayList<TokenStream>();
        StringBuilder tokenString = new StringBuilder();
        while ((currentToken = stream.getTokenSource().nextToken()).getType() != -1) {
            if (_logger.getLevel() != null && _logger.getLevel().intValue() <= Level.FINE.intValue()) {
                tokenString.append(DateParser.tokenNames[currentToken.getType()]);
                tokenString.append(" ");
            }
            if (currentGroup == null) {
                if (currentToken.getType() == 239 || !DateParser.FOLLOW_empty_in_parse176.member(currentToken.getType())) continue;
                currentGroup = new ArrayList<Token>();
                currentGroup.add(currentToken);
                continue;
            }
            if (currentToken.getType() == 239) {
                currentGroup.add(currentToken);
                continue;
            }
            if (currentToken.getType() == 241) {
                if (currentGroup.size() > 0) {
                    groups.add((TokenStream)new CommonTokenStream((TokenSource)new NattyTokenSource(currentGroup)));
                }
                currentGroup = null;
                continue;
            }
            currentGroup.add(currentToken);
        }
        if (currentGroup != null) {
            groups.add((TokenStream)new CommonTokenStream((TokenSource)new NattyTokenSource(currentGroup)));
        }
        _logger.fine("global token stream: " + tokenString.toString());
        return groups;
    }
}

