/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2.session;

import com.dropbox.client2.DropboxAPI;
import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;

public abstract class AbstractSession
implements Session {
    private static final String API_SERVER = "api.dropbox.com";
    private static final String CONTENT_SERVER = "api-content.dropbox.com";
    private static final String WEB_SERVER = "www.dropbox.com";
    private static final int KEEP_ALIVE_DURATION_SECS = 20;
    private static final int KEEP_ALIVE_MONITOR_INTERVAL_SECS = 5;
    private static final int DEFAULT_TIMEOUT_MILLIS = 30000;
    private final Session.AccessType accessType;
    private final AppKeyPair appKeyPair;
    private AccessTokenPair accessTokenPair = null;
    private HttpClient client = null;

    public AbstractSession(AppKeyPair appKeyPair, Session.AccessType accessType) {
        this(appKeyPair, accessType, null);
    }

    public AbstractSession(AppKeyPair appKeyPair, Session.AccessType accessType, AccessTokenPair accessTokenPair) {
        if (appKeyPair == null) {
            throw new IllegalArgumentException("'appKeyPair' must be non-null");
        }
        if (accessType == null) {
            throw new IllegalArgumentException("'type' must be non-null");
        }
        this.appKeyPair = appKeyPair;
        this.accessType = accessType;
        this.accessTokenPair = accessTokenPair;
    }

    public void setAccessTokenPair(AccessTokenPair accessTokenPair) {
        if (accessTokenPair == null) {
            throw new IllegalArgumentException("'accessTokenPair' must be non-null");
        }
        this.accessTokenPair = accessTokenPair;
    }

    public AppKeyPair getAppKeyPair() {
        return this.appKeyPair;
    }

    public AccessTokenPair getAccessTokenPair() {
        return this.accessTokenPair;
    }

    public Session.AccessType getAccessType() {
        return this.accessType;
    }

    public Locale getLocale() {
        return Locale.ENGLISH;
    }

    public boolean isLinked() {
        return this.accessTokenPair != null;
    }

    public void unlink() {
        this.accessTokenPair = null;
    }

    public void sign(HttpRequest httpRequest) {
        httpRequest.addHeader("Authorization", AbstractSession.buildOAuthHeader(this.appKeyPair, this.accessTokenPair));
    }

    private static String buildOAuthHeader(AppKeyPair appKeyPair, AccessTokenPair accessTokenPair) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OAuth oauth_version=\"1.0\"");
        stringBuilder.append(", oauth_signature_method=\"PLAINTEXT\"");
        stringBuilder.append(", oauth_consumer_key=\"").append(AbstractSession.encode(appKeyPair.key)).append("\"");
        if (accessTokenPair != null) {
            stringBuilder.append(", oauth_token=\"").append(AbstractSession.encode(accessTokenPair.key)).append("\"");
            string = AbstractSession.encode(appKeyPair.secret) + "&" + AbstractSession.encode(accessTokenPair.secret);
        } else {
            string = AbstractSession.encode(appKeyPair.secret) + "&";
        }
        stringBuilder.append(", oauth_signature=\"").append(string).append("\"");
        return stringBuilder.toString();
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            AssertionError assertionError = new AssertionError((Object)"UTF-8 isn't available");
            ((Throwable)((Object)assertionError)).initCause(unsupportedEncodingException);
            throw assertionError;
        }
    }

    public synchronized Session.ProxyInfo getProxyInfo() {
        return null;
    }

    public synchronized HttpClient getHttpClient() {
        if (this.client == null) {
            BasicHttpParams basicHttpParams = new BasicHttpParams();
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)basicHttpParams, (ConnPerRoute)new ConnPerRoute(){

                public int getMaxForRoute(HttpRoute httpRoute) {
                    return 10;
                }
            });
            ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)20);
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
            schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
            DBClientConnManager dBClientConnManager = new DBClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
            BasicHttpParams basicHttpParams2 = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams2, (int)30000);
            HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams2, (int)30000);
            HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams2, (int)8192);
            HttpProtocolParams.setUserAgent((HttpParams)basicHttpParams2, (String)("OfficialDropboxJavaSDK/" + DropboxAPI.SDK_VERSION));
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient((ClientConnectionManager)dBClientConnManager, (HttpParams)basicHttpParams2){

                protected ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
                    return new DBKeepAliveStrategy();
                }

                protected ConnectionReuseStrategy createConnectionReuseStrategy() {
                    return new DBConnectionReuseStrategy();
                }
            };
            defaultHttpClient.addRequestInterceptor(new HttpRequestInterceptor(){

                public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                    if (!httpRequest.containsHeader("Accept-Encoding")) {
                        httpRequest.addHeader("Accept-Encoding", "gzip");
                    }
                }
            });
            defaultHttpClient.addResponseInterceptor(new HttpResponseInterceptor(){

                public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
                    Header header;
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity != null && (header = httpEntity.getContentEncoding()) != null) {
                        HeaderElement[] headerElementArray;
                        for (HeaderElement headerElement : headerElementArray = header.getElements()) {
                            if (!headerElement.getName().equalsIgnoreCase("gzip")) continue;
                            httpResponse.setEntity((HttpEntity)new GzipDecompressingEntity(httpResponse.getEntity()));
                            return;
                        }
                    }
                }
            });
            this.client = defaultHttpClient;
        }
        return this.client;
    }

    public void setRequestTimeout(HttpUriRequest httpUriRequest) {
        HttpParams httpParams = httpUriRequest.getParams();
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)30000);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)30000);
    }

    public String getAPIServer() {
        return API_SERVER;
    }

    public String getContentServer() {
        return CONTENT_SERVER;
    }

    public String getWebServer() {
        return WEB_SERVER;
    }

    private static class GzipDecompressingEntity
    extends HttpEntityWrapper {
        public GzipDecompressingEntity(HttpEntity httpEntity) {
            super(httpEntity);
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            InputStream inputStream = this.wrappedEntity.getContent();
            return new GZIPInputStream(inputStream);
        }

        public long getContentLength() {
            return -1L;
        }
    }

    private static class IdleConnectionCloserThread
    extends Thread {
        private final DBClientConnManager manager;
        private final int idleTimeoutSeconds;
        private final int checkIntervalMs;
        private static IdleConnectionCloserThread thread = null;

        public IdleConnectionCloserThread(DBClientConnManager dBClientConnManager, int n, int n2) {
            this.manager = dBClientConnManager;
            this.idleTimeoutSeconds = n;
            this.checkIntervalMs = n2 * 1000;
        }

        public static synchronized void ensureRunning(DBClientConnManager dBClientConnManager, int n, int n2) {
            if (thread == null) {
                thread = new IdleConnectionCloserThread(dBClientConnManager, n, n2);
                thread.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (true) {
                    Object object = this;
                    // MONITORENTER : object
                    this.wait(this.checkIntervalMs);
                    // MONITOREXIT : object
                    this.manager.closeExpiredConnections();
                    this.manager.closeIdleConnections(this.idleTimeoutSeconds, TimeUnit.SECONDS);
                    object = IdleConnectionCloserThread.class;
                    // MONITORENTER : com.dropbox.client2.session.AbstractSession$IdleConnectionCloserThread.class
                    if (this.manager.getConnectionsInPool() == 0) {
                        thread = null;
                        // MONITOREXIT : object
                        return;
                    }
                    // MONITOREXIT : object
                }
            }
            catch (InterruptedException interruptedException) {
                thread = null;
                return;
            }
        }
    }

    private static class DBClientConnManager
    extends ThreadSafeClientConnManager {
        public DBClientConnManager(HttpParams httpParams, SchemeRegistry schemeRegistry) {
            super(httpParams, schemeRegistry);
        }

        public ClientConnectionRequest requestConnection(HttpRoute httpRoute, Object object) {
            IdleConnectionCloserThread.ensureRunning(this, 20, 5);
            return super.requestConnection(httpRoute, object);
        }
    }

    private static class DBConnectionReuseStrategy
    extends DefaultConnectionReuseStrategy {
        private DBConnectionReuseStrategy() {
        }

        public boolean keepAlive(HttpResponse httpResponse, HttpContext httpContext) {
            int n;
            HeaderIterator headerIterator;
            HeaderIterator headerIterator2;
            if (httpResponse == null) {
                throw new IllegalArgumentException("HTTP response may not be null.");
            }
            if (httpContext == null) {
                throw new IllegalArgumentException("HTTP context may not be null.");
            }
            ProtocolVersion protocolVersion = httpResponse.getStatusLine().getProtocolVersion();
            Header header = httpResponse.getFirstHeader("Transfer-Encoding");
            if (header != null) {
                if (!"chunked".equalsIgnoreCase(header.getValue())) {
                    return false;
                }
            } else {
                headerIterator2 = httpResponse.getHeaders("Content-Length");
                if (headerIterator2 == null || ((Header[])headerIterator2).length != 1) {
                    return false;
                }
                headerIterator = headerIterator2[0];
                try {
                    n = Integer.parseInt(headerIterator.getValue());
                    if (n < 0) {
                        return false;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (!(headerIterator2 = httpResponse.headerIterator("Connection")).hasNext()) {
                headerIterator2 = httpResponse.headerIterator("Proxy-Connection");
            }
            if (headerIterator2.hasNext()) {
                try {
                    headerIterator = this.createTokenIterator(headerIterator2);
                    n = 0;
                    while (headerIterator.hasNext()) {
                        String string = headerIterator.nextToken();
                        if ("Close".equalsIgnoreCase(string)) {
                            return false;
                        }
                        if (!"Keep-Alive".equalsIgnoreCase(string)) continue;
                        n = 1;
                    }
                    if (n != 0) {
                        return true;
                    }
                }
                catch (ParseException parseException) {
                    return false;
                }
            }
            return !protocolVersion.lessEquals((ProtocolVersion)HttpVersion.HTTP_1_0);
        }
    }

    private static class DBKeepAliveStrategy
    implements ConnectionKeepAliveStrategy {
        private DBKeepAliveStrategy() {
        }

        public long getKeepAliveDuration(HttpResponse httpResponse, HttpContext httpContext) {
            long l = 20000L;
            BasicHeaderElementIterator basicHeaderElementIterator = new BasicHeaderElementIterator(httpResponse.headerIterator("Keep-Alive"));
            while (basicHeaderElementIterator.hasNext()) {
                HeaderElement headerElement = basicHeaderElementIterator.nextElement();
                String string = headerElement.getName();
                String string2 = headerElement.getValue();
                if (string2 == null || !string.equalsIgnoreCase("timeout")) continue;
                try {
                    l = Math.min(l, Long.parseLong(string2) * 1000L);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return l;
        }
    }
}

