/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.client2;

import com.dropbox.client2.exception.DropboxException;
import com.dropbox.client2.session.AppKeyPair;
import com.dropbox.client2.session.Session;
import com.dropbox.client2.session.WebAuthSession;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SessionTest
extends TestCase {
    AppKeyPair mConsumerTokenPair = new AppKeyPair("ebv4269mzcrtqcg", "xxsm3igaqylfk73");
    String mTestingUser = "dropboxapitest542351346136@thisdoesnotexist.com";
    String mTestingPassword = "test123";

    public SessionTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(SessionTest.class);
    }

    public void test_config() {
        assert (this.mConsumerTokenPair != null) : "Please make sure config/testing.json has your consumer key and secret";
        assert (!this.mConsumerTokenPair.key.equals("YOUR CONSUMER KEY")) : "Please edit config/testing.json with the consumer key you received from Dropbox";
        assert (!this.mConsumerTokenPair.secret.equals("YOUR CONSUMER SECRET")) : "You need to change your consumer secret from the default";
        assert (this.mTestingUser != null) : "Please make sure config/testing.json has your consumer key";
        assert (this.mTestingPassword != null) : "Please make sure config/testing.json has your consumer secret";
        assert (!this.mTestingUser.equals("YOUR DROPBOX LOGIN")) : "Please edit config/testing.json with the consumer key you received from Dropbox";
        assert (!this.mTestingPassword.equals("DROPBOX PASSWORD")) : "You need to change your consumer secret from the default";
    }

    public void test_session() throws Exception {
        WebAuthSession webAuthSession = new WebAuthSession(this.mConsumerTokenPair, Session.AccessType.DROPBOX);
        assert (webAuthSession.getAppKeyPair().equals(this.mConsumerTokenPair));
        assert (!webAuthSession.isLinked()) : "Session not linked";
    }

    public void test_retrieveRequestToken() throws Exception {
        block3: {
            WebAuthSession webAuthSession = new WebAuthSession(this.mConsumerTokenPair, Session.AccessType.DROPBOX);
            try {
                WebAuthSession.WebAuthInfo webAuthInfo = webAuthSession.getAuthInfo("somecallback");
                assert (webAuthInfo.requestTokenPair != null);
            }
            catch (DropboxException dropboxException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("DropboxException: " + dropboxException.toString()));
            }
        }
    }
}

