/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.parser;

import java.util.ArrayList;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.LiteralNode;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.ObjectNode;
import jdk.nashorn.internal.ir.PropertyNode;
import jdk.nashorn.internal.ir.UnaryNode;
import jdk.nashorn.internal.parser.AbstractParser;
import jdk.nashorn.internal.parser.Lexer;
import jdk.nashorn.internal.parser.TokenStream;
import jdk.nashorn.internal.parser.TokenType;
import jdk.nashorn.internal.runtime.ErrorManager;
import jdk.nashorn.internal.runtime.Source;

public class JSONParser
extends AbstractParser {
    public JSONParser(Source source, ErrorManager errors) {
        super(source, errors, false, 0);
    }

    public static String quote(String value) {
        StringBuilder product = new StringBuilder();
        product.append("\"");
        block9: for (char ch : value.toCharArray()) {
            switch (ch) {
                case '\\': {
                    product.append("\\\\");
                    continue block9;
                }
                case '\"': {
                    product.append("\\\"");
                    continue block9;
                }
                case '\b': {
                    product.append("\\b");
                    continue block9;
                }
                case '\f': {
                    product.append("\\f");
                    continue block9;
                }
                case '\n': {
                    product.append("\\n");
                    continue block9;
                }
                case '\r': {
                    product.append("\\r");
                    continue block9;
                }
                case '\t': {
                    product.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch < ' ') {
                        product.append(Lexer.unicodeEscape(ch));
                        continue block9;
                    }
                    product.append(ch);
                }
            }
        }
        product.append("\"");
        return product.toString();
    }

    public Node parse() {
        this.stream = new TokenStream();
        this.lexer = new Lexer(this.source, this.stream){

            @Override
            protected boolean skipComments() {
                return false;
            }

            @Override
            protected boolean isStringDelimiter(char ch) {
                return ch == '\"';
            }

            @Override
            protected boolean isWhitespace(char ch) {
                return Lexer.isJsonWhitespace(ch);
            }

            @Override
            protected boolean isEOL(char ch) {
                return Lexer.isJsonEOL(ch);
            }

            @Override
            protected void scanNumber() {
                int startPosition = this.position;
                TokenType valueType = TokenType.DECIMAL;
                if (this.ch0 == '.') {
                    this.error(Lexer.message("json.invalid.number", new String[0]), TokenType.STRING, this.position, this.limit);
                }
                int digit = 1.convertDigit(this.ch0, 10);
                this.skip(1);
                if (digit != 0) {
                    while (1.convertDigit(this.ch0, 10) != -1) {
                        this.skip(1);
                    }
                }
                if (this.ch0 == '.' || this.ch0 == 'E' || this.ch0 == 'e') {
                    if (this.ch0 == '.') {
                        this.skip(1);
                        boolean mantissa = false;
                        while (1.convertDigit(this.ch0, 10) != -1) {
                            mantissa = true;
                            this.skip(1);
                        }
                        if (!mantissa) {
                            this.error(Lexer.message("json.invalid.number", new String[0]), TokenType.STRING, this.position, this.limit);
                        }
                    }
                    if (this.ch0 == 'E' || this.ch0 == 'e') {
                        this.skip(1);
                        if (this.ch0 == '+' || this.ch0 == '-') {
                            this.skip(1);
                        }
                        boolean exponent = false;
                        while (1.convertDigit(this.ch0, 10) != -1) {
                            exponent = true;
                            this.skip(1);
                        }
                        if (!exponent) {
                            this.error(Lexer.message("json.invalid.number", new String[0]), TokenType.STRING, this.position, this.limit);
                        }
                    }
                    valueType = TokenType.FLOATING;
                }
                this.add(valueType, startPosition);
            }

            @Override
            protected boolean isEscapeCharacter(char ch) {
                switch (ch) {
                    case '\"': 
                    case '/': 
                    case '\\': 
                    case 'b': 
                    case 'f': 
                    case 'n': 
                    case 'r': 
                    case 't': 
                    case 'u': {
                        return true;
                    }
                }
                return false;
            }
        };
        this.k = -1;
        this.next();
        Expression resultNode = this.jsonLiteral();
        this.expect(TokenType.EOF);
        return resultNode;
    }

    private LiteralNode<?> getStringLiteral() {
        LiteralNode<?> literal = this.getLiteral();
        String str = (String)literal.getValue();
        block3: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                default: {
                    if (ch > '\u001f') continue block3;
                }
                case '\"': 
                case '\\': {
                    throw this.error(AbstractParser.message("unexpected.token", str));
                }
            }
        }
        return literal;
    }

    private Expression jsonLiteral() {
        long literalToken = this.token;
        switch (this.type) {
            case STRING: {
                return this.getStringLiteral();
            }
            case ESCSTRING: 
            case DECIMAL: 
            case FLOATING: {
                return this.getLiteral();
            }
            case FALSE: {
                this.next();
                return LiteralNode.newInstance(literalToken, this.finish, false);
            }
            case TRUE: {
                this.next();
                return LiteralNode.newInstance(literalToken, this.finish, true);
            }
            case NULL: {
                this.next();
                return LiteralNode.newInstance(literalToken, this.finish);
            }
            case LBRACKET: {
                return this.arrayLiteral();
            }
            case LBRACE: {
                return this.objectLiteral();
            }
            case SUB: {
                this.next();
                long realToken = this.token;
                Object value = this.getValue();
                if (value instanceof Number) {
                    this.next();
                    return new UnaryNode(literalToken, LiteralNode.newInstance(realToken, this.finish, (Number)value));
                }
                throw this.error(AbstractParser.message("expected", "number", this.type.getNameOrType()));
            }
        }
        throw this.error(AbstractParser.message("expected", "json literal", this.type.getNameOrType()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private LiteralNode<Expression[]> arrayLiteral() {
        long arrayToken = this.token;
        this.next();
        LiteralNode<Expression[]> result = null;
        ArrayList<Expression> elements = new ArrayList<Expression>();
        block4: while (true) {
            switch (this.type) {
                case RBRACKET: {
                    this.next();
                    return LiteralNode.newInstance(arrayToken, this.finish, elements);
                }
                case COMMARIGHT: {
                    this.next();
                    if (this.type != TokenType.RBRACKET) continue block4;
                    throw this.error(AbstractParser.message("trailing.comma.in.json", this.type.getNameOrType()));
                }
                default: {
                    elements.add(this.jsonLiteral());
                    if (this.type != TokenType.COMMARIGHT && this.type != TokenType.RBRACKET) throw this.error(AbstractParser.message("expected", ", or ]", this.type.getNameOrType()));
                    continue block4;
                }
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ObjectNode objectLiteral() {
        long objectToken = this.token;
        this.next();
        ArrayList<PropertyNode> elements = new ArrayList<PropertyNode>();
        block4: while (true) {
            switch (this.type) {
                case RBRACE: {
                    this.next();
                    return new ObjectNode(objectToken, this.finish, elements);
                }
                case COMMARIGHT: {
                    this.next();
                    if (this.type != TokenType.RBRACE) continue block4;
                    throw this.error(AbstractParser.message("trailing.comma.in.json", this.type.getNameOrType()));
                }
                default: {
                    PropertyNode property = this.propertyAssignment();
                    elements.add(property);
                    if (this.type != TokenType.RBRACE && this.type != TokenType.COMMARIGHT) throw this.error(AbstractParser.message("expected", ", or }", this.type.getNameOrType()));
                    continue block4;
                }
            }
            break;
        }
    }

    private PropertyNode propertyAssignment() {
        long propertyToken = this.token;
        LiteralNode<?> name = null;
        if (this.type == TokenType.STRING) {
            name = this.getStringLiteral();
        } else if (this.type == TokenType.ESCSTRING) {
            name = this.getLiteral();
        }
        if (name != null) {
            this.expect(TokenType.COLON);
            Expression value = this.jsonLiteral();
            return new PropertyNode(propertyToken, value.getFinish(), name, value, null, null);
        }
        throw this.error(AbstractParser.message("expected", "string", this.type.getNameOrType()));
    }
}

