/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.rowset.serial.SerialException;

public class SerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buf;
    private Blob blob;
    private long len;
    private long origLen;
    static final long serialVersionUID = -8144641928112860441L;

    public SerialBlob(byte[] byArray) throws SerialException, SQLException {
        this.len = byArray.length;
        this.buf = new byte[(int)this.len];
        int n = 0;
        while ((long)n < this.len) {
            this.buf[n] = byArray[n];
            ++n;
        }
        this.origLen = this.len;
    }

    public SerialBlob(Blob blob) throws SerialException, SQLException {
        if (blob == null) {
            throw new SQLException("Cannot instantiate a SerialBlob object with a null Blob object");
        }
        this.len = blob.length();
        this.buf = blob.getBytes(1L, (int)this.len);
        this.blob = blob;
        this.origLen = this.len;
    }

    @Override
    public byte[] getBytes(long l, int n) throws SerialException {
        this.isValid();
        if ((long)n > this.len) {
            n = (int)this.len;
        }
        if (l < 1L || this.len - l < 0L) {
            throw new SerialException("Invalid arguments: position cannot be less than 1 or greater than the length of the SerialBlob");
        }
        --l;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.buf[(int)l];
            ++l;
        }
        return byArray;
    }

    @Override
    public long length() throws SerialException {
        this.isValid();
        return this.len;
    }

    @Override
    public InputStream getBinaryStream() throws SerialException {
        this.isValid();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        return byteArrayInputStream;
    }

    @Override
    public long position(byte[] byArray, long l) throws SerialException, SQLException {
        this.isValid();
        if (l < 1L || l > this.len) {
            return -1L;
        }
        int n = (int)l - 1;
        int n2 = 0;
        long l2 = byArray.length;
        while ((long)n < this.len) {
            if (byArray[n2] == this.buf[n]) {
                if ((long)(n2 + 1) == l2) {
                    return (long)(n + 1) - (l2 - 1L);
                }
                ++n2;
                ++n;
                continue;
            }
            if (byArray[n2] == this.buf[n]) continue;
            ++n;
        }
        return -1L;
    }

    @Override
    public long position(Blob blob, long l) throws SerialException, SQLException {
        this.isValid();
        return this.position(blob.getBytes(1L, (int)blob.length()), l);
    }

    @Override
    public int setBytes(long l, byte[] byArray) throws SerialException, SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    @Override
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SerialException, SQLException {
        int n3;
        this.isValid();
        if (n < 0 || n > byArray.length) {
            throw new SerialException("Invalid offset in byte array set");
        }
        if (l < 1L || l > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if ((long)n2 > this.origLen) {
            throw new SerialException("Buffer is not sufficient to hold the value");
        }
        if (n2 + n > byArray.length) {
            throw new SerialException("Invalid OffSet. Cannot have combined offset and length that is greater that the Blob buffer");
        }
        --l;
        for (n3 = 0; n3 < n2 || n + n3 + 1 < byArray.length - n; ++n3) {
            this.buf[(int)l + n3] = byArray[n + n3];
        }
        return n3;
    }

    @Override
    public OutputStream setBinaryStream(long l) throws SerialException, SQLException {
        this.isValid();
        if (this.blob != null) {
            return this.blob.setBinaryStream(l);
        }
        throw new SerialException("Unsupported operation. SerialBlob cannot return a writable binary stream, unless instantiated with a Blob object that provides a setBinaryStream() implementation");
    }

    @Override
    public void truncate(long l) throws SerialException {
        this.isValid();
        if (l > this.len) {
            throw new SerialException("Length more than what can be truncated");
        }
        if ((int)l == 0) {
            this.buf = new byte[0];
            this.len = l;
        } else {
            this.len = l;
            this.buf = this.getBytes(1L, (int)this.len);
        }
    }

    @Override
    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        this.isValid();
        if (l < 1L || l > this.length()) {
            throw new SerialException("Invalid position in BLOB object set");
        }
        if (l2 < 1L || l2 > this.len - l + 1L) {
            throw new SerialException("length is < 1 or pos + length >total number of bytes");
        }
        return new ByteArrayInputStream(this.buf, (int)l - 1, (int)l2);
    }

    @Override
    public void free() throws SQLException {
        if (this.buf != null) {
            this.buf = null;
            if (this.blob != null) {
                this.blob.free();
            }
            this.blob = null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SerialBlob) {
            SerialBlob serialBlob = (SerialBlob)object;
            if (this.len == serialBlob.len) {
                return Arrays.equals(this.buf, serialBlob.buf);
            }
        }
        return false;
    }

    public int hashCode() {
        return ((31 + Arrays.hashCode(this.buf)) * 31 + (int)this.len) * 31 + (int)this.origLen;
    }

    public Object clone() {
        try {
            SerialBlob serialBlob = (SerialBlob)super.clone();
            serialBlob.buf = this.buf != null ? Arrays.copyOf(this.buf, (int)this.len) : null;
            serialBlob.blob = null;
            return serialBlob;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        byte[] byArray = (byte[])getField.get("buf", null);
        if (byArray == null) {
            throw new InvalidObjectException("buf is null and should not be!");
        }
        this.buf = (byte[])byArray.clone();
        this.len = getField.get("len", 0L);
        if ((long)this.buf.length != this.len) {
            throw new InvalidObjectException("buf is not the expected size");
        }
        this.origLen = getField.get("origLen", 0L);
        this.blob = (Blob)getField.get("blob", null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("buf", this.buf);
        putField.put("len", this.len);
        putField.put("origLen", this.origLen);
        putField.put("blob", this.blob instanceof Serializable ? this.blob : null);
        objectOutputStream.writeFields();
    }

    private void isValid() throws SerialException {
        if (this.buf == null) {
            throw new SerialException("Error: You cannot call a method on a SerialBlob instance once free() has been called.");
        }
    }
}

