/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.MutableBigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import sun.misc.Unsafe;

public class BigDecimal
extends Number
implements Comparable<BigDecimal> {
    private final BigInteger intVal;
    private final int scale;
    private transient int precision;
    private transient String stringCache;
    static final long INFLATED = Long.MIN_VALUE;
    private static final BigInteger INFLATED_BIGINT = BigInteger.valueOf(Long.MIN_VALUE);
    private final transient long intCompact;
    private static final int MAX_COMPACT_DIGITS = 18;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final ThreadLocal<StringBuilderHelper> threadLocalStringBuilderHelper = new ThreadLocal<StringBuilderHelper>(){

        @Override
        protected StringBuilderHelper initialValue() {
            return new StringBuilderHelper();
        }
    };
    private static final BigDecimal[] zeroThroughTen = new BigDecimal[]{new BigDecimal(BigInteger.ZERO, 0L, 0, 1), new BigDecimal(BigInteger.ONE, 1L, 0, 1), new BigDecimal(BigInteger.valueOf(2L), 2L, 0, 1), new BigDecimal(BigInteger.valueOf(3L), 3L, 0, 1), new BigDecimal(BigInteger.valueOf(4L), 4L, 0, 1), new BigDecimal(BigInteger.valueOf(5L), 5L, 0, 1), new BigDecimal(BigInteger.valueOf(6L), 6L, 0, 1), new BigDecimal(BigInteger.valueOf(7L), 7L, 0, 1), new BigDecimal(BigInteger.valueOf(8L), 8L, 0, 1), new BigDecimal(BigInteger.valueOf(9L), 9L, 0, 1), new BigDecimal(BigInteger.TEN, 10L, 0, 2)};
    private static final BigDecimal[] ZERO_SCALED_BY = new BigDecimal[]{zeroThroughTen[0], new BigDecimal(BigInteger.ZERO, 0L, 1, 1), new BigDecimal(BigInteger.ZERO, 0L, 2, 1), new BigDecimal(BigInteger.ZERO, 0L, 3, 1), new BigDecimal(BigInteger.ZERO, 0L, 4, 1), new BigDecimal(BigInteger.ZERO, 0L, 5, 1), new BigDecimal(BigInteger.ZERO, 0L, 6, 1), new BigDecimal(BigInteger.ZERO, 0L, 7, 1), new BigDecimal(BigInteger.ZERO, 0L, 8, 1), new BigDecimal(BigInteger.ZERO, 0L, 9, 1), new BigDecimal(BigInteger.ZERO, 0L, 10, 1), new BigDecimal(BigInteger.ZERO, 0L, 11, 1), new BigDecimal(BigInteger.ZERO, 0L, 12, 1), new BigDecimal(BigInteger.ZERO, 0L, 13, 1), new BigDecimal(BigInteger.ZERO, 0L, 14, 1), new BigDecimal(BigInteger.ZERO, 0L, 15, 1)};
    private static final long HALF_LONG_MAX_VALUE = 0x3FFFFFFFFFFFFFFFL;
    private static final long HALF_LONG_MIN_VALUE = -4611686018427387904L;
    public static final BigDecimal ZERO = zeroThroughTen[0];
    public static final BigDecimal ONE = zeroThroughTen[1];
    public static final BigDecimal TEN = zeroThroughTen[10];
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static final double[] double10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
    private static final float[] float10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
    private static final long[] LONG_TEN_POWERS_TABLE = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static volatile BigInteger[] BIG_TEN_POWERS_TABLE = new BigInteger[]{BigInteger.ONE, BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L), BigInteger.valueOf(10000000000L), BigInteger.valueOf(100000000000L), BigInteger.valueOf(1000000000000L), BigInteger.valueOf(10000000000000L), BigInteger.valueOf(100000000000000L), BigInteger.valueOf(1000000000000000L), BigInteger.valueOf(10000000000000000L), BigInteger.valueOf(100000000000000000L), BigInteger.valueOf(1000000000000000000L)};
    private static final int BIG_TEN_POWERS_TABLE_INITLEN = BIG_TEN_POWERS_TABLE.length;
    private static final int BIG_TEN_POWERS_TABLE_MAX = 16 * BIG_TEN_POWERS_TABLE_INITLEN;
    private static final long[] THRESHOLDS_TABLE = new long[]{Long.MAX_VALUE, 0xCCCCCCCCCCCCCCCL, 92233720368547758L, 9223372036854775L, 922337203685477L, 92233720368547L, 9223372036854L, 922337203685L, 92233720368L, 9223372036L, 922337203L, 92233720L, 0x8CBCCCL, 922337L, 92233L, 9223L, 922L, 92L, 9L};
    private static final long DIV_NUM_BASE = 0x100000000L;
    private static final long[][] LONGLONG_TEN_POWERS_TABLE = new long[][]{{0L, -8446744073709551616L}, {5L, 7766279631452241920L}, {54L, 3875820019684212736L}, {542L, 1864712049423024128L}, {5421L, 200376420520689664L}, {54210L, 2003764205206896640L}, {542101L, 1590897978359414784L}, {5421010L, -2537764290115403776L}, {54210108L, -6930898827444486144L}, {542101086L, 4477988020393345024L}, {5421010862L, 7886392056514347008L}, {54210108624L, 5076944270305263616L}, {542101086242L, -4570789518076018688L}, {5421010862427L, -8814407033341083648L}, {54210108624275L, 4089650035136921600L}, {542101086242752L, 4003012203950112768L}, {5421010862427522L, 3136633892082024448L}, {54210108624275221L, -5527149226598858752L}, {542101086242752217L, 68739955140067328L}, {5421010862427522170L, 687399551400673280L}};

    BigDecimal(BigInteger bigInteger, long l, int n, int n2) {
        this.scale = n;
        this.precision = n2;
        this.intCompact = l;
        this.intVal = bigInteger;
    }

    public BigDecimal(char[] cArray, int n, int n2) {
        this(cArray, n, n2, MathContext.UNLIMITED);
    }

    public BigDecimal(char[] cArray, int n, int n2, MathContext mathContext) {
        if (n + n2 > cArray.length || n < 0) {
            throw new NumberFormatException("Bad offset or len arguments for char[] input.");
        }
        int n3 = 0;
        int n4 = 0;
        long l = 0L;
        BigInteger bigInteger = null;
        try {
            boolean bl = false;
            if (cArray[n] == '-') {
                bl = true;
                ++n;
                --n2;
            } else if (cArray[n] == '+') {
                ++n;
                --n2;
            }
            boolean bl2 = false;
            long l2 = 0L;
            boolean bl3 = n2 <= 18;
            int n5 = 0;
            if (bl3) {
                int n6;
                while (n2 > 0) {
                    char c = cArray[n];
                    if (c == '0') {
                        if (n3 == 0) {
                            n3 = 1;
                        } else if (l != 0L) {
                            l *= 10L;
                            ++n3;
                        }
                        if (bl2) {
                            ++n4;
                        }
                    } else if (c >= '1' && c <= '9') {
                        n6 = c - 48;
                        if (n3 != 1 || l != 0L) {
                            ++n3;
                        }
                        l = l * 10L + (long)n6;
                        if (bl2) {
                            ++n4;
                        }
                    } else if (c == '.') {
                        if (bl2) {
                            throw new NumberFormatException();
                        }
                        bl2 = true;
                    } else if (Character.isDigit(c)) {
                        n6 = Character.digit(c, 10);
                        if (n6 == 0) {
                            if (n3 == 0) {
                                n3 = 1;
                            } else if (l != 0L) {
                                l *= 10L;
                                ++n3;
                            }
                        } else {
                            if (n3 != 1 || l != 0L) {
                                ++n3;
                            }
                            l = l * 10L + (long)n6;
                        }
                        if (bl2) {
                            ++n4;
                        }
                    } else {
                        if (c == 'e' || c == 'E') {
                            l2 = BigDecimal.parseExp(cArray, n, n2);
                            if ((long)((int)l2) == l2) break;
                            throw new NumberFormatException();
                        }
                        throw new NumberFormatException();
                    }
                    ++n;
                    --n2;
                }
                if (n3 == 0) {
                    throw new NumberFormatException();
                }
                if (l2 != 0L) {
                    n4 = this.adjustScale(n4, l2);
                }
                l = bl ? -l : l;
                n6 = mathContext.precision;
                int n7 = n3 - n6;
                if (n6 > 0 && n7 > 0) {
                    while (n7 > 0) {
                        n4 = BigDecimal.checkScaleNonZero((long)n4 - (long)n7);
                        l = BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n7], mathContext.roundingMode.oldMode);
                        n3 = BigDecimal.longDigitLength(l);
                        n7 = n3 - n6;
                    }
                }
            } else {
                char[] cArray2 = new char[n2];
                while (n2 > 0) {
                    char c = cArray[n];
                    if (c >= '0' && c <= '9' || Character.isDigit(c)) {
                        if (c == '0' || Character.digit(c, 10) == 0) {
                            if (n3 == 0) {
                                cArray2[n5] = c;
                                n3 = 1;
                            } else if (n5 != 0) {
                                cArray2[n5++] = c;
                                ++n3;
                            }
                        } else {
                            if (n3 != 1 || n5 != 0) {
                                ++n3;
                            }
                            cArray2[n5++] = c;
                        }
                        if (bl2) {
                            ++n4;
                        }
                    } else if (c == '.') {
                        if (bl2) {
                            throw new NumberFormatException();
                        }
                        bl2 = true;
                    } else {
                        if (c != 'e' && c != 'E') {
                            throw new NumberFormatException();
                        }
                        l2 = BigDecimal.parseExp(cArray, n, n2);
                        if ((long)((int)l2) == l2) break;
                        throw new NumberFormatException();
                    }
                    ++n;
                    --n2;
                }
                if (n3 == 0) {
                    throw new NumberFormatException();
                }
                if (l2 != 0L) {
                    n4 = this.adjustScale(n4, l2);
                }
                bigInteger = new BigInteger(cArray2, bl ? -1 : 1, n3);
                l = BigDecimal.compactValFor(bigInteger);
                int n8 = mathContext.precision;
                if (n8 > 0 && n3 > n8) {
                    int n9;
                    if (l == Long.MIN_VALUE) {
                        n9 = n3 - n8;
                        while (n9 > 0) {
                            n4 = BigDecimal.checkScaleNonZero((long)n4 - (long)n9);
                            l = BigDecimal.compactValFor(bigInteger = BigDecimal.divideAndRoundByTenPow(bigInteger, n9, mathContext.roundingMode.oldMode));
                            if (l != Long.MIN_VALUE) {
                                n3 = BigDecimal.longDigitLength(l);
                                break;
                            }
                            n3 = BigDecimal.bigDigitLength(bigInteger);
                            n9 = n3 - n8;
                        }
                    }
                    if (l != Long.MIN_VALUE) {
                        n9 = n3 - n8;
                        while (n9 > 0) {
                            n4 = BigDecimal.checkScaleNonZero((long)n4 - (long)n9);
                            l = BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n9], mathContext.roundingMode.oldMode);
                            n3 = BigDecimal.longDigitLength(l);
                            n9 = n3 - n8;
                        }
                        bigInteger = null;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NumberFormatException();
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new NumberFormatException();
        }
        this.scale = n4;
        this.precision = n3;
        this.intCompact = l;
        this.intVal = bigInteger;
    }

    private int adjustScale(int n, long l) {
        long l2 = (long)n - l;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new NumberFormatException("Scale out of range.");
        }
        n = (int)l2;
        return n;
    }

    private static long parseExp(char[] cArray, int n, int n2) {
        boolean bl;
        long l = 0L;
        char c = cArray[++n];
        --n2;
        boolean bl2 = bl = c == '-';
        if (bl || c == '+') {
            c = cArray[++n];
            --n2;
        }
        if (n2 <= 0) {
            throw new NumberFormatException();
        }
        while (n2 > 10 && (c == '0' || Character.digit(c, 10) == 0)) {
            c = cArray[++n];
            --n2;
        }
        if (n2 > 10) {
            throw new NumberFormatException();
        }
        while (true) {
            int n3;
            if (c >= '0' && c <= '9') {
                n3 = c - 48;
            } else {
                n3 = Character.digit(c, 10);
                if (n3 < 0) {
                    throw new NumberFormatException();
                }
            }
            l = l * 10L + (long)n3;
            if (n2 == 1) break;
            c = cArray[++n];
            --n2;
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    public BigDecimal(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public BigDecimal(char[] cArray, MathContext mathContext) {
        this(cArray, 0, cArray.length, mathContext);
    }

    public BigDecimal(String string) {
        this(string.toCharArray(), 0, string.length());
    }

    public BigDecimal(String string, MathContext mathContext) {
        this(string.toCharArray(), 0, string.length(), mathContext);
    }

    public BigDecimal(double d) {
        this(d, MathContext.UNLIMITED);
    }

    public BigDecimal(double d, MathContext mathContext) {
        BigInteger bigInteger;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        long l = Double.doubleToLongBits(d);
        int n = l >> 63 == 0L ? 1 : -1;
        int n2 = (int)(l >> 52 & 0x7FFL);
        long l2 = n2 == 0 ? (l & 0xFFFFFFFFFFFFFL) << 1 : l & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        n2 -= 1075;
        if (l2 == 0L) {
            this.intVal = BigInteger.ZERO;
            this.scale = 0;
            this.intCompact = 0L;
            this.precision = 1;
            return;
        }
        while ((l2 & 1L) == 0L) {
            l2 >>= 1;
            ++n2;
        }
        int n3 = 0;
        long l3 = (long)n * l2;
        if (n2 == 0) {
            bigInteger = l3 == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        } else {
            if (n2 < 0) {
                bigInteger = BigInteger.valueOf(5L).pow(-n2).multiply(l3);
                n3 = -n2;
            } else {
                bigInteger = BigInteger.valueOf(2L).pow(n2).multiply(l3);
            }
            l3 = BigDecimal.compactValFor(bigInteger);
        }
        int n4 = 0;
        int n5 = mathContext.precision;
        if (n5 > 0) {
            int n6;
            int n7 = mathContext.roundingMode.oldMode;
            if (l3 == Long.MIN_VALUE) {
                n4 = BigDecimal.bigDigitLength(bigInteger);
                n6 = n4 - n5;
                while (n6 > 0) {
                    n3 = BigDecimal.checkScaleNonZero((long)n3 - (long)n6);
                    l3 = BigDecimal.compactValFor(bigInteger = BigDecimal.divideAndRoundByTenPow(bigInteger, n6, n7));
                    if (l3 != Long.MIN_VALUE) break;
                    n4 = BigDecimal.bigDigitLength(bigInteger);
                    n6 = n4 - n5;
                }
            }
            if (l3 != Long.MIN_VALUE) {
                n4 = BigDecimal.longDigitLength(l3);
                n6 = n4 - n5;
                while (n6 > 0) {
                    n3 = BigDecimal.checkScaleNonZero((long)n3 - (long)n6);
                    l3 = BigDecimal.divideAndRound(l3, LONG_TEN_POWERS_TABLE[n6], mathContext.roundingMode.oldMode);
                    n4 = BigDecimal.longDigitLength(l3);
                    n6 = n4 - n5;
                }
                bigInteger = null;
            }
        }
        this.intVal = bigInteger;
        this.intCompact = l3;
        this.scale = n3;
        this.precision = n4;
    }

    public BigDecimal(BigInteger bigInteger) {
        this.scale = 0;
        this.intVal = bigInteger;
        this.intCompact = BigDecimal.compactValFor(bigInteger);
    }

    public BigDecimal(BigInteger bigInteger, MathContext mathContext) {
        this(bigInteger, 0, mathContext);
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        this.intVal = bigInteger;
        this.intCompact = BigDecimal.compactValFor(bigInteger);
        this.scale = n;
    }

    public BigDecimal(BigInteger bigInteger, int n, MathContext mathContext) {
        long l = BigDecimal.compactValFor(bigInteger);
        int n2 = mathContext.precision;
        int n3 = 0;
        if (n2 > 0) {
            int n4;
            int n5 = mathContext.roundingMode.oldMode;
            if (l == Long.MIN_VALUE) {
                n3 = BigDecimal.bigDigitLength(bigInteger);
                n4 = n3 - n2;
                while (n4 > 0) {
                    n = BigDecimal.checkScaleNonZero((long)n - (long)n4);
                    l = BigDecimal.compactValFor(bigInteger = BigDecimal.divideAndRoundByTenPow(bigInteger, n4, n5));
                    if (l != Long.MIN_VALUE) break;
                    n3 = BigDecimal.bigDigitLength(bigInteger);
                    n4 = n3 - n2;
                }
            }
            if (l != Long.MIN_VALUE) {
                n3 = BigDecimal.longDigitLength(l);
                n4 = n3 - n2;
                while (n4 > 0) {
                    n = BigDecimal.checkScaleNonZero((long)n - (long)n4);
                    l = BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n4], n5);
                    n3 = BigDecimal.longDigitLength(l);
                    n4 = n3 - n2;
                }
                bigInteger = null;
            }
        }
        this.intVal = bigInteger;
        this.intCompact = l;
        this.scale = n;
        this.precision = n3;
    }

    public BigDecimal(int n) {
        this.intCompact = n;
        this.scale = 0;
        this.intVal = null;
    }

    public BigDecimal(int n, MathContext mathContext) {
        int n2 = mathContext.precision;
        long l = n;
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            n4 = BigDecimal.longDigitLength(l);
            int n5 = n4 - n2;
            while (n5 > 0) {
                n3 = BigDecimal.checkScaleNonZero((long)n3 - (long)n5);
                l = BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n5], mathContext.roundingMode.oldMode);
                n4 = BigDecimal.longDigitLength(l);
                n5 = n4 - n2;
            }
        }
        this.intVal = null;
        this.intCompact = l;
        this.scale = n3;
        this.precision = n4;
    }

    public BigDecimal(long l) {
        this.intCompact = l;
        this.intVal = l == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        this.scale = 0;
    }

    public BigDecimal(long l, MathContext mathContext) {
        BigInteger bigInteger;
        int n = mathContext.precision;
        int n2 = mathContext.roundingMode.oldMode;
        int n3 = 0;
        int n4 = 0;
        BigInteger bigInteger2 = bigInteger = l == Long.MIN_VALUE ? INFLATED_BIGINT : null;
        if (n > 0) {
            int n5;
            if (l == Long.MIN_VALUE) {
                n3 = 19;
                n5 = n3 - n;
                while (n5 > 0) {
                    n4 = BigDecimal.checkScaleNonZero((long)n4 - (long)n5);
                    l = BigDecimal.compactValFor(bigInteger = BigDecimal.divideAndRoundByTenPow(bigInteger, n5, n2));
                    if (l != Long.MIN_VALUE) break;
                    n3 = BigDecimal.bigDigitLength(bigInteger);
                    n5 = n3 - n;
                }
            }
            if (l != Long.MIN_VALUE) {
                n3 = BigDecimal.longDigitLength(l);
                n5 = n3 - n;
                while (n5 > 0) {
                    n4 = BigDecimal.checkScaleNonZero((long)n4 - (long)n5);
                    l = BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n5], mathContext.roundingMode.oldMode);
                    n3 = BigDecimal.longDigitLength(l);
                    n5 = n3 - n;
                }
                bigInteger = null;
            }
        }
        this.intVal = bigInteger;
        this.intCompact = l;
        this.scale = n4;
        this.precision = n3;
    }

    public static BigDecimal valueOf(long l, int n) {
        if (n == 0) {
            return BigDecimal.valueOf(l);
        }
        if (l == 0L) {
            return BigDecimal.zeroValueOf(n);
        }
        return new BigDecimal(l == Long.MIN_VALUE ? INFLATED_BIGINT : null, l, n, 0);
    }

    public static BigDecimal valueOf(long l) {
        if (l >= 0L && l < (long)zeroThroughTen.length) {
            return zeroThroughTen[(int)l];
        }
        if (l != Long.MIN_VALUE) {
            return new BigDecimal(null, l, 0, 0);
        }
        return new BigDecimal(INFLATED_BIGINT, l, 0, 0);
    }

    static BigDecimal valueOf(long l, int n, int n2) {
        if (n == 0 && l >= 0L && l < (long)zeroThroughTen.length) {
            return zeroThroughTen[(int)l];
        }
        if (l == 0L) {
            return BigDecimal.zeroValueOf(n);
        }
        return new BigDecimal(l == Long.MIN_VALUE ? INFLATED_BIGINT : null, l, n, n2);
    }

    static BigDecimal valueOf(BigInteger bigInteger, int n, int n2) {
        long l = BigDecimal.compactValFor(bigInteger);
        if (l == 0L) {
            return BigDecimal.zeroValueOf(n);
        }
        if (n == 0 && l >= 0L && l < (long)zeroThroughTen.length) {
            return zeroThroughTen[(int)l];
        }
        return new BigDecimal(bigInteger, l, n, n2);
    }

    static BigDecimal zeroValueOf(int n) {
        if (n >= 0 && n < ZERO_SCALED_BY.length) {
            return ZERO_SCALED_BY[n];
        }
        return new BigDecimal(BigInteger.ZERO, 0L, n, 1);
    }

    public static BigDecimal valueOf(double d) {
        return new BigDecimal(Double.toString(d));
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        if (this.intCompact != Long.MIN_VALUE) {
            if (bigDecimal.intCompact != Long.MIN_VALUE) {
                return BigDecimal.add(this.intCompact, this.scale, bigDecimal.intCompact, bigDecimal.scale);
            }
            return BigDecimal.add(this.intCompact, this.scale, bigDecimal.intVal, bigDecimal.scale);
        }
        if (bigDecimal.intCompact != Long.MIN_VALUE) {
            return BigDecimal.add(bigDecimal.intCompact, bigDecimal.scale, this.intVal, this.scale);
        }
        return BigDecimal.add(this.intVal, this.scale, bigDecimal.intVal, bigDecimal.scale);
    }

    public BigDecimal add(BigDecimal bigDecimal, MathContext mathContext) {
        boolean bl;
        if (mathContext.precision == 0) {
            return this.add(bigDecimal);
        }
        BigDecimal bigDecimal2 = this;
        boolean bl2 = bigDecimal2.signum() == 0;
        boolean bl3 = bl = bigDecimal.signum() == 0;
        if (bl2 || bl) {
            int n;
            BigDecimal bigDecimal3;
            int n2 = Math.max(bigDecimal2.scale(), bigDecimal.scale());
            if (bl2 && bl) {
                return BigDecimal.zeroValueOf(n2);
            }
            BigDecimal bigDecimal4 = bigDecimal3 = bl2 ? BigDecimal.doRound(bigDecimal, mathContext) : BigDecimal.doRound(bigDecimal2, mathContext);
            if (bigDecimal3.scale() == n2) {
                return bigDecimal3;
            }
            if (bigDecimal3.scale() > n2) {
                return BigDecimal.stripZerosToMatchScale(bigDecimal3.intVal, bigDecimal3.intCompact, bigDecimal3.scale, n2);
            }
            int n3 = mathContext.precision - bigDecimal3.precision();
            if (n3 >= (n = n2 - bigDecimal3.scale())) {
                return bigDecimal3.setScale(n2);
            }
            return bigDecimal3.setScale(bigDecimal3.scale() + n3);
        }
        long l = (long)bigDecimal2.scale - (long)bigDecimal.scale;
        if (l != 0L) {
            BigDecimal[] bigDecimalArray = this.preAlign(bigDecimal2, bigDecimal, l, mathContext);
            BigDecimal.matchScale(bigDecimalArray);
            bigDecimal2 = bigDecimalArray[0];
            bigDecimal = bigDecimalArray[1];
        }
        return BigDecimal.doRound(bigDecimal2.inflated().add(bigDecimal.inflated()), bigDecimal2.scale, mathContext);
    }

    private BigDecimal[] preAlign(BigDecimal bigDecimal, BigDecimal bigDecimal2, long l, MathContext mathContext) {
        BigDecimal bigDecimal3;
        BigDecimal bigDecimal4;
        assert (l != 0L);
        if (l < 0L) {
            bigDecimal4 = bigDecimal;
            bigDecimal3 = bigDecimal2;
        } else {
            bigDecimal4 = bigDecimal2;
            bigDecimal3 = bigDecimal;
        }
        long l2 = (long)bigDecimal4.scale - (long)bigDecimal4.precision() + (long)mathContext.precision;
        long l3 = (long)bigDecimal3.scale - (long)bigDecimal3.precision() + 1L;
        if (l3 > (long)(bigDecimal4.scale + 2) && l3 > l2 + 2L) {
            bigDecimal3 = BigDecimal.valueOf(bigDecimal3.signum(), this.checkScale(Math.max((long)bigDecimal4.scale, l2) + 3L));
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[]{bigDecimal4, bigDecimal3};
        return bigDecimalArray;
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        if (this.intCompact != Long.MIN_VALUE) {
            if (bigDecimal.intCompact != Long.MIN_VALUE) {
                return BigDecimal.add(this.intCompact, this.scale, -bigDecimal.intCompact, bigDecimal.scale);
            }
            return BigDecimal.add(this.intCompact, this.scale, bigDecimal.intVal.negate(), bigDecimal.scale);
        }
        if (bigDecimal.intCompact != Long.MIN_VALUE) {
            return BigDecimal.add(-bigDecimal.intCompact, bigDecimal.scale, this.intVal, this.scale);
        }
        return BigDecimal.add(this.intVal, this.scale, bigDecimal.intVal.negate(), bigDecimal.scale);
    }

    public BigDecimal subtract(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.subtract(bigDecimal);
        }
        return this.add(bigDecimal.negate(), mathContext);
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        int n = this.checkScale((long)this.scale + (long)bigDecimal.scale);
        if (this.intCompact != Long.MIN_VALUE) {
            if (bigDecimal.intCompact != Long.MIN_VALUE) {
                return BigDecimal.multiply(this.intCompact, bigDecimal.intCompact, n);
            }
            return BigDecimal.multiply(this.intCompact, bigDecimal.intVal, n);
        }
        if (bigDecimal.intCompact != Long.MIN_VALUE) {
            return BigDecimal.multiply(bigDecimal.intCompact, this.intVal, n);
        }
        return BigDecimal.multiply(this.intVal, bigDecimal.intVal, n);
    }

    public BigDecimal multiply(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.multiply(bigDecimal);
        }
        int n = this.checkScale((long)this.scale + (long)bigDecimal.scale);
        if (this.intCompact != Long.MIN_VALUE) {
            if (bigDecimal.intCompact != Long.MIN_VALUE) {
                return BigDecimal.multiplyAndRound(this.intCompact, bigDecimal.intCompact, n, mathContext);
            }
            return BigDecimal.multiplyAndRound(this.intCompact, bigDecimal.intVal, n, mathContext);
        }
        if (bigDecimal.intCompact != Long.MIN_VALUE) {
            return BigDecimal.multiplyAndRound(bigDecimal.intCompact, this.intVal, n, mathContext);
        }
        return BigDecimal.multiplyAndRound(this.intVal, bigDecimal.intVal, n, mathContext);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (this.intCompact != Long.MIN_VALUE) {
            if (bigDecimal.intCompact != Long.MIN_VALUE) {
                return BigDecimal.divide(this.intCompact, this.scale, bigDecimal.intCompact, bigDecimal.scale, n, n2);
            }
            return BigDecimal.divide(this.intCompact, this.scale, bigDecimal.intVal, bigDecimal.scale, n, n2);
        }
        if (bigDecimal.intCompact != Long.MIN_VALUE) {
            return BigDecimal.divide(this.intVal, this.scale, bigDecimal.intCompact, bigDecimal.scale, n, n2);
        }
        return BigDecimal.divide(this.intVal, this.scale, bigDecimal.intVal, bigDecimal.scale, n, n2);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, RoundingMode roundingMode) {
        return this.divide(bigDecimal, n, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) {
        return this.divide(bigDecimal, this.scale, n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return this.divide(bigDecimal, this.scale, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (bigDecimal.signum() == 0) {
            if (this.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        int n = BigDecimal.saturateLong((long)this.scale - (long)bigDecimal.scale);
        if (this.signum() == 0) {
            return BigDecimal.zeroValueOf(n);
        }
        MathContext mathContext = new MathContext((int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)bigDecimal.precision() / 3.0), Integer.MAX_VALUE), RoundingMode.UNNECESSARY);
        try {
            bigDecimal2 = this.divide(bigDecimal, mathContext);
        }
        catch (ArithmeticException arithmeticException) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result.");
        }
        int n2 = bigDecimal2.scale();
        if (n > n2) {
            return bigDecimal2.setScale(n, 7);
        }
        return bigDecimal2;
    }

    public BigDecimal divide(BigDecimal bigDecimal, MathContext mathContext) {
        int n = mathContext.precision;
        if (n == 0) {
            return this.divide(bigDecimal);
        }
        BigDecimal bigDecimal2 = this;
        long l = (long)bigDecimal2.scale - (long)bigDecimal.scale;
        if (bigDecimal.signum() == 0) {
            if (bigDecimal2.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        if (bigDecimal2.signum() == 0) {
            return BigDecimal.zeroValueOf(BigDecimal.saturateLong(l));
        }
        int n2 = bigDecimal2.precision();
        int n3 = bigDecimal.precision();
        if (bigDecimal2.intCompact != Long.MIN_VALUE) {
            if (bigDecimal.intCompact != Long.MIN_VALUE) {
                return BigDecimal.divide(bigDecimal2.intCompact, n2, bigDecimal.intCompact, n3, l, mathContext);
            }
            return BigDecimal.divide(bigDecimal2.intCompact, n2, bigDecimal.intVal, n3, l, mathContext);
        }
        if (bigDecimal.intCompact != Long.MIN_VALUE) {
            return BigDecimal.divide(bigDecimal2.intVal, n2, bigDecimal.intCompact, n3, l, mathContext);
        }
        return BigDecimal.divide(bigDecimal2.intVal, n2, bigDecimal.intVal, n3, l, mathContext);
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal) {
        int n = BigDecimal.saturateLong((long)this.scale - (long)bigDecimal.scale);
        if (this.compareMagnitude(bigDecimal) < 0) {
            return BigDecimal.zeroValueOf(n);
        }
        if (this.signum() == 0 && bigDecimal.signum() != 0) {
            return this.setScale(n, 7);
        }
        int n2 = (int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)bigDecimal.precision() / 3.0) + Math.abs((long)this.scale() - (long)bigDecimal.scale()) + 2L, Integer.MAX_VALUE);
        BigDecimal bigDecimal2 = this.divide(bigDecimal, new MathContext(n2, RoundingMode.DOWN));
        if (bigDecimal2.scale > 0) {
            bigDecimal2 = bigDecimal2.setScale(0, RoundingMode.DOWN);
            bigDecimal2 = BigDecimal.stripZerosToMatchScale(bigDecimal2.intVal, bigDecimal2.intCompact, bigDecimal2.scale, n);
        }
        if (bigDecimal2.scale < n) {
            bigDecimal2 = bigDecimal2.setScale(n, 7);
        }
        return bigDecimal2;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal, MathContext mathContext) {
        int n;
        if (mathContext.precision == 0 || this.compareMagnitude(bigDecimal) < 0) {
            return this.divideToIntegralValue(bigDecimal);
        }
        int n2 = BigDecimal.saturateLong((long)this.scale - (long)bigDecimal.scale);
        BigDecimal bigDecimal2 = this.divide(bigDecimal, new MathContext(mathContext.precision, RoundingMode.DOWN));
        if (bigDecimal2.scale() < 0) {
            BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
            if (this.subtract(bigDecimal3).compareMagnitude(bigDecimal) >= 0) {
                throw new ArithmeticException("Division impossible");
            }
        } else if (bigDecimal2.scale() > 0) {
            bigDecimal2 = bigDecimal2.setScale(0, RoundingMode.DOWN);
        }
        if (n2 > bigDecimal2.scale() && (n = mathContext.precision - bigDecimal2.precision()) > 0) {
            return bigDecimal2.setScale(bigDecimal2.scale() + Math.min(n, n2 - bigDecimal2.scale));
        }
        return BigDecimal.stripZerosToMatchScale(bigDecimal2.intVal, bigDecimal2.intCompact, bigDecimal2.scale, n2);
    }

    public BigDecimal remainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = this.divideAndRemainder(bigDecimal);
        return bigDecimalArray[1];
    }

    public BigDecimal remainder(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal[] bigDecimalArray = this.divideAndRemainder(bigDecimal, mathContext);
        return bigDecimalArray[1];
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray;
        bigDecimalArray = new BigDecimal[]{this.divideToIntegralValue(bigDecimal), this.subtract(bigDecimalArray[0].multiply(bigDecimal))};
        return bigDecimalArray;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.divideAndRemainder(bigDecimal);
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[2];
        BigDecimal bigDecimal2 = this;
        bigDecimalArray[0] = bigDecimal2.divideToIntegralValue(bigDecimal, mathContext);
        bigDecimalArray[1] = bigDecimal2.subtract(bigDecimalArray[0].multiply(bigDecimal));
        return bigDecimalArray;
    }

    public BigDecimal pow(int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        int n2 = this.checkScale((long)this.scale * (long)n);
        return new BigDecimal(this.inflated().pow(n), n2);
    }

    public BigDecimal pow(int n, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.pow(n);
        }
        if (n < -999999999 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        if (n == 0) {
            return ONE;
        }
        BigDecimal bigDecimal = this;
        MathContext mathContext2 = mathContext;
        int n2 = Math.abs(n);
        if (mathContext.precision > 0) {
            int n3 = BigDecimal.longDigitLength(n2);
            if (n3 > mathContext.precision) {
                throw new ArithmeticException("Invalid operation");
            }
            mathContext2 = new MathContext(mathContext.precision + n3 + 1, mathContext.roundingMode);
        }
        BigDecimal bigDecimal2 = ONE;
        boolean bl = false;
        int n4 = 1;
        while (true) {
            if ((n2 += n2) < 0) {
                bl = true;
                bigDecimal2 = bigDecimal2.multiply(bigDecimal, mathContext2);
            }
            if (n4 == 31) break;
            if (bl) {
                bigDecimal2 = bigDecimal2.multiply(bigDecimal2, mathContext2);
            }
            ++n4;
        }
        if (n < 0) {
            bigDecimal2 = ONE.divide(bigDecimal2, mathContext2);
        }
        return BigDecimal.doRound(bigDecimal2, mathContext);
    }

    public BigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal abs(MathContext mathContext) {
        return this.signum() < 0 ? this.negate(mathContext) : this.plus(mathContext);
    }

    public BigDecimal negate() {
        if (this.intCompact == Long.MIN_VALUE) {
            return new BigDecimal(this.intVal.negate(), Long.MIN_VALUE, this.scale, this.precision);
        }
        return BigDecimal.valueOf(-this.intCompact, this.scale, this.precision);
    }

    public BigDecimal negate(MathContext mathContext) {
        return this.negate().plus(mathContext);
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this;
        }
        return BigDecimal.doRound(this, mathContext);
    }

    public int signum() {
        return this.intCompact != Long.MIN_VALUE ? Long.signum(this.intCompact) : this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        int n = this.precision;
        if (n == 0) {
            long l = this.intCompact;
            n = l != Long.MIN_VALUE ? BigDecimal.longDigitLength(l) : BigDecimal.bigDigitLength(this.intVal);
            this.precision = n;
        }
        return n;
    }

    public BigInteger unscaledValue() {
        return this.inflated();
    }

    public BigDecimal round(MathContext mathContext) {
        return this.plus(mathContext);
    }

    public BigDecimal setScale(int n, RoundingMode roundingMode) {
        return this.setScale(n, roundingMode.oldMode);
    }

    public BigDecimal setScale(int n, int n2) {
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        int n3 = this.scale;
        if (n == n3) {
            return this;
        }
        if (this.signum() == 0) {
            return BigDecimal.zeroValueOf(n);
        }
        if (this.intCompact != Long.MIN_VALUE) {
            long l = this.intCompact;
            if (n > n3) {
                int n4 = this.checkScale((long)n - (long)n3);
                if ((l = BigDecimal.longMultiplyPowerTen(l, n4)) != Long.MIN_VALUE) {
                    return BigDecimal.valueOf(l, n);
                }
                BigInteger bigInteger = this.bigMultiplyPowerTen(n4);
                return new BigDecimal(bigInteger, Long.MIN_VALUE, n, this.precision > 0 ? this.precision + n4 : 0);
            }
            int n5 = this.checkScale((long)n3 - (long)n);
            if (n5 < LONG_TEN_POWERS_TABLE.length) {
                return BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n5], n, n2, n);
            }
            return BigDecimal.divideAndRound(this.inflated(), BigDecimal.bigTenToThe(n5), n, n2, n);
        }
        if (n > n3) {
            int n6 = this.checkScale((long)n - (long)n3);
            BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(this.intVal, n6);
            return new BigDecimal(bigInteger, Long.MIN_VALUE, n, this.precision > 0 ? this.precision + n6 : 0);
        }
        int n7 = this.checkScale((long)n3 - (long)n);
        if (n7 < LONG_TEN_POWERS_TABLE.length) {
            return BigDecimal.divideAndRound(this.intVal, LONG_TEN_POWERS_TABLE[n7], n, n2, n);
        }
        return BigDecimal.divideAndRound(this.intVal, BigDecimal.bigTenToThe(n7), n, n2, n);
    }

    public BigDecimal setScale(int n) {
        return this.setScale(n, 7);
    }

    public BigDecimal movePointLeft(int n) {
        int n2 = this.checkScale((long)this.scale + (long)n);
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.intCompact, n2, 0);
        return bigDecimal.scale < 0 ? bigDecimal.setScale(0, 7) : bigDecimal;
    }

    public BigDecimal movePointRight(int n) {
        int n2 = this.checkScale((long)this.scale - (long)n);
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.intCompact, n2, 0);
        return bigDecimal.scale < 0 ? bigDecimal.setScale(0, 7) : bigDecimal;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        return new BigDecimal(this.intVal, this.intCompact, this.checkScale((long)this.scale - (long)n), this.precision);
    }

    public BigDecimal stripTrailingZeros() {
        if (this.intCompact == 0L || this.intVal != null && this.intVal.signum() == 0) {
            return ZERO;
        }
        if (this.intCompact != Long.MIN_VALUE) {
            return BigDecimal.createAndStripZerosToMatchScale(this.intCompact, this.scale, Long.MIN_VALUE);
        }
        return BigDecimal.createAndStripZerosToMatchScale(this.intVal, this.scale, Long.MIN_VALUE);
    }

    @Override
    public int compareTo(BigDecimal bigDecimal) {
        int n;
        int n2;
        if (this.scale == bigDecimal.scale) {
            long l = this.intCompact;
            long l2 = bigDecimal.intCompact;
            if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
                return l != l2 ? (l > l2 ? 1 : -1) : 0;
            }
        }
        if ((n2 = this.signum()) != (n = bigDecimal.signum())) {
            return n2 > n ? 1 : -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.compareMagnitude(bigDecimal);
        return n2 > 0 ? n3 : -n3;
    }

    private int compareMagnitude(BigDecimal bigDecimal) {
        long l = bigDecimal.intCompact;
        long l2 = this.intCompact;
        if (l2 == 0L) {
            return l == 0L ? 0 : -1;
        }
        if (l == 0L) {
            return 1;
        }
        long l3 = (long)this.scale - (long)bigDecimal.scale;
        if (l3 != 0L) {
            long l4;
            long l5 = (long)this.precision() - (long)this.scale;
            if (l5 < (l4 = (long)bigDecimal.precision() - (long)bigDecimal.scale)) {
                return -1;
            }
            if (l5 > l4) {
                return 1;
            }
            BigInteger bigInteger = null;
            if (l3 < 0L) {
                if (l3 > Integer.MIN_VALUE && (l2 == Long.MIN_VALUE || (l2 = BigDecimal.longMultiplyPowerTen(l2, (int)(-l3))) == Long.MIN_VALUE) && l == Long.MIN_VALUE) {
                    bigInteger = this.bigMultiplyPowerTen((int)(-l3));
                    return bigInteger.compareMagnitude(bigDecimal.intVal);
                }
            } else if (l3 <= Integer.MAX_VALUE && (l == Long.MIN_VALUE || (l = BigDecimal.longMultiplyPowerTen(l, (int)l3)) == Long.MIN_VALUE) && l2 == Long.MIN_VALUE) {
                bigInteger = bigDecimal.bigMultiplyPowerTen((int)l3);
                return this.intVal.compareMagnitude(bigInteger);
            }
        }
        if (l2 != Long.MIN_VALUE) {
            return l != Long.MIN_VALUE ? BigDecimal.longCompareMagnitude(l2, l) : -1;
        }
        if (l != Long.MIN_VALUE) {
            return 1;
        }
        return this.intVal.compareMagnitude(bigDecimal.intVal);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        if (object == this) {
            return true;
        }
        if (this.scale != bigDecimal.scale) {
            return false;
        }
        long l = this.intCompact;
        long l2 = bigDecimal.intCompact;
        if (l != Long.MIN_VALUE) {
            if (l2 == Long.MIN_VALUE) {
                l2 = BigDecimal.compactValFor(bigDecimal.intVal);
            }
            return l2 == l;
        }
        if (l2 != Long.MIN_VALUE) {
            return l2 == BigDecimal.compactValFor(this.intVal);
        }
        return this.inflated().equals(bigDecimal.inflated());
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) <= 0 ? this : bigDecimal;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) >= 0 ? this : bigDecimal;
    }

    public int hashCode() {
        if (this.intCompact != Long.MIN_VALUE) {
            long l = this.intCompact < 0L ? -this.intCompact : this.intCompact;
            int n = (int)((long)((int)(l >>> 32) * 31) + (l & 0xFFFFFFFFL));
            return 31 * (this.intCompact < 0L ? -n : n) + this.scale;
        }
        return 31 * this.intVal.hashCode() + this.scale;
    }

    public String toString() {
        String string = this.stringCache;
        if (string == null) {
            this.stringCache = string = this.layoutChars(true);
        }
        return string;
    }

    public String toEngineeringString() {
        return this.layoutChars(false);
    }

    public String toPlainString() {
        if (this.scale == 0) {
            if (this.intCompact != Long.MIN_VALUE) {
                return Long.toString(this.intCompact);
            }
            return this.intVal.toString();
        }
        if (this.scale < 0) {
            StringBuilder stringBuilder;
            if (this.signum() == 0) {
                return "0";
            }
            int n = BigDecimal.checkScaleNonZero(-((long)this.scale));
            if (this.intCompact != Long.MIN_VALUE) {
                stringBuilder = new StringBuilder(20 + n);
                stringBuilder.append(this.intCompact);
            } else {
                String string = this.intVal.toString();
                stringBuilder = new StringBuilder(string.length() + n);
                stringBuilder.append(string);
            }
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('0');
            }
            return stringBuilder.toString();
        }
        String string = this.intCompact != Long.MIN_VALUE ? Long.toString(Math.abs(this.intCompact)) : this.intVal.abs().toString();
        return this.getValueString(this.signum(), string, this.scale);
    }

    private String getValueString(int n, String string, int n2) {
        StringBuilder stringBuilder;
        int n3 = string.length() - n2;
        if (n3 == 0) {
            return (n < 0 ? "-0." : "0.") + string;
        }
        if (n3 > 0) {
            stringBuilder = new StringBuilder(string);
            stringBuilder.insert(n3, '.');
            if (n < 0) {
                stringBuilder.insert(0, '-');
            }
        } else {
            stringBuilder = new StringBuilder(3 - n3 + string.length());
            stringBuilder.append(n < 0 ? "-0." : "0.");
            for (int i = 0; i < -n3; ++i) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public BigInteger toBigInteger() {
        return this.setScale(0, 1).inflated();
    }

    public BigInteger toBigIntegerExact() {
        return this.setScale(0, 7).inflated();
    }

    @Override
    public long longValue() {
        return this.intCompact != Long.MIN_VALUE && this.scale == 0 ? this.intCompact : this.toBigInteger().longValue();
    }

    public long longValueExact() {
        if (this.intCompact != Long.MIN_VALUE && this.scale == 0) {
            return this.intCompact;
        }
        if (this.precision() - this.scale > 19) {
            throw new ArithmeticException("Overflow");
        }
        if (this.signum() == 0) {
            return 0L;
        }
        if (this.precision() - this.scale <= 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        BigDecimal bigDecimal = this.setScale(0, 7);
        if (bigDecimal.precision() >= 19) {
            LongOverflow.check(bigDecimal);
        }
        return bigDecimal.inflated().longValue();
    }

    @Override
    public int intValue() {
        return this.intCompact != Long.MIN_VALUE && this.scale == 0 ? (int)this.intCompact : this.toBigInteger().intValue();
    }

    public int intValueExact() {
        long l = this.longValueExact();
        if ((long)((int)l) != l) {
            throw new ArithmeticException("Overflow");
        }
        return (int)l;
    }

    public short shortValueExact() {
        long l = this.longValueExact();
        if ((long)((short)l) != l) {
            throw new ArithmeticException("Overflow");
        }
        return (short)l;
    }

    public byte byteValueExact() {
        long l = this.longValueExact();
        if ((long)((byte)l) != l) {
            throw new ArithmeticException("Overflow");
        }
        return (byte)l;
    }

    @Override
    public float floatValue() {
        if (this.intCompact != Long.MIN_VALUE) {
            if (this.scale == 0) {
                return this.intCompact;
            }
            if (Math.abs(this.intCompact) < 0x400000L) {
                if (this.scale > 0 && this.scale < float10pow.length) {
                    return (float)this.intCompact / float10pow[this.scale];
                }
                if (this.scale < 0 && this.scale > -float10pow.length) {
                    return (float)this.intCompact * float10pow[-this.scale];
                }
            }
        }
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        if (this.intCompact != Long.MIN_VALUE) {
            if (this.scale == 0) {
                return this.intCompact;
            }
            if (Math.abs(this.intCompact) < 0x10000000000000L) {
                if (this.scale > 0 && this.scale < double10pow.length) {
                    return (double)this.intCompact / double10pow[this.scale];
                }
                if (this.scale < 0 && this.scale > -double10pow.length) {
                    return (double)this.intCompact * double10pow[-this.scale];
                }
            }
        }
        return Double.parseDouble(this.toString());
    }

    public BigDecimal ulp() {
        return BigDecimal.valueOf(1L, this.scale(), 1);
    }

    private String layoutChars(boolean bl) {
        StringBuilder stringBuilder;
        block21: {
            long l;
            block23: {
                int n;
                int n2;
                char[] cArray;
                int n3;
                block24: {
                    block22: {
                        block20: {
                            if (this.scale == 0) {
                                return this.intCompact != Long.MIN_VALUE ? Long.toString(this.intCompact) : this.intVal.toString();
                            }
                            if (this.scale == 2 && this.intCompact >= 0L && this.intCompact < Integer.MAX_VALUE) {
                                int n4 = (int)this.intCompact % 100;
                                int n5 = (int)this.intCompact / 100;
                                return Integer.toString(n5) + '.' + StringBuilderHelper.DIGIT_TENS[n4] + StringBuilderHelper.DIGIT_ONES[n4];
                            }
                            StringBuilderHelper stringBuilderHelper = threadLocalStringBuilderHelper.get();
                            if (this.intCompact != Long.MIN_VALUE) {
                                n3 = stringBuilderHelper.putIntCompact(Math.abs(this.intCompact));
                                cArray = stringBuilderHelper.getCompactCharArray();
                            } else {
                                n3 = 0;
                                cArray = this.intVal.abs().toString().toCharArray();
                            }
                            stringBuilder = stringBuilderHelper.getStringBuilder();
                            if (this.signum() < 0) {
                                stringBuilder.append('-');
                            }
                            n2 = cArray.length - n3;
                            l = -((long)this.scale) + (long)(n2 - 1);
                            if (this.scale < 0 || l < -6L) break block20;
                            int n6 = this.scale - n2;
                            if (n6 >= 0) {
                                stringBuilder.append('0');
                                stringBuilder.append('.');
                                while (n6 > 0) {
                                    stringBuilder.append('0');
                                    --n6;
                                }
                                stringBuilder.append(cArray, n3, n2);
                            } else {
                                stringBuilder.append(cArray, n3, -n6);
                                stringBuilder.append('.');
                                stringBuilder.append(cArray, -n6 + n3, this.scale);
                            }
                            break block21;
                        }
                        if (!bl) break block22;
                        stringBuilder.append(cArray[n3]);
                        if (n2 > 1) {
                            stringBuilder.append('.');
                            stringBuilder.append(cArray, n3 + 1, n2 - 1);
                        }
                        break block23;
                    }
                    n = (int)(l % 3L);
                    if (n < 0) {
                        n += 3;
                    }
                    l -= (long)n;
                    ++n;
                    if (this.signum() != 0) break block24;
                    switch (n) {
                        case 1: {
                            stringBuilder.append('0');
                            break block23;
                        }
                        case 2: {
                            stringBuilder.append("0.00");
                            l += 3L;
                            break block23;
                        }
                        case 3: {
                            stringBuilder.append("0.0");
                            l += 3L;
                            break block23;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected sig value " + n));
                        }
                    }
                }
                if (n >= n2) {
                    stringBuilder.append(cArray, n3, n2);
                    for (int i = n - n2; i > 0; --i) {
                        stringBuilder.append('0');
                    }
                } else {
                    stringBuilder.append(cArray, n3, n);
                    stringBuilder.append('.');
                    stringBuilder.append(cArray, n3 + n, n2 - n);
                }
            }
            if (l != 0L) {
                stringBuilder.append('E');
                if (l > 0L) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(l);
            }
        }
        return stringBuilder.toString();
    }

    private static BigInteger bigTenToThe(int n) {
        if (n < 0) {
            return BigInteger.ZERO;
        }
        if (n < BIG_TEN_POWERS_TABLE_MAX) {
            BigInteger[] bigIntegerArray = BIG_TEN_POWERS_TABLE;
            if (n < bigIntegerArray.length) {
                return bigIntegerArray[n];
            }
            return BigDecimal.expandBigIntegerTenPowers(n);
        }
        return BigInteger.TEN.pow(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BigInteger expandBigIntegerTenPowers(int n) {
        Class<BigDecimal> clazz = BigDecimal.class;
        synchronized (BigDecimal.class) {
            BigInteger[] bigIntegerArray = BIG_TEN_POWERS_TABLE;
            int n2 = bigIntegerArray.length;
            if (n2 <= n) {
                int n3;
                for (n3 = n2 << 1; n3 <= n; n3 <<= 1) {
                }
                bigIntegerArray = Arrays.copyOf(bigIntegerArray, n3);
                for (int i = n2; i < n3; ++i) {
                    bigIntegerArray[i] = bigIntegerArray[i - 1].multiply(BigInteger.TEN);
                }
                BIG_TEN_POWERS_TABLE = bigIntegerArray;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return bigIntegerArray[n];
        }
    }

    private static long longMultiplyPowerTen(long l, int n) {
        if (l == 0L || n <= 0) {
            return l;
        }
        long[] lArray = LONG_TEN_POWERS_TABLE;
        long[] lArray2 = THRESHOLDS_TABLE;
        if (n < lArray.length && n < lArray2.length) {
            long l2 = lArray[n];
            if (l == 1L) {
                return l2;
            }
            if (Math.abs(l) <= lArray2[n]) {
                return l * l2;
            }
        }
        return Long.MIN_VALUE;
    }

    private BigInteger bigMultiplyPowerTen(int n) {
        if (n <= 0) {
            return this.inflated();
        }
        if (this.intCompact != Long.MIN_VALUE) {
            return BigDecimal.bigTenToThe(n).multiply(this.intCompact);
        }
        return this.intVal.multiply(BigDecimal.bigTenToThe(n));
    }

    private BigInteger inflated() {
        if (this.intVal == null) {
            return BigInteger.valueOf(this.intCompact);
        }
        return this.intVal;
    }

    private static void matchScale(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray[0].scale == bigDecimalArray[1].scale) {
            return;
        }
        if (bigDecimalArray[0].scale < bigDecimalArray[1].scale) {
            bigDecimalArray[0] = bigDecimalArray[0].setScale(bigDecimalArray[1].scale, 7);
        } else if (bigDecimalArray[1].scale < bigDecimalArray[0].scale) {
            bigDecimalArray[1] = bigDecimalArray[1].setScale(bigDecimalArray[0].scale, 7);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.intVal == null) {
            String string = "BigDecimal: null intVal in stream";
            throw new StreamCorruptedException(string);
        }
        UnsafeHolder.setIntCompactVolatile(this, BigDecimal.compactValFor(this.intVal));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.intVal == null) {
            UnsafeHolder.setIntValVolatile(this, BigInteger.valueOf(this.intCompact));
        }
        objectOutputStream.defaultWriteObject();
    }

    static int longDigitLength(long l) {
        long[] lArray;
        assert (l != Long.MIN_VALUE);
        if (l < 0L) {
            l = -l;
        }
        if (l < 10L) {
            return 1;
        }
        int n = (64 - Long.numberOfLeadingZeros(l) + 1) * 1233 >>> 12;
        return n >= (lArray = LONG_TEN_POWERS_TABLE).length || l < lArray[n] ? n : n + 1;
    }

    private static int bigDigitLength(BigInteger bigInteger) {
        if (bigInteger.signum == 0) {
            return 1;
        }
        int n = (int)(((long)bigInteger.bitLength() + 1L) * 646456993L >>> 31);
        return bigInteger.compareMagnitude(BigDecimal.bigTenToThe(n)) < 0 ? n : n + 1;
    }

    private int checkScale(long l) {
        int n = (int)l;
        if ((long)n != l) {
            BigInteger bigInteger;
            int n2 = n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            if (this.intCompact != 0L && ((bigInteger = this.intVal) == null || bigInteger.signum() != 0)) {
                throw new ArithmeticException(n > 0 ? "Underflow" : "Overflow");
            }
        }
        return n;
    }

    private static long compactValFor(BigInteger bigInteger) {
        int[] nArray = bigInteger.mag;
        int n = nArray.length;
        if (n == 0) {
            return 0L;
        }
        int n2 = nArray[0];
        if (n > 2 || n == 2 && n2 < 0) {
            return Long.MIN_VALUE;
        }
        long l = n == 2 ? ((long)nArray[1] & 0xFFFFFFFFL) + ((long)n2 << 32) : (long)n2 & 0xFFFFFFFFL;
        return bigInteger.signum < 0 ? -l : l;
    }

    private static int longCompareMagnitude(long l, long l2) {
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    private static int saturateLong(long l) {
        int n = (int)l;
        return l == (long)n ? n : (l < 0L ? Integer.MIN_VALUE : Integer.MAX_VALUE);
    }

    private static void print(String string, BigDecimal bigDecimal) {
        System.err.format("%s:\tintCompact %d\tintVal %d\tscale %d\tprecision %d%n", string, bigDecimal.intCompact, bigDecimal.intVal, bigDecimal.scale, bigDecimal.precision);
    }

    private BigDecimal audit() {
        if (this.intCompact == Long.MIN_VALUE) {
            if (this.intVal == null) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"null intVal");
            }
            if (this.precision > 0 && this.precision != BigDecimal.bigDigitLength(this.intVal)) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"precision mismatch");
            }
        } else {
            long l;
            if (this.intVal != null && (l = this.intVal.longValue()) != this.intCompact) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)("Inconsistent state, intCompact=" + this.intCompact + "\t intVal=" + l));
            }
            if (this.precision > 0 && this.precision != BigDecimal.longDigitLength(this.intCompact)) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"precision mismatch");
            }
        }
        return this;
    }

    private static int checkScaleNonZero(long l) {
        int n = (int)l;
        if ((long)n != l) {
            throw new ArithmeticException(n > 0 ? "Underflow" : "Overflow");
        }
        return n;
    }

    private static int checkScale(long l, long l2) {
        int n = (int)l2;
        if ((long)n != l2) {
            int n2 = n = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            if (l != 0L) {
                throw new ArithmeticException(n > 0 ? "Underflow" : "Overflow");
            }
        }
        return n;
    }

    private static int checkScale(BigInteger bigInteger, long l) {
        int n = (int)l;
        if ((long)n != l) {
            int n2 = n = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            if (bigInteger.signum() != 0) {
                throw new ArithmeticException(n > 0 ? "Underflow" : "Overflow");
            }
        }
        return n;
    }

    private static BigDecimal doRound(BigDecimal bigDecimal, MathContext mathContext) {
        int n = mathContext.precision;
        boolean bl = false;
        if (n > 0) {
            int n2;
            BigInteger bigInteger = bigDecimal.intVal;
            long l = bigDecimal.intCompact;
            int n3 = bigDecimal.scale;
            int n4 = bigDecimal.precision();
            int n5 = mathContext.roundingMode.oldMode;
            if (l == Long.MIN_VALUE) {
                n2 = n4 - n;
                while (n2 > 0) {
                    n3 = BigDecimal.checkScaleNonZero((long)n3 - (long)n2);
                    bigInteger = BigDecimal.divideAndRoundByTenPow(bigInteger, n2, n5);
                    bl = true;
                    l = BigDecimal.compactValFor(bigInteger);
                    if (l != Long.MIN_VALUE) {
                        n4 = BigDecimal.longDigitLength(l);
                        break;
                    }
                    n4 = BigDecimal.bigDigitLength(bigInteger);
                    n2 = n4 - n;
                }
            }
            if (l != Long.MIN_VALUE) {
                n2 = n4 - n;
                while (n2 > 0) {
                    n3 = BigDecimal.checkScaleNonZero((long)n3 - (long)n2);
                    l = BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n2], mathContext.roundingMode.oldMode);
                    bl = true;
                    n4 = BigDecimal.longDigitLength(l);
                    n2 = n4 - n;
                    bigInteger = null;
                }
            }
            return bl ? new BigDecimal(bigInteger, l, n3, n4) : bigDecimal;
        }
        return bigDecimal;
    }

    private static BigDecimal doRound(long l, int n, MathContext mathContext) {
        int n2 = mathContext.precision;
        if (n2 > 0 && n2 < 19) {
            int n3 = BigDecimal.longDigitLength(l);
            int n4 = n3 - n2;
            while (n4 > 0) {
                n = BigDecimal.checkScaleNonZero((long)n - (long)n4);
                l = BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n4], mathContext.roundingMode.oldMode);
                n3 = BigDecimal.longDigitLength(l);
                n4 = n3 - n2;
            }
            return BigDecimal.valueOf(l, n, n3);
        }
        return BigDecimal.valueOf(l, n);
    }

    private static BigDecimal doRound(BigInteger bigInteger, int n, MathContext mathContext) {
        int n2 = mathContext.precision;
        int n3 = 0;
        if (n2 > 0) {
            int n4;
            long l = BigDecimal.compactValFor(bigInteger);
            int n5 = mathContext.roundingMode.oldMode;
            if (l == Long.MIN_VALUE) {
                n3 = BigDecimal.bigDigitLength(bigInteger);
                n4 = n3 - n2;
                while (n4 > 0) {
                    n = BigDecimal.checkScaleNonZero((long)n - (long)n4);
                    l = BigDecimal.compactValFor(bigInteger = BigDecimal.divideAndRoundByTenPow(bigInteger, n4, n5));
                    if (l != Long.MIN_VALUE) break;
                    n3 = BigDecimal.bigDigitLength(bigInteger);
                    n4 = n3 - n2;
                }
            }
            if (l != Long.MIN_VALUE) {
                n3 = BigDecimal.longDigitLength(l);
                n4 = n3 - n2;
                while (n4 > 0) {
                    n = BigDecimal.checkScaleNonZero((long)n - (long)n4);
                    l = BigDecimal.divideAndRound(l, LONG_TEN_POWERS_TABLE[n4], mathContext.roundingMode.oldMode);
                    n3 = BigDecimal.longDigitLength(l);
                    n4 = n3 - n2;
                }
                return BigDecimal.valueOf(l, n, n3);
            }
        }
        return new BigDecimal(bigInteger, Long.MIN_VALUE, n, n3);
    }

    private static BigInteger divideAndRoundByTenPow(BigInteger bigInteger, int n, int n2) {
        bigInteger = n < LONG_TEN_POWERS_TABLE.length ? BigDecimal.divideAndRound(bigInteger, LONG_TEN_POWERS_TABLE[n], n2) : BigDecimal.divideAndRound(bigInteger, BigDecimal.bigTenToThe(n), n2);
        return bigInteger;
    }

    private static BigDecimal divideAndRound(long l, long l2, int n, int n2, int n3) {
        int n4;
        long l3 = l / l2;
        if (n2 == 1 && n == n3) {
            return BigDecimal.valueOf(l3, n);
        }
        long l4 = l % l2;
        int n5 = n4 = l < 0L == l2 < 0L ? 1 : -1;
        if (l4 != 0L) {
            boolean bl = BigDecimal.needIncrement(l2, n2, n4, l3, l4);
            return BigDecimal.valueOf(bl ? l3 + (long)n4 : l3, n);
        }
        if (n3 != n) {
            return BigDecimal.createAndStripZerosToMatchScale(l3, n, (long)n3);
        }
        return BigDecimal.valueOf(l3, n);
    }

    private static long divideAndRound(long l, long l2, int n) {
        int n2;
        long l3 = l / l2;
        if (n == 1) {
            return l3;
        }
        long l4 = l % l2;
        int n3 = n2 = l < 0L == l2 < 0L ? 1 : -1;
        if (l4 != 0L) {
            boolean bl = BigDecimal.needIncrement(l2, n, n2, l3, l4);
            return bl ? l3 + (long)n2 : l3;
        }
        return l3;
    }

    private static boolean commonNeedIncrement(int n, int n2, int n3, boolean bl) {
        switch (n) {
            case 7: {
                throw new ArithmeticException("Rounding necessary");
            }
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return n2 > 0;
            }
            case 3: {
                return n2 < 0;
            }
        }
        assert (n >= 4 && n <= 6) : "Unexpected rounding mode" + (Object)((Object)RoundingMode.valueOf(n));
        if (n3 < 0) {
            return false;
        }
        if (n3 > 0) {
            return true;
        }
        assert (n3 == 0);
        switch (n) {
            case 5: {
                return false;
            }
            case 4: {
                return true;
            }
            case 6: {
                return bl;
            }
        }
        throw new AssertionError((Object)("Unexpected rounding mode" + n));
    }

    private static boolean needIncrement(long l, int n, int n2, long l2, long l3) {
        assert (l3 != 0L);
        int n3 = l3 <= -4611686018427387904L || l3 > 0x3FFFFFFFFFFFFFFFL ? 1 : BigDecimal.longCompareMagnitude(2L * l3, l);
        return BigDecimal.commonNeedIncrement(n, n2, n3, (l2 & 1L) != 0L);
    }

    private static BigInteger divideAndRound(BigInteger bigInteger, long l, int n) {
        int n2;
        long l2 = 0L;
        MutableBigInteger mutableBigInteger = null;
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(bigInteger.mag);
        mutableBigInteger = new MutableBigInteger();
        l2 = mutableBigInteger2.divide(l, mutableBigInteger);
        boolean bl = l2 == 0L;
        int n3 = n2 = l < 0L ? -bigInteger.signum : bigInteger.signum;
        if (!bl && BigDecimal.needIncrement(l, n, n2, mutableBigInteger, l2)) {
            mutableBigInteger.add(MutableBigInteger.ONE);
        }
        return mutableBigInteger.toBigInteger(n2);
    }

    private static BigDecimal divideAndRound(BigInteger bigInteger, long l, int n, int n2, int n3) {
        int n4;
        long l2 = 0L;
        MutableBigInteger mutableBigInteger = null;
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger(bigInteger.mag);
        mutableBigInteger = new MutableBigInteger();
        l2 = mutableBigInteger2.divide(l, mutableBigInteger);
        boolean bl = l2 == 0L;
        int n5 = n4 = l < 0L ? -bigInteger.signum : bigInteger.signum;
        if (!bl) {
            if (BigDecimal.needIncrement(l, n2, n4, mutableBigInteger, l2)) {
                mutableBigInteger.add(MutableBigInteger.ONE);
            }
            return mutableBigInteger.toBigDecimal(n4, n);
        }
        if (n3 != n) {
            long l3 = mutableBigInteger.toCompactValue(n4);
            if (l3 != Long.MIN_VALUE) {
                return BigDecimal.createAndStripZerosToMatchScale(l3, n, (long)n3);
            }
            BigInteger bigInteger2 = mutableBigInteger.toBigInteger(n4);
            return BigDecimal.createAndStripZerosToMatchScale(bigInteger2, n, (long)n3);
        }
        return mutableBigInteger.toBigDecimal(n4, n);
    }

    private static boolean needIncrement(long l, int n, int n2, MutableBigInteger mutableBigInteger, long l2) {
        assert (l2 != 0L);
        int n3 = l2 <= -4611686018427387904L || l2 > 0x3FFFFFFFFFFFFFFFL ? 1 : BigDecimal.longCompareMagnitude(2L * l2, l);
        return BigDecimal.commonNeedIncrement(n, n2, n3, mutableBigInteger.isOdd());
    }

    private static BigInteger divideAndRound(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        int n2;
        MutableBigInteger mutableBigInteger = new MutableBigInteger(bigInteger.mag);
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(bigInteger2.mag);
        MutableBigInteger mutableBigInteger4 = mutableBigInteger.divide(mutableBigInteger3, mutableBigInteger2);
        boolean bl = mutableBigInteger4.isZero();
        int n3 = n2 = bigInteger.signum != bigInteger2.signum ? -1 : 1;
        if (!bl && BigDecimal.needIncrement(mutableBigInteger3, n, n2, mutableBigInteger2, mutableBigInteger4)) {
            mutableBigInteger2.add(MutableBigInteger.ONE);
        }
        return mutableBigInteger2.toBigInteger(n2);
    }

    private static BigDecimal divideAndRound(BigInteger bigInteger, BigInteger bigInteger2, int n, int n2, int n3) {
        int n4;
        MutableBigInteger mutableBigInteger = new MutableBigInteger(bigInteger.mag);
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
        MutableBigInteger mutableBigInteger3 = new MutableBigInteger(bigInteger2.mag);
        MutableBigInteger mutableBigInteger4 = mutableBigInteger.divide(mutableBigInteger3, mutableBigInteger2);
        boolean bl = mutableBigInteger4.isZero();
        int n5 = n4 = bigInteger.signum != bigInteger2.signum ? -1 : 1;
        if (!bl) {
            if (BigDecimal.needIncrement(mutableBigInteger3, n2, n4, mutableBigInteger2, mutableBigInteger4)) {
                mutableBigInteger2.add(MutableBigInteger.ONE);
            }
            return mutableBigInteger2.toBigDecimal(n4, n);
        }
        if (n3 != n) {
            long l = mutableBigInteger2.toCompactValue(n4);
            if (l != Long.MIN_VALUE) {
                return BigDecimal.createAndStripZerosToMatchScale(l, n, (long)n3);
            }
            BigInteger bigInteger3 = mutableBigInteger2.toBigInteger(n4);
            return BigDecimal.createAndStripZerosToMatchScale(bigInteger3, n, (long)n3);
        }
        return mutableBigInteger2.toBigDecimal(n4, n);
    }

    private static boolean needIncrement(MutableBigInteger mutableBigInteger, int n, int n2, MutableBigInteger mutableBigInteger2, MutableBigInteger mutableBigInteger3) {
        assert (!mutableBigInteger3.isZero());
        int n3 = mutableBigInteger3.compareHalf(mutableBigInteger);
        return BigDecimal.commonNeedIncrement(n, n2, n3, mutableBigInteger2.isOdd());
    }

    private static BigDecimal createAndStripZerosToMatchScale(BigInteger bigInteger, int n, long l) {
        BigInteger[] bigIntegerArray;
        while (bigInteger.compareMagnitude(BigInteger.TEN) >= 0 && (long)n > l && !bigInteger.testBit(0) && (bigIntegerArray = bigInteger.divideAndRemainder(BigInteger.TEN))[1].signum() == 0) {
            bigInteger = bigIntegerArray[0];
            n = BigDecimal.checkScale(bigInteger, (long)n - 1L);
        }
        return BigDecimal.valueOf(bigInteger, n, 0);
    }

    private static BigDecimal createAndStripZerosToMatchScale(long l, int n, long l2) {
        long l3;
        while (Math.abs(l) >= 10L && (long)n > l2 && (l & 1L) == 0L && (l3 = l % 10L) == 0L) {
            n = BigDecimal.checkScale(l /= 10L, (long)n - 1L);
        }
        return BigDecimal.valueOf(l, n);
    }

    private static BigDecimal stripZerosToMatchScale(BigInteger bigInteger, long l, int n, int n2) {
        if (l != Long.MIN_VALUE) {
            return BigDecimal.createAndStripZerosToMatchScale(l, n, (long)n2);
        }
        return BigDecimal.createAndStripZerosToMatchScale(bigInteger == null ? INFLATED_BIGINT : bigInteger, n, (long)n2);
    }

    private static long add(long l, long l2) {
        long l3 = l + l2;
        if (((l3 ^ l) & (l3 ^ l2)) >= 0L) {
            return l3;
        }
        return Long.MIN_VALUE;
    }

    private static BigDecimal add(long l, long l2, int n) {
        long l3 = BigDecimal.add(l, l2);
        if (l3 != Long.MIN_VALUE) {
            return BigDecimal.valueOf(l3, n);
        }
        return new BigDecimal(BigInteger.valueOf(l).add(l2), n);
    }

    private static BigDecimal add(long l, int n, long l2, int n2) {
        long l3 = (long)n - (long)n2;
        if (l3 == 0L) {
            return BigDecimal.add(l, l2, n);
        }
        if (l3 < 0L) {
            int n3 = BigDecimal.checkScale(l, -l3);
            long l4 = BigDecimal.longMultiplyPowerTen(l, n3);
            if (l4 != Long.MIN_VALUE) {
                return BigDecimal.add(l4, l2, n2);
            }
            BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l, n3).add(l2);
            return (l ^ l2) >= 0L ? new BigDecimal(bigInteger, Long.MIN_VALUE, n2, 0) : BigDecimal.valueOf(bigInteger, n2, 0);
        }
        int n4 = BigDecimal.checkScale(l2, l3);
        long l5 = BigDecimal.longMultiplyPowerTen(l2, n4);
        if (l5 != Long.MIN_VALUE) {
            return BigDecimal.add(l, l5, n);
        }
        BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l2, n4).add(l);
        return (l ^ l2) >= 0L ? new BigDecimal(bigInteger, Long.MIN_VALUE, n, 0) : BigDecimal.valueOf(bigInteger, n, 0);
    }

    private static BigDecimal add(long l, int n, BigInteger bigInteger, int n2) {
        BigInteger bigInteger2;
        boolean bl;
        int n3 = n;
        long l2 = (long)n3 - (long)n2;
        boolean bl2 = bl = Long.signum(l) == bigInteger.signum;
        if (l2 < 0L) {
            int n4 = BigDecimal.checkScale(l, -l2);
            n3 = n2;
            long l3 = BigDecimal.longMultiplyPowerTen(l, n4);
            bigInteger2 = l3 == Long.MIN_VALUE ? bigInteger.add(BigDecimal.bigMultiplyPowerTen(l, n4)) : bigInteger.add(l3);
        } else {
            int n5 = BigDecimal.checkScale(bigInteger, l2);
            bigInteger = BigDecimal.bigMultiplyPowerTen(bigInteger, n5);
            bigInteger2 = bigInteger.add(l);
        }
        return bl ? new BigDecimal(bigInteger2, Long.MIN_VALUE, n3, 0) : BigDecimal.valueOf(bigInteger2, n3, 0);
    }

    private static BigDecimal add(BigInteger bigInteger, int n, BigInteger bigInteger2, int n2) {
        int n3 = n;
        long l = (long)n3 - (long)n2;
        if (l != 0L) {
            int n4;
            if (l < 0L) {
                n4 = BigDecimal.checkScale(bigInteger, -l);
                n3 = n2;
                bigInteger = BigDecimal.bigMultiplyPowerTen(bigInteger, n4);
            } else {
                n4 = BigDecimal.checkScale(bigInteger2, l);
                bigInteger2 = BigDecimal.bigMultiplyPowerTen(bigInteger2, n4);
            }
        }
        BigInteger bigInteger3 = bigInteger.add(bigInteger2);
        return bigInteger.signum == bigInteger2.signum ? new BigDecimal(bigInteger3, Long.MIN_VALUE, n3, 0) : BigDecimal.valueOf(bigInteger3, n3, 0);
    }

    private static BigInteger bigMultiplyPowerTen(long l, int n) {
        if (n <= 0) {
            return BigInteger.valueOf(l);
        }
        return BigDecimal.bigTenToThe(n).multiply(l);
    }

    private static BigInteger bigMultiplyPowerTen(BigInteger bigInteger, int n) {
        if (n <= 0) {
            return bigInteger;
        }
        if (n < LONG_TEN_POWERS_TABLE.length) {
            return bigInteger.multiply(LONG_TEN_POWERS_TABLE[n]);
        }
        return bigInteger.multiply(BigDecimal.bigTenToThe(n));
    }

    private static BigDecimal divideSmallFastPath(long l, int n, long l2, int n2, long l3, MathContext mathContext) {
        BigDecimal bigDecimal;
        int n3 = mathContext.precision;
        int n4 = mathContext.roundingMode.oldMode;
        assert (n <= n2 && n2 < 18 && n3 < 18);
        int n5 = n2 - n;
        long l4 = n5 == 0 ? l : BigDecimal.longMultiplyPowerTen(l, n5);
        int n6 = BigDecimal.longCompareMagnitude(l4, l2);
        if (n6 > 0) {
            int n7 = BigDecimal.checkScaleNonZero(l3 + (long)(--n2) - (long)n + (long)n3);
            if (BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n) > 0) {
                int n8 = BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n);
                long l5 = BigDecimal.longMultiplyPowerTen(l, n8);
                if (l5 == Long.MIN_VALUE) {
                    bigDecimal = null;
                    if (n3 - 1 >= 0 && n3 - 1 < LONG_TEN_POWERS_TABLE.length) {
                        bigDecimal = BigDecimal.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[n3 - 1], l4, l2, n7, n4, BigDecimal.checkScaleNonZero(l3));
                    }
                    if (bigDecimal == null) {
                        BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l4, n3 - 1);
                        bigDecimal = BigDecimal.divideAndRound(bigInteger, l2, n7, n4, BigDecimal.checkScaleNonZero(l3));
                    }
                } else {
                    bigDecimal = BigDecimal.divideAndRound(l5, l2, n7, n4, BigDecimal.checkScaleNonZero(l3));
                }
            } else {
                int n9 = BigDecimal.checkScaleNonZero((long)n - (long)n3);
                if (n9 == n2) {
                    bigDecimal = BigDecimal.divideAndRound(l, l2, n7, n4, BigDecimal.checkScaleNonZero(l3));
                } else {
                    int n10 = BigDecimal.checkScaleNonZero((long)n9 - (long)n2);
                    long l6 = BigDecimal.longMultiplyPowerTen(l2, n10);
                    if (l6 == Long.MIN_VALUE) {
                        BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l2, n10);
                        bigDecimal = BigDecimal.divideAndRound(BigInteger.valueOf(l), bigInteger, n7, n4, BigDecimal.checkScaleNonZero(l3));
                    } else {
                        bigDecimal = BigDecimal.divideAndRound(l, l6, n7, n4, BigDecimal.checkScaleNonZero(l3));
                    }
                }
            }
        } else {
            int n11 = BigDecimal.checkScaleNonZero(l3 + (long)n2 - (long)n + (long)n3);
            if (n6 == 0) {
                bigDecimal = BigDecimal.roundedTenPower(l4 < 0L == l2 < 0L ? 1 : -1, n3, n11, BigDecimal.checkScaleNonZero(l3));
            } else {
                long l7 = BigDecimal.longMultiplyPowerTen(l4, n3);
                if (l7 == Long.MIN_VALUE) {
                    bigDecimal = null;
                    if (n3 < LONG_TEN_POWERS_TABLE.length) {
                        bigDecimal = BigDecimal.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[n3], l4, l2, n11, n4, BigDecimal.checkScaleNonZero(l3));
                    }
                    if (bigDecimal == null) {
                        BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l4, n3);
                        bigDecimal = BigDecimal.divideAndRound(bigInteger, l2, n11, n4, BigDecimal.checkScaleNonZero(l3));
                    }
                } else {
                    bigDecimal = BigDecimal.divideAndRound(l7, l2, n11, n4, BigDecimal.checkScaleNonZero(l3));
                }
            }
        }
        return BigDecimal.doRound(bigDecimal, mathContext);
    }

    private static BigDecimal divide(long l, int n, long l2, int n2, long l3, MathContext mathContext) {
        BigDecimal bigDecimal;
        int n3 = mathContext.precision;
        if (n <= n2 && n2 < 18 && n3 < 18) {
            return BigDecimal.divideSmallFastPath(l, n, l2, n2, l3, mathContext);
        }
        if (BigDecimal.compareMagnitudeNormalized(l, n, l2, n2) > 0) {
            --n2;
        }
        int n4 = mathContext.roundingMode.oldMode;
        int n5 = BigDecimal.checkScaleNonZero(l3 + (long)n2 - (long)n + (long)n3);
        if (BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n) > 0) {
            int n6 = BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n);
            long l4 = BigDecimal.longMultiplyPowerTen(l, n6);
            if (l4 == Long.MIN_VALUE) {
                BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l, n6);
                bigDecimal = BigDecimal.divideAndRound(bigInteger, l2, n5, n4, BigDecimal.checkScaleNonZero(l3));
            } else {
                bigDecimal = BigDecimal.divideAndRound(l4, l2, n5, n4, BigDecimal.checkScaleNonZero(l3));
            }
        } else {
            int n7 = BigDecimal.checkScaleNonZero((long)n - (long)n3);
            if (n7 == n2) {
                bigDecimal = BigDecimal.divideAndRound(l, l2, n5, n4, BigDecimal.checkScaleNonZero(l3));
            } else {
                int n8 = BigDecimal.checkScaleNonZero((long)n7 - (long)n2);
                long l5 = BigDecimal.longMultiplyPowerTen(l2, n8);
                if (l5 == Long.MIN_VALUE) {
                    BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l2, n8);
                    bigDecimal = BigDecimal.divideAndRound(BigInteger.valueOf(l), bigInteger, n5, n4, BigDecimal.checkScaleNonZero(l3));
                } else {
                    bigDecimal = BigDecimal.divideAndRound(l, l5, n5, n4, BigDecimal.checkScaleNonZero(l3));
                }
            }
        }
        return BigDecimal.doRound(bigDecimal, mathContext);
    }

    private static BigDecimal divide(BigInteger bigInteger, int n, long l, int n2, long l2, MathContext mathContext) {
        BigDecimal bigDecimal;
        if (-BigDecimal.compareMagnitudeNormalized(l, n2, bigInteger, n) > 0) {
            --n2;
        }
        int n3 = mathContext.precision;
        int n4 = mathContext.roundingMode.oldMode;
        int n5 = BigDecimal.checkScaleNonZero(l2 + (long)n2 - (long)n + (long)n3);
        if (BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n) > 0) {
            int n6 = BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n);
            BigInteger bigInteger2 = BigDecimal.bigMultiplyPowerTen(bigInteger, n6);
            bigDecimal = BigDecimal.divideAndRound(bigInteger2, l, n5, n4, BigDecimal.checkScaleNonZero(l2));
        } else {
            int n7 = BigDecimal.checkScaleNonZero((long)n - (long)n3);
            if (n7 == n2) {
                bigDecimal = BigDecimal.divideAndRound(bigInteger, l, n5, n4, BigDecimal.checkScaleNonZero(l2));
            } else {
                int n8 = BigDecimal.checkScaleNonZero((long)n7 - (long)n2);
                long l3 = BigDecimal.longMultiplyPowerTen(l, n8);
                if (l3 == Long.MIN_VALUE) {
                    BigInteger bigInteger3 = BigDecimal.bigMultiplyPowerTen(l, n8);
                    bigDecimal = BigDecimal.divideAndRound(bigInteger, bigInteger3, n5, n4, BigDecimal.checkScaleNonZero(l2));
                } else {
                    bigDecimal = BigDecimal.divideAndRound(bigInteger, l3, n5, n4, BigDecimal.checkScaleNonZero(l2));
                }
            }
        }
        return BigDecimal.doRound(bigDecimal, mathContext);
    }

    private static BigDecimal divide(long l, int n, BigInteger bigInteger, int n2, long l2, MathContext mathContext) {
        BigDecimal bigDecimal;
        if (BigDecimal.compareMagnitudeNormalized(l, n, bigInteger, n2) > 0) {
            --n2;
        }
        int n3 = mathContext.precision;
        int n4 = mathContext.roundingMode.oldMode;
        int n5 = BigDecimal.checkScaleNonZero(l2 + (long)n2 - (long)n + (long)n3);
        if (BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n) > 0) {
            int n6 = BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n);
            BigInteger bigInteger2 = BigDecimal.bigMultiplyPowerTen(l, n6);
            bigDecimal = BigDecimal.divideAndRound(bigInteger2, bigInteger, n5, n4, BigDecimal.checkScaleNonZero(l2));
        } else {
            int n7 = BigDecimal.checkScaleNonZero((long)n - (long)n3);
            int n8 = BigDecimal.checkScaleNonZero((long)n7 - (long)n2);
            BigInteger bigInteger3 = BigDecimal.bigMultiplyPowerTen(bigInteger, n8);
            bigDecimal = BigDecimal.divideAndRound(BigInteger.valueOf(l), bigInteger3, n5, n4, BigDecimal.checkScaleNonZero(l2));
        }
        return BigDecimal.doRound(bigDecimal, mathContext);
    }

    private static BigDecimal divide(BigInteger bigInteger, int n, BigInteger bigInteger2, int n2, long l, MathContext mathContext) {
        BigDecimal bigDecimal;
        if (BigDecimal.compareMagnitudeNormalized(bigInteger, n, bigInteger2, n2) > 0) {
            --n2;
        }
        int n3 = mathContext.precision;
        int n4 = mathContext.roundingMode.oldMode;
        int n5 = BigDecimal.checkScaleNonZero(l + (long)n2 - (long)n + (long)n3);
        if (BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n) > 0) {
            int n6 = BigDecimal.checkScaleNonZero((long)n3 + (long)n2 - (long)n);
            BigInteger bigInteger3 = BigDecimal.bigMultiplyPowerTen(bigInteger, n6);
            bigDecimal = BigDecimal.divideAndRound(bigInteger3, bigInteger2, n5, n4, BigDecimal.checkScaleNonZero(l));
        } else {
            int n7 = BigDecimal.checkScaleNonZero((long)n - (long)n3);
            int n8 = BigDecimal.checkScaleNonZero((long)n7 - (long)n2);
            BigInteger bigInteger4 = BigDecimal.bigMultiplyPowerTen(bigInteger2, n8);
            bigDecimal = BigDecimal.divideAndRound(bigInteger, bigInteger4, n5, n4, BigDecimal.checkScaleNonZero(l));
        }
        return BigDecimal.doRound(bigDecimal, mathContext);
    }

    private static BigDecimal multiplyDivideAndRound(long l, long l2, long l3, int n, int n2, int n3) {
        int n4 = Long.signum(l) * Long.signum(l2) * Long.signum(l3);
        l = Math.abs(l);
        l2 = Math.abs(l2);
        l3 = Math.abs(l3);
        long l4 = l >>> 32;
        long l5 = l & 0xFFFFFFFFL;
        long l6 = l2 >>> 32;
        long l7 = l2 & 0xFFFFFFFFL;
        long l8 = l5 * l7;
        long l9 = l8 & 0xFFFFFFFFL;
        long l10 = l8 >>> 32;
        l8 = l4 * l7 + l10;
        l10 = l8 & 0xFFFFFFFFL;
        long l11 = l8 >>> 32;
        l8 = l5 * l6 + l10;
        l10 = l8 & 0xFFFFFFFFL;
        long l12 = (l11 += l8 >>> 32) >>> 32;
        l8 = l4 * l6 + (l11 &= 0xFFFFFFFFL);
        l11 = l8 & 0xFFFFFFFFL;
        l12 = (l8 >>> 32) + l12 & 0xFFFFFFFFL;
        long l13 = BigDecimal.make64(l12, l11);
        long l14 = BigDecimal.make64(l10, l9);
        return BigDecimal.divideAndRound128(l13, l14, l3, n4, n, n2, n3);
    }

    private static BigDecimal divideAndRound128(long l, long l2, long l3, int n, int n2, int n3, int n4) {
        long l4;
        long l5;
        if (l >= l3) {
            return null;
        }
        int n5 = Long.numberOfLeadingZeros(l3);
        long l6 = (l3 <<= n5) >>> 32;
        long l7 = l3 & 0xFFFFFFFFL;
        long l8 = l2 << n5;
        long l9 = l8 >>> 32;
        long l10 = l8 & 0xFFFFFFFFL;
        l8 = l << n5 | l2 >>> 64 - n5;
        long l11 = l8 & 0xFFFFFFFFL;
        l8 = BigDecimal.divWord(l8, l6);
        long l12 = l8 >>> 32;
        for (l5 = l8 & 0xFFFFFFFFL; l5 >= 0x100000000L || BigDecimal.unsignedLongCompare(l5 * l7, BigDecimal.make64(l12, l9)); --l5) {
            if ((l12 += l6) < 0x100000000L) continue;
        }
        l8 = BigDecimal.mulsub(l11, l9, l6, l7, l5);
        l9 = l8 & 0xFFFFFFFFL;
        l8 = BigDecimal.divWord(l8, l6);
        l12 = l8 >>> 32;
        for (l4 = l8 & 0xFFFFFFFFL; l4 >= 0x100000000L || BigDecimal.unsignedLongCompare(l4 * l7, BigDecimal.make64(l12, l10)); --l4) {
            if ((l12 += l6) < 0x100000000L) continue;
        }
        if ((int)l5 < 0) {
            MutableBigInteger mutableBigInteger = new MutableBigInteger(new int[]{(int)l5, (int)l4});
            if (n3 == 1 && n2 == n4) {
                return mutableBigInteger.toBigDecimal(n, n2);
            }
            long l13 = BigDecimal.mulsub(l9, l10, l6, l7, l4) >>> n5;
            if (l13 != 0L) {
                if (BigDecimal.needIncrement(l3 >>> n5, n3, n, mutableBigInteger, l13)) {
                    mutableBigInteger.add(MutableBigInteger.ONE);
                }
                return mutableBigInteger.toBigDecimal(n, n2);
            }
            if (n4 != n2) {
                BigInteger bigInteger = mutableBigInteger.toBigInteger(n);
                return BigDecimal.createAndStripZerosToMatchScale(bigInteger, n2, (long)n4);
            }
            return mutableBigInteger.toBigDecimal(n, n2);
        }
        long l14 = BigDecimal.make64(l5, l4);
        l14 *= (long)n;
        if (n3 == 1 && n2 == n4) {
            return BigDecimal.valueOf(l14, n2);
        }
        long l15 = BigDecimal.mulsub(l9, l10, l6, l7, l4) >>> n5;
        if (l15 != 0L) {
            boolean bl = BigDecimal.needIncrement(l3 >>> n5, n3, n, l14, l15);
            return BigDecimal.valueOf(bl ? l14 + (long)n : l14, n2);
        }
        if (n4 != n2) {
            return BigDecimal.createAndStripZerosToMatchScale(l14, n2, (long)n4);
        }
        return BigDecimal.valueOf(l14, n2);
    }

    private static BigDecimal roundedTenPower(int n, int n2, int n3, int n4) {
        if (n3 > n4) {
            int n5 = n3 - n4;
            if (n5 < n2) {
                return BigDecimal.scaledTenPow(n2 - n5, n, n4);
            }
            return BigDecimal.valueOf(n, n3 - n2);
        }
        return BigDecimal.scaledTenPow(n2, n, n3);
    }

    static BigDecimal scaledTenPow(int n, int n2, int n3) {
        if (n < LONG_TEN_POWERS_TABLE.length) {
            return BigDecimal.valueOf((long)n2 * LONG_TEN_POWERS_TABLE[n], n3);
        }
        BigInteger bigInteger = BigDecimal.bigTenToThe(n);
        if (n2 == -1) {
            bigInteger = bigInteger.negate();
        }
        return new BigDecimal(bigInteger, Long.MIN_VALUE, n3, n + 1);
    }

    private static long divWord(long l, long l2) {
        if (l2 == 1L) {
            long l3 = (int)l;
            return l3 & 0xFFFFFFFFL;
        }
        long l4 = (l >>> 1) / (l2 >>> 1);
        long l5 = l - l4 * l2;
        while (l5 < 0L) {
            l5 += l2;
            --l4;
        }
        while (l5 >= l2) {
            l5 -= l2;
            ++l4;
        }
        return l5 << 32 | l4 & 0xFFFFFFFFL;
    }

    private static long make64(long l, long l2) {
        return l << 32 | l2;
    }

    private static long mulsub(long l, long l2, long l3, long l4, long l5) {
        long l6 = l2 - l5 * l4;
        return BigDecimal.make64(l + (l6 >>> 32) - l5 * l3, l6 & 0xFFFFFFFFL);
    }

    private static boolean unsignedLongCompare(long l, long l2) {
        return l + Long.MIN_VALUE > l2 + Long.MIN_VALUE;
    }

    private static boolean unsignedLongCompareEq(long l, long l2) {
        return l + Long.MIN_VALUE >= l2 + Long.MIN_VALUE;
    }

    private static int compareMagnitudeNormalized(long l, int n, long l2, int n2) {
        int n3 = n - n2;
        if (n3 != 0) {
            if (n3 < 0) {
                l = BigDecimal.longMultiplyPowerTen(l, -n3);
            } else {
                l2 = BigDecimal.longMultiplyPowerTen(l2, n3);
            }
        }
        if (l != Long.MIN_VALUE) {
            return l2 != Long.MIN_VALUE ? BigDecimal.longCompareMagnitude(l, l2) : -1;
        }
        return 1;
    }

    private static int compareMagnitudeNormalized(long l, int n, BigInteger bigInteger, int n2) {
        if (l == 0L) {
            return -1;
        }
        int n3 = n - n2;
        if (n3 < 0 && BigDecimal.longMultiplyPowerTen(l, -n3) == Long.MIN_VALUE) {
            return BigDecimal.bigMultiplyPowerTen(l, -n3).compareMagnitude(bigInteger);
        }
        return -1;
    }

    private static int compareMagnitudeNormalized(BigInteger bigInteger, int n, BigInteger bigInteger2, int n2) {
        int n3 = n - n2;
        if (n3 < 0) {
            return BigDecimal.bigMultiplyPowerTen(bigInteger, -n3).compareMagnitude(bigInteger2);
        }
        return bigInteger.compareMagnitude(BigDecimal.bigMultiplyPowerTen(bigInteger2, n3));
    }

    private static long multiply(long l, long l2) {
        long l3;
        long l4 = l * l2;
        long l5 = Math.abs(l);
        if ((l5 | (l3 = Math.abs(l2))) >>> 31 == 0L || l2 == 0L || l4 / l2 == l) {
            return l4;
        }
        return Long.MIN_VALUE;
    }

    private static BigDecimal multiply(long l, long l2, int n) {
        long l3 = BigDecimal.multiply(l, l2);
        if (l3 != Long.MIN_VALUE) {
            return BigDecimal.valueOf(l3, n);
        }
        return new BigDecimal(BigInteger.valueOf(l).multiply(l2), Long.MIN_VALUE, n, 0);
    }

    private static BigDecimal multiply(long l, BigInteger bigInteger, int n) {
        if (l == 0L) {
            return BigDecimal.zeroValueOf(n);
        }
        return new BigDecimal(bigInteger.multiply(l), Long.MIN_VALUE, n, 0);
    }

    private static BigDecimal multiply(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        return new BigDecimal(bigInteger.multiply(bigInteger2), Long.MIN_VALUE, n, 0);
    }

    private static BigDecimal multiplyAndRound(long l, long l2, int n, MathContext mathContext) {
        long l3;
        long l4 = BigDecimal.multiply(l, l2);
        if (l4 != Long.MIN_VALUE) {
            return BigDecimal.doRound(l4, n, mathContext);
        }
        int n2 = 1;
        if (l < 0L) {
            l = -l;
            n2 = -1;
        }
        if (l2 < 0L) {
            l2 = -l2;
            n2 *= -1;
        }
        long l5 = l >>> 32;
        long l6 = l & 0xFFFFFFFFL;
        long l7 = l2 >>> 32;
        long l8 = l2 & 0xFFFFFFFFL;
        l4 = l6 * l8;
        long l9 = l4 & 0xFFFFFFFFL;
        long l10 = l4 >>> 32;
        l4 = l5 * l8 + l10;
        l10 = l4 & 0xFFFFFFFFL;
        long l11 = l4 >>> 32;
        l4 = l6 * l7 + l10;
        l10 = l4 & 0xFFFFFFFFL;
        long l12 = (l11 += l4 >>> 32) >>> 32;
        l11 &= 0xFFFFFFFFL;
        l4 = l5 * l7 + l11;
        long l13 = BigDecimal.make64(l12 = (l4 >>> 32) + l12 & 0xFFFFFFFFL, l11 = l4 & 0xFFFFFFFFL);
        BigDecimal bigDecimal = BigDecimal.doRound128(l13, l3 = BigDecimal.make64(l10, l9), n2, n, mathContext);
        if (bigDecimal != null) {
            return bigDecimal;
        }
        bigDecimal = new BigDecimal(BigInteger.valueOf(l).multiply(l2 * (long)n2), Long.MIN_VALUE, n, 0);
        return BigDecimal.doRound(bigDecimal, mathContext);
    }

    private static BigDecimal multiplyAndRound(long l, BigInteger bigInteger, int n, MathContext mathContext) {
        if (l == 0L) {
            return BigDecimal.zeroValueOf(n);
        }
        return BigDecimal.doRound(bigInteger.multiply(l), n, mathContext);
    }

    private static BigDecimal multiplyAndRound(BigInteger bigInteger, BigInteger bigInteger2, int n, MathContext mathContext) {
        return BigDecimal.doRound(bigInteger.multiply(bigInteger2), n, mathContext);
    }

    private static BigDecimal doRound128(long l, long l2, int n, int n2, MathContext mathContext) {
        int n3 = mathContext.precision;
        BigDecimal bigDecimal = null;
        int n4 = BigDecimal.precision(l, l2) - n3;
        if (n4 > 0 && n4 < LONG_TEN_POWERS_TABLE.length) {
            n2 = BigDecimal.checkScaleNonZero((long)n2 - (long)n4);
            bigDecimal = BigDecimal.divideAndRound128(l, l2, LONG_TEN_POWERS_TABLE[n4], n, n2, mathContext.roundingMode.oldMode, n2);
        }
        if (bigDecimal != null) {
            return BigDecimal.doRound(bigDecimal, mathContext);
        }
        return null;
    }

    private static int precision(long l, long l2) {
        if (l == 0L) {
            if (l2 >= 0L) {
                return BigDecimal.longDigitLength(l2);
            }
            return BigDecimal.unsignedLongCompareEq(l2, LONGLONG_TEN_POWERS_TABLE[0][1]) ? 20 : 19;
        }
        int n = (128 - Long.numberOfLeadingZeros(l) + 1) * 1233 >>> 12;
        int n2 = n - 19;
        return n2 >= LONGLONG_TEN_POWERS_TABLE.length || BigDecimal.longLongCompareMagnitude(l, l2, LONGLONG_TEN_POWERS_TABLE[n2][0], LONGLONG_TEN_POWERS_TABLE[n2][1]) ? n : n + 1;
    }

    private static boolean longLongCompareMagnitude(long l, long l2, long l3, long l4) {
        if (l != l3) {
            return l < l3;
        }
        return l2 + Long.MIN_VALUE < l4 + Long.MIN_VALUE;
    }

    private static BigDecimal divide(long l, int n, long l2, int n2, int n3, int n4) {
        if (BigDecimal.checkScale(l, (long)n3 + (long)n2) > n) {
            int n5 = n3 + n2;
            int n6 = n5 - n;
            if (n6 < LONG_TEN_POWERS_TABLE.length) {
                long l3 = l;
                if ((l3 = BigDecimal.longMultiplyPowerTen(l3, n6)) != Long.MIN_VALUE) {
                    return BigDecimal.divideAndRound(l3, l2, n3, n4, n3);
                }
                BigDecimal bigDecimal = BigDecimal.multiplyDivideAndRound(LONG_TEN_POWERS_TABLE[n6], l, l2, n3, n4, n3);
                if (bigDecimal != null) {
                    return bigDecimal;
                }
            }
            BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l, n6);
            return BigDecimal.divideAndRound(bigInteger, l2, n3, n4, n3);
        }
        int n7 = BigDecimal.checkScale(l2, (long)n - (long)n3);
        int n8 = n7 - n2;
        if (n8 < LONG_TEN_POWERS_TABLE.length) {
            long l4 = l2;
            if ((l4 = BigDecimal.longMultiplyPowerTen(l4, n8)) != Long.MIN_VALUE) {
                return BigDecimal.divideAndRound(l, l4, n3, n4, n3);
            }
        }
        BigInteger bigInteger = BigDecimal.bigMultiplyPowerTen(l2, n8);
        return BigDecimal.divideAndRound(BigInteger.valueOf(l), bigInteger, n3, n4, n3);
    }

    private static BigDecimal divide(BigInteger bigInteger, int n, long l, int n2, int n3, int n4) {
        if (BigDecimal.checkScale(bigInteger, (long)n3 + (long)n2) > n) {
            int n5 = n3 + n2;
            int n6 = n5 - n;
            BigInteger bigInteger2 = BigDecimal.bigMultiplyPowerTen(bigInteger, n6);
            return BigDecimal.divideAndRound(bigInteger2, l, n3, n4, n3);
        }
        int n7 = BigDecimal.checkScale(l, (long)n - (long)n3);
        int n8 = n7 - n2;
        if (n8 < LONG_TEN_POWERS_TABLE.length) {
            long l2 = l;
            if ((l2 = BigDecimal.longMultiplyPowerTen(l2, n8)) != Long.MIN_VALUE) {
                return BigDecimal.divideAndRound(bigInteger, l2, n3, n4, n3);
            }
        }
        BigInteger bigInteger3 = BigDecimal.bigMultiplyPowerTen(l, n8);
        return BigDecimal.divideAndRound(bigInteger, bigInteger3, n3, n4, n3);
    }

    private static BigDecimal divide(long l, int n, BigInteger bigInteger, int n2, int n3, int n4) {
        if (BigDecimal.checkScale(l, (long)n3 + (long)n2) > n) {
            int n5 = n3 + n2;
            int n6 = n5 - n;
            BigInteger bigInteger2 = BigDecimal.bigMultiplyPowerTen(l, n6);
            return BigDecimal.divideAndRound(bigInteger2, bigInteger, n3, n4, n3);
        }
        int n7 = BigDecimal.checkScale(bigInteger, (long)n - (long)n3);
        int n8 = n7 - n2;
        BigInteger bigInteger3 = BigDecimal.bigMultiplyPowerTen(bigInteger, n8);
        return BigDecimal.divideAndRound(BigInteger.valueOf(l), bigInteger3, n3, n4, n3);
    }

    private static BigDecimal divide(BigInteger bigInteger, int n, BigInteger bigInteger2, int n2, int n3, int n4) {
        if (BigDecimal.checkScale(bigInteger, (long)n3 + (long)n2) > n) {
            int n5 = n3 + n2;
            int n6 = n5 - n;
            BigInteger bigInteger3 = BigDecimal.bigMultiplyPowerTen(bigInteger, n6);
            return BigDecimal.divideAndRound(bigInteger3, bigInteger2, n3, n4, n3);
        }
        int n7 = BigDecimal.checkScale(bigInteger2, (long)n - (long)n3);
        int n8 = n7 - n2;
        BigInteger bigInteger4 = BigDecimal.bigMultiplyPowerTen(bigInteger2, n8);
        return BigDecimal.divideAndRound(bigInteger, bigInteger4, n3, n4, n3);
    }

    private static class UnsafeHolder {
        private static final Unsafe unsafe;
        private static final long intCompactOffset;
        private static final long intValOffset;

        private UnsafeHolder() {
        }

        static void setIntCompactVolatile(BigDecimal bigDecimal, long l) {
            unsafe.putLongVolatile(bigDecimal, intCompactOffset, l);
        }

        static void setIntValVolatile(BigDecimal bigDecimal, BigInteger bigInteger) {
            unsafe.putObjectVolatile(bigDecimal, intValOffset, bigInteger);
        }

        static {
            try {
                unsafe = Unsafe.getUnsafe();
                intCompactOffset = unsafe.objectFieldOffset(BigDecimal.class.getDeclaredField("intCompact"));
                intValOffset = unsafe.objectFieldOffset(BigDecimal.class.getDeclaredField("intVal"));
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }
    }

    static class StringBuilderHelper {
        final StringBuilder sb = new StringBuilder();
        final char[] cmpCharArray = new char[19];
        static final char[] DIGIT_TENS = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        static final char[] DIGIT_ONES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

        StringBuilderHelper() {
        }

        StringBuilder getStringBuilder() {
            this.sb.setLength(0);
            return this.sb;
        }

        char[] getCompactCharArray() {
            return this.cmpCharArray;
        }

        int putIntCompact(long l) {
            int n;
            assert (l >= 0L);
            int n2 = this.cmpCharArray.length;
            while (l > Integer.MAX_VALUE) {
                long l2 = l / 100L;
                n = (int)(l - l2 * 100L);
                l = l2;
                this.cmpCharArray[--n2] = DIGIT_ONES[n];
                this.cmpCharArray[--n2] = DIGIT_TENS[n];
            }
            int n3 = (int)l;
            while (n3 >= 100) {
                int n4 = n3 / 100;
                n = n3 - n4 * 100;
                n3 = n4;
                this.cmpCharArray[--n2] = DIGIT_ONES[n];
                this.cmpCharArray[--n2] = DIGIT_TENS[n];
            }
            this.cmpCharArray[--n2] = DIGIT_ONES[n3];
            if (n3 >= 10) {
                this.cmpCharArray[--n2] = DIGIT_TENS[n3];
            }
            return n2;
        }
    }

    private static class LongOverflow {
        private static final BigInteger LONGMIN = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger LONGMAX = BigInteger.valueOf(Long.MAX_VALUE);

        private LongOverflow() {
        }

        public static void check(BigDecimal bigDecimal) {
            BigInteger bigInteger = bigDecimal.inflated();
            if (bigInteger.compareTo(LONGMIN) < 0 || bigInteger.compareTo(LONGMAX) > 0) {
                throw new ArithmeticException("Overflow");
            }
        }
    }
}

