/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.SessionState;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public final class SessionCertStore
implements CertStore,
SessionState.Client {
    private KeyStore sessionKS = null;
    private String name;
    private File sessionDataFolder;

    private SessionCertStore() {
    }

    public SessionCertStore(String string) {
        this.name = string;
        SessionState.register(this);
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    public synchronized void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.loading");
        if (this.sessionKS == null) {
            try {
                this.sessionKS = KeyStore.getInstance("JKS");
                this.sessionKS.load(null, new char[0]);
                if (this.sessionDataFolder != null) {
                    this.importState(this.sessionDataFolder);
                    this.sessionDataFolder = null;
                }
            }
            catch (IOException iOException) {
                Trace.msgSecurityPrintln(iOException.getMessage());
            }
            catch (KeyStoreException keyStoreException) {
                Trace.msgSecurityPrintln(keyStoreException.getMessage());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Trace.msgSecurityPrintln(noSuchAlgorithmException.getMessage());
            }
            catch (CertificateException certificateException) {
                Trace.msgSecurityPrintln(certificateException.getMessage());
            }
        }
        Trace.msgSecurityPrintln("sessioncertstore.cert.loaded");
    }

    public synchronized void importState(final File file) {
        if (this.sessionKS == null) {
            this.sessionDataFolder = file;
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file2 = new File(file, SessionCertStore.this.name);
                    if (file2 != null && file2.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        SessionCertStore.this.sessionKS.load(bufferedInputStream, new char[0]);
                        bufferedInputStream.close();
                        fileInputStream.close();
                        file2.delete();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException.getException());
        }
    }

    public void exportState(File file) {
        if (this.sessionKS == null) {
            return;
        }
        final File file2 = new File(file, this.name);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    file2.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    char[] cArray = new char[]{};
                    SessionCertStore.this.sessionKS.store(bufferedOutputStream, cArray);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException.getException());
        }
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.saving");
        Trace.msgSecurityPrintln("sessioncertstore.cert.saved");
    }

    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, null, false);
    }

    public boolean add(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        return CertUtils.add(this.sessionKS, "sessioncertstore", certificate, string, bl);
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.removing");
        String string = this.sessionKS.getCertificateAlias(certificate);
        if (string != null) {
            this.sessionKS.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("sessioncertstore.cert.removed");
        return true;
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, null, false);
    }

    public boolean contains(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        return CertUtils.contains(this.sessionKS, certificate, string, bl);
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.canverify");
        return false;
    }

    public Collection getCertificates() throws KeyStoreException {
        Trace.msgSecurityPrintln("sessioncertstore.cert.getcertificates");
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        Enumeration<String> enumeration = this.sessionKS.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this.sessionKS.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }
}

